/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PointlessArithmeticExpressionInspection
extends BaseInspection {
    private static final Set<IElementType> arithmeticTokens = new THashSet(9);
    public boolean m_ignoreExpressionsContainingConstants = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreExpressionsContainingConstants");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("pointless.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", this.calculateReplacementExpression((PsiPolyadicExpression)infos[0]));
        if (string == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression2) {
        PsiExpression[] operands2 = expression2.getOperands();
        IElementType tokenType = expression2.getOperationTokenType();
        List<PsiExpression> expressions2 = this.collectSalientOperands(operands2, tokenType, expression2.getType());
        PsiJavaToken token = expression2.getTokenBeforeOperand(operands2[1]);
        assert (token != null);
        String delimiter = " " + token.getText() + " ";
        return expressions2.stream().map(PsiElement::getText).collect(Collectors.joining(delimiter));
    }

    @NotNull
    List<PsiExpression> collectSalientOperands(PsiExpression[] operands2, IElementType tokenType, PsiType type2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)operands2[0].getProject());
        SmartList expressions2 = new SmartList();
        int length = operands2.length;
        for (int i = 0; i < length; ++i) {
            PsiExpression operand2 = operands2[i];
            if (tokenType.equals(JavaTokenType.PLUS) && this.isZero(operand2) || tokenType.equals(JavaTokenType.MINUS) && this.isZero(operand2) && !expressions2.isEmpty() || tokenType.equals(JavaTokenType.ASTERISK) && this.isOne(operand2) || tokenType.equals(JavaTokenType.DIV) && this.isOne(operand2) && !expressions2.isEmpty()) continue;
            if (tokenType.equals(JavaTokenType.MINUS) && i == 1 && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions2), operand2)) {
                expressions2.remove(expressions2.size() - 1);
                expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "0L" : "0", (PsiElement)operand2));
                continue;
            }
            if (tokenType.equals(JavaTokenType.DIV) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions2), operand2)) {
                expressions2.remove(expressions2.size() - 1);
                expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "1L" : "1", (PsiElement)operand2));
                continue;
            }
            if (tokenType.equals(JavaTokenType.ASTERISK) && this.isZero(operand2) || tokenType.equals(JavaTokenType.PERC) && (this.isOne(operand2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ContainerUtil.getLastItem((List)expressions2), operand2))) {
                expressions2.clear();
                expressions2.add(factory.createExpressionFromText(PsiType.LONG.equals((Object)type2) ? "0L" : "0", (PsiElement)operand2));
                SmartList smartList = expressions2;
                if (smartList == null) {
                    PointlessArithmeticExpressionInspection.$$$reportNull$$$0(2);
                }
                return smartList;
            }
            expressions2.add(operand2);
        }
        if (expressions2.isEmpty()) {
            expressions2.add(factory.createExpressionFromText(tokenType.equals(JavaTokenType.ASTERISK) ? "1" : "0", (PsiElement)operands2[0]));
        }
        SmartList smartList = expressions2;
        if (smartList == null) {
            PointlessArithmeticExpressionInspection.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new PointlessArithmeticFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessArithmeticVisitor();
    }

    boolean isZero(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression2) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isZero(expression2);
    }

    boolean isOne(PsiExpression expression2) {
        if (this.m_ignoreExpressionsContainingConstants && PsiUtil.deparenthesizeExpression((PsiExpression)expression2) instanceof PsiReferenceExpression) {
            return false;
        }
        return ExpressionUtils.isOne(expression2);
    }

    static {
        arithmeticTokens.add(JavaTokenType.PLUS);
        arithmeticTokens.add(JavaTokenType.MINUS);
        arithmeticTokens.add(JavaTokenType.ASTERISK);
        arithmeticTokens.add(JavaTokenType.DIV);
        arithmeticTokens.add(JavaTokenType.PERC);
        arithmeticTokens.add(JavaTokenType.GT);
        arithmeticTokens.add(JavaTokenType.LT);
        arithmeticTokens.add(JavaTokenType.LE);
        arithmeticTokens.add(JavaTokenType.GE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSalientOperands";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class PointlessArithmeticVisitor
    extends BaseInspectionVisitor {
        private PointlessArithmeticVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            if (expression2 == null) {
                PointlessArithmeticVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression2);
            PsiType expressionType = expression2.getType();
            if (expressionType == null || PsiType.DOUBLE.equals((Object)expressionType) || PsiType.FLOAT.equals((Object)expressionType)) {
                return;
            }
            if (!arithmeticTokens.contains(expression2.getOperationTokenType())) {
                return;
            }
            if (ExpressionUtils.hasStringType((PsiExpression)expression2) || PsiUtilCore.hasErrorElementChild((PsiElement)expression2)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            IElementType tokenType = expression2.getOperationTokenType();
            boolean isPointless = tokenType.equals(JavaTokenType.PLUS) ? this.additionExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.MINUS) ? this.subtractionExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.ASTERISK) ? this.multiplyExpressionIsPointless(operands2) : (tokenType.equals(JavaTokenType.DIV) || tokenType.equals(JavaTokenType.PERC) ? this.divideExpressionIsPointless(operands2) : false)));
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        private boolean subtractionExpressionIsPointless(PsiExpression[] expressions2) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions2.length; ++i) {
                PsiExpression expression2 = expressions2[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isZero(expression2) || this.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression2, i))) {
                    return true;
                }
                previousExpression = expression2;
            }
            return false;
        }

        private boolean additionExpressionIsPointless(PsiExpression[] expressions2) {
            for (PsiExpression expression2 : expressions2) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression2)) continue;
                return true;
            }
            return false;
        }

        private boolean multiplyExpressionIsPointless(PsiExpression[] expressions2) {
            for (PsiExpression expression2 : expressions2) {
                if (!PointlessArithmeticExpressionInspection.this.isZero(expression2) && !PointlessArithmeticExpressionInspection.this.isOne(expression2)) continue;
                return true;
            }
            return false;
        }

        private boolean divideExpressionIsPointless(PsiExpression[] expressions2) {
            PsiExpression previousExpression = null;
            for (int i = 0; i < expressions2.length; ++i) {
                PsiExpression expression2 = expressions2[i];
                if (previousExpression != null && (PointlessArithmeticExpressionInspection.this.isOne(expression2) || this.areExpressionsIdenticalWithoutSideEffects(previousExpression, expression2, i) && !PointlessArithmeticExpressionInspection.this.isZero(expression2))) {
                    return true;
                }
                previousExpression = expression2;
            }
            return false;
        }

        private boolean areExpressionsIdenticalWithoutSideEffects(PsiExpression expression1, PsiExpression expression2, int index) {
            return index == 1 && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expression1, expression2) && !SideEffectChecker.mayHaveSideEffects(expression1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticVisitor", "visitPolyadicExpression"));
        }
    }

    private class PointlessArithmeticFix
    extends InspectionGadgetsFix {
        private PointlessArithmeticFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessArithmeticFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
            PsiExpression[] operands2 = expression2.getOperands();
            PsiType type2 = expression2.getType();
            List<PsiExpression> expressions2 = PointlessArithmeticExpressionInspection.this.collectSalientOperands(operands2, expression2.getOperationTokenType(), type2);
            CommentTracker tracker = new CommentTracker();
            PsiJavaToken token = expression2.getTokenBeforeOperand(operands2[1]);
            assert (token != null);
            String delimiter = " " + token.getText() + " ";
            String replacement = expressions2.stream().map(x -> tracker.textWithComments((PsiElement)x)).collect(Collectors.joining(delimiter));
            boolean castToLongNeeded = TypeConversionUtil.isLongType((PsiType)type2) && expressions2.stream().noneMatch(x -> TypeConversionUtil.isLongType((PsiType)x.getType()));
            tracker.replaceExpressionAndRestoreComments((PsiExpression)expression2, castToLongNeeded ? "(long)" + replacement : replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/PointlessArithmeticExpressionInspection$PointlessArithmeticFix", "getFamilyName"));
        }
    }
}

