/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MisspelledMethodNameInspection
extends BaseInspection {
    public boolean ignoreIfMethodIsOverride = true;

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (InspectionProfileEntry)this, "ignoreIfMethodIsOverride");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix((String)infos[0]);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.display.name", new Object[0]);
        if (string == null) {
            MisspelledMethodNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.problem.descriptor", infos[0]);
        if (string == null) {
            MisspelledMethodNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNamesDifferOnlyByCaseVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/MisspelledMethodNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodNamesDifferOnlyByCaseVisitor
    extends BaseInspectionVisitor {
        private MethodNamesDifferOnlyByCaseVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            PsiMethod[] methods = aClass.getAllMethods();
            THashMap methodNames = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            THashMap errorNames = new THashMap();
            for (PsiMethod method : methods) {
                PsiIdentifier identifier;
                ProgressManager.checkCanceled();
                if (method.isConstructor() || MisspelledMethodNameInspection.this.ignoreIfMethodIsOverride && MethodUtils.hasSuper(method)) continue;
                String name2 = method.getName();
                PsiMethod existing = (PsiMethod)methodNames.get(name2);
                if (existing == null) {
                    methodNames.put(name2, method);
                    continue;
                }
                PsiClass methodClass = method.getContainingClass();
                PsiClass existingMethodClass = existing.getContainingClass();
                String existingName = existing.getName();
                if (name2.equals(existingName)) continue;
                if (existingMethodClass == aClass && (identifier = existing.getNameIdentifier()) != null) {
                    errorNames.put(identifier, name2);
                }
                if (methodClass != aClass || (identifier = method.getNameIdentifier()) == null) continue;
                errorNames.put(identifier, existingName);
            }
            for (Map.Entry entry : errorNames.entrySet()) {
                PsiIdentifier identifier = (PsiIdentifier)entry.getKey();
                String otherName = (String)entry.getValue();
                this.registerError((PsiElement)identifier, otherName);
            }
        }
    }
}

