/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodNameSameAsClassNameInspection
extends BaseInspection {
    private static final Set<String> MODIFIERS_ALLOWED_ON_CONSTRUCTORS = ContainerUtil.set((Object[])new String[]{"public", "protected", "private"});

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Boolean onTheFly = (Boolean)infos[0];
        Boolean canBeConvertedToConstructor = (Boolean)infos[1];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        if (onTheFly.booleanValue()) {
            fixes.add(new RenameFix());
        }
        if (canBeConvertedToConstructor.booleanValue()) {
            fixes.add(new MethodNameSameAsClassNameFix());
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            MethodNameSameAsClassNameInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.display.name", new Object[0]);
        if (string == null) {
            MethodNameSameAsClassNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.name.same.as.class.name.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodNameSameAsClassNameInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodNameSameAsClassNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MethodNameSameAsClassNameVisitor
    extends BaseInspectionVisitor {
        private MethodNameSameAsClassNameVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodNameSameAsClassNameVisitor.$$$reportNull$$$0(0);
            }
            if (method.isConstructor()) {
                return;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className2 = containingClass.getName();
            if (!methodName.equals(className2)) {
                return;
            }
            MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
            boolean canReplaceWithConstructor = method.getBody() != null && !containingClass.isInterface() && Arrays.stream(containingClass.getConstructors()).noneMatch(ctor -> MethodSignatureUtil.areErasedParametersEqual((MethodSignature)signature, (MethodSignature)ctor.getSignature(PsiSubstitutor.EMPTY)));
            this.registerMethodError(method, this.isOnTheFly(), canReplaceWithConstructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameVisitor", "visitMethod"));
        }
    }

    private static class MethodNameSameAsClassNameFix
    extends InspectionGadgetsFix {
        private MethodNameSameAsClassNameFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.method.ctr.quickfix", new Object[0]);
            if (string == null) {
                MethodNameSameAsClassNameFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)element.getParent(), PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (String modifier : PsiModifier.MODIFIERS) {
                if (MODIFIERS_ALLOWED_ON_CONSTRUCTORS.contains(modifier)) continue;
                modifiers.setModifierProperty(modifier, false);
            }
            returnTypeElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/MethodNameSameAsClassNameInspection$MethodNameSameAsClassNameFix", "getFamilyName"));
        }
    }
}

