/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PackageDotHtmlMayBePackageInfoInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean packageInfoExists = (Boolean)infos[1];
        if (packageInfoExists) {
            return new DeletePackageDotHtmlFix();
        }
        String aPackage = (String)infos[0];
        return new PackageDotHtmlMayBePackageInfoFix(aPackage);
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.display.name", new Object[0]);
        if (string == null) {
            PackageDotHtmlMayBePackageInfoInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[1]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.exists.problem.descriptor", new Object[0]);
            if (string == null) {
                PackageDotHtmlMayBePackageInfoInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.problem.descriptor", new Object[0]);
        if (string == null) {
            PackageDotHtmlMayBePackageInfoInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageDotHtmlMayBePackageInfoVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PackageDotHtmlMayBePackageInfoVisitor
    extends BaseInspectionVisitor {
        private PackageDotHtmlMayBePackageInfoVisitor() {
        }

        public void visitFile(PsiFile file) {
            super.visitFile(file);
            if (!(file instanceof XmlFile)) {
                return;
            }
            String fileName = file.getName();
            if (!"package.html".equals(fileName)) {
                return;
            }
            PsiDirectory directory = file.getContainingDirectory();
            if (directory == null) {
                return;
            }
            String aPackage = PackageDotHtmlMayBePackageInfoVisitor.getPackage(directory);
            if (aPackage == null) {
                return;
            }
            boolean exists = directory.findFile("package-info.java") != null;
            this.registerError((PsiElement)file, aPackage, exists);
        }

        public static String getPackage(@NotNull PsiDirectory directory) {
            if (directory == null) {
                PackageDotHtmlMayBePackageInfoVisitor.$$$reportNull$$$0(0);
            }
            VirtualFile virtualFile = directory.getVirtualFile();
            Project project = directory.getProject();
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
            return fileIndex.getPackageNameByDirectory(virtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$PackageDotHtmlMayBePackageInfoVisitor", "getPackage"));
        }
    }

    private static class PackageDotHtmlMayBePackageInfoFix
    extends InspectionGadgetsFix {
        private final String aPackage;

        PackageDotHtmlMayBePackageInfoFix(String aPackage) {
            this.aPackage = aPackage;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.convert.quickfix", new Object[0]);
            if (string == null) {
                PackageDotHtmlMayBePackageInfoFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            XmlFile xmlFile = (XmlFile)element;
            PsiDirectory directory = xmlFile.getContainingDirectory();
            if (directory == null) {
                return;
            }
            PsiFile file = directory.findFile("package-info.java");
            if (file != null) {
                return;
            }
            String packageInfoText = PackageDotHtmlMayBePackageInfoFix.getPackageInfoText(xmlFile);
            PsiJavaFile packageInfoFile = (PsiJavaFile)directory.createFile("package-info.java");
            String commentText = PackageDotHtmlMayBePackageInfoFix.buildCommentText(packageInfoText);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiDocComment comment = elementFactory.createDocCommentFromText(commentText);
            if (!this.aPackage.isEmpty()) {
                PsiPackageStatement packageStatement = elementFactory.createPackageStatement(this.aPackage);
                PsiElement addedElement = packageInfoFile.add((PsiElement)packageStatement);
                packageInfoFile.addBefore((PsiElement)comment, addedElement);
            } else {
                packageInfoFile.add((PsiElement)comment);
            }
            xmlFile.delete();
            if (this.isOnTheFly()) {
                packageInfoFile.navigate(true);
            }
        }

        @NotNull
        private static String buildCommentText(String packageInfoText) {
            StringBuilder commentText = new StringBuilder("/**\n");
            String[] lines = StringUtil.splitByLines((String)packageInfoText);
            boolean appended = false;
            for (String line : lines) {
                if (!appended && line.isEmpty()) continue;
                commentText.append(" * ").append(line).append('\n');
                appended = true;
            }
            commentText.append("*/");
            String string = commentText.toString();
            if (string == null) {
                PackageDotHtmlMayBePackageInfoFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        static String getPackageInfoText(XmlFile xmlFile) {
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                PsiElement[] children;
                for (PsiElement child : children = rootTag.getChildren()) {
                    HtmlTag htmlTag;
                    String name2;
                    if (!(child instanceof HtmlTag) || !"body".equalsIgnoreCase(name2 = (htmlTag = (HtmlTag)child).getName())) continue;
                    XmlTagValue value2 = htmlTag.getValue();
                    String string = value2.getText();
                    if (string == null) {
                        PackageDotHtmlMayBePackageInfoFix.$$$reportNull$$$0(2);
                    }
                    return string;
                }
            }
            String string = xmlFile.getText();
            if (string == null) {
                PackageDotHtmlMayBePackageInfoFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$PackageDotHtmlMayBePackageInfoFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildCommentText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageInfoText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class DeletePackageDotHtmlFix
    extends InspectionGadgetsFix {
        private DeletePackageDotHtmlFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("package.dot.html.may.be.package.info.delete.quickfix", new Object[0]);
            if (string == null) {
                DeletePackageDotHtmlFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof XmlFile)) {
                return;
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageDotHtmlMayBePackageInfoInspection$DeletePackageDotHtmlFix", "getFamilyName"));
        }
    }
}

