/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.BaseSwitchFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import one.util.streamex.Joining;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CreateMissingSwitchBranchesFix
extends BaseSwitchFix {
    private final Set<String> myNames;

    public CreateMissingSwitchBranchesFix(@NotNull PsiSwitchBlock block, Set<String> names) {
        if (block == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(0);
        }
        super(block);
        this.myNames = names;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        if (this.myNames.size() == 1) {
            String string = "Create missing switch branch '" + this.myNames.iterator().next() + "'";
            if (string == null) {
                CreateMissingSwitchBranchesFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = "Create missing branches: " + CreateMissingSwitchBranchesFix.formatMissingBranches(this.myNames);
        if (string == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Create enum switch branches" == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(4);
        }
        return "Create enum switch branches";
    }

    @Override
    protected void invoke() {
        PsiSwitchBlock switchBlock = (PsiSwitchBlock)this.myBlock.getElement();
        if (switchBlock == null) {
            return;
        }
        PsiCodeBlock body2 = switchBlock.getBody();
        PsiExpression switchExpression = switchBlock.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        boolean isRuleBasedFormat = SwitchUtils.isRuleFormatSwitch(switchBlock);
        if (body2 == null) {
            StringBuilder newStatementText = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            newStatementText.append("switch(").append(commentTracker.text((PsiElement)switchExpression)).append("){");
            for (String missingName : this.myNames) {
                newStatementText.append(String.join((CharSequence)"", CreateMissingSwitchBranchesFix.generateStatements(missingName, switchBlock, isRuleBasedFormat)));
            }
            newStatementText.append('}');
            commentTracker.replaceAndRestoreComments((PsiElement)switchBlock, newStatementText.toString());
            this.createTemplate(switchBlock);
            return;
        }
        List allEnumConstants = StreamEx.of((Object[])enumClass.getAllFields()).select(PsiEnumConstant.class).toList();
        Map nextEnumConstants = StreamEx.of((Collection)allEnumConstants).pairMap(Couple::of).toMap(c -> (PsiEnumConstant)c.getFirst(), c -> (PsiEnumConstant)c.getSecond());
        List missingEnumElements = ((StreamEx)StreamEx.of((Collection)allEnumConstants).filter(c -> this.myNames.contains(c.getName()))).toList();
        PsiEnumConstant nextEnumConstant = CreateMissingSwitchBranchesFix.getNextEnumConstant(nextEnumConstants, missingEnumElements);
        for (PsiElement bodyElement = body2.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
            List<PsiEnumConstant> constants = SwitchUtils.findEnumConstants((PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)bodyElement, PsiSwitchLabelStatementBase.class));
            while (nextEnumConstant != null && constants.contains(nextEnumConstant)) {
                CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore((PsiEnumConstant)missingEnumElements.get(0), bodyElement, switchBlock, isRuleBasedFormat);
                missingEnumElements.remove(0);
                if (missingEnumElements.isEmpty()) break;
                nextEnumConstant = CreateMissingSwitchBranchesFix.getNextEnumConstant(nextEnumConstants, missingEnumElements);
            }
            if (!CreateMissingSwitchBranchesFix.isDefaultSwitchLabelStatement(bodyElement)) continue;
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore(missingEnumElement, bodyElement, switchBlock, isRuleBasedFormat);
            }
            missingEnumElements.clear();
            break;
        }
        if (!missingEnumElements.isEmpty()) {
            PsiElement lastChild = body2.getLastChild();
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateMissingSwitchBranchesFix.addSwitchLabelStatementBefore(missingEnumElement, lastChild, switchBlock, isRuleBasedFormat);
            }
        }
        this.createTemplate(switchBlock);
    }

    private void createTemplate(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(5);
        }
        if (!(block instanceof PsiSwitchExpression)) {
            return;
        }
        Editor editor = BaseSwitchFix.prepareForTemplateAndObtainEditor((PsiElement)block);
        if (editor == null) {
            return;
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)block);
        List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)block.getBody(), PsiSwitchLabelStatementBase.class);
        List<PsiExpression> elementsToReplace = this.getElementsToReplace(labels2);
        for (PsiExpression expression2 : elementsToReplace) {
            builder.replaceElement((PsiElement)expression2, (Expression)new ConstantNode(expression2.getText()));
        }
        builder.run(editor, true);
    }

    @NotNull
    private List<PsiExpression> getElementsToReplace(@NotNull List<PsiSwitchLabelStatementBase> labels2) {
        if (labels2 == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(6);
        }
        ArrayList<PsiExpression> elementsToReplace = new ArrayList<PsiExpression>();
        for (PsiSwitchLabelStatementBase label : labels2) {
            List<PsiEnumConstant> constants = SwitchUtils.findEnumConstants(label);
            if (constants.size() != 1 || !this.myNames.contains(constants.get(0).getName())) continue;
            if (label instanceof PsiSwitchLabeledRuleStatement) {
                PsiStatement body2 = ((PsiSwitchLabeledRuleStatement)label).getBody();
                if (!(body2 instanceof PsiExpressionStatement)) continue;
                ContainerUtil.addIfNotNull(elementsToReplace, (Object)((PsiExpressionStatement)body2).getExpression());
                continue;
            }
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)label);
            if (next instanceof PsiBreakStatement) {
                ContainerUtil.addIfNotNull(elementsToReplace, (Object)((PsiBreakStatement)next).getValueExpression());
            }
            if (!(next instanceof PsiYieldStatement)) continue;
            ContainerUtil.addIfNotNull(elementsToReplace, (Object)((PsiYieldStatement)next).getExpression());
        }
        ArrayList<PsiExpression> arrayList = elementsToReplace;
        if (arrayList == null) {
            CreateMissingSwitchBranchesFix.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static List<String> generateStatements(String name2, PsiSwitchBlock switchBlock, boolean isRuleBasedFormat) {
        if (switchBlock instanceof PsiSwitchExpression) {
            String value2 = TypeUtils.getDefaultValue(((PsiSwitchExpression)switchBlock).getType());
            if (isRuleBasedFormat) {
                return Collections.singletonList("case " + name2 + " -> " + value2 + ";");
            }
            return Arrays.asList("case " + name2 + ":", "break " + value2 + ";");
        }
        if (isRuleBasedFormat) {
            return Collections.singletonList("case " + name2 + " -> {}");
        }
        return Arrays.asList("case " + name2 + ":", "break;");
    }

    private static void addSwitchLabelStatementBefore(PsiEnumConstant missingEnumElement, PsiElement anchor, PsiSwitchBlock switchBlock, boolean isRuleBasedFormat) {
        if (anchor instanceof PsiSwitchLabelStatement) {
            PsiElement sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            while (sibling instanceof PsiSwitchLabelStatement) {
                anchor = sibling;
                sibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            }
        }
        PsiElement correctedAnchor = anchor;
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        CreateMissingSwitchBranchesFix.generateStatements(missingEnumElement.getName(), switchBlock, isRuleBasedFormat).stream().map(text2 -> factory.createStatementFromText(text2, parent)).forEach(statement -> parent.addBefore((PsiElement)statement, correctedAnchor));
    }

    private static PsiEnumConstant getNextEnumConstant(Map<PsiEnumConstant, PsiEnumConstant> nextEnumConstants, List<PsiEnumConstant> missingEnumElements) {
        PsiEnumConstant nextEnumConstant = nextEnumConstants.get(missingEnumElements.get(0));
        while (missingEnumElements.contains(nextEnumConstant)) {
            nextEnumConstant = nextEnumConstants.get(nextEnumConstant);
        }
        return nextEnumConstant;
    }

    private static boolean isDefaultSwitchLabelStatement(PsiElement element) {
        return element instanceof PsiSwitchLabelStatementBase && ((PsiSwitchLabelStatementBase)element).isDefaultCase();
    }

    public static String formatMissingBranches(Set<String> names) {
        return (String)StreamEx.of(names).map(name2 -> "'" + name2 + "'").mapLast("and "::concat).collect((Collector)Joining.with((CharSequence)", ").maxChars(50).cutAfterDelimiter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/CreateMissingSwitchBranchesFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/CreateMissingSwitchBranchesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

