/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TooBroadCatchInspection
extends BaseInspection {
    public boolean onlyWarnOnRootExceptions = false;
    public boolean ignoreInTestCode = false;
    public boolean ignoreThrown = false;

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiElement context = (PsiElement)infos[1];
        SmartTypePointerManager pointerManager = SmartTypePointerManager.getInstance((Project)context.getProject());
        List maskedTypes = (List)infos[0];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        for (PsiType thrown : maskedTypes) {
            String typeText = thrown.getCanonicalText();
            if ("java.lang.RuntimeException".equals(typeText)) {
                fixes.add(new ReplaceWithRuntimeExceptionFix());
                continue;
            }
            fixes.add(new AddCatchSectionFix(pointerManager.createSmartTypePointer(thrown), typeText));
        }
        SuppressForTestsScopeFix fix2 = SuppressForTestsScopeFix.build(this, context);
        if (fix2 != null) {
            fixes.add(fix2);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            TooBroadCatchInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("too.broad.catch.option", new Object[0]), "onlyWarnOnRootExceptions");
        panel.addCheckbox(InspectionGadgetsBundle.message("overly.broad.throws.clause.ignore.thrown.option", new Object[0]), "ignoreThrown");
        return panel;
    }

    @NotNull
    public String getID() {
        if ("OverlyBroadCatchBlock" == null) {
            TooBroadCatchInspection.$$$reportNull$$$0(1);
        }
        return "OverlyBroadCatchBlock";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.catch.display.name", new Object[0]);
        if (string == null) {
            TooBroadCatchInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        List typesMasked = (List)infos[0];
        String typesMaskedString = ((PsiType)typesMasked.get(0)).getPresentableText();
        if (typesMasked.size() == 1) {
            String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor", typesMaskedString);
            if (string == null) {
                TooBroadCatchInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        int lastTypeIndex = typesMasked.size() - 1;
        for (int i = 1; i < lastTypeIndex; ++i) {
            typesMaskedString = typesMaskedString + ", ";
            typesMaskedString = typesMaskedString + ((PsiType)typesMasked.get(i)).getPresentableText();
        }
        String lastTypeString = ((PsiType)typesMasked.get(lastTypeIndex)).getPresentableText();
        String string = InspectionGadgetsBundle.message("too.broad.catch.problem.descriptor1", typesMaskedString, lastTypeString);
        if (string == null) {
            TooBroadCatchInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadCatchVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/TooBroadCatchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class TooBroadCatchVisitor
    extends BaseInspectionVisitor {
        private TooBroadCatchVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                TooBroadCatchVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            PsiCodeBlock tryBlock = statement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Set<PsiClassType> thrownTypes = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement.getResourceList(), thrownTypes);
            HashSet caughtTypes = new HashSet(thrownTypes.size());
            PsiCatchSection[] catchSections = statement.getCatchSections();
            boolean runtimeExceptionSeen = false;
            for (PsiCatchSection catchSection : catchSections) {
                PsiTypeElement typeElement;
                PsiParameter parameter2 = catchSection.getParameter();
                if (parameter2 == null || (typeElement = parameter2.getTypeElement()) == null) continue;
                PsiTypeElement[] children = (PsiTypeElement[])PsiTreeUtil.getChildrenOfType((PsiElement)typeElement, PsiTypeElement.class);
                if (children != null) {
                    for (PsiTypeElement child : children) {
                        runtimeExceptionSeen = this.check(thrownTypes, child, runtimeExceptionSeen, caughtTypes);
                    }
                    continue;
                }
                runtimeExceptionSeen = this.check(thrownTypes, typeElement, runtimeExceptionSeen, caughtTypes);
            }
        }

        private boolean check(Set<? extends PsiClassType> thrownTypes, PsiTypeElement caughtTypeElement, boolean runtimeExceptionSeen, Set<? super PsiType> caughtTypes) {
            PsiType caughtType = caughtTypeElement.getType();
            if ("java.lang.RuntimeException".equals(caughtType.getCanonicalText())) {
                runtimeExceptionSeen = true;
            } else if (thrownTypes.isEmpty() && "java.lang.Exception".equals(caughtType.getCanonicalText()) && !runtimeExceptionSeen) {
                PsiClassType runtimeExceptionType = TypeUtils.getType("java.lang.RuntimeException", (PsiElement)caughtTypeElement);
                this.registerError((PsiElement)caughtTypeElement, Collections.singletonList(runtimeExceptionType), caughtTypeElement);
            }
            List<PsiType> maskedExceptions = this.findMaskedExceptions(thrownTypes, caughtType, caughtTypes);
            if (maskedExceptions.isEmpty()) {
                return runtimeExceptionSeen;
            }
            this.registerError((PsiElement)caughtTypeElement, maskedExceptions, caughtTypeElement);
            return runtimeExceptionSeen;
        }

        private List<PsiType> findMaskedExceptions(Set<? extends PsiClassType> thrownTypes, PsiType caughtType, Set<? super PsiType> caughtTypes) {
            if (thrownTypes.contains(caughtType)) {
                caughtTypes.add((PsiType)caughtType);
                thrownTypes.remove(caughtType);
                if (TooBroadCatchInspection.this.ignoreThrown) {
                    return Collections.emptyList();
                }
            }
            if (TooBroadCatchInspection.this.onlyWarnOnRootExceptions && !ExceptionUtils.isGenericExceptionClass(caughtType)) {
                return Collections.emptyList();
            }
            ArrayList<PsiType> maskedTypes = new ArrayList<PsiType>();
            for (PsiType psiType : thrownTypes) {
                if (caughtTypes.contains(psiType) || !caughtType.isAssignableFrom(psiType)) continue;
                caughtTypes.add((PsiType)psiType);
                maskedTypes.add(psiType);
            }
            return maskedTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$TooBroadCatchVisitor", "visitTryStatement"));
        }
    }

    private static class AddCatchSectionFix
    extends InspectionGadgetsFix {
        private final SmartTypePointer myThrown;
        private final String myText;

        AddCatchSectionFix(SmartTypePointer thrown, String typeText) {
            this.myThrown = thrown;
            this.myText = typeText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.catch.quickfix", this.myText);
            if (string == null) {
                AddCatchSectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Add 'catch' clause" == null) {
                AddCatchSectionFix.$$$reportNull$$$0(1);
            }
            return "Add 'catch' clause";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiType thrownType = this.myThrown.getType();
            if (thrownType == null) {
                return;
            }
            PsiElement typeElement = descriptor.getPsiElement();
            if (typeElement == null) {
                return;
            }
            PsiElement catchParameter = typeElement.getParent();
            if (!(catchParameter instanceof PsiParameter)) {
                return;
            }
            PsiElement catchBlock = ((PsiParameter)catchParameter).getDeclarationScope();
            if (!(catchBlock instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection myBeforeCatchSection = (PsiCatchSection)catchBlock;
            PsiTryStatement myTryStatement = myBeforeCatchSection.getTryStatement();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String name2 = codeStyleManager.suggestUniqueVariableName("e", (PsiElement)myTryStatement.getTryBlock(), false);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiCatchSection section = factory.createCatchSection(thrownType, name2, (PsiElement)myTryStatement);
            PsiCatchSection element = (PsiCatchSection)myTryStatement.addBefore((PsiElement)section, (PsiElement)myBeforeCatchSection);
            codeStyleManager.shortenClassReferences((PsiElement)element);
            if (this.isOnTheFly()) {
                PsiCodeBlock newBlock = element.getCatchBlock();
                assert (newBlock != null);
                TextRange range = SurroundWithUtil.getRangeToSelect(newBlock);
                PsiFile file = element.getContainingFile();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor == null) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (editor.getDocument() != document) {
                    return;
                }
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/errorhandling/TooBroadCatchInspection$AddCatchSectionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ReplaceWithRuntimeExceptionFix
    extends InspectionGadgetsFix {
        private ReplaceWithRuntimeExceptionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.with.catch.clause.for.runtime.exception.quickfix", new Object[0]);
            if (string == null) {
                ReplaceWithRuntimeExceptionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClassType type2 = factory.createTypeByFQClassName("java.lang.RuntimeException");
            PsiTypeElement newTypeElement = factory.createTypeElement((PsiType)type2);
            typeElement.replace((PsiElement)newTypeElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$ReplaceWithRuntimeExceptionFix", "getFamilyName"));
        }
    }
}

