/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ClassUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastUtils;

public class SuspiciousPackagePrivateAccessInspection
extends AbstractBaseUastLocalInspectionTool {
    private static final Key<SuspiciousPackagePrivateAccessInspection> INSPECTION_KEY = Key.create((String)"SuspiciousPackagePrivateAccess");
    @XCollection
    public List<ModulesSet> MODULES_SETS_LOADED_TOGETHER = new ArrayList<ModulesSet>();
    private final AtomicClearableLazyValue<Map<String, ModulesSet>> myModuleSetByModuleName = AtomicClearableLazyValue.create(() -> {
        HashMap<String, ModulesSet> result = new HashMap<String, ModulesSet>();
        for (ModulesSet modulesSet : this.MODULES_SETS_LOADED_TOGETHER) {
            for (String module : modulesSet.modules) {
                result.put(module, modulesSet);
            }
        }
        return result;
    });

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = ApiUsageUastVisitor.createPsiElementVisitor(new SuspiciousApiUsageProcessor(holder, (Map)this.myModuleSetByModuleName.getValue()));
        if (psiElementVisitor == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static boolean canAccessProtectedMember(UElement sourceNode, PsiMember member, PsiClass accessObjectType) {
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass contextClass = SuspiciousPackagePrivateAccessInspection.getContextClass(sourceNode, member instanceof PsiClass);
        if (contextClass == null) {
            return false;
        }
        return SuspiciousPackagePrivateAccessInspection.canAccessProtectedMember(member, memberClass, accessObjectType, member.hasModifierProperty("static"), contextClass);
    }

    private static boolean canAccessProtectedMember(@NotNull PsiMember member, @NotNull PsiClass memberClass, @Nullable PsiClass accessObjectClass, boolean isStatic, @NotNull PsiClass contextClass) {
        if (member == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(2);
        }
        if (memberClass == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(3);
        }
        if (contextClass == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(4);
        }
        if (!ClassUtils.inSamePackage((PsiElement)memberClass, (PsiElement)contextClass)) {
            return true;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)memberClass, (boolean)true) && (member instanceof PsiClass || isStatic || accessObjectClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)accessObjectClass, (PsiClass)contextClass, (boolean)true));
    }

    @Nullable
    private static PsiClass getContextClass(@NotNull UElement sourceNode, boolean forClassReference) {
        PsiElement sourcePsi;
        UClass sourceClass;
        if (sourceNode == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(5);
        }
        if ((sourceClass = (UClass)UastUtils.findContaining((PsiElement)(sourcePsi = sourceNode.getSourcePsi()), UClass.class)) == null) {
            return null;
        }
        if (SuspiciousPackagePrivateAccessInspection.isReferenceBelongsToEnclosingClass(sourceNode, sourceClass, forClassReference)) {
            UClass parentClass = UastUtils.getContainingUClass((UElement)sourceClass);
            return parentClass != null ? parentClass.getJavaPsi() : null;
        }
        return sourceClass.getJavaPsi();
    }

    private static boolean isReferenceBelongsToEnclosingClass(@NotNull UElement sourceNode, @NotNull UClass sourceClass, boolean forClassReference) {
        UElement parent;
        if (sourceNode == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(6);
        }
        if (sourceClass == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(7);
        }
        if ((parent = sourceClass.getUastParent()) instanceof UObjectLiteralExpression && ((UCallExpression)parent).getValueArguments().stream().anyMatch(it -> UastUtils.isPsiAncestor((UElement)it, (UElement)sourceNode))) {
            return true;
        }
        return forClassReference && sourceClass.getUastSuperTypes().stream().anyMatch(it -> UastUtils.isPsiAncestor((UElement)it, (UElement)sourceNode));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextArea component = new JBTextArea(5, 80);
        component.setText(this.MODULES_SETS_LOADED_TOGETHER.stream().map(it -> String.join((CharSequence)",", it.modules)).collect(Collectors.joining("\n")));
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.clear();
                for (String line : StringUtil.splitByLines((String)component.getText())) {
                    ModulesSet set = new ModulesSet();
                    set.modules = new LinkedHashSet<String>(StringUtil.split((String)line, (String)","));
                    if (set.modules.isEmpty()) continue;
                    SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.add(set);
                }
                SuspiciousPackagePrivateAccessInspection.this.myModuleSetByModuleName.drop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$1", "textChanged"));
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        JPanel labels2 = new JPanel(new FlowLayout(0));
        labels2.add((Component)new JBLabel(InspectionGadgetsBundle.message("groups.of.modules.loaded.together.label", new Object[0])));
        labels2.add((Component)ContextHelpLabel.create((String)InspectionGadgetsBundle.message("groups.of.modules.loaded.together.description", new Object[0])));
        panel.add((Component)labels2, "North");
        panel.add((Component)new JBScrollPane((Component)component), "Center");
        return panel;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            SuspiciousPackagePrivateAccessInspection.$$$reportNull$$$0(8);
        }
        super.readSettings(node);
        this.myModuleSetByModuleName.drop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canAccessProtectedMember";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceBelongsToEnclosingClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MarkModulesAsLoadedTogetherFix
    implements LocalQuickFix {
        private final String myModule1;
        private final String myModule2;

        private MarkModulesAsLoadedTogetherFix(String module1, String module2) {
            this.myModule1 = module1;
            this.myModule2 = module2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = "Mark '" + this.myModule1 + "' and '" + this.myModule2 + "' modules as loaded together";
            if (string == null) {
                MarkModulesAsLoadedTogetherFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            if ("Mark modules as loaded together" == null) {
                MarkModulesAsLoadedTogetherFix.$$$reportNull$$$0(1);
            }
            return "Mark modules as loaded together";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MarkModulesAsLoadedTogetherFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MarkModulesAsLoadedTogetherFix.$$$reportNull$$$0(3);
            }
            InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement != null) {
                profile.modifyToolSettings(INSPECTION_KEY, psiElement, inspection -> {
                    Map moduleSetByModule = (Map)((SuspiciousPackagePrivateAccessInspection)inspection).myModuleSetByModuleName.getValue();
                    ModulesSet module1Set = (ModulesSet)moduleSetByModule.get(this.myModule1);
                    ModulesSet module2Set = (ModulesSet)moduleSetByModule.get(this.myModule2);
                    if (module1Set == null) {
                        if (module2Set == null) {
                            ModulesSet modulesSet = new ModulesSet();
                            modulesSet.modules.add(this.myModule1);
                            modulesSet.modules.add(this.myModule2);
                            inspection.MODULES_SETS_LOADED_TOGETHER.add(modulesSet);
                        } else {
                            module2Set.modules.add(this.myModule1);
                        }
                    } else if (module2Set == null) {
                        module1Set.modules.add(this.myModule2);
                    } else if (module1Set != module2Set) {
                        module1Set.modules.addAll(module2Set.modules);
                        inspection.MODULES_SETS_LOADED_TOGETHER.remove(module2Set);
                    }
                    ((SuspiciousPackagePrivateAccessInspection)inspection).myModuleSetByModuleName.drop();
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$MarkModulesAsLoadedTogetherFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$MarkModulesAsLoadedTogetherFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="modules-set")
    public static class ModulesSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        public Set<String> modules = new LinkedHashSet<String>();
    }

    private static class SuspiciousApiUsageProcessor
    implements ApiUsageProcessor {
        private final ProblemsHolder myProblemsHolder;
        private final Map<String, ModulesSet> myModuleNameToModulesSet;

        private SuspiciousApiUsageProcessor(ProblemsHolder problemsHolder, Map<String, ModulesSet> moduleNameToModulesSet) {
            this.myProblemsHolder = problemsHolder;
            this.myModuleNameToModulesSet = moduleNameToModulesSet;
        }

        @Override
        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            if (sourceNode == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(0);
            }
            if (target == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(1);
            }
            PsiClass accessObjectType = SuspiciousApiUsageProcessor.getAccessObjectType(qualifier);
            if (target instanceof PsiJvmMember) {
                this.checkAccess(sourceNode, (PsiJvmMember)target, accessObjectType);
                if (!(target instanceof PsiClass) && accessObjectType != null) {
                    this.checkAccess(sourceNode, (PsiJvmMember)accessObjectType, null);
                }
            }
        }

        @Override
        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            if (sourceNode == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(2);
            }
            if (instantiatedClass == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(3);
            }
            if (subclassDeclaration == null && constructor != null) {
                this.checkAccess(sourceNode, (PsiJvmMember)constructor, null);
            }
        }

        @Nullable
        private static PsiClass getAccessObjectType(@Nullable UExpression qualifier) {
            if (qualifier == null || qualifier instanceof UThisExpression || qualifier instanceof USuperExpression) {
                return null;
            }
            PsiType type2 = qualifier.getExpressionType();
            if (type2 instanceof PsiClassType) {
                return ((PsiClassType)type2).resolve();
            }
            if (qualifier instanceof UReferenceExpression) {
                return (PsiClass)ObjectUtils.tryCast((Object)((UReferenceExpression)qualifier).resolve(), PsiClass.class);
            }
            return null;
        }

        private void checkAccess(@NotNull UElement sourceNode, @NotNull PsiJvmMember target, @Nullable PsiClass accessObjectType) {
            if (sourceNode == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(4);
            }
            if (target == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(5);
            }
            if (target.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
                this.checkPackageLocalAccess(sourceNode, target, "package-private");
            } else if (target.hasModifier(JvmModifier.PROTECTED) && !SuspiciousPackagePrivateAccessInspection.canAccessProtectedMember(sourceNode, (PsiMember)target, accessObjectType)) {
                this.checkPackageLocalAccess(sourceNode, target, "protected and used not through a subclass here");
            }
        }

        private void checkPackageLocalAccess(@NotNull UElement sourceNode, PsiJvmMember targetElement, String accessType) {
            PsiElement sourcePsi;
            if (sourceNode == null) {
                SuspiciousApiUsageProcessor.$$$reportNull$$$0(6);
            }
            if ((sourcePsi = sourceNode.getSourcePsi()) != null) {
                Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement);
                Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
                if (this.isPackageLocalAccessSuspicious(sourceModule, targetModule) && PsiTreeUtil.getParentOfType((PsiElement)sourcePsi, PsiComment.class) == null) {
                    List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)targetElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
                    String elementDescription = StringUtil.removeHtmlTags((String)StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)targetElement, (boolean)true)));
                    Object[] quickFixes = IntentionWrapper.wrapToQuickFixes((IntentionAction[])fixes.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)targetElement.getContainingFile());
                    this.myProblemsHolder.registerProblem(sourcePsi, elementDescription + " is " + accessType + ", but declared in a different module '" + targetModule.getName() + "'", (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)new MarkModulesAsLoadedTogetherFix(sourceModule.getName(), targetModule.getName())));
                }
            }
        }

        private boolean isPackageLocalAccessSuspicious(Module sourceModule, Module targetModule) {
            if (targetModule == null || sourceModule == null || targetModule.equals(sourceModule)) {
                return false;
            }
            ModulesSet sourceGroup = this.myModuleNameToModulesSet.get(sourceModule.getName());
            ModulesSet targetGroup = this.myModuleNameToModulesSet.get(targetModule.getName());
            return sourceGroup == null || sourceGroup != targetGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instantiatedClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/dependency/SuspiciousPackagePrivateAccessInspection$SuspiciousApiUsageProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReference";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processConstructorInvocation";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAccess";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageLocalAccess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

