/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.ScopeUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooBroadScopeInspection
extends BaseInspection {
    public boolean m_allowConstructorAsInitializer = false;
    public boolean m_onlyLookAtBlocks = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("too.broad.scope.display.name", new Object[0]);
        if (string == null) {
            TooBroadScopeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("TooBroadScope" == null) {
            TooBroadScopeInspection.$$$reportNull$$$0(1);
        }
        return "TooBroadScope";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel checkboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.only.blocks.option", new Object[0]), "m_onlyLookAtBlocks");
        checkboxOptionsPanel.addCheckbox(InspectionGadgetsBundle.message("too.broad.scope.allow.option", new Object[0]), "m_allowConstructorAsInitializer");
        return checkboxOptionsPanel;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("too.broad.scope.problem.descriptor", new Object[0]);
        if (string == null) {
            TooBroadScopeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isMovable(PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) == null) {
            return true;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)expression2) || ExpressionUtils.isNullLiteral(expression2)) {
            return true;
        }
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
            for (PsiExpression initializer : arrayInitializerExpression.getInitializers()) {
                if (this.isMovable(initializer)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiExpression[] expressions2;
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            PsiExpression[] arrayDimensions = newExpression.getArrayDimensions();
            if (arrayDimensions.length > 0) {
                for (PsiExpression arrayDimension : arrayDimensions) {
                    if (this.isMovable(arrayDimension)) continue;
                    return false;
                }
                return true;
            }
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer != null) {
                PsiExpression[] initializers;
                for (PsiExpression initializerExpression : initializers = arrayInitializer.getInitializers()) {
                    if (this.isMovable(initializerExpression)) continue;
                    return false;
                }
                return true;
            }
            PsiType type2 = newExpression.getType();
            if (type2 == null) {
                return false;
            }
            if (!this.m_allowConstructorAsInitializer && !TooBroadScopeInspection.isAllowedType(type2)) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            for (PsiExpression argumentExpression : expressions2 = argumentList.getExpressions()) {
                if (this.isMovable(argumentExpression)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (!this.isMovable(qualifier)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiClass) {
                return true;
            }
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (!ClassUtils.isImmutable(variable.getType()) && !CollectionUtils.isEmptyArray(variable)) {
                return false;
            }
            if (variable.hasModifierProperty("final")) {
                return true;
            }
            PsiElement context = PsiUtil.getVariableCodeBlock((PsiVariable)variable, (PsiElement)referenceExpression);
            return context != null && !(variable instanceof PsiField) && HighlightControlFlowUtil.isEffectivelyFinal(variable, context, (PsiJavaCodeReferenceElement)referenceExpression);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                if (this.isMovable(operand2)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            if (!TooBroadScopeInspection.isAllowedType(expression2.getType())) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (!TooBroadScopeInspection.isAllowedMethod(method)) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null && !this.isMovable(qualifierExpression2)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            for (PsiExpression argument : argumentList.getExpressions()) {
                if (this.isMovable(argument)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        return new TooBroadScopeInspectionFix(variable.getName());
    }

    private static boolean isAllowedMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null || !qualifiedName.startsWith("java.") || qualifiedName.equals("java.lang.Thread")) {
            return false;
        }
        String methodName = method.getName();
        return !"now".equals(methodName) && !"currentTimeMillis".equals(methodName) && !"nanoTime".equals(methodName) && !"waitFor".equals(methodName);
    }

    private static boolean isAllowedType(PsiType type2) {
        if (ClassUtils.isImmutable(type2)) {
            return true;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return TooBroadScopeInspection.isAllowedClass(aClass);
    }

    private static boolean isAllowedClass(@Nullable PsiClass aClass) {
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
            return true;
        }
        return aClass != null && aClass.isEnum();
    }

    static List<PsiReferenceExpression> findReferences(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            TooBroadScopeInspection.$$$reportNull$$$0(3);
        }
        SmartList result = new SmartList();
        ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope()).forEach(arg_0 -> TooBroadScopeInspection.lambda$findReferences$0((List)result, arg_0));
        return result;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TooBroadScopeVisitor();
    }

    private static /* synthetic */ boolean lambda$findReferences$0(List result, PsiReference reference) {
        return reference instanceof PsiReferenceExpression && result.add((PsiReferenceExpression)reference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/dataflow/TooBroadScopeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TooBroadScopeInspectionFix
    extends InspectionGadgetsFix {
        private final String variableName;

        TooBroadScopeInspectionFix(String variableName) {
            this.variableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.scope.narrow.quickfix", this.variableName);
            if (string == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Narrow scope" == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(1);
            }
            return "Narrow scope";
        }

        @Override
        protected void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            PsiDeclarationStatement newDeclaration;
            PsiElement referenceElement;
            PsiElement firstReferenceScope;
            PsiElement variableIdentifier;
            if (project == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(2);
            }
            if (!((variableIdentifier = descriptor.getPsiElement()) instanceof PsiIdentifier)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)variableIdentifier.getParent();
            assert (variable != null);
            List<PsiReferenceExpression> references = TooBroadScopeInspection.findReferences(variable);
            PsiElement commonParent = ScopeUtils.getCommonParent(references);
            if (commonParent == null) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class});
                if (variableScope == null) {
                    return;
                }
                if ((commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                    return;
                }
            }
            if ((firstReferenceScope = PsiTreeUtil.getParentOfType((PsiElement)(referenceElement = (PsiElement)references.get(0)), (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class, PsiTryStatement.class})) == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            if (commonParent instanceof PsiTryStatement) {
                PsiElement resourceReference = referenceElement.getParent();
                PsiResourceVariable resourceVariable = JavaPsiFacade.getElementFactory((Project)project).createResourceVariable(Objects.requireNonNull(variable.getName()), variable.getType(), tracker.markUnchanged(initializer), (PsiElement)variable);
                newDeclaration = resourceReference.getParent().addBefore((PsiElement)resourceVariable, resourceReference);
                resourceReference.delete();
            } else if (commonParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)commonParent;
                PsiStatement initialization = forStatement.getInitialization();
                if (initialization == null) {
                    return;
                }
                if (initialization instanceof PsiExpressionStatement) {
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)initialization;
                    PsiExpression expression2 = expressionStatement.getExpression();
                    if (!(expression2 instanceof PsiAssignmentExpression)) {
                        return;
                    }
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    newDeclaration = this.createNewDeclaration((PsiVariable)variable, rhs, tracker);
                } else {
                    newDeclaration = this.createNewDeclaration((PsiVariable)variable, initializer, tracker);
                }
                newDeclaration = initialization.replace((PsiElement)newDeclaration);
            } else if (firstReferenceScope.equals(commonParent)) {
                newDeclaration = this.moveDeclarationToLocation((PsiVariable)variable, referenceElement, tracker);
            } else {
                PsiElement commonParentChild = ScopeUtils.getChildWhichContainsElement(commonParent, referenceElement);
                if (commonParentChild == null) {
                    return;
                }
                PsiElement location = commonParentChild.getPrevSibling();
                newDeclaration = this.createNewDeclaration((PsiVariable)variable, initializer, tracker);
                newDeclaration = commonParent.addAfter((PsiElement)newDeclaration, location);
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            newDeclaration = codeStyleManager.reformat((PsiElement)newDeclaration);
            this.removeOldVariable((PsiVariable)variable, tracker);
            tracker.insertCommentsBefore((PsiElement)newDeclaration);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement((PsiElement)newDeclaration);
            }
        }

        private void removeOldVariable(@NotNull PsiVariable variable, CommentTracker tracker) {
            PsiDeclarationStatement declaration2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(3);
            }
            if ((declaration2 = (PsiDeclarationStatement)variable.getParent()) == null) {
                return;
            }
            PsiElement[] declaredElements = declaration2.getDeclaredElements();
            if (declaredElements.length == 1) {
                tracker.delete((PsiElement)declaration2);
            } else {
                tracker.delete((PsiElement)variable);
            }
        }

        private PsiDeclarationStatement createNewDeclaration(@NotNull PsiVariable variable, @Nullable PsiExpression initializer, CommentTracker tracker) {
            PsiTypeElement typeElement;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(4);
            }
            Project project = variable.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            String name2 = variable.getName();
            if (name2 == null) {
                name2 = "";
            }
            PsiType type2 = variable.getType();
            PsiDeclarationStatement newDeclaration = factory.createVariableDeclarationStatement(name2, type2, tracker.markUnchanged(initializer), (PsiElement)variable);
            PsiLocalVariable newVariable = (PsiLocalVariable)newDeclaration.getDeclaredElements()[0];
            PsiModifierList newModifierList = newVariable.getModifierList();
            PsiModifierList modifierList = variable.getModifierList();
            if (newModifierList != null && modifierList != null) {
                newModifierList.setModifierProperty("final", variable.hasModifierProperty("final"));
                GenerateMembersUtil.copyAnnotations(modifierList, newModifierList, new String[0]);
            }
            if ((typeElement = variable.getTypeElement()) != null && typeElement.isInferredType()) {
                newVariable.getTypeElement().replace((PsiElement)factory.createTypeElementFromText("var", (PsiElement)variable));
            }
            return newDeclaration;
        }

        private PsiDeclarationStatement moveDeclarationToLocation(@NotNull PsiVariable variable, @NotNull PsiElement location, CommentTracker tracker) {
            PsiExpressionStatement expressionStatement;
            PsiExpression expression2;
            if (variable == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(5);
            }
            if (location == null) {
                TooBroadScopeInspectionFix.$$$reportNull$$$0(6);
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)location, PsiStatement.class, (boolean)false);
            assert (statement != null);
            PsiElement statementParent = statement.getParent();
            while (statementParent instanceof PsiStatement && !(statementParent instanceof PsiForStatement)) {
                statement = (PsiStatement)statementParent;
                statementParent = statement.getParent();
            }
            assert (statementParent != null);
            PsiExpression initializer = variable.getInitializer();
            if (TooBroadScopeInspection.this.isMovable(initializer) && statement instanceof PsiExpressionStatement && (expression2 = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                PsiExpression rhs = assignmentExpression.getRExpression();
                PsiExpression lhs = assignmentExpression.getLExpression();
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (location.equals(lhs) && JavaTokenType.EQ == tokenType && !VariableAccessUtils.variableIsUsed(variable, (PsiElement)rhs)) {
                    PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, rhs, tracker);
                    newDeclaration = (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
                    PsiElement parent = assignmentExpression.getParent();
                    assert (parent != null);
                    tracker.delete(parent);
                    return newDeclaration;
                }
            }
            PsiDeclarationStatement newDeclaration = this.createNewDeclaration(variable, initializer, tracker);
            if (statement instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)statement;
                PsiStatement initialization = forStatement.getInitialization();
                newDeclaration = (PsiDeclarationStatement)forStatement.addBefore((PsiElement)newDeclaration, (PsiElement)initialization);
                if (initialization != null) {
                    tracker.delete((PsiElement)initialization);
                }
                return newDeclaration;
            }
            return (PsiDeclarationStatement)statementParent.addBefore((PsiElement)newDeclaration, (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/dataflow/TooBroadScopeInspection$TooBroadScopeInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeOldVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewDeclaration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "moveDeclarationToLocation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TooBroadScopeVisitor
    extends BaseInspectionVisitor {
        TooBroadScopeVisitor() {
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (variable instanceof PsiResourceVariable) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (!TooBroadScopeInspection.this.isMovable(initializer)) {
                return;
            }
            List<PsiReferenceExpression> references = TooBroadScopeInspection.findReferences(variable);
            if (references.isEmpty()) {
                return;
            }
            PsiElement commonParent = ScopeUtils.getCommonParent(references);
            if (commonParent == null) {
                return;
            }
            PsiElement variableScope = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiForStatement.class});
            if (variableScope == null) {
                return;
            }
            if (initializer != null && (commonParent = ScopeUtils.moveOutOfLoopsAndClasses(commonParent, variableScope)) == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)commonParent, (PsiElement)variableScope, (boolean)true)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)commonParent, (boolean)true)) {
                this.registerVariableError((PsiVariable)variable, variable);
                return;
            }
            if (TooBroadScopeInspection.this.m_onlyLookAtBlocks) {
                return;
            }
            if (commonParent instanceof PsiForStatement) {
                return;
            }
            PsiElement referenceElement = (PsiElement)references.get(0);
            PsiElement blockChild = ScopeUtils.getChildWhichContainsElement(variableScope, referenceElement);
            if (blockChild == null) {
                return;
            }
            PsiElement insertionPoint = ScopeUtils.findTighterDeclarationLocation(blockChild, (PsiVariable)variable);
            if (insertionPoint == null) {
                if (!(blockChild instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)blockChild;
                PsiExpression expression2 = expressionStatement.getExpression();
                if (!(expression2 instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                IElementType tokenType = assignmentExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQ) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!lhs.equals(referenceElement)) {
                    return;
                }
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)rhs)) {
                    return;
                }
            }
            if (insertionPoint != null && FileTypeUtils.isInServerPageFile((PsiElement)insertionPoint)) {
                PsiElement variableParent;
                PsiElement elementBefore = insertionPoint.getPrevSibling();
                if ((elementBefore = PsiTreeUtil.skipWhitespacesBackward((PsiElement)elementBefore)) instanceof PsiDeclarationStatement && elementBefore.equals(variableParent = variable.getParent())) {
                    return;
                }
            }
            this.registerVariableError((PsiVariable)variable, variable);
        }
    }
}

