/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("RedundantIfStatement" == null) {
            TrivialIfInspection.$$$reportNull$$$0(0);
        }
        return "RedundantIfStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.if.display.name", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialIfInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new TrivialIfFix();
    }

    public static void simplify(PsiIfStatement statement) {
        IfBranches branches = IfBranches.fromAssignment(statement);
        if (branches != null) {
            TrivialIfInspection.replaceSimplifiableAssignment(statement, branches);
            return;
        }
        branches = IfBranches.fromReturn(statement);
        if (branches != null) {
            TrivialIfInspection.replaceSimplifiableReturn(statement, branches);
            return;
        }
        branches = IfBranches.fromImplicitReturn(statement);
        if (branches != null) {
            TrivialIfInspection.replaceSimplifiableImplicitReturn(statement, branches);
            return;
        }
        branches = IfBranches.fromImplicitAssignment(statement);
        if (branches != null) {
            TrivialIfInspection.replaceSimplifiableImplicitAssignment(statement, branches);
            return;
        }
        if (TrivialIfInspection.isSimplifiableAssert(statement)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement) {
        PsiExpression condition2 = statement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        if (statement.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory((Project)statement.getProject()).createExpressionFromText(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText(), (PsiElement)statement);
        assertCondition.replace((PsiElement)replacementCondition);
        statement.replace((PsiElement)assertStatement);
    }

    private static void replaceSimplifiableImplicitReturn(PsiIfStatement statement, IfBranches branches) {
        PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)branches.myThenExpression, PsiReturnStatement.class);
        if (returnStatement == null) {
            return;
        }
        PsiReturnStatement nextStatement = ControlFlowUtils.getNextReturnStatement((PsiStatement)statement);
        if (nextStatement == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String replacementText = branches.getReplacementText(ct);
        if (replacementText == null) {
            return;
        }
        if (Objects.requireNonNull(nextStatement.getReturnValue()).textMatches((CharSequence)replacementText)) {
            ct.deleteAndRestoreComments((PsiElement)statement);
        } else {
            PsiElement sibling;
            if (nextStatement.getParent() == statement.getParent() && (sibling = nextStatement.getPrevSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
            ct.replace((PsiElement)Objects.requireNonNull(returnStatement.getReturnValue()), replacementText);
            ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)returnStatement);
            if (!ControlFlowUtils.isReachable((PsiStatement)nextStatement)) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)nextStatement);
            }
        }
    }

    private static void replaceSimplifiableReturn(PsiIfStatement statement, IfBranches branches) {
        PsiReturnStatement returnStatement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)branches.myThenExpression, PsiReturnStatement.class);
        if (returnStatement == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String replacementText = branches.getReplacementText(ct);
        if (replacementText == null) {
            return;
        }
        ct.replace((PsiElement)Objects.requireNonNull(returnStatement.getReturnValue()), replacementText);
        ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)returnStatement);
    }

    private static void replaceSimplifiableAssignment(PsiIfStatement statement, IfBranches branches) {
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)branches.myThenExpression, PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        PsiElement assignmentParent = assignment.getParent();
        assert (assignmentParent instanceof PsiExpressionStatement);
        CommentTracker ct = new CommentTracker();
        String replacementText = branches.getReplacementText(ct);
        if (replacementText == null) {
            return;
        }
        ct.replace((PsiElement)Objects.requireNonNull(assignment.getRExpression()), replacementText);
        ct.replaceAndRestoreComments((PsiElement)statement, assignmentParent);
    }

    private static void replaceSimplifiableImplicitAssignment(PsiIfStatement statement, IfBranches branches) {
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)branches.myThenExpression, PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        PsiElement assignmentParent = assignment.getParent();
        assert (assignmentParent instanceof PsiExpressionStatement);
        PsiStatement prevStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement), PsiStatement.class);
        if (prevStatement == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        ct.delete((PsiElement)prevStatement);
        String replacementText = branches.getReplacementText(ct);
        if (replacementText == null) {
            return;
        }
        ct.replace((PsiElement)Objects.requireNonNull(assignment.getRExpression()), replacementText);
        ct.replaceAndRestoreComments((PsiElement)statement, assignmentParent);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialIfVisitor();
    }

    public static boolean isTrivial(PsiIfStatement ifStatement) {
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        IfBranches branches = IfBranches.fromAssignment(ifStatement);
        if (branches == null) {
            branches = IfBranches.fromReturn(ifStatement);
        }
        if (branches == null) {
            branches = IfBranches.fromImplicitReturn(ifStatement);
        }
        if (branches == null) {
            branches = IfBranches.fromImplicitAssignment(ifStatement);
        }
        if (branches != null && (branches.isFalseTrue() || branches.isTrueFalse() || branches.getRedundantComparisonReplacement() != null)) {
            return true;
        }
        return TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/TrivialIfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IfBranches {
        @NotNull
        final PsiExpression myCondition;
        @NotNull
        final PsiExpression myThenExpression;
        @NotNull
        final PsiExpression myElseExpression;

        IfBranches(@NotNull PsiExpression condition2, @NotNull PsiExpression thenExpression2, @NotNull PsiExpression elseExpression2) {
            if (condition2 == null) {
                IfBranches.$$$reportNull$$$0(0);
            }
            if (thenExpression2 == null) {
                IfBranches.$$$reportNull$$$0(1);
            }
            if (elseExpression2 == null) {
                IfBranches.$$$reportNull$$$0(2);
            }
            this.myCondition = condition2;
            this.myThenExpression = thenExpression2;
            this.myElseExpression = elseExpression2;
        }

        @Nullable
        String getReplacementText(CommentTracker ct) {
            if (this.isTrueFalse()) {
                return ct.text((PsiElement)this.myCondition);
            }
            if (this.isFalseTrue()) {
                return BoolUtils.getNegatedExpressionText(this.myCondition, ct);
            }
            PsiExpression replacement = this.getRedundantComparisonReplacement();
            if (replacement != null) {
                return ct.text((PsiElement)replacement);
            }
            return null;
        }

        PsiExpression getRedundantComparisonReplacement() {
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myCondition), PsiBinaryExpression.class);
            if (binOp == null) {
                return null;
            }
            IElementType tokenType = binOp.getOperationTokenType();
            boolean equals = tokenType.equals(JavaTokenType.EQEQ);
            if (!equals && !tokenType.equals(JavaTokenType.NE)) {
                return null;
            }
            PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            if (!ExpressionUtils.isSafelyRecomputableExpression(left) || !ExpressionUtils.isSafelyRecomputableExpression(right)) {
                return null;
            }
            if (TypeConversionUtil.isFloatOrDoubleType((PsiType)left.getType()) && TypeConversionUtil.isFloatOrDoubleType((PsiType)right.getType())) {
                return null;
            }
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            if (equivalence.expressionsAreEquivalent(left, this.myThenExpression) && equivalence.expressionsAreEquivalent(right, this.myElseExpression) || equivalence.expressionsAreEquivalent(right, this.myThenExpression) && equivalence.expressionsAreEquivalent(left, this.myElseExpression)) {
                return equals ? this.myElseExpression : this.myThenExpression;
            }
            return null;
        }

        boolean isTrueFalse() {
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myThenExpression), Boolean.TRUE) && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myElseExpression), Boolean.FALSE);
        }

        boolean isFalseTrue() {
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myThenExpression), Boolean.FALSE) && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myElseExpression), Boolean.TRUE);
        }

        static IfBranches fromAssignment(PsiIfStatement ifStatement) {
            return IfBranches.fromAssignment(ifStatement, ifStatement.getThenBranch(), ifStatement.getElseBranch(), true);
        }

        static IfBranches fromImplicitAssignment(PsiIfStatement ifStatement) {
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiStatement prevStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ifStatement), PsiStatement.class);
            return IfBranches.fromAssignment(ifStatement, ifStatement.getThenBranch(), prevStatement, false);
        }

        private static IfBranches fromAssignment(PsiIfStatement ifStatement, PsiStatement thenBranch, PsiStatement elseBranch, boolean explicit) {
            if (ifStatement.getCondition() == null) {
                return null;
            }
            thenBranch = ControlFlowUtils.stripBraces(thenBranch);
            elseBranch = ControlFlowUtils.stripBraces(elseBranch);
            if (!(thenBranch instanceof PsiExpressionStatement) || !(elseBranch instanceof PsiExpressionStatement)) {
                return null;
            }
            PsiAssignmentExpression thenExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)thenBranch).getExpression(), PsiAssignmentExpression.class);
            PsiAssignmentExpression elseExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)elseBranch).getExpression(), PsiAssignmentExpression.class);
            if (thenExpression2 == null || elseExpression2 == null) {
                return null;
            }
            IElementType thenTokenType = thenExpression2.getOperationTokenType();
            if (!thenTokenType.equals(elseExpression2.getOperationTokenType())) {
                return null;
            }
            if (!explicit && !thenTokenType.equals(JavaTokenType.EQ)) {
                return null;
            }
            PsiExpression thenLhs = thenExpression2.getLExpression();
            PsiExpression elseLhs = elseExpression2.getLExpression();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs)) {
                return null;
            }
            PsiExpression thenRhs = thenExpression2.getRExpression();
            PsiExpression elseRhs = elseExpression2.getRExpression();
            if (thenRhs == null || elseRhs == null) {
                return null;
            }
            if (!explicit && !ExpressionUtils.isSafelyRecomputableExpression(elseRhs)) {
                return null;
            }
            return new IfBranches(ifStatement.getCondition(), thenRhs, elseRhs);
        }

        static IfBranches fromReturn(PsiIfStatement ifStatement) {
            if (ifStatement.getCondition() == null) {
                return null;
            }
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            if (!(thenBranch instanceof PsiReturnStatement) || !(elseBranch instanceof PsiReturnStatement)) {
                return null;
            }
            PsiExpression thenValue = ((PsiReturnStatement)thenBranch).getReturnValue();
            PsiExpression elseValue = ((PsiReturnStatement)elseBranch).getReturnValue();
            if (thenValue == null || elseValue == null) {
                return null;
            }
            return new IfBranches(ifStatement.getCondition(), thenValue, elseValue);
        }

        static IfBranches fromImplicitReturn(PsiIfStatement ifStatement) {
            if (ifStatement.getCondition() == null || ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            if (!(thenBranch instanceof PsiReturnStatement)) {
                return null;
            }
            PsiReturnStatement elseReturn = ControlFlowUtils.getNextReturnStatement((PsiStatement)ifStatement);
            if (elseReturn == null) {
                return null;
            }
            PsiExpression thenValue = ((PsiReturnStatement)thenBranch).getReturnValue();
            PsiExpression elseValue = elseReturn.getReturnValue();
            if (thenValue == null || elseValue == null) {
                return null;
            }
            return new IfBranches(ifStatement.getCondition(), thenValue, elseValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thenExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elseExpression";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/controlflow/TrivialIfInspection$IfBranches";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TrivialIfVisitor
    extends BaseInspectionVisitor {
        private TrivialIfVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            if (ifStatement == null) {
                TrivialIfVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(ifStatement);
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            if (TrivialIfInspection.isTrivial(ifStatement)) {
                this.registerStatementError((PsiStatement)ifStatement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfVisitor", "visitIfStatement"));
        }
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                TrivialIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/TrivialIfInspection$TrivialIfFix", "getFamilyName"));
        }
    }
}

