/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileInspection
extends BaseInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;
    public boolean m_ignoreLoopsWithBody = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.display.name", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ForLoopReplaceableByWhile" == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(1);
        }
        return "ForLoopReplaceableByWhile";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), "m_ignoreLoopsWithoutConditions");
        panel.addCheckbox("Ignore non-empty for loops", "m_ignoreLoopsWithBody");
        return panel;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(3);
        }
        this.defaultWriteSettings(node, "m_ignoreLoopsWithBody");
        this.writeBooleanOption(node, "m_ignoreLoopsWithBody", true);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            ProblemHighlightType highlightType;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
                return;
            }
            if (!ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithBody) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
                return;
            }
            if (this.highlightLoop(statement)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError(statement.getFirstChild(), highlightType, new Object[0]);
        }

        private boolean highlightLoop(@NotNull PsiForStatement statement) {
            PsiStatement initialization;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(1);
            }
            if ((initialization = statement.getInitialization()) != null && !(initialization instanceof PsiEmptyStatement)) {
                return false;
            }
            PsiStatement update2 = statement.getUpdate();
            if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
                return false;
            }
            if (ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithoutConditions) {
                PsiExpression condition2 = statement.getCondition();
                if (condition2 == null) {
                    return false;
                }
                String conditionText = condition2.getText();
                if ("true".equals(conditionText)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ForLoopReplaceableByWhileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionGadgetsFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"while"});
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCodeBlock loopBody;
            PsiBlockStatement blockStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiForStatement.class);
            if (forStatement == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiStatement initialization = forStatement.getInitialization();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
            PsiExpression forCondition = forStatement.getCondition();
            PsiExpression whileCondition = whileStatement.getCondition();
            if (forCondition != null) {
                assert (whileCondition != null);
                commentTracker.replace((PsiElement)whileCondition, (PsiElement)forCondition);
            }
            if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
                return;
            }
            PsiStatement forStatementBody = forStatement.getBody();
            if (forStatementBody instanceof PsiBlockStatement) {
                PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)commentTracker.markUnchanged(forStatementBody));
                loopBody = newWhileBody.getCodeBlock();
            } else {
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (forStatementBody != null && !(forStatementBody instanceof PsiEmptyStatement)) {
                    codeBlock.add((PsiElement)commentTracker.markUnchanged(forStatementBody));
                }
                loopBody = codeBlock;
            }
            PsiStatement update2 = forStatement.getUpdate();
            if (update2 != null) {
                PsiStatement[] updateStatements;
                if (update2 instanceof PsiExpressionListStatement) {
                    PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update2;
                    PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                    PsiExpression[] expressions2 = expressionList.getExpressions();
                    updateStatements = new PsiStatement[expressions2.length];
                    for (int i = 0; i < expressions2.length; ++i) {
                        updateStatements[i] = factory.createStatementFromText(commentTracker.text((PsiElement)expressions2[i]) + ';', element);
                    }
                } else {
                    PsiStatement updateStatement = factory.createStatementFromText(commentTracker.markUnchanged(update2).getText() + ';', element);
                    updateStatements = new PsiStatement[]{updateStatement};
                }
                Collection continueStatements = PsiTreeUtil.findChildrenOfType((PsiElement)loopBody, PsiContinueStatement.class);
                for (PsiContinueStatement continueStatement : continueStatements) {
                    BlockUtils.addBefore((PsiStatement)continueStatement, updateStatements);
                }
                for (PsiStatement updateStatement : updateStatements) {
                    loopBody.addBefore((PsiElement)updateStatement, loopBody.getLastChild());
                }
            }
            if (initialization == null || initialization instanceof PsiEmptyStatement) {
                commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
            } else {
                JavaCodeStyleManager manager;
                initialization = (PsiStatement)commentTracker.markUnchanged(initialization).copy();
                PsiStatement newStatement = (PsiStatement)commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
                if (initialization instanceof PsiDeclarationStatement && ReplaceForByWhileFix.hasConflictingName((PsiDeclarationStatement)initialization, newStatement, manager = JavaCodeStyleManager.getInstance((Project)newStatement.getProject()))) {
                    PsiBlockStatement emptyBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)newStatement);
                    emptyBlockStatement.getCodeBlock().add((PsiElement)newStatement);
                    newStatement = ((PsiBlockStatement)newStatement.replace((PsiElement)emptyBlockStatement)).getCodeBlock().getStatements()[0];
                }
                BlockUtils.addBefore(newStatement, initialization);
            }
        }

        private static boolean hasConflictingName(PsiDeclarationStatement initialization, PsiStatement newStatement, JavaCodeStyleManager manager) {
            return ((StreamEx)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiNamedElement.class).map(namedElement -> namedElement.getName()).filter(Objects::nonNull)).anyMatch(name2 -> !name2.equals(manager.suggestUniqueVariableName(name2, (PsiElement)newStatement, true)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ReplaceForByWhileFix", "getFamilyName"));
        }
    }
}

