/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThreeState;
import com.siyeh.ig.fixes.RemoveRedundantPolyadicOperandFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.ReorderingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionCoveredByFurtherConditionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ConditionCoveredByFurtherConditionInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConditionCoveredByFurtherConditionInspection.$$$reportNull$$$0(0);
        }
        ConditionCoveredByFurtherConditionVisitor conditionCoveredByFurtherConditionVisitor = new ConditionCoveredByFurtherConditionVisitor(holder);
        if (conditionCoveredByFurtherConditionVisitor == null) {
            ConditionCoveredByFurtherConditionInspection.$$$reportNull$$$0(1);
        }
        return conditionCoveredByFurtherConditionVisitor;
    }

    @NotNull
    private static Map<PsiExpression, ThreeState> computeOperandValues(final PsiPolyadicExpression expressionToAnalyze) {
        StandardDataFlowRunner runner = new StandardDataFlowRunner(false, (PsiElement)expressionToAnalyze);
        final HashMap values = new HashMap();
        StandardInstructionVisitor visitor = new StandardInstructionVisitor(){

            @Override
            protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
                return true;
            }

            @Override
            protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
                Object bool;
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.beforeExpressionPush(value2, expression2, range, state);
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent()) != expressionToAnalyze) {
                    return;
                }
                ThreeState old = (ThreeState)values.get(expression2);
                if (old == ThreeState.UNSURE) {
                    return;
                }
                ThreeState result = ThreeState.UNSURE;
                if (value2 instanceof DfaConstValue && (bool = ((DfaConstValue)value2).getValue()) instanceof Boolean) {
                    result = ThreeState.fromBoolean((boolean)((Boolean)bool));
                }
                values.put(expression2, old == null || old == result ? result : ThreeState.UNSURE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/controlflow/ConditionCoveredByFurtherConditionInspection$1";
                objectArray[2] = "beforeExpressionPush";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        RunnerResult result = runner.analyzeMethod((PsiElement)expressionToAnalyze, visitor);
        Map map2 = result == RunnerResult.OK ? values : Collections.emptyMap();
        if (map2 == null) {
            ConditionCoveredByFurtherConditionInspection.$$$reportNull$$$0(2);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/ConditionCoveredByFurtherConditionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/ConditionCoveredByFurtherConditionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOperandValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConditionCoveredByFurtherConditionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        ConditionCoveredByFurtherConditionVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType type2 = expression2.getOperationTokenType();
            if (type2.equals(JavaTokenType.ANDAND)) {
                this.processConditionChain(expression2, true);
            } else if (type2.equals(JavaTokenType.OROR)) {
                this.processConditionChain(expression2, false);
            }
        }

        private void processConditionChain(PsiPolyadicExpression expression2, boolean and) {
            ((StreamEx)StreamEx.of((Object[])expression2.getOperands()).map(operand2 -> ConditionCoveredByFurtherConditionVisitor.isAllowed(operand2) ? operand2 : null).groupRuns((o1, o2) -> o1 != null && o2 != null).remove(list -> list.size() == 1)).forEach(operands2 -> this.process(expression2, (List<PsiExpression>)operands2, and));
        }

        private static boolean isAllowed(PsiExpression expression2) {
            return ReorderingUtils.isSideEffectFree(expression2, true);
        }

        private void process(PsiPolyadicExpression context, List<PsiExpression> operands2, boolean and) {
            int[] indices2;
            for (int index : indices2 = ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, operands2, and)) {
                List<PsiExpression> dependencies = operands2.subList(index + 1, operands2.size());
                PsiExpression operand2 = operands2.get(index);
                dependencies = ConditionCoveredByFurtherConditionVisitor.minimizeDependencies(context, operand2, and, dependencies);
                if (dependencies.isEmpty()) continue;
                String operandText = PsiExpressionTrimRenderer.render((PsiExpression)operand2);
                String description = "Condition '" + operandText + "' covered by subsequent " + (dependencies.size() == 1 ? "condition '" + PsiExpressionTrimRenderer.render((PsiExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)dependencies.get(0))) + "'" : "conditions");
                this.myHolder.registerProblem((PsiElement)operand2, description, new LocalQuickFix[]{new RemoveRedundantPolyadicOperandFix(operandText)});
            }
        }

        private static List<PsiExpression> minimizeDependencies(PsiPolyadicExpression context, PsiExpression operand2, boolean and, List<PsiExpression> dependencies) {
            if (dependencies.isEmpty() || ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, Collections.singletonList(operand2), and).length != 0) {
                return Collections.emptyList();
            }
            if (dependencies.size() == 1) {
                return dependencies;
            }
            for (PsiExpression dependency : dependencies) {
                if (ArrayUtil.indexOf((int[])ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, Arrays.asList(operand2, dependency), and), (int)0) == -1) continue;
                return Collections.singletonList(dependency);
            }
            return dependencies;
        }

        private static int[] getRedundantOperandIndices(PsiPolyadicExpression context, List<PsiExpression> operands2, boolean and) {
            assert (!operands2.isEmpty());
            if (operands2.size() == 1) {
                int[] nArray;
                Object value2 = DfaUtil.computeValue(operands2.get(0));
                if (Boolean.valueOf(and).equals(value2)) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
                }
                return nArray;
            }
            String text2 = StreamEx.ofReversed(operands2).map(expression2 -> ParenthesesUtils.getText(expression2, 13)).joining((CharSequence)(and ? " && " : " || "));
            PsiExpression expression3 = JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(text2, (PsiElement)context);
            if (!(expression3 instanceof PsiPolyadicExpression)) {
                LOG.error("Unexpected expression type: " + expression3.getClass().getName(), new Attachment[]{new Attachment("reversed.txt", text2)});
                return ArrayUtilRt.EMPTY_INT_ARRAY;
            }
            PsiPolyadicExpression expressionToAnalyze = (PsiPolyadicExpression)expression3;
            List<PsiExpression> reversedOperands = Arrays.asList(expressionToAnalyze.getOperands());
            Map values = ConditionCoveredByFurtherConditionInspection.computeOperandValues(expressionToAnalyze);
            return StreamEx.ofKeys((Map)values, arg_0 -> ThreeState.fromBoolean((boolean)and).equals(arg_0)).mapToInt(operand2 -> IntStreamEx.ofIndices((List)reversedOperands, op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)operand2, (boolean)false)).findFirst().orElse(0)).map(index -> operands2.size() - 1 - index).toArray();
        }
    }
}

