/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameDiffersFromFileNameInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass[] classes2;
        PsiJavaFile file = (PsiJavaFile)infos[0];
        String fileName = file.getName();
        int prefixIndex = fileName.indexOf(46);
        String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
        for (PsiClass psiClass : classes2 = file.getClasses()) {
            String className2 = psiClass.getName();
            if (!filenameWithoutPrefix.equals(className2)) continue;
            return null;
        }
        return new RenameFix(filenameWithoutPrefix);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.display.name", new Object[0]);
        if (string == null) {
            ClassNameDiffersFromFileNameInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassNameDiffersFromFileNameInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameDiffersFromFileNameVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ClassNameDiffersFromFileNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameDiffersFromFileNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement parent;
            if (aClass == null) {
                ClassNameDiffersFromFileNameVisitor.$$$reportNull$$$0(0);
            }
            if (!((parent = aClass.getParent()) instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)parent;
            String className2 = aClass.getName();
            if (className2 == null) {
                return;
            }
            String fileName = file.getName();
            int prefixIndex = fileName.indexOf(46);
            if (prefixIndex < 0) {
                return;
            }
            String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
            if (className2.equals(filenameWithoutPrefix)) {
                return;
            }
            this.registerClassError(aClass, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspection$ClassNameDiffersFromFileNameVisitor", "visitClass"));
        }
    }
}

