/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CallMatcher
extends Predicate<PsiMethodCallExpression> {
    public Stream<String> names();

    @Contract(value="null -> false", pure=true)
    public boolean methodReferenceMatches(PsiMethodReferenceExpression var1);

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean test(@Nullable PsiMethodCallExpression var1);

    @Contract(value="null -> false", pure=true)
    public boolean methodMatches(@Nullable PsiMethod var1);

    @Contract(value="null -> false")
    default public boolean matches(@Nullable PsiExpression expression2) {
        return (expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression && this.test((PsiMethodCallExpression)expression2);
    }

    public static CallMatcher anyOf(final CallMatcher ... matchers) {
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return Stream.of(matchers).flatMap(CallMatcher::names);
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                for (CallMatcher m : matchers) {
                    if (!m.methodReferenceMatches(methodRef)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean methodMatches(PsiMethod method) {
                for (CallMatcher m : matchers) {
                    if (!m.methodMatches(method)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean test(PsiMethodCallExpression call) {
                for (CallMatcher m : matchers) {
                    if (!m.test(call)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return Stream.of(matchers).map(Object::toString).collect(Collectors.joining(" or ", "{", "}"));
            }
        };
    }

    public static Simple instanceCall(@NotNull String className2, String ... methodNames) {
        if (className2 == null) {
            CallMatcher.$$$reportNull$$$0(0);
        }
        return new Simple(className2, (Set)ContainerUtil.newTroveSet((Object[])methodNames), null, CallType.INSTANCE);
    }

    public static Simple exactInstanceCall(@NotNull String className2, String ... methodNames) {
        if (className2 == null) {
            CallMatcher.$$$reportNull$$$0(1);
        }
        return new Simple(className2, (Set)ContainerUtil.newTroveSet((Object[])methodNames), null, CallType.EXACT_INSTANCE);
    }

    public static Simple staticCall(@NotNull String className2, String ... methodNames) {
        if (className2 == null) {
            CallMatcher.$$$reportNull$$$0(2);
        }
        return new Simple(className2, (Set)ContainerUtil.newTroveSet((Object[])methodNames), null, CallType.STATIC);
    }

    public static Simple enumValues() {
        return Simple.ENUM_VALUES;
    }

    public static Simple enumValueOf() {
        return Simple.ENUM_VALUE_OF;
    }

    @Nullable
    default public PsiReferenceExpression getReferenceIfMatched(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodReferenceExpression && this.methodReferenceMatches((PsiMethodReferenceExpression)expression2)) {
            return (PsiReferenceExpression)expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression && this.test((PsiMethodCallExpression)expression2)) {
            return ((PsiMethodCallExpression)expression2).getMethodExpression();
        }
        return null;
    }

    default public CallMatcher withContextFilter(final @NotNull Predicate<? super PsiElement> filter) {
        if (filter == null) {
            CallMatcher.$$$reportNull$$$0(3);
        }
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return CallMatcher.this.names();
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                if (methodRef == null || !filter.test(methodRef)) {
                    return false;
                }
                return CallMatcher.this.methodReferenceMatches(methodRef);
            }

            @Override
            public boolean test(@Nullable PsiMethodCallExpression call) {
                if (call == null || !filter.test(call)) {
                    return false;
                }
                return CallMatcher.this.test(call);
            }

            @Override
            public boolean methodMatches(@Nullable PsiMethod method) {
                if (method == null || !filter.test(method)) {
                    return false;
                }
                return CallMatcher.this.methodMatches(method);
            }

            public String toString() {
                return CallMatcher.this.toString();
            }
        };
    }

    default public CallMatcher withLanguageLevelAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            CallMatcher.$$$reportNull$$$0(4);
        }
        return this.withContextFilter(element -> PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(level));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/callMatcher/CallMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "exactInstanceCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "staticCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withContextFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withLanguageLevelAtLeast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum CallType {
        STATIC{

            @Override
            boolean matches(PsiClass aClass, String className2, boolean isStatic) {
                return isStatic && className2.equals(aClass.getQualifiedName());
            }
        }
        ,
        ENUM_STATIC{

            @Override
            boolean matches(PsiClass aClass, String className2, boolean isStatic) {
                return isStatic && aClass.isEnum();
            }
        }
        ,
        INSTANCE{

            @Override
            boolean matches(PsiClass aClass, String className2, boolean isStatic) {
                return !isStatic && InheritanceUtil.isInheritor((PsiClass)aClass, (String)className2);
            }
        }
        ,
        EXACT_INSTANCE{

            @Override
            boolean matches(PsiClass aClass, String className2, boolean isStatic) {
                return !isStatic && className2.equals(aClass.getQualifiedName());
            }
        };


        abstract boolean matches(PsiClass var1, String var2, boolean var3);
    }

    public static class Simple
    implements CallMatcher {
        static final Simple ENUM_VALUES = new Simple("", Collections.singleton("values"), ArrayUtilRt.EMPTY_STRING_ARRAY, CallType.ENUM_STATIC);
        static final Simple ENUM_VALUE_OF = new Simple("", Collections.singleton("valueOf"), new String[]{"java.lang.String"}, CallType.ENUM_STATIC);
        @NotNull
        private final String myClassName;
        @NotNull
        private final Set<String> myNames;
        @Nullable
        private final String[] myParameters;
        private final CallType myCallType;

        private Simple(@NotNull String className2, @NotNull Set<String> names, @Nullable String[] parameters2, CallType callType) {
            if (className2 == null) {
                Simple.$$$reportNull$$$0(0);
            }
            if (names == null) {
                Simple.$$$reportNull$$$0(1);
            }
            this.myClassName = className2;
            this.myNames = names;
            this.myParameters = parameters2;
            this.myCallType = callType;
        }

        @Override
        public Stream<String> names() {
            return this.myNames.stream();
        }

        public Simple parameterCount(int count) {
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameter count is already set to " + count);
            }
            return new Simple(this.myClassName, this.myNames, count == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[count], this.myCallType);
        }

        public Simple parameterTypes(String ... types) {
            if (types == null) {
                Simple.$$$reportNull$$$0(2);
            }
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameters are already registered");
            }
            return new Simple(this.myClassName, this.myNames, types.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])types.clone(), this.myCallType);
        }

        private static boolean parameterTypeMatches(String type2, PsiParameter parameter2) {
            if (type2 == null) {
                return true;
            }
            PsiType psiType = parameter2.getType();
            return psiType.equalsToText(type2) || psiType instanceof PsiClassType && ((PsiClassType)psiType).rawType().equalsToText(type2);
        }

        @Override
        public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
            if (methodRef == null) {
                return false;
            }
            String name2 = methodRef.getReferenceName();
            if (!this.myNames.contains(name2)) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            if (!this.methodMatches(method)) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            return this.parametersMatch(parameterList);
        }

        @Override
        public boolean test(PsiMethodCallExpression call) {
            if (call == null) {
                return false;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            if (!this.myNames.contains(name2)) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (this.myParameters != null && this.myParameters.length > 0 && args.length < this.myParameters.length - 1) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            int count = parameterList.getParametersCount();
            if (count > args.length + 1 || !MethodCallUtils.isVarArgCall((PsiCall)call) && count != args.length) {
                return false;
            }
            return this.methodMatches(method);
        }

        private boolean parametersMatch(@NotNull PsiParameterList parameterList) {
            if (parameterList == null) {
                Simple.$$$reportNull$$$0(3);
            }
            if (this.myParameters == null) {
                return true;
            }
            if (this.myParameters.length != parameterList.getParametersCount()) {
                return false;
            }
            return StreamEx.zip((Object[])this.myParameters, (Object[])parameterList.getParameters(), Simple::parameterTypeMatches).allMatch(Boolean.TRUE::equals);
        }

        @Override
        @Contract(value="null -> false")
        public boolean methodMatches(PsiMethod method) {
            if (method == null) {
                return false;
            }
            if (!this.myNames.contains(method.getName())) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            return this.myCallType.matches(aClass, this.myClassName, method.hasModifierProperty("static")) && this.parametersMatch(method.getParameterList());
        }

        public String toString() {
            return this.myClassName + "." + String.join((CharSequence)"|", this.myNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterList";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/callMatcher/CallMatcher$Simple";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parameterTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parametersMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

