/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortedCollectionWithNonComparableKeysInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> COLLECTIONS = ContainerUtil.immutableSet((Object[])new String[]{"java.util.TreeSet", "java.util.TreeMap", "java.util.concurrent.ConcurrentSkipListSet", "java.util.concurrent.ConcurrentSkipListMap"});
    public boolean IGNORE_TYPE_PARAMETERS;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.option.type.parameters", (Object[])new Object[0]), (InspectionProfileEntry)this, "IGNORE_TYPE_PARAMETERS");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SortedCollectionWithNonComparableKeysInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression2) {
                if (expression2.getAnonymousClass() != null || expression2.isArrayCreation() || expression2.getArgumentList() == null || !expression2.getArgumentList().isEmpty()) {
                    return;
                }
                PsiJavaCodeReferenceElement reference = expression2.getClassReference();
                if (reference == null) {
                    return;
                }
                String qualifiedName = reference.getQualifiedName();
                if (!COLLECTIONS.contains(qualifiedName)) {
                    return;
                }
                PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)expression2.getType(), PsiClassType.class);
                if (type2 == null || type2.isRaw()) {
                    return;
                }
                PsiType elementType = (PsiType)ArrayUtil.getFirstElement((Object[])type2.getParameters());
                if (elementType == null || TypeUtils.isJavaLangObject(elementType)) {
                    return;
                }
                SetInspectionOptionFix fix2 = null;
                if (elementType instanceof PsiClassType && ((PsiClassType)elementType).resolve() instanceof PsiTypeParameter) {
                    if (SortedCollectionWithNonComparableKeysInspection.this.IGNORE_TYPE_PARAMETERS) {
                        return;
                    }
                    String message2 = InspectionsBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.option.type.parameters", (Object[])new Object[0]);
                    fix2 = new SetInspectionOptionFix((LocalInspectionTool)SortedCollectionWithNonComparableKeysInspection.this, "IGNORE_TYPE_PARAMETERS", message2, true);
                }
                if (InheritanceUtil.isInheritor((PsiType)elementType, (String)"java.lang.Comparable")) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"inspection.sorted.collection.with.non.comparable.keys.message", (Object[])new Object[0]), new LocalQuickFix[]{fix2});
            }
        };
        if (javaElementVisitor == null) {
            SortedCollectionWithNonComparableKeysInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/SortedCollectionWithNonComparableKeysInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/SortedCollectionWithNonComparableKeysInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

