/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultOfObjectAllocationIgnoredInspection
extends BaseInspection {
    public OrderedSet<String> ignoredClasses = new OrderedSet();

    @Nullable
    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.ignoredClasses, "Ignored classes", "Choose class for which object allocation can be ignored", new String[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        return SuppressForTestsScopeFix.build(this, context);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name2;
        SmartList result = new SmartList();
        PsiExpression expression2 = (PsiExpression)infos[0];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (aClass != null && (name2 = aClass.getQualifiedName()) != null) {
            result.add(new IgnoreClassFix(name2, (Collection<? super String>)this.ignoredClasses, "Ignore allocations of objects with type '" + name2 + "'"));
        }
        ContainerUtil.addIfNotNull((Collection)result, (Object)SuppressForTestsScopeFix.build(this, (PsiElement)expression2));
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            ResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(0);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("result.of.object.allocation.ignored.display.name", new Object[0]);
        if (string == null) {
            ResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("result.of.object.allocation.ignored.problem.descriptor", new Object[0]);
        if (string == null) {
            ResultOfObjectAllocationIgnoredInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResultOfObjectAllocationIgnoredVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ResultOfObjectAllocationIgnoredInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ResultOfObjectAllocationIgnoredVisitor
    extends BaseInspectionVisitor {
        private ResultOfObjectAllocationIgnoredVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
                return;
            }
            if (expression2.isArrayCreation()) {
                return;
            }
            PsiJavaCodeReferenceElement reference = expression2.getClassOrAnonymousClassReference();
            if (reference == null) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            if (!(expression2 instanceof PsiAnonymousClass) && ResultOfObjectAllocationIgnoredInspection.this.ignoredClasses.contains((Object)aClass.getQualifiedName())) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2);
        }
    }
}

