/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

abstract class BaseEqualsVisitor
extends BaseInspectionVisitor {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object");
    private static final CallMatcher STATIC_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));

    BaseEqualsVisitor() {
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        PsiType rightType;
        PsiType leftType;
        super.visitMethodReferenceExpression(expression2);
        if (!OBJECT_EQUALS.methodReferenceMatches(expression2) && !STATIC_EQUALS.methodReferenceMatches(expression2)) {
            return;
        }
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)method, (PsiClassType.ClassResolveResult)resolveResult);
        if (parameters2.length == 2) {
            leftType = substitutor.substitute(parameters2[0].getType());
            rightType = substitutor.substitute(parameters2[1].getType());
        } else {
            PsiExpression qualifier = expression2.getQualifierExpression();
            assert (qualifier != null);
            leftType = qualifier.getType();
            rightType = substitutor.substitute(parameters2[0].getType());
        }
        if (leftType != null && rightType != null) {
            this.checkTypes((PsiReferenceExpression)expression2, leftType, rightType);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
        PsiExpression expression22;
        PsiExpression expression1;
        if (expression2 == null) {
            BaseEqualsVisitor.$$$reportNull$$$0(0);
        }
        super.visitMethodCallExpression(expression2);
        PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
        if (OBJECT_EQUALS.test(expression2)) {
            expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier(expression2.getMethodExpression()));
            expression22 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
        } else if (STATIC_EQUALS.test(expression2)) {
            expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            expression22 = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1]);
        } else {
            return;
        }
        if (expression1 == null || expression22 == null) {
            return;
        }
        PsiType leftType = BaseEqualsVisitor.getType(expression1);
        PsiType rightType = BaseEqualsVisitor.getType(expression22);
        if (leftType != null && rightType != null) {
            this.checkTypes(expression2.getMethodExpression(), leftType, rightType);
        }
    }

    private static PsiType getType(PsiExpression expression2) {
        if (!(expression2 instanceof PsiNewExpression)) {
            return expression2.getType();
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression2;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        return anonymousClass != null ? anonymousClass.getBaseClassType() : expression2.getType();
    }

    abstract void checkTypes(@NotNull PsiReferenceExpression var1, @NotNull PsiType var2, @NotNull PsiType var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/BaseEqualsVisitor", "visitMethodCallExpression"));
    }
}

