/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.display.name", new Object[0]);
        if (string == null) {
            ArrayEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.array.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayEqualsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType componentType;
        PsiArrayType type2 = (PsiArrayType)infos[0];
        if (type2 != null && (componentType = type2.getComponentType()) instanceof PsiArrayType) {
            return new ArrayEqualsFix(true);
        }
        return new ArrayEqualsFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ArrayEqualsVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ArrayEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (argument == null) {
                return;
            }
            PsiType argumentType = argument.getType();
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiArrayType)) {
                return;
            }
            this.registerMethodCallError(expression2, qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class ArrayEqualsFix
    extends InspectionGadgetsFix {
        private final boolean deepEquals;

        ArrayEqualsFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            if (this.deepEquals) {
                String string = InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]);
                if (string == null) {
                    ArrayEqualsFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
            if (string == null) {
                ArrayEqualsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with Arrays.equals" == null) {
                ArrayEqualsFix.$$$reportNull$$$0(2);
            }
            return "Replace with Arrays.equals";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name2 = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name2.getParent();
            assert (expression2 != null);
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2.getParent();
            PsiExpression qualifier = expression2.getQualifierExpression();
            assert (qualifier != null);
            CommentTracker commentTracker = new CommentTracker();
            String qualifierText = commentTracker.text((PsiElement)qualifier);
            assert (call != null);
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            String argumentText = commentTracker.text((PsiElement)arguments[0]);
            StringBuilder newExpressionText = new StringBuilder();
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(qualifierText);
            newExpressionText.append(", ");
            newExpressionText.append(argumentText);
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ArrayEqualsInspection$ArrayEqualsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

