/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.asserttoif;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssertionCanBeIfInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assertion.can.be.if.name", new Object[0]);
        if (string == null) {
            AssertionCanBeIfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            AssertionCanBeIfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertToIfVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AssertToIfFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/asserttoif/AssertionCanBeIfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AssertToIfFix
    extends InspectionGadgetsFix {
        private AssertToIfFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("assert.can.be.if.quickfix", new Object[0]);
            if (string == null) {
                AssertToIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiAssertStatement assertStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiAssertStatement psiAssertStatement = assertStatement = element instanceof PsiKeyword ? (PsiAssertStatement)element.getParent() : (PsiAssertStatement)element;
            if (!(assertStatement.getParent() instanceof PsiCodeBlock)) {
                assertStatement = BlockUtils.expandSingleStatementToBlockStatement(assertStatement);
            }
            PsiExpression condition2 = assertStatement.getAssertCondition();
            CommentTracker tracker = new CommentTracker();
            StringBuilder newStatement = new StringBuilder("if(");
            newStatement.append(BoolUtils.getNegatedExpressionText(condition2, tracker));
            newStatement.append(") throw new java.lang.AssertionError(");
            PsiExpression description = assertStatement.getAssertDescription();
            if (description != null) {
                newStatement.append(tracker.text((PsiElement)description));
            }
            newStatement.append(");");
            PsiReplacementUtil.replaceStatement((PsiStatement)assertStatement, newStatement.toString(), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/asserttoif/AssertionCanBeIfInspection$AssertToIfFix", "getFamilyName"));
        }
    }

    private static class AssertToIfVisitor
    extends BaseInspectionVisitor {
        private AssertToIfVisitor() {
        }

        public void visitAssertStatement(PsiAssertStatement assertStatement) {
            super.visitAssertStatement(assertStatement);
            if (assertStatement.getAssertCondition() == null) {
                return;
            }
            PsiElement lastLeaf = PsiTreeUtil.getDeepestLast((PsiElement)assertStatement);
            if (lastLeaf instanceof PsiErrorElement || PsiUtil.isJavaToken((PsiElement)lastLeaf, (IElementType)JavaTokenType.SEMICOLON) && PsiTreeUtil.prevLeaf((PsiElement)lastLeaf) instanceof PsiErrorElement) {
                return;
            }
            if (this.isVisibleHighlight((PsiElement)assertStatement)) {
                this.registerStatementError((PsiStatement)assertStatement, new Object[0]);
            } else {
                this.registerError((PsiElement)assertStatement, new Object[0]);
            }
        }
    }
}

