/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.util.Comparing;
import com.intellij.unscramble.ThreadOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadState {
    private final String myName;
    private final String myState;
    private String myStackTrace;
    private boolean myEmptyStackTrace;
    private String myJavaThreadState;
    private String myThreadStateDetail;
    private String myExtraState;
    private boolean isDaemon;
    private final Set<ThreadState> myThreadsWaitingForMyLock = new HashSet<ThreadState>();
    private final Set<ThreadState> myDeadlockedThreads = new HashSet<ThreadState>();
    @Nullable
    private ThreadOperation myOperation;

    public ThreadState(String name2, String state) {
        this.myName = name2;
        this.myState = state.trim();
    }

    public String getName() {
        return this.myName;
    }

    public String getState() {
        return this.myState;
    }

    public String getStackTrace() {
        return this.myStackTrace;
    }

    public void setStackTrace(String stackTrace, boolean isEmpty) {
        this.myStackTrace = stackTrace;
        this.myEmptyStackTrace = isEmpty;
    }

    public Collection<ThreadState> getAwaitingThreads() {
        return Collections.unmodifiableSet(this.myThreadsWaitingForMyLock);
    }

    public String toString() {
        return this.myName;
    }

    public void setJavaThreadState(String javaThreadState) {
        this.myJavaThreadState = javaThreadState;
    }

    public void setThreadStateDetail(@NonNls String threadStateDetail) {
        this.myThreadStateDetail = threadStateDetail;
    }

    public String getJavaThreadState() {
        return this.myJavaThreadState;
    }

    public String getThreadStateDetail() {
        if (this.myOperation != null) {
            return this.myOperation.toString();
        }
        return this.myThreadStateDetail;
    }

    public boolean isEmptyStackTrace() {
        return this.myEmptyStackTrace;
    }

    public String getExtraState() {
        return this.myExtraState;
    }

    public void setExtraState(String extraState) {
        this.myExtraState = extraState;
    }

    public boolean isSleeping() {
        return "sleeping".equals(this.getThreadStateDetail()) || ("parking".equals(this.getThreadStateDetail()) || "waiting on condition".equals(this.myState)) && this.isThreadPoolExecutor();
    }

    private boolean isThreadPoolExecutor() {
        return this.myStackTrace.contains("java.util.concurrent.ScheduledThreadPoolExecutor$DelayedWorkQueue.take") || this.myStackTrace.contains("java.util.concurrent.ThreadPoolExecutor.getTask");
    }

    public boolean isAwaitedBy(ThreadState thread) {
        return this.myThreadsWaitingForMyLock.contains(thread);
    }

    public void addWaitingThread(@NotNull ThreadState thread) {
        if (thread == null) {
            ThreadState.$$$reportNull$$$0(0);
        }
        this.myThreadsWaitingForMyLock.add(thread);
    }

    public boolean isDeadlocked() {
        return !this.myDeadlockedThreads.isEmpty();
    }

    public void addDeadlockedThread(ThreadState thread) {
        this.myDeadlockedThreads.add(thread);
    }

    @Nullable
    public ThreadOperation getOperation() {
        return this.myOperation;
    }

    public void setOperation(@Nullable ThreadOperation operation) {
        this.myOperation = operation;
    }

    public boolean isWaiting() {
        return "on object monitor".equals(this.myThreadStateDetail) || this.myState.startsWith("waiting") || "parking".equals(this.myThreadStateDetail) && !this.isSleeping();
    }

    public boolean isEDT() {
        String name2 = this.getName();
        return ThreadState.isEDT(name2);
    }

    public static boolean isEDT(String name2) {
        return ThreadDumper.isEDT((String)name2);
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/unscramble/ThreadState", "addWaitingThread"));
    }

    public static class CompoundThreadState
    extends ThreadState {
        private final ThreadState myOriginalState;
        private int myCounter = 1;

        public CompoundThreadState(ThreadState state) {
            super(state.myName, state.myState);
            this.myOriginalState = state;
        }

        public boolean add(ThreadState state) {
            if (this.myOriginalState.isEDT()) {
                return false;
            }
            if (!Comparing.equal((String)state.myState, (String)this.myOriginalState.myState)) {
                return false;
            }
            if (state.myEmptyStackTrace != this.myOriginalState.myEmptyStackTrace) {
                return false;
            }
            if (state.isDaemon != this.myOriginalState.isDaemon) {
                return false;
            }
            if (!Comparing.equal((String)state.myJavaThreadState, (String)this.myOriginalState.myJavaThreadState)) {
                return false;
            }
            if (!Comparing.equal((String)state.myThreadStateDetail, (String)this.myOriginalState.myThreadStateDetail)) {
                return false;
            }
            if (!Comparing.equal((String)state.myExtraState, (String)this.myOriginalState.myExtraState)) {
                return false;
            }
            if (!Comparing.haveEqualElements((Collection)state.myThreadsWaitingForMyLock, (Collection)this.myOriginalState.myThreadsWaitingForMyLock)) {
                return false;
            }
            if (!Comparing.haveEqualElements((Collection)state.myDeadlockedThreads, (Collection)this.myOriginalState.myDeadlockedThreads)) {
                return false;
            }
            if (!Comparing.equal((String)CompoundThreadState.getMergeableStackTrace(state.myStackTrace, true), (String)CompoundThreadState.getMergeableStackTrace(this.myOriginalState.myStackTrace, true))) {
                return false;
            }
            ++this.myCounter;
            return true;
        }

        private static String getMergeableStackTrace(String stackTrace, boolean skipFirstLine) {
            if (stackTrace == null) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            String[] lines = stackTrace.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i == 0 && skipFirstLine) continue;
                line = line.replaceAll("<0x.+>\\s", "<merged>");
                builder.append(line).append("\n");
            }
            return builder.toString();
        }

        @Override
        public String getName() {
            return this.myCounter == 1 ? this.myOriginalState.getName() : this.myCounter + " similar threads";
        }

        @Override
        public String getState() {
            return this.myOriginalState.getState();
        }

        @Override
        public String getStackTrace() {
            return this.myCounter == 1 ? this.myOriginalState.getStackTrace() : CompoundThreadState.getMergeableStackTrace(this.myOriginalState.getStackTrace(), false);
        }

        @Override
        public Collection<ThreadState> getAwaitingThreads() {
            return this.myOriginalState.getAwaitingThreads();
        }

        @Override
        public String getJavaThreadState() {
            return this.myOriginalState.getJavaThreadState();
        }

        @Override
        public String getThreadStateDetail() {
            return this.myOriginalState.getThreadStateDetail();
        }

        @Override
        public boolean isEmptyStackTrace() {
            return this.myOriginalState.isEmptyStackTrace();
        }

        @Override
        public String getExtraState() {
            return this.myOriginalState.getExtraState();
        }

        @Override
        public boolean isAwaitedBy(ThreadState thread) {
            return this.myOriginalState.isAwaitedBy(thread);
        }

        @Override
        public boolean isDeadlocked() {
            return this.myOriginalState.isDeadlocked();
        }

        @Override
        @Nullable
        public ThreadOperation getOperation() {
            return this.myOriginalState.getOperation();
        }

        @Override
        public boolean isWaiting() {
            return this.myOriginalState.isWaiting();
        }

        @Override
        public boolean isEDT() {
            return this.myOriginalState.isEDT();
        }

        @Override
        public boolean isDaemon() {
            return this.myOriginalState.isDaemon();
        }

        @Override
        public boolean isSleeping() {
            return this.myOriginalState.isSleeping();
        }
    }
}

