/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.template.Template;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestGenerator
implements TestGenerator {
    @Override
    public PsiElement generateTest(final Project project, final CreateTestDialog d) {
        return (PsiElement)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> (PsiElement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                try {
                    VirtualFile virtualFile;
                    PsiImportStatementBase[] importStatements;
                    PsiImportList list;
                    IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                    PsiClass targetClass = JavaTestGenerator.createTestClass(d);
                    if (targetClass == null) {
                        return null;
                    }
                    TestFramework frameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
                    String defaultSuperClass = frameworkDescriptor.getDefaultSuperClass();
                    String superClassName = d.getSuperClassName();
                    if (!Comparing.strEqual((String)superClassName, (String)defaultSuperClass)) {
                        JavaTestGenerator.addSuperClass(targetClass, project, superClassName);
                    }
                    PsiFile file = targetClass.getContainingFile();
                    Editor editor = CodeInsightUtil.positionCursorAtLBrace(project, file, targetClass);
                    JavaTestGenerator.addTestMethods(editor, targetClass, d.getTargetClass(), frameworkDescriptor, d.getSelectedMethods(), d.shouldGeneratedBefore(), d.shouldGeneratedAfter());
                    if (file instanceof PsiJavaFile && (list = ((PsiJavaFile)file).getImportList()) != null && (importStatements = list.getAllImportStatements()).length > 0 && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)list)) != null) {
                        HashSet<String> imports2 = new HashSet<String>();
                        for (PsiImportStatementBase base : importStatements) {
                            imports2.add(base.getText());
                        }
                        virtualFile.putCopyableUserData(ImportsHighlightUtil.IMPORTS_FROM_TEMPLATE, imports2);
                    }
                    return targetClass;
                }
                catch (IncorrectOperationException e) {
                    JavaTestGenerator.showErrorLater(project, d.getClassName());
                    return null;
                }
            }
        }));
    }

    @Nullable
    private static PsiClass createTestClass(CreateTestDialog d) {
        PsiClass classFromTemplate;
        TestFramework testFrameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
        FileTemplateDescriptor fileTemplateDescriptor = TestIntegrationUtils.MethodKind.TEST_CLASS.getFileTemplateDescriptor(testFrameworkDescriptor);
        PsiDirectory targetDirectory = d.getTargetDirectory();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
        if (aPackage != null) {
            GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((PsiDirectory)targetDirectory, (boolean)false);
            PsiClass[] classes2 = aPackage.findClassByShortName(d.getClassName(), scope);
            if (classes2.length > 0) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)classes2[0])) {
                    return null;
                }
                return classes2[0];
            }
        }
        if (fileTemplateDescriptor != null && (classFromTemplate = JavaTestGenerator.createTestClassFromCodeTemplate(d, fileTemplateDescriptor, targetDirectory)) != null) {
            return classFromTemplate;
        }
        return JavaDirectoryService.getInstance().createClass(targetDirectory, d.getClassName());
    }

    private static PsiClass createTestClassFromCodeTemplate(CreateTestDialog d, FileTemplateDescriptor fileTemplateDescriptor, PsiDirectory targetDirectory) {
        String templateName = fileTemplateDescriptor.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)targetDirectory.getProject()).getCodeTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance((Project)targetDirectory.getProject()).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", d.getClassName());
        PsiClass targetClass = d.getTargetClass();
        if (targetClass != null && targetClass.isValid()) {
            properties.setProperty("CLASS_NAME", targetClass.getQualifiedName());
        }
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)fileTemplate, (String)templateName, (Properties)properties, (PsiDirectory)targetDirectory);
            if (psiElement instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void addSuperClass(PsiClass targetClass, Project project, String superClassName) throws IncorrectOperationException {
        if (superClassName == null) {
            return;
        }
        PsiReferenceList extendsList = targetClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        PsiElementFactory ef = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass superClass = JavaTestGenerator.findClass(project, superClassName);
        PsiJavaCodeReferenceElement superClassRef = superClass != null ? ef.createClassReferenceElement(superClass) : ef.createFQClassNameReferenceElement(superClassName, GlobalSearchScope.allScope((Project)project));
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        if (referenceElements.length == 0) {
            extendsList.add((PsiElement)superClassRef);
        } else {
            referenceElements[0].replace((PsiElement)superClassRef);
        }
    }

    @Nullable
    private static PsiClass findClass(Project project, String fqName) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope);
    }

    public static void addTestMethods(Editor editor, PsiClass targetClass, TestFramework descriptor, Collection<? extends MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        JavaTestGenerator.addTestMethods(editor, targetClass, null, descriptor, methods, generateBefore, generateAfter);
    }

    public static void addTestMethods(Editor editor, PsiClass targetClass, @Nullable PsiClass sourceClass, TestFramework descriptor, Collection<? extends MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        HashSet existingNames = new HashSet();
        PsiMethod anchor = null;
        if (generateBefore && descriptor.findSetUpMethod((PsiElement)targetClass) == null) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.SET_UP, descriptor, targetClass, sourceClass, editor, null, existingNames, null);
        }
        if (generateAfter && descriptor.findTearDownMethod((PsiElement)targetClass) == null) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEAR_DOWN, descriptor, targetClass, sourceClass, editor, null, existingNames, anchor);
        }
        Template template = TestIntegrationUtils.createTestMethodTemplate(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, sourceClass, null, true, existingNames);
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        String prefix = elementFactory != null ? elementFactory.createMethodFromText(template.getTemplateText(), (PsiElement)targetClass).getName() : "";
        existingNames.addAll(ContainerUtil.map((Object[])targetClass.getAllMethods(), method -> StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)prefix))));
        for (MemberInfo memberInfo : methods) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, sourceClass, editor, ((PsiMember)memberInfo.getMember()).getName(), existingNames, anchor);
        }
    }

    private static void showErrorLater(Project project, String targetClassName) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{targetClassName}), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
    }

    private static PsiMethod generateMethod(@NotNull TestIntegrationUtils.MethodKind methodKind, TestFramework descriptor, PsiClass targetClass, @Nullable PsiClass sourceClass, Editor editor, @Nullable String name2, Set<? super String> existingNames, PsiMethod anchor) {
        if (methodKind == null) {
            JavaTestGenerator.$$$reportNull$$$0(0);
        }
        PsiMethod dummyMethod = TestIntegrationUtils.createDummyMethod((PsiElement)targetClass);
        PsiMethod method = (PsiMethod)(anchor == null ? targetClass.add((PsiElement)dummyMethod) : targetClass.addAfter((PsiElement)dummyMethod, (PsiElement)anchor));
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TestIntegrationUtils.runTestMethodTemplate(methodKind, descriptor, editor, targetClass, sourceClass, method, name2, true, existingNames);
        return method;
    }

    @Override
    public String toString() {
        return CodeInsightBundle.message((String)"intention.create.test.dialog.java", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/createTest/JavaTestGenerator", "generateMethod"));
    }
}

