/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.JavaPredefinedConfigurations;
import com.intellij.structuralsearch.JavaReplaceHandler;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.JavaCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.ExprTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.FormalArgTypePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStructuralSearchProfile
extends StructuralSearchProfile {
    public static final PatternContext DEFAULT_CONTEXT = new PatternContext("default", "Default");
    public static final PatternContext MEMBER_CONTEXT = new PatternContext("member", "Class Member");
    private static final List<PatternContext> PATTERN_CONTEXTS = ContainerUtil.immutableList((Object[])new PatternContext[]{DEFAULT_CONTEXT, MEMBER_CONTEXT});
    private static final Set<String> PRIMITIVE_TYPES = new THashSet(Arrays.asList("short", "boolean", "double", "long", "int", "float", "char", "byte"));
    private static final Key<List<PsiErrorElement>> ERRORS = new Key("STRUCTURAL_SEARCH_ERRORS");
    private static final Comparator<PsiErrorElement> ERROR_COMPARATOR = Comparator.comparingInt(PsiElement::getTextOffset).thenComparing(PsiErrorElement::getErrorDescription);

    public String getText(PsiElement match, int start, int end) {
        PsiElement parent;
        if (match instanceof PsiIdentifier && (parent = match.getParent()) instanceof PsiJavaCodeReferenceElement && !(parent instanceof PsiExpression)) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            String text2 = referenceElement.getText();
            if (end != -1) {
                return text2.substring(start, end);
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null) {
                return text2.substring(start, parameterList.getStartOffsetInParent());
            }
            return text2;
        }
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String text2;
        if (element instanceof PsiNamedElement) {
            text2 = ((PsiNamedElement)element).getName();
        } else if (element instanceof PsiAnnotation) {
            PsiJavaCodeReferenceElement referenceElement = ((PsiAnnotation)element).getNameReferenceElement();
            text2 = referenceElement == null ? null : referenceElement.getQualifiedName();
        } else if (element instanceof PsiNameValuePair) {
            text2 = ((PsiNameValuePair)element).getName();
        } else {
            int i;
            text2 = element.getText();
            if (StringUtil.startsWithChar((CharSequence)text2, (char)'@')) {
                text2 = text2.substring(1);
            }
            if (StringUtil.endsWithChar((CharSequence)text2, (char)';')) {
                text2 = text2.substring(0, text2.length() - 1);
            } else if (element instanceof PsiExpressionStatement && (i = text2.indexOf(59)) != -1) {
                text2 = text2.substring(0, i);
            }
        }
        if (text2 == null) {
            text2 = element.getText();
        }
        String string = text2;
        if (string == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getMeaningfulText(PsiElement element) {
        if (element instanceof PsiReferenceExpression && ((PsiReferenceExpression)element).getQualifierExpression() != null) {
            String text2;
            PsiElement resolve2 = ((PsiReferenceExpression)element).resolve();
            if (resolve2 instanceof PsiClass) {
                return element.getText();
            }
            PsiElement referencedElement = ((PsiReferenceExpression)element).getReferenceNameElement();
            String string = text2 = referencedElement != null ? referencedElement.getText() : "";
            if (resolve2 == null && text2.length() > 0 && Character.isUpperCase(text2.charAt(0))) {
                return element.getText();
            }
            return text2;
        }
        return super.getMeaningfulText(element);
    }

    @Nullable
    public String getAlternativeText(PsiElement node, String previousText) {
        if (node instanceof PsiJavaCodeReferenceElement || node instanceof PsiClass) {
            PsiElement element;
            PsiElement psiElement = element = node instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)node).resolve() : node;
            if (element instanceof PsiClass) {
                String text2 = ((PsiClass)element).getQualifiedName();
                if (text2 != null && text2.equals(previousText)) {
                    text2 = ((PsiClass)element).getName();
                }
                if (text2 != null) {
                    return text2;
                }
            }
        } else if (node instanceof PsiLiteralExpression || node instanceof PsiComment) {
            return node.getText();
        }
        return null;
    }

    public PsiElement updateCurrentNode(PsiElement targetNode) {
        if (targetNode instanceof PsiCodeBlock && ((PsiCodeBlock)targetNode).getStatementCount() == 1) {
            PsiElement targetNodeParent = targetNode.getParent();
            if (targetNodeParent instanceof PsiBlockStatement) {
                targetNodeParent = targetNodeParent.getParent();
            }
            if (targetNodeParent instanceof PsiIfStatement || targetNodeParent instanceof PsiLoopStatement) {
                targetNode = targetNodeParent;
            }
        }
        return targetNode;
    }

    public PsiElement extendMatchedByDownUp(PsiElement targetNode) {
        PsiElement parent;
        if (targetNode instanceof PsiIdentifier && ((parent = (targetNode = targetNode.getParent()).getParent()) instanceof PsiTypeElement || parent instanceof PsiStatement)) {
            targetNode = parent;
        }
        return targetNode;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        if (file instanceof PsiIdentifier) {
            file = file.getParent();
        }
        return file;
    }

    @NotNull
    public PsiElement getPresentableElement(PsiElement element) {
        PsiElement parent;
        if ((element = super.getPresentableElement(element)) instanceof PsiReferenceExpression) {
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiMethodCallExpression) {
                PsiElement psiElement = parent2;
                if (psiElement == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(1);
                }
                return psiElement;
            }
        } else if (element instanceof PsiJavaCodeReferenceElement && ((parent = element.getParent()) instanceof PsiTypeElement || parent instanceof PsiNewExpression || parent instanceof PsiAnnotation || parent instanceof PsiAnonymousClass)) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public void compile(PsiElement[] elements, @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(4);
        }
        new JavaCompilingVisitor(globalVisitor).compile(elements);
    }

    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(5);
        }
        JavaMatchingVisitor javaMatchingVisitor = new JavaMatchingVisitor(globalVisitor);
        if (javaMatchingVisitor == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(6);
        }
        return javaMatchingVisitor;
    }

    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> JavaStructuralSearchProfile.isLexicalNode(element);
        if (nodeFilter == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(7);
        }
        return nodeFilter;
    }

    private static boolean isLexicalNode(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiJavaToken) {
            return !(element instanceof PsiKeyword) || !PRIMITIVE_TYPES.contains(element.getText()) || !(element.getParent() instanceof PsiNewExpression);
        }
        return false;
    }

    @NotNull
    public CompiledPattern createCompiledPattern() {
        JavaCompiledPattern javaCompiledPattern = new JavaCompiledPattern();
        if (javaCompiledPattern == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(8);
        }
        return javaCompiledPattern;
    }

    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name2, MatchOptions options) {
        ExprTypePredicate predicate;
        SmartList result = new SmartList();
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfExprType())) {
            predicate = new ExprTypePredicate(constraint.getNameOfExprType(), name2, constraint.isExprTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            result.add(constraint.isInvertExprType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        if (!StringUtil.isEmptyOrSpaces((String)constraint.getNameOfFormalArgType())) {
            predicate = new FormalArgTypePredicate(constraint.getNameOfFormalArgType(), name2, constraint.isFormalArgTypeWithinHierarchy(), options.isCaseSensitiveMatch(), constraint.isPartOfSearchResults());
            result.add(constraint.isInvertFormalType() ? new NotPredicate((MatchPredicate)predicate) : predicate);
        }
        return result;
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return language == JavaLanguage.INSTANCE;
    }

    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (replaceOptions == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(11);
        }
        return new JavaReplaceHandler(project, replaceOptions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context, @NotNull LanguageFileType fileType, @NotNull Language language, String contextId, @NotNull Project project, boolean physical) {
        if (text2 == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(14);
        }
        if (language == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if (project == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(16);
        }
        if (physical) {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + " cannot create physical PSI");
        }
        if (MEMBER_CONTEXT.getId().equals(contextId)) {
            context = PatternTreeContext.Class;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (context == PatternTreeContext.Block) {
            SmartList result;
            block31: {
                PsiElement[] classPattern;
                PsiCodeBlock codeBlock = elementFactory.createCodeBlockFromText("{\n" + text2 + "\n}", null);
                PsiElement element = codeBlock.getFirstBodyElement();
                if (element == null) {
                    if (PsiElement.EMPTY_ARRAY == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(17);
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                result = new SmartList();
                PsiElement lastBodyElement = codeBlock.getLastBodyElement();
                while (element != null) {
                    if (!(element instanceof PsiWhiteSpace)) {
                        result.add(element);
                    }
                    if (element == lastBodyElement) break;
                    element = element.getNextSibling();
                }
                if (result.isEmpty()) {
                    if (PsiElement.EMPTY_ARRAY == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(18);
                    }
                    return PsiElement.EMPTY_ARRAY;
                }
                if (JavaStructuralSearchProfile.shouldTryExpressionPattern((List<PsiElement>)result)) {
                    PsiElement[] expressionPattern2;
                    block32: {
                        try {
                            expressionPattern2 = this.createPatternTree(text2, PatternTreeContext.Expression, fileType, language, contextId, project, false);
                            if (expressionPattern2.length != 1) break block31;
                            if (expressionPattern2 != null) break block32;
                        }
                        catch (IncorrectOperationException expressionPattern2) {
                            break block31;
                        }
                        JavaStructuralSearchProfile.$$$reportNull$$$0(19);
                    }
                    return expressionPattern2;
                }
                if (JavaStructuralSearchProfile.shouldTryClassPattern((List<PsiElement>)result) && (classPattern = this.createPatternTree(text2, PatternTreeContext.Class, fileType, language, contextId, project, false)).length <= result.size()) {
                    if (classPattern == null) {
                        JavaStructuralSearchProfile.$$$reportNull$$$0(20);
                    }
                    return classPattern;
                }
            }
            PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(21);
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Class) {
            PsiElement endChild;
            PsiClass clazz = elementFactory.createClassFromText(text2, null);
            PsiElement startChild = clazz.getLBrace();
            if (startChild != null) {
                startChild = startChild.getNextSibling();
            }
            if ((endChild = clazz.getRBrace()) != null) {
                endChild = endChild.getPrevSibling();
            }
            if (startChild == endChild) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    JavaStructuralSearchProfile.$$$reportNull$$$0(22);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            assert (startChild != null);
            SmartList result = new SmartList();
            for (PsiElement element = startChild.getNextSibling(); element != endChild && element != null; element = element.getNextSibling()) {
                result.add(element);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)result);
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(23);
            }
            return psiElementArray;
        }
        if (context == PatternTreeContext.Expression) {
            PsiElement[] psiElementArray = new PsiElement[]{elementFactory.createExpressionFromText(text2, null)};
            if (psiElementArray == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(24);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = PsiFileFactory.getInstance((Project)project).createFileFromText("__dummy.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text2).getChildren();
        if (psiElementArray == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return psiElementArray;
    }

    private static boolean shouldTryExpressionPattern(List<PsiElement> elements) {
        PsiElement lastChild;
        PsiElement firstElement;
        return elements.size() >= 1 && elements.size() <= 3 && (firstElement = elements.get(0)) instanceof PsiDeclarationStatement && (lastChild = firstElement.getLastChild()) instanceof PsiErrorElement && PsiTreeUtil.prevLeaf((PsiElement)lastChild) instanceof PsiErrorElement;
    }

    private static boolean shouldTryClassPattern(List<PsiElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        PsiElement firstElement = elements.get(0);
        if (firstElement instanceof PsiDeclarationStatement && firstElement.getFirstChild() instanceof PsiClass) {
            return true;
        }
        if (elements.size() < 2) {
            return false;
        }
        PsiElement secondElement = elements.get(1);
        PsiElement lastElement = elements.get(elements.size() - 1);
        if (firstElement instanceof PsiDocComment) {
            return true;
        }
        if (firstElement instanceof PsiDeclarationStatement && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiErrorElement && secondElement instanceof PsiExpressionStatement && PsiTreeUtil.lastChild((PsiElement)secondElement) instanceof PsiErrorElement) {
            return true;
        }
        if (firstElement instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)firstElement).isDefaultCase() && PsiTreeUtil.lastChild((PsiElement)firstElement) instanceof PsiErrorElement && secondElement instanceof PsiDeclarationStatement) {
            return true;
        }
        return firstElement instanceof PsiExpressionStatement && firstElement.getFirstChild() instanceof PsiMethodCallExpression && firstElement.getLastChild() instanceof PsiErrorElement && lastElement instanceof PsiBlockStatement;
    }

    @NotNull
    public Class<? extends TemplateContextType> getTemplateContextTypeClass() {
        if (JavaCodeContextType.class == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(26);
        }
        return JavaCodeContextType.class;
    }

    @NotNull
    public List<PatternContext> getPatternContexts() {
        if (!Registry.is((String)"ssr.in.editor.problem.highlighting")) {
            List list = super.getPatternContexts();
            if (list == null) {
                JavaStructuralSearchProfile.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<PatternContext> list = PATTERN_CONTEXTS;
        if (list == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public PsiCodeFragment createCodeFragment(Project project, String text2, String contextId) {
        JavaCodeFragment javaCodeFragment = MEMBER_CONTEXT.getId().equals(contextId) ? JavaCodeFragmentFactory.getInstance((Project)project).createMemberCodeFragment(text2, null, true) : JavaCodeFragmentFactory.getInstance((Project)project).createCodeBlockCodeFragment(text2, null, true);
        if (javaCodeFragment == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(29);
        }
        return javaCodeFragment;
    }

    public String getCodeFragmentText(PsiFile fragment) {
        List imports2 = StringUtil.split((String)((JavaCodeFragment)fragment).importsToString(), (String)",");
        final Map importMap = imports2.stream().collect(Collectors.toMap(s -> s.substring(s.lastIndexOf(46) + 1), Function.identity()));
        final StringBuilder result = new StringBuilder();
        fragment.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (!reference.isQualified()) {
                    String text2 = reference.getText();
                    String fqName = (String)importMap.get(text2);
                    result.append(fqName != null ? fqName : text2);
                } else {
                    super.visitReferenceElement(reference);
                }
            }

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element.getFirstChild() == null) {
                    result.append(element.getText());
                }
            }
        });
        return result.toString();
    }

    public boolean highlightProblemsInEditor() {
        return true;
    }

    public boolean shouldShowProblem(HighlightInfo highlightInfo, PsiFile file, PatternContext context) {
        Runnable callback;
        PsiStatement child;
        String text2;
        PsiElement prev;
        if (!Registry.is((String)"ssr.in.editor.problem.highlighting")) {
            return false;
        }
        if (highlightInfo.getSeverity() != HighlightSeverity.ERROR && highlightInfo.getSeverity() != HighlightSeverity.INFORMATION) {
            return false;
        }
        PsiErrorElement error = JavaStructuralSearchProfile.findErrorElementAt(file, highlightInfo.startOffset, highlightInfo.getDescription());
        if (error == null) {
            return false;
        }
        String description = error.getErrorDescription();
        PsiElement parent = error.getParent();
        if (parent instanceof PsiClass && !(parent instanceof PsiCodeFragment) && "Identifier expected".equals(description) && (prev = error.getPrevSibling()) instanceof PsiTypeElement && StringUtil.startsWithChar((CharSequence)(text2 = prev.getText()), (char)'$') && StringUtil.endsWithChar((CharSequence)text2, (char)'$')) {
            return false;
        }
        if (parent instanceof PsiTryStatement && "'catch' or 'finally' expected".equals(description)) {
            return false;
        }
        List children = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)file, PsiStatement.class);
        if (children.size() == 1 && context == DEFAULT_CONTEXT && (child = (PsiStatement)children.get(0)) == parent && (child instanceof PsiExpressionStatement || child instanceof PsiDeclarationStatement)) {
            if ("';' expected".equals(description) && error.getNextSibling() == null) {
                return false;
            }
            if ("Identifier or type expected".equals(description)) {
                return false;
            }
            if ("Identifier expected".equals(description)) {
                return false;
            }
        }
        if (this.myProblemCallback != null && (callback = (Runnable)this.myProblemCallback.get()) != null) {
            callback.run();
        }
        return true;
    }

    private static PsiErrorElement findErrorElementAt(PsiFile file, int offset, String description) {
        List errorList = (List)ERRORS.get((UserDataHolder)file, JavaStructuralSearchProfile.findErrors(file));
        for (PsiErrorElement element : errorList) {
            if (element.getTextOffset() != offset || !description.equals(element.getErrorDescription())) continue;
            return element;
        }
        return null;
    }

    private static List<PsiErrorElement> findErrors(PsiFile file) {
        Collection errors = PsiTreeUtil.findChildrenOfType((PsiElement)file, PsiErrorElement.class);
        ArrayList<PsiErrorElement> errorList = new ArrayList<PsiErrorElement>(errors);
        Collections.sort(errorList, ERROR_COMPARATOR);
        file.putUserData(ERRORS, errorList);
        return errorList;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
        ValidatingVisitor visitor = new ValidatingVisitor();
        NodeIterator nodes = pattern.getNodes();
        if (pattern.getNodeCount() == 1 && (nodes.current() instanceof PsiExpressionStatement || nodes.current() instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(nodes.current());
        }
        while (nodes.hasNext()) {
            nodes.current().accept((PsiElementVisitor)visitor);
            nodes.advance();
        }
        nodes.reset();
    }

    public void checkReplacementPattern(Project project, ReplaceOptions options) {
        MatchOptions matchOptions = options.getMatchOptions();
        LanguageFileType fileType = matchOptions.getFileType();
        Language dialect = matchOptions.getDialect();
        PsiElement[] statements = this.createPatternTree(matchOptions.getSearchPattern(), PatternTreeContext.Block, fileType, dialect, null, project, false);
        boolean searchIsExpression = statements.length == 1 && statements[0].getLastChild() instanceof PsiErrorElement;
        PsiElement[] statements2 = this.createPatternTree(options.getReplacement(), PatternTreeContext.Block, fileType, dialect, null, project, false);
        boolean replaceIsExpression = statements2.length == 1 && statements2[0].getLastChild() instanceof PsiErrorElement;
        ValidatingVisitor visitor = new ValidatingVisitor();
        if (statements2.length == 1 && (statements2[0] instanceof PsiExpressionStatement || statements2[0] instanceof PsiDeclarationStatement)) {
            visitor.setCurrent(statements2[0]);
        }
        for (PsiElement statement : statements2) {
            statement.accept((PsiElementVisitor)visitor);
        }
        if (searchIsExpression && statements[0].getFirstChild() instanceof PsiModifierList && statements2.length == 0) {
            return;
        }
        boolean targetFound = false;
        for (String name2 : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name2);
            if (!constraint.isPartOfSearchResults() || "__context__".equals(constraint.getName())) continue;
            targetFound = true;
            break;
        }
        if (!targetFound && searchIsExpression != replaceIsExpression) {
            throw new UnsupportedPatternException(searchIsExpression ? SSRBundle.message((String)"replacement.template.is.not.expression.error.message", (Object[])new Object[0]) : SSRBundle.message((String)"search.template.is.not.expression.error.message", (Object[])new Object[0]));
        }
    }

    public LanguageFileType getDefaultFileType(LanguageFileType currentDefaultFileType) {
        return StdFileTypes.JAVA;
    }

    public Configuration[] getPredefinedTemplates() {
        return JavaPredefinedConfigurations.createPredefinedTemplates();
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, final ReplacementBuilder builder) {
        if (node == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(30);
        }
        node.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement((PsiElement)expression2);
            }

            public void visitParameter(PsiParameter parameter2) {
                super.visitParameter(parameter2);
                String name2 = parameter2.getName();
                String type2 = parameter2.getType().getCanonicalText();
                if (StructuralSearchUtil.isTypedVariable((String)name2)) {
                    name2 = Replacer.stripTypedVariableDecoration((String)name2);
                    if (StructuralSearchUtil.isTypedVariable((String)type2)) {
                        type2 = Replacer.stripTypedVariableDecoration((String)type2);
                    }
                    ParameterInfo nameInfo = builder.findParameterization(name2);
                    ParameterInfo typeInfo = builder.findParameterization(type2);
                    PsiElement scope = parameter2.getDeclarationScope();
                    if (nameInfo != null && typeInfo != null && !(scope instanceof PsiCatchSection) && !(scope instanceof PsiForeachStatement)) {
                        nameInfo.setArgumentContext(false);
                        typeInfo.setArgumentContext(false);
                        typeInfo.setMethodParameterContext(true);
                        nameInfo.setMethodParameterContext(true);
                        typeInfo.setElement((PsiElement)parameter2.getTypeElement());
                    }
                }
            }
        });
    }

    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, int offset, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean forceAddingNewLine = false;
            if (info.isMethodParameterContext()) {
                StringBuilder buf = new StringBuilder();
                JavaStructuralSearchProfile.handleMethodParameter(buf, info, replacementInfo);
                replacementString = buf.toString();
            } else if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                MatchResult previous = null;
                boolean stripSemicolon = false;
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    boolean bl = stripSemicolon = !(currentElement instanceof PsiField);
                    if (previous != null) {
                        PsiElement prevSibling;
                        PsiElement parent = currentElement.getParent();
                        if (parent instanceof PsiVariable) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parent);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            }
                        } else if (info.isStatementContext()) {
                            prevSibling = currentElement.getPrevSibling();
                            if (prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() == previous.getMatch()) {
                                buf.append(prevSibling.getText());
                            } else {
                                buf.append('\n');
                            }
                        } else if (info.isArgumentContext()) {
                            buf.append(',');
                        } else if (parent instanceof PsiClass) {
                            prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)currentElement);
                            if (PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                                buf.append(',');
                            } else {
                                buf.append('\n');
                            }
                        } else if (parent instanceof PsiReferenceList) {
                            buf.append(',');
                        } else if (parent instanceof PsiPolyadicExpression) {
                            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)parent;
                            PsiJavaToken token = expression2.getTokenBeforeOperand(expression2.getOperands()[1]);
                            if (token != null) {
                                buf.append(token.getText());
                            }
                        } else {
                            buf.append(' ');
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    forceAddingNewLine = currentElement instanceof PsiComment;
                    previous = matchResult;
                }
                replacementString = stripSemicolon ? StringUtil.trimEnd((String)buf.toString(), (char)';') : buf.toString();
            } else {
                PsiElement matchElement = match.getMatch();
                if (info.isStatementContext()) {
                    forceAddingNewLine = matchElement instanceof PsiComment;
                }
                String matchImage = match.getMatchImage();
                replacementString = !(matchElement instanceof PsiField) ? StringUtil.trimEnd((String)matchImage, (char)';') : matchImage;
            }
            offset = Replacer.insertSubstitution((StringBuilder)result, (int)offset, (ParameterInfo)info, (String)replacementString);
            offset = JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, match);
            if (forceAddingNewLine && info.isStatementContext()) {
                result.insert(info.getStartIndex() + offset + 1, '\n');
                ++offset;
            }
        }
        return offset;
    }

    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result) {
        PsiElement element = info.getElement();
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        if (prevSibling instanceof PsiJavaToken && JavaStructuralSearchProfile.isRemovableToken(prevSibling)) {
            int start = info.getBeforeDelimiterPos() + offset - (prevSibling.getTextLength() - 1);
            int end = info.getStartIndex() + offset;
            result.delete(start, end);
            return offset - (end - start);
        }
        PsiElement nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        if (JavaStructuralSearchProfile.isRemovableToken(nextSibling)) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + nextSibling.getTextLength() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element instanceof PsiTypeElement && nextSibling instanceof PsiIdentifier) {
            int start = info.getStartIndex() + offset;
            int end = info.getAfterDelimiterPos() + offset;
            result.delete(start, end);
            return offset - 1;
        }
        if (element == null || !(element.getParent() instanceof PsiForStatement)) {
            return JavaStructuralSearchProfile.removeExtraSemicolon(info, offset, result, null);
        }
        return offset;
    }

    private static boolean isRemovableToken(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnnotationParameterList || parent instanceof PsiAssertStatement || parent instanceof PsiExpressionList || parent instanceof PsiParameterList || parent instanceof PsiPolyadicExpression || parent instanceof PsiReferenceExpression || parent instanceof PsiReferenceList || parent instanceof PsiReferenceParameterList || parent instanceof PsiResourceList || parent instanceof PsiTypeParameterList || parent instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return false;
        }
        String text2 = element.getText();
        if (text2.length() != 1) {
            return true;
        }
        switch (text2.charAt(0)) {
            case '(': 
            case ')': 
            case '<': 
            case '>': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    public boolean isIdentifier(@Nullable PsiElement element) {
        return element instanceof PsiIdentifier;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = Collections.singleton("packageLocal");
        if (set == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(31);
        }
        return set;
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return match instanceof PsiMember;
    }

    private static void handleMethodParameter(StringBuilder buf, ParameterInfo info, ReplacementInfo replacementInfo) {
        if (!(info.getElement() instanceof PsiTypeElement)) {
            return;
        }
        String name2 = ((PsiParameter)info.getElement().getParent()).getName();
        name2 = StructuralSearchUtil.isTypedVariable((String)name2) ? Replacer.stripTypedVariableDecoration((String)name2) : name2;
        MatchResult matchResult = replacementInfo.getNamedMatchResult(name2);
        if (matchResult == null) {
            return;
        }
        if (matchResult.isMultipleMatch()) {
            for (MatchResult result : matchResult.getChildren()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                JavaStructuralSearchProfile.appendParameter(buf, result);
            }
        } else {
            JavaStructuralSearchProfile.appendParameter(buf, matchResult);
        }
    }

    private static void appendParameter(StringBuilder buf, MatchResult matchResult) {
        List sons = matchResult.getChildren();
        assert (sons.size() == 1);
        buf.append(((MatchResult)sons.get(0)).getMatchImage()).append(' ').append(matchResult.getMatchImage());
    }

    private static int removeExtraSemicolon(ParameterInfo info, int offset, StringBuilder result, MatchResult match) {
        if (info.isStatementContext()) {
            PsiElement matchElement;
            int index = offset + info.getStartIndex();
            PsiElement psiElement = matchElement = match == null ? null : match.getMatch();
            if (result.charAt(index) == ';' && (matchElement == null || result.charAt(index - 1) == '}' && !(matchElement instanceof PsiDeclarationStatement) && !(matchElement instanceof PsiNewExpression) && !(matchElement instanceof PsiArrayInitializerExpression) || (match.isMultipleMatch() ? ((MatchResult)match.getChildren().get(match.getChildren().size() - 1)).getMatch() instanceof PsiComment : matchElement instanceof PsiComment))) {
                result.deleteCharAt(index);
                --offset;
            }
        }
        return offset;
    }

    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        switch (constraintName) {
            case "TEXT": {
                return !completePattern;
            }
            case "TEXT HIERARCHY": {
                if (variableNode != null) {
                    PsiElement parent = variableNode.getParent();
                    if (parent instanceof PsiJavaCodeReferenceElement) {
                        PsiElement grandParent = parent.getParent();
                        if (grandParent instanceof PsiTypeElement || grandParent instanceof PsiReferenceList || grandParent instanceof PsiReferenceExpression || grandParent instanceof PsiNewExpression || grandParent instanceof PsiAnonymousClass) {
                            return true;
                        }
                    } else {
                        if (parent instanceof PsiClass) {
                            return true;
                        }
                        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            case "EXPECTED TYPE": {
                PsiElement grandParent;
                if (variableNode != null && ((grandParent = variableNode.getParent().getParent()) instanceof PsiExpressionStatement ? JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent) : grandParent instanceof PsiStatement)) {
                    return false;
                }
            }
            case "TYPE": {
                PsiElement child;
                if (variableNode instanceof PsiExpressionStatement && (child = variableNode.getLastChild()) instanceof PsiErrorElement) {
                    PsiErrorElement errorElement = (PsiErrorElement)child;
                    return "';' expected".equals(errorElement.getErrorDescription());
                }
                return variableNode != null && variableNode.getParent() instanceof PsiExpression;
            }
            case "MINIMUM ZERO": {
                if (target || variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMinCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "MAXIMUM UNLIMITED": {
                if (variableNode == null) {
                    return false;
                }
                return JavaStructuralSearchProfile.isApplicableMaxCount(variableNode) || JavaStructuralSearchProfile.isApplicableMinMaxCount(variableNode);
            }
            case "REFERENCE": {
                if (completePattern || variableNode == null) {
                    return false;
                }
                if (variableNode instanceof PsiLiteralExpression && ((PsiLiteralExpression)variableNode).getValue() instanceof String) {
                    return true;
                }
                PsiElement parent = variableNode.getParent();
                return parent instanceof PsiJavaCodeReferenceElement;
            }
        }
        return super.isApplicableConstraint(constraintName, variableNode, completePattern, target);
    }

    private static boolean isApplicableMinCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        PsiElement label;
        PsiElement parent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(32);
        }
        if ((parent = variableNode.getParent()) instanceof PsiContinueStatement) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiReferenceList) {
            return true;
        }
        if (grandParent instanceof PsiPolyadicExpression) {
            return ((PsiPolyadicExpression)grandParent).getOperands().length > 2;
        }
        if (parent instanceof PsiReferenceExpression) {
            if (grandParent instanceof PsiReferenceExpression) {
                return true;
            }
            if (grandParent instanceof PsiReturnStatement) {
                return true;
            }
            if (grandParent instanceof PsiAssertStatement) {
                return ((PsiAssertStatement)grandParent).getAssertDescription() == parent;
            }
            if (grandParent instanceof PsiNameValuePair) {
                return ((PsiNameValuePair)grandParent).getValue() == parent;
            }
            if (grandParent instanceof PsiBreakStatement) {
                return true;
            }
            if (grandParent instanceof PsiForStatement) {
                return true;
            }
        }
        if (grandParent instanceof PsiExpressionList && (label = grandParent.getParent()) instanceof PsiSwitchLabelStatementBase) {
            return ((PsiSwitchLabelStatementBase)label).getEnclosingSwitchStatement() != null;
        }
        if (grandParent instanceof PsiVariable) {
            return ((PsiVariable)grandParent).getInitializer() == parent;
        }
        if (grandParent instanceof PsiNewExpression) {
            return ((PsiNewExpression)grandParent).getArrayInitializer() != null;
        }
        if (grandParent instanceof PsiTypeElement) {
            greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiTypeElement) {
                PsiType type2 = ((PsiTypeElement)greatGrandParent).getType();
                return type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).isExtends();
            }
            if (greatGrandParent instanceof PsiMethod) {
                return true;
            }
        }
        if (grandParent instanceof PsiExpressionStatement) {
            greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiForStatement && !PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)greatGrandParent).getBody(), (PsiElement)variableNode, (boolean)true)) {
                return true;
            }
            if (JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent)) {
                if (greatGrandParent instanceof PsiLoopStatement || greatGrandParent instanceof PsiIfStatement) {
                    return false;
                }
                return !(greatGrandParent instanceof PsiCodeBlock) || !(greatGrandParent.getParent() instanceof JavaDummyHolder) || PsiTreeUtil.getChildrenOfAnyType((PsiElement)greatGrandParent, (Class[])new Class[]{PsiStatement.class, PsiComment.class}).size() > 1;
            }
        }
        return false;
    }

    private static boolean isApplicableMaxCount(@NotNull PsiElement variableNode) {
        PsiElement parent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(33);
        }
        if ((parent = variableNode.getParent()) instanceof PsiLocalVariable) {
            PsiLocalVariable localVariable = (PsiLocalVariable)parent;
            if (localVariable instanceof PsiResourceVariable) {
                return false;
            }
            return !localVariable.getTypeElement().isInferredType();
        }
        if (parent instanceof PsiField) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiPolyadicExpression) {
            return true;
        }
        if (grandParent instanceof PsiExpressionList && grandParent.getParent() instanceof PsiSwitchLabelStatementBase) {
            return true;
        }
        if (grandParent instanceof PsiExpressionStatement && JavaStructuralSearchProfile.isCompleteStatement((PsiExpressionStatement)grandParent)) {
            PsiElement greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)greatGrandParent;
                return forStatement.getInitialization() == grandParent || forStatement.getUpdate() == grandParent;
            }
            return greatGrandParent instanceof PsiCodeBlock;
        }
        if (grandParent instanceof PsiReferenceList) {
            PsiElement greatGrandParent = grandParent.getParent();
            return !(greatGrandParent instanceof PsiClass) || ((PsiClass)greatGrandParent).getExtendsList() != grandParent || greatGrandParent instanceof PsiTypeParameter;
        }
        return false;
    }

    private static boolean isApplicableMinMaxCount(@NotNull PsiElement variableNode) {
        PsiElement greatGrandParent;
        if (variableNode == null) {
            JavaStructuralSearchProfile.$$$reportNull$$$0(34);
        }
        if (variableNode instanceof PsiDocToken) {
            return true;
        }
        PsiElement parent = variableNode.getParent();
        if (JavaStructuralSearchProfile.isMemberSurroundedByClass(parent)) {
            return true;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof PsiCatchSection && parent instanceof PsiParameter) {
            return true;
        }
        if (grandParent instanceof PsiAnnotation && !(grandParent.getParent().getNextSibling() instanceof PsiErrorElement)) {
            return true;
        }
        if (grandParent instanceof PsiParameterList || grandParent instanceof PsiArrayInitializerMemberValue || grandParent instanceof PsiExpressionList && !(grandParent.getParent() instanceof PsiSwitchLabelStatementBase) || grandParent instanceof PsiTypeParameterList || grandParent instanceof PsiResourceList || grandParent instanceof PsiResourceExpression || grandParent instanceof PsiArrayInitializerExpression) {
            return true;
        }
        if (grandParent instanceof PsiTypeElement && ((greatGrandParent = grandParent.getParent()) instanceof PsiReferenceParameterList || greatGrandParent instanceof PsiClass)) {
            return true;
        }
        if (grandParent instanceof PsiAnnotationParameterList && parent instanceof PsiNameValuePair) {
            return ((PsiNameValuePair)parent).getNameIdentifier() == variableNode;
        }
        return false;
    }

    private static boolean isMemberSurroundedByClass(PsiElement parent) {
        if (!(parent instanceof PsiMember) || parent instanceof PsiTypeParameter) {
            return false;
        }
        PsiMember member = (PsiMember)parent;
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String name2 = aClass.getName();
        return name2 != null && !"_Dummy_".equals(name2);
    }

    private static boolean isCompleteStatement(PsiExpressionStatement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == element) {
            return true;
        }
        PsiElement lastChild = element.getLastChild();
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            lastChild = lastChild.getPrevSibling();
        }
        return PsiUtil.isJavaToken((PsiElement)lastChild, (IElementType)JavaTokenType.SEMICOLON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVisitor";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/JavaStructuralSearchProfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatchingVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalNodesFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompiledPattern";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextTypeClass";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternContexts";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFragment";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMatchingVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMinCount";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMaxCount";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableMinMaxCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ValidatingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myCurrent;

        ValidatingVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null || !nameReferenceElement.getText().equals("Modifier")) {
                return;
            }
            for (PsiNameValuePair pair2 : annotation.getParameterList().getAttributes()) {
                for (PsiAnnotationMemberValue v : AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)pair2.getValue())) {
                    ValidatingVisitor.checkModifier(StringUtil.unquoteString((String)v.getText()));
                }
            }
        }

        private static void checkModifier(String name2) {
            if (!"Instance".equals(name2) && !"packageLocal".equals(name2) && ArrayUtil.find((Object[])JavaMatchingVisitor.MODIFIERS, (Object)name2) < 0) {
                throw new MalformedPatternException(SSRBundle.message((String)"invalid.modifier.type", (Object[])new Object[]{name2}));
            }
        }

        public void visitErrorElement(PsiErrorElement element) {
            super.visitErrorElement(element);
            PsiElement parent = element.getParent();
            String errorDescription = element.getErrorDescription();
            if (parent instanceof PsiClass && "Identifier expected".equals(errorDescription)) {
                return;
            }
            if (parent instanceof PsiTryStatement && "'catch' or 'finally' expected".equals(errorDescription)) {
                return;
            }
            if (parent == this.myCurrent) {
                if ("';' expected".equals(errorDescription) && element.getNextSibling() == null) {
                    return;
                }
                if ("Identifier or type expected".equals(errorDescription)) {
                    return;
                }
                if ("Identifier expected".equals(errorDescription)) {
                    return;
                }
            }
            throw new MalformedPatternException(element);
        }

        void setCurrent(PsiElement current) {
            this.myCurrent = current;
        }
    }
}

