/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.JavaSliceProvider;
import com.intellij.slicer.JavaSlicerAnalysisUtil;
import com.intellij.slicer.SliceNullnessAnalyzerBase;
import org.jetbrains.annotations.NotNull;

public class JavaSliceNullnessAnalyzer
extends SliceNullnessAnalyzerBase {
    public JavaSliceNullnessAnalyzer() {
        super(JavaSlicerAnalysisUtil.LEAF_ELEMENT_EQUALITY, JavaSliceProvider.getInstance());
    }

    @Override
    @NotNull
    protected Nullability checkNullability(PsiElement element) {
        Nullability result;
        PsiMethod method;
        PsiElement value2 = element;
        if (value2 instanceof PsiExpression) {
            value2 = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)value2));
        }
        if (value2 instanceof PsiLiteralExpression) {
            Nullability nullability = ((PsiLiteralExpression)value2).getValue() == null ? Nullability.NULLABLE : Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(0);
            }
            return nullability;
        }
        if (value2 instanceof PsiNewExpression) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(1);
            }
            return nullability;
        }
        if (value2 instanceof PsiThisExpression) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(2);
            }
            return nullability;
        }
        if (value2 instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)value2).resolveMethod()) != null) {
            Nullability nullability = NullableNotNullManager.getNullability((PsiModifierListOwner)method);
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(3);
            }
            return nullability;
        }
        if (value2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)value2).getOperationTokenType() == JavaTokenType.PLUS) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(4);
            }
            return nullability;
        }
        PsiElement context = value2;
        if (value2 instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)value2).resolve();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            value2 = resolved;
        }
        if (value2 instanceof PsiParameter && ((PsiParameter)value2).getDeclarationScope() instanceof PsiCatchSection) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(5);
            }
            return nullability;
        }
        if ((value2 instanceof PsiLocalVariable || value2 instanceof PsiParameter) && (result = DfaUtil.checkNullability((PsiVariable)value2, context)) != Nullability.UNKNOWN) {
            Nullability nullability = result;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(6);
            }
            return nullability;
        }
        if (value2 instanceof PsiEnumConstant) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(7);
            }
            return nullability;
        }
        if (value2 instanceof PsiModifierListOwner) {
            Nullability nullability = NullableNotNullManager.getNullability((PsiModifierListOwner)((PsiModifierListOwner)value2));
            if (nullability == null) {
                JavaSliceNullnessAnalyzer.$$$reportNull$$$0(8);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            JavaSliceNullnessAnalyzer.$$$reportNull$$$0(9);
        }
        return nullability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/JavaSliceNullnessAnalyzer", "checkNullability"));
    }
}

