/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.duplicates.BreakReturnValue;
import com.intellij.refactoring.util.duplicates.ComplexityHolder;
import com.intellij.refactoring.util.duplicates.ConditionalReturnStatementValue;
import com.intellij.refactoring.util.duplicates.ContinueReturnValue;
import com.intellij.refactoring.util.duplicates.ExpressionReturnValue;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.GotoReturnValue;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.ReturnStatementReturnValue;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.duplicates.DuplicatesFinder");
    public static final Key<Parameter> PARAMETER = Key.create((String)"PARAMETER");
    @NotNull
    private final PsiElement[] myPattern;
    private final InputVariables myParameters;
    private final List<? extends PsiVariable> myOutputParameters;
    private final List<PsiElement> myPatternAsList;
    private boolean myMultipleExitPoints;
    @Nullable
    private final ReturnValue myReturnValue;
    @Nullable
    private final Set<? extends TextRange> myTextRanges;
    private final MatchType myMatchType;
    private final Set<? extends PsiVariable> myEffectivelyLocal;
    private ComplexityHolder myPatternComplexityHolder;
    private ComplexityHolder myCandidateComplexityHolder;

    public DuplicatesFinder(@NotNull PsiElement[] pattern, InputVariables parameters2, @Nullable ReturnValue returnValue, @NotNull List<? extends PsiVariable> outputParameters, @NotNull MatchType matchType, @Nullable Set<? extends PsiVariable> effectivelyLocal, @Nullable Set<? extends TextRange> textRanges) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(0);
        }
        if (outputParameters == null) {
            DuplicatesFinder.$$$reportNull$$$0(1);
        }
        if (matchType == null) {
            DuplicatesFinder.$$$reportNull$$$0(2);
        }
        this.myReturnValue = returnValue;
        LOG.assertTrue(pattern.length > 0);
        this.myPattern = pattern;
        this.myPatternAsList = Arrays.asList(this.myPattern);
        this.myOutputParameters = outputParameters;
        this.myMatchType = matchType;
        this.myEffectivelyLocal = effectivelyLocal != null ? effectivelyLocal : Collections.emptySet();
        this.myTextRanges = textRanges;
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(pattern[0]);
        try {
            int endOffset;
            int startOffset;
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false);
            int i = 0;
            while ((startOffset = controlFlow.getStartOffset(pattern[i++])) < 0 && i < pattern.length) {
            }
            int j = pattern.length - 1;
            while ((endOffset = controlFlow.getEndOffset(pattern[j--])) < 0 && j >= 0) {
            }
            IntArrayList exitPoints = new IntArrayList();
            Collection<PsiStatement> exitStatements = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            boolean bl = this.myMultipleExitPoints = exitPoints.size() > 1;
            if (this.myMultipleExitPoints) {
                parameters2 = parameters2.copy();
                parameters2.removeParametersUsedInExitsOnly(codeFragment, exitStatements, controlFlow, startOffset, endOffset);
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        this.myParameters = parameters2;
    }

    public DuplicatesFinder(@NotNull PsiElement[] pattern, InputVariables parameters2, @Nullable ReturnValue returnValue, @NotNull List<? extends PsiVariable> outputParameters) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(3);
        }
        if (outputParameters == null) {
            DuplicatesFinder.$$$reportNull$$$0(4);
        }
        this(pattern, parameters2, returnValue, outputParameters, MatchType.EXACT, null, null);
    }

    public DuplicatesFinder(PsiElement[] pattern, InputVariables psiParameters, List<? extends PsiVariable> psiVariables) {
        this(pattern, psiParameters, null, psiVariables);
    }

    public InputVariables getParameters() {
        return this.myParameters;
    }

    @NotNull
    public PsiElement[] getPattern() {
        if (this.myPattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(5);
        }
        return this.myPattern;
    }

    @Nullable
    public ReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    public List<Match> findDuplicates(PsiElement scope) {
        this.annotatePattern();
        ArrayList<Match> result = new ArrayList<Match>();
        this.findPatternOccurrences(result, scope);
        this.deannotatePattern();
        return result;
    }

    @Nullable
    public Match isDuplicate(@NotNull PsiElement element, boolean ignoreParameterTypesAndPostVariableUsages) {
        if (element == null) {
            DuplicatesFinder.$$$reportNull$$$0(6);
        }
        this.annotatePattern();
        Match match = this.isDuplicateFragment(element, ignoreParameterTypesAndPostVariableUsages);
        this.deannotatePattern();
        return match;
    }

    private void annotatePattern() {
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement qualifier;
                PsiElement element = reference.resolve();
                if (element instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)element;
                    PsiType type2 = variable.getType();
                    DuplicatesFinder.this.myParameters.annotateWithParameter(reference);
                    if (DuplicatesFinder.this.myOutputParameters.contains(element)) {
                        reference.putUserData(PARAMETER, (Object)new Parameter(variable, type2));
                    }
                }
                if ((qualifier = reference.getQualifier()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
            }
        };
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)visitor);
        }
    }

    private void deannotatePattern() {
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                if (expression2.getUserData(PARAMETER) != null) {
                    expression2.putUserData(PARAMETER, null);
                }
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.getUserData(PARAMETER) != null) {
                    reference.putUserData(PARAMETER, null);
                }
            }
        };
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)visitor);
        }
    }

    private void findPatternOccurrences(List<? super Match> array, PsiElement scope) {
        PsiElement[] children;
        for (PsiElement child : children = scope.getChildren()) {
            ProgressManager.checkCanceled();
            Match match = this.isDuplicateFragment(child, false);
            if (match != null && (this.myTextRanges == null || this.myTextRanges.contains(match.getTextRange()))) {
                array.add(match);
                continue;
            }
            this.findPatternOccurrences(array, child);
        }
    }

    @Nullable
    private Match isDuplicateFragment(@NotNull PsiElement candidate, boolean ignoreParameterTypesAndPostVariableUsages) {
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(7);
        }
        if (this.isSelf(candidate)) {
            return null;
        }
        PsiElement sibling = candidate;
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>();
        for (PsiElement element : this.myPattern) {
            if (sibling == null) {
                return null;
            }
            if (!DuplicatesFinder.canBeEquivalent(element, sibling) || this.isSelf(sibling)) {
                return null;
            }
            candidates.add(sibling);
            sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)sibling, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class, PsiEmptyStatement.class});
        }
        LOG.assertTrue(this.myPattern.length == candidates.size());
        if (this.myPattern.length == 1 && this.myPattern[0] instanceof PsiExpression) {
            if (candidates.get(0) instanceof PsiExpression) {
                PsiExpression candidateExpression = (PsiExpression)candidates.get(0);
                if (PsiUtil.isAccessedForWriting((PsiExpression)candidateExpression)) {
                    return null;
                }
                PsiType patternType = ((PsiExpression)this.myPattern[0]).getType();
                PsiType candidateType = candidateExpression.getType();
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                PsiMethod method = (PsiMethod)PsiTreeUtil.getContextOfType((PsiElement)this.myPattern[0], (Class[])new Class[]{PsiMethod.class});
                if (method != null) {
                    PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)candidate.getProject()).getResolveHelper();
                    substitutor = resolveHelper.inferTypeArguments(method.getTypeParameters(), new PsiType[]{patternType}, new PsiType[]{candidateType}, PsiUtil.getLanguageLevel((PsiElement)method));
                }
                if (!DuplicatesFinder.canTypesBeEquivalent(substitutor.substitute(patternType), candidateType)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        Match match = new Match((PsiElement)candidates.get(0), (PsiElement)candidates.get(candidates.size() - 1), ignoreParameterTypesAndPostVariableUsages);
        for (int i = 0; i < this.myPattern.length; ++i) {
            if (this.matchPattern(this.myPattern[i], (PsiElement)candidates.get(i), candidates, match)) continue;
            return null;
        }
        if (!ignoreParameterTypesAndPostVariableUsages && this.checkPostVariableUsages(candidates, match)) {
            return null;
        }
        return match;
    }

    protected boolean isSelf(@NotNull PsiElement candidate) {
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(8);
        }
        for (PsiElement pattern : this.myPattern) {
            ProgressManager.checkCanceled();
            if (!PsiTreeUtil.isAncestor((PsiElement)pattern, (PsiElement)candidate, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPostVariableUsages(ArrayList<? extends PsiElement> candidates, Match match) {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(candidates.get(0));
        try {
            int endOffset;
            int startOffset;
            ControlFlow controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false);
            int i = 0;
            while ((startOffset = controlFlow.getStartOffset(candidates.get(i++))) < 0 && i < candidates.size()) {
            }
            int j = candidates.size() - 1;
            while ((endOffset = controlFlow.getEndOffset(candidates.get(j--))) < 0 && j >= 0) {
            }
            IntArrayList exitPoints = new IntArrayList();
            ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, exitPoints, ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES);
            PsiVariable[] outVariables = ControlFlowUtil.getOutputVariables(controlFlow, startOffset, endOffset, exitPoints.toArray());
            if (outVariables.length > 0) {
                if (outVariables.length == 1) {
                    ReturnValue value2;
                    ReturnValue returnValue = match.getReturnValue();
                    if (returnValue == null) {
                        returnValue = this.myReturnValue;
                    }
                    if (returnValue instanceof GotoReturnValue || returnValue instanceof ConditionalReturnStatementValue && ((ConditionalReturnStatementValue)returnValue).isEmptyOrConstantExpression()) {
                        return false;
                    }
                    if (returnValue instanceof VariableReturnValue && (value2 = match.getOutputVariableValue(((VariableReturnValue)returnValue).getVariable())) != null) {
                        PsiExpression expression2;
                        if (value2.isEquivalent(new VariableReturnValue(outVariables[0]))) {
                            return false;
                        }
                        if (value2 instanceof ExpressionReturnValue && (expression2 = ((ExpressionReturnValue)value2).getExpression()) instanceof PsiReferenceExpression) {
                            PsiElement variable = ((PsiReferenceExpression)expression2).resolve();
                            return variable == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)outVariables[0]);
                        }
                    }
                }
                return true;
            }
        }
        catch (AnalysisCanceledException analysisCanceledException) {
            // empty catch block
        }
        return false;
    }

    private static boolean canTypesBeEquivalent(PsiType type1, PsiType type2) {
        if (type1 == null || type2 == null) {
            return false;
        }
        if (!type2.isAssignableFrom(type1)) {
            if (type1 instanceof PsiImmediateClassType && type2 instanceof PsiImmediateClassType) {
                PsiClass psiClass1 = ((PsiImmediateClassType)type1).resolve();
                PsiClass psiClass2 = ((PsiImmediateClassType)type2).resolve();
                if (!(psiClass1 instanceof PsiAnonymousClass && psiClass2 instanceof PsiAnonymousClass && psiClass1.getManager().areElementsEquivalent((PsiElement)((PsiAnonymousClass)psiClass1).getBaseClassType().resolve(), (PsiElement)((PsiAnonymousClass)psiClass2).getBaseClassType().resolve()))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean canBeEquivalent(PsiElement pattern, PsiElement candidate) {
        if (pattern instanceof PsiReturnStatement && candidate instanceof PsiExpressionStatement) {
            return true;
        }
        if (pattern instanceof PsiReturnStatement && candidate instanceof PsiDeclarationStatement) {
            return true;
        }
        if (pattern instanceof PsiThisExpression && candidate instanceof PsiReferenceExpression) {
            return true;
        }
        ASTNode node1 = pattern.getNode();
        ASTNode node2 = candidate.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        if (pattern instanceof PsiUnaryExpression) {
            return ((PsiUnaryExpression)pattern).getOperationTokenType() == ((PsiUnaryExpression)candidate).getOperationTokenType();
        }
        if (pattern instanceof PsiPolyadicExpression) {
            return ((PsiPolyadicExpression)pattern).getOperationTokenType() == ((PsiPolyadicExpression)candidate).getOperationTokenType();
        }
        return true;
    }

    private boolean matchPattern(@Nullable PsiElement pattern, @Nullable PsiElement candidate, @NotNull List<PsiElement> candidates, @NotNull Match match) {
        PsiElement[] children2;
        PsiElement[] children1;
        Boolean matches;
        if (candidates == null) {
            DuplicatesFinder.$$$reportNull$$$0(9);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(10);
        }
        if (pattern == null || candidate == null) {
            return pattern == candidate;
        }
        Boolean parameterMatches = this.matchParameter(pattern, candidate, match);
        if (parameterMatches != null) {
            return parameterMatches;
        }
        if (!DuplicatesFinder.canBeEquivalent(pattern, candidate)) {
            return false;
        }
        if (pattern instanceof PsiExpressionList && candidate instanceof PsiExpressionList && (matches = this.matchVarargs((PsiExpressionList)pattern, (PsiExpressionList)candidate, candidates, match)) != null) {
            return matches;
        }
        if (DuplicatesFinder.isParameterModification(pattern, candidate)) {
            return false;
        }
        if (pattern instanceof PsiJavaCodeReferenceElement && candidate instanceof PsiJavaCodeReferenceElement && (matches = this.matchReferenceElement((PsiJavaCodeReferenceElement)pattern, (PsiJavaCodeReferenceElement)candidate, candidates, match)) != null) {
            return matches;
        }
        if (pattern instanceof PsiTypeCastExpression && candidate instanceof PsiTypeCastExpression) {
            if (!DuplicatesFinder.isEquivalentTypeCast((PsiTypeCastExpression)pattern, (PsiTypeCastExpression)candidate)) {
                return false;
            }
        } else if (pattern instanceof PsiNewExpression && candidate instanceof PsiNewExpression) {
            if (!DuplicatesFinder.isEquivalentNewExpression((PsiNewExpression)pattern, (PsiNewExpression)candidate)) {
                return false;
            }
        } else {
            if (pattern instanceof PsiClassObjectAccessExpression && candidate instanceof PsiClassObjectAccessExpression) {
                return DuplicatesFinder.matchObjectAccess((PsiClassObjectAccessExpression)pattern, (PsiClassObjectAccessExpression)candidate);
            }
            if (pattern instanceof PsiInstanceOfExpression && candidate instanceof PsiInstanceOfExpression) {
                if (!DuplicatesFinder.isEquivalentInstanceOf((PsiInstanceOfExpression)pattern, (PsiInstanceOfExpression)candidate)) {
                    return false;
                }
            } else {
                if (pattern instanceof PsiReturnStatement) {
                    return this.matchReturnStatement((PsiReturnStatement)pattern, candidate, candidates, match);
                }
                if (pattern instanceof PsiContinueStatement) {
                    match.registerReturnValue(new ContinueReturnValue());
                } else if (pattern instanceof PsiBreakStatement) {
                    match.registerReturnValue(new BreakReturnValue());
                } else if (pattern instanceof PsiMethodCallExpression && candidate instanceof PsiMethodCallExpression) {
                    if (!DuplicatesFinder.isEquivalentMethodCall((PsiMethodCallExpression)pattern, (PsiMethodCallExpression)candidate)) {
                        return false;
                    }
                } else if (pattern instanceof PsiReferenceExpression && candidate instanceof PsiReferenceExpression) {
                    matches = DuplicatesFinder.matchReferenceExpression((PsiReferenceExpression)pattern, (PsiReferenceExpression)candidate, match);
                    if (matches != null) {
                        return matches;
                    }
                } else {
                    if (pattern instanceof PsiThisExpression) {
                        return DuplicatesFinder.matchThisExpression((PsiThisExpression)pattern, candidate, match);
                    }
                    if (pattern instanceof PsiSuperExpression && candidate instanceof PsiSuperExpression) {
                        return DuplicatesFinder.matchSuperExpression((PsiSuperExpression)pattern, (PsiSuperExpression)candidate);
                    }
                    if (pattern instanceof PsiModifierList && candidate instanceof PsiModifierList) {
                        return DuplicatesFinder.matchModifierList((PsiModifierList)pattern, (PsiModifierList)candidate);
                    }
                }
            }
        }
        if (!this.matchChildren(children1 = DuplicatesFinder.getFilteredChildren(pattern), children2 = DuplicatesFinder.getFilteredChildren(candidate), candidates, match)) {
            return false;
        }
        if (children1.length == 0) {
            return this.matchLeaf(pattern, candidate, match);
        }
        return true;
    }

    @Nullable
    private Boolean matchParameter(@NotNull PsiElement pattern, @NotNull PsiElement candidate, @NotNull Match match) {
        Parameter parameter2;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(11);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(12);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(13);
        }
        if ((parameter2 = (Parameter)pattern.getUserData(PARAMETER)) == null || this.myMatchType == MatchType.EXACT && parameter2.isFolded()) {
            return null;
        }
        if (!match.putParameter(parameter2, candidate)) {
            return false;
        }
        if (parameter2.isFolded() && pattern instanceof PsiExpression && candidate instanceof PsiExpression) {
            match.putFoldedExpressionMapping(parameter2, (PsiExpression)pattern, (PsiExpression)candidate);
        }
        return true;
    }

    @Nullable
    private Boolean matchVarargs(@NotNull PsiExpressionList pattern, @NotNull PsiExpressionList candidate, @NotNull List<PsiElement> candidates, @NotNull Match match) {
        PsiElement resolved;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(14);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(15);
        }
        if (candidates == null) {
            DuplicatesFinder.$$$reportNull$$$0(16);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(17);
        }
        PsiExpression[] expressions2 = pattern.getExpressions();
        PsiExpression[] childExpressions = candidate.getExpressions();
        if (expressions2.length > 0 && expressions2[expressions2.length - 1] instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expressions2[expressions2.length - 1]).resolve()) instanceof PsiParameter && ((PsiParameter)resolved).getType() instanceof PsiEllipsisType) {
            for (int i = 0; i < expressions2.length - 1; ++i) {
                Parameter parameter2 = (Parameter)expressions2[i].getUserData(PARAMETER);
                if (!(parameter2 == null ? !this.matchPattern((PsiElement)expressions2[i], (PsiElement)childExpressions[i], candidates, match) : !match.putParameter(parameter2, (PsiElement)childExpressions[i]))) continue;
                return false;
            }
            Parameter param = (Parameter)expressions2[expressions2.length - 1].getUserData(PARAMETER);
            if (param == null) {
                return false;
            }
            for (int i = expressions2.length - 1; i < childExpressions.length; ++i) {
                if (match.putParameter(param, (PsiElement)childExpressions[i])) continue;
                return false;
            }
            return true;
        }
        return null;
    }

    private static boolean isParameterModification(@NotNull PsiElement pattern, @NotNull PsiElement candidate) {
        PsiExpression lExpression;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(18);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(19);
        }
        return pattern instanceof PsiAssignmentExpression ? (lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)pattern).getLExpression())) instanceof PsiReferenceExpression && lExpression.getType() instanceof PsiPrimitiveType && ((PsiReferenceExpression)lExpression).resolve() instanceof PsiParameter : pattern instanceof PsiUnaryExpression && candidate instanceof PsiUnaryExpression && DuplicatesFinder.checkParameterModification(((PsiUnaryExpression)pattern).getOperand(), ((PsiUnaryExpression)pattern).getOperationTokenType(), ((PsiUnaryExpression)candidate).getOperand());
    }

    @Nullable
    private Boolean matchReferenceElement(@NotNull PsiJavaCodeReferenceElement pattern, @NotNull PsiJavaCodeReferenceElement candidate, @NotNull List<? extends PsiElement> candidates, @NotNull Match match) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(20);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(21);
        }
        if (candidates == null) {
            DuplicatesFinder.$$$reportNull$$$0(22);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(23);
        }
        PsiElement resolveResult1 = pattern.resolve();
        PsiElement resolveResult2 = candidate.resolve();
        if (resolveResult1 instanceof PsiClass && resolveResult2 instanceof PsiClass) {
            return true;
        }
        if (DuplicatesFinder.isUnder(resolveResult1, this.myPatternAsList) && DuplicatesFinder.isUnder(resolveResult2, candidates)) {
            DuplicatesFinder.traverseParameter(resolveResult1, resolveResult2, match);
            return match.putDeclarationCorrespondence(resolveResult1, resolveResult2);
        }
        if (resolveResult1 instanceof PsiVariable && this.myEffectivelyLocal.contains((PsiVariable)resolveResult1)) {
            return (resolveResult2 instanceof PsiLocalVariable || resolveResult2 instanceof PsiParameter) && match.putDeclarationCorrespondence(resolveResult1, resolveResult2);
        }
        PsiElement qualifier2 = candidate.getQualifier();
        while (qualifier2 instanceof PsiParenthesizedExpression) {
            qualifier2 = ((PsiParenthesizedExpression)qualifier2).getExpression();
        }
        if (!DuplicatesFinder.equivalentResolve(resolveResult1, resolveResult2, qualifier2)) {
            return this.matchExtractableVariable((PsiElement)pattern, (PsiElement)candidate, match);
        }
        PsiElement qualifier1 = pattern.getQualifier();
        while (qualifier1 instanceof PsiParenthesizedExpression) {
            qualifier1 = ((PsiParenthesizedExpression)qualifier1).getExpression();
        }
        if (qualifier1 instanceof PsiReferenceExpression && qualifier2 instanceof PsiReferenceExpression && !match.areCorrespond(((PsiReferenceExpression)qualifier1).resolve(), ((PsiReferenceExpression)qualifier2).resolve())) {
            return false;
        }
        if (qualifier1 == null && qualifier2 == null) {
            PsiClass patternClass = RefactoringChangeUtil.getThisClass((PsiElement)pattern);
            PsiClass candidateClass = RefactoringChangeUtil.getThisClass((PsiElement)candidate);
            if (resolveResult1 == resolveResult2 && resolveResult1 instanceof PsiMember) {
                PsiClass containingClass = ((PsiMember)resolveResult1).getContainingClass();
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)candidateClass, (PsiClass)patternClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)candidateClass, (PsiClass)containingClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)patternClass, (PsiClass)containingClass, (boolean)true)) {
                    return false;
                }
            }
        }
        return null;
    }

    private static boolean isEquivalentTypeCast(@NotNull PsiTypeCastExpression pattern, @NotNull PsiTypeCastExpression candidate) {
        PsiType type2;
        PsiType type1;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(24);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(25);
        }
        PsiTypeElement castTypeElement1 = pattern.getCastType();
        PsiTypeElement castTypeElement2 = candidate.getCastType();
        return castTypeElement1 == null || castTypeElement2 == null || (type1 = TypeConversionUtil.erasure((PsiType)castTypeElement1.getType())).equals(type2 = TypeConversionUtil.erasure((PsiType)castTypeElement2.getType()));
    }

    private static boolean isEquivalentNewExpression(@NotNull PsiNewExpression pattern, @NotNull PsiNewExpression candidate) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(26);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(27);
        }
        PsiType type1 = pattern.getType();
        PsiType type2 = candidate.getType();
        if (type1 == null || type2 == null) {
            return false;
        }
        PsiMethod constructor1 = pattern.resolveConstructor();
        PsiMethod constructor2 = candidate.resolveConstructor();
        return !(constructor1 != null && constructor2 != null ? !pattern.getManager().areElementsEquivalent((PsiElement)constructor1, (PsiElement)constructor2) : !DuplicatesFinder.canTypesBeEquivalent(type1, type2));
    }

    private static boolean matchObjectAccess(@NotNull PsiClassObjectAccessExpression pattern, @NotNull PsiClassObjectAccessExpression candidate) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(28);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(29);
        }
        PsiTypeElement operand1 = pattern.getOperand();
        PsiTypeElement operand2 = candidate.getOperand();
        return operand1.getType().equals(operand2.getType());
    }

    private static boolean isEquivalentInstanceOf(@NotNull PsiInstanceOfExpression pattern, @NotNull PsiInstanceOfExpression candidate) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(30);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(31);
        }
        PsiTypeElement operand1 = pattern.getCheckType();
        PsiTypeElement operand2 = candidate.getCheckType();
        if (operand1 == null || operand2 == null) {
            return false;
        }
        return operand1.getType().equals(operand2.getType());
    }

    private static boolean isEquivalentMethodCall(@NotNull PsiMethodCallExpression pattern, @NotNull PsiMethodCallExpression candidate) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(32);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(33);
        }
        PsiMethod patternMethod = pattern.resolveMethod();
        PsiMethod candidateMethod = candidate.resolveMethod();
        return patternMethod == null || candidateMethod == null || MethodSignatureUtil.areSignaturesEqual((PsiMethod)patternMethod, (PsiMethod)candidateMethod);
    }

    @Nullable
    private static Boolean matchReferenceExpression(@NotNull PsiReferenceExpression pattern, @NotNull PsiReferenceExpression candidate, @NotNull Match match) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(34);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(35);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(36);
        }
        PsiExpression patternQualifier = pattern.getQualifierExpression();
        PsiExpression candidateQualifier = candidate.getQualifierExpression();
        if (patternQualifier == null) {
            return DuplicatesFinder.matchUnqualifiedPatternReference(pattern, candidateQualifier, match);
        }
        if (candidateQualifier == null) {
            return DuplicatesFinder.matchUnqualifiedCandidateReference(patternQualifier, candidate, match);
        }
        if (patternQualifier instanceof PsiThisExpression && candidateQualifier instanceof PsiThisExpression) {
            return DuplicatesFinder.matchThisQualifierReference((PsiThisExpression)patternQualifier, (PsiThisExpression)candidateQualifier);
        }
        return null;
    }

    private static boolean matchUnqualifiedPatternReference(@NotNull PsiReferenceExpression pattern, @Nullable PsiExpression candidateQualifier, @NotNull Match match) {
        PsiElement resolved;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(37);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(38);
        }
        PsiClass contextClass = RefactoringChangeUtil.getThisClass((PsiElement)pattern);
        if (candidateQualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)candidateQualifier).resolve()) instanceof PsiClass && contextClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)((PsiClass)resolved), (boolean)true)) {
            return true;
        }
        return contextClass != null && match.registerInstanceExpression(candidateQualifier, contextClass);
    }

    private static boolean matchUnqualifiedCandidateReference(@NotNull PsiExpression patternQualifier, @NotNull PsiReferenceExpression candidate, @NotNull Match match) {
        if (patternQualifier == null) {
            DuplicatesFinder.$$$reportNull$$$0(39);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(40);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(41);
        }
        if (patternQualifier instanceof PsiThisExpression) {
            PsiJavaCodeReferenceElement qualifier = ((PsiThisExpression)patternQualifier).getQualifier();
            PsiClass contextClass = qualifier == null ? RefactoringChangeUtil.getThisClass((PsiElement)patternQualifier) : qualifier.resolve();
            return contextClass instanceof PsiClass && match.registerInstanceExpression(null, contextClass);
        }
        PsiType type2 = patternQualifier.getType();
        PsiClass contextClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
        try {
            PsiClass classContext;
            PsiElement resolved;
            Parameter parameter2 = (Parameter)patternQualifier.getUserData(PARAMETER);
            if (parameter2 != null) {
                PsiClass thisCandidate;
                PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)parameter2.getVariable());
                if (contextClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)thisClass, (PsiClass)contextClass, (boolean)true)) {
                    contextClass = thisClass;
                }
                if ((thisCandidate = RefactoringChangeUtil.getThisClass((PsiElement)candidate)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)thisCandidate, (PsiClass)contextClass, (boolean)true)) {
                    contextClass = thisCandidate;
                }
                return contextClass != null && !(contextClass instanceof PsiAnonymousClass) && match.putParameter(parameter2, (PsiElement)RefactoringChangeUtil.createThisExpression(patternQualifier.getManager(), contextClass));
            }
            return patternQualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)patternQualifier).resolve()) instanceof PsiClass && (classContext = RefactoringChangeUtil.getThisClass((PsiElement)candidate)) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)classContext, (PsiClass)((PsiClass)resolved), (boolean)true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    private static boolean matchThisQualifierReference(PsiThisExpression patternQualifier, PsiThisExpression candidateQualifier) {
        PsiJavaCodeReferenceElement thisPatternQualifier = patternQualifier.getQualifier();
        PsiClass patternContextClass = thisPatternQualifier == null ? RefactoringChangeUtil.getThisClass((PsiElement)patternQualifier) : thisPatternQualifier.resolve();
        PsiJavaCodeReferenceElement thisCandidateQualifier = candidateQualifier.getQualifier();
        PsiClass candidateContextClass = thisCandidateQualifier == null ? RefactoringChangeUtil.getThisClass((PsiElement)candidateQualifier) : thisCandidateQualifier.resolve();
        return patternContextClass == candidateContextClass;
    }

    private static boolean matchThisExpression(@NotNull PsiThisExpression pattern, @NotNull PsiElement candidate, @NotNull Match match) {
        PsiJavaCodeReferenceElement qualifier;
        PsiClass contextClass;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(42);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(43);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(44);
        }
        Object object = contextClass = (qualifier = pattern.getQualifier()) == null ? RefactoringChangeUtil.getThisClass((PsiElement)pattern) : qualifier.resolve();
        if (candidate instanceof PsiReferenceExpression) {
            PsiElement parent = candidate.getParent();
            return parent instanceof PsiReferenceExpression && contextClass instanceof PsiClass && match.registerInstanceExpression(((PsiReferenceExpression)parent).getQualifierExpression(), contextClass);
        }
        if (candidate instanceof PsiThisExpression) {
            PsiJavaCodeReferenceElement candidateQualifier = ((PsiThisExpression)candidate).getQualifier();
            PsiClass candidateContextClass = candidateQualifier == null ? RefactoringChangeUtil.getThisClass(candidate) : candidateQualifier.resolve();
            return contextClass == candidateContextClass;
        }
        return false;
    }

    private static boolean matchSuperExpression(@NotNull PsiSuperExpression pattern, @NotNull PsiSuperExpression candidate) {
        PsiJavaCodeReferenceElement qualifier;
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(45);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(46);
        }
        PsiClass contextClass = (qualifier = pattern.getQualifier()) == null ? RefactoringChangeUtil.getThisClass((PsiElement)pattern) : qualifier.resolve();
        PsiJavaCodeReferenceElement candidateQualifier = candidate.getQualifier();
        return contextClass == (candidateQualifier != null ? candidateQualifier.resolve() : RefactoringChangeUtil.getThisClass((PsiElement)candidate));
    }

    private boolean matchChildren(@NotNull PsiElement[] children1, @NotNull PsiElement[] children2, @NotNull List<PsiElement> candidates, @NotNull Match match) {
        if (children1 == null) {
            DuplicatesFinder.$$$reportNull$$$0(47);
        }
        if (children2 == null) {
            DuplicatesFinder.$$$reportNull$$$0(48);
        }
        if (candidates == null) {
            DuplicatesFinder.$$$reportNull$$$0(49);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(50);
        }
        if (children1.length != children2.length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (this.matchPattern(child1, child2, candidates, match) || this.matchExtractableExpression(child1, child2, candidates, match)) continue;
            return false;
        }
        return true;
    }

    public boolean matchLeaf(@NotNull PsiElement pattern, @NotNull PsiElement candidate, @NotNull Match match) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(51);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(52);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(53);
        }
        if (pattern.getParent() instanceof PsiVariable && ((PsiVariable)pattern.getParent()).getNameIdentifier() == pattern) {
            return match.putDeclarationCorrespondence(pattern.getParent(), candidate.getParent());
        }
        return pattern.textMatches(candidate);
    }

    private boolean matchExtractableExpression(@Nullable PsiElement pattern, @Nullable PsiElement candidate, @NotNull List<PsiElement> candidates, @NotNull Match match) {
        ExtractableExpressionPart candidatePart;
        ExtractableExpressionPart patternPart;
        if (candidates == null) {
            DuplicatesFinder.$$$reportNull$$$0(54);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(55);
        }
        if (this.myMatchType == MatchType.EXACT || !(pattern instanceof PsiExpression) || !(candidate instanceof PsiExpression)) {
            return false;
        }
        if (this.myPattern.length == 1 && DuplicatesFinder.isSameExpression(this.myPattern[0], (PsiExpression)pattern)) {
            return false;
        }
        if (this.myPatternComplexityHolder == null) {
            this.myPatternComplexityHolder = new ComplexityHolder(this.myPatternAsList);
        }
        if ((patternPart = ExtractableExpressionPart.match((PsiExpression)pattern, this.myPatternAsList, this.myPatternComplexityHolder)) == null) {
            return false;
        }
        if (this.myCandidateComplexityHolder == null || this.myCandidateComplexityHolder.getScope() != candidates) {
            this.myCandidateComplexityHolder = new ComplexityHolder(candidates);
        }
        if ((candidatePart = ExtractableExpressionPart.match((PsiExpression)candidate, candidates, this.myCandidateComplexityHolder)) == null) {
            return false;
        }
        if (patternPart.myValue != null && patternPart.myValue.equals(candidatePart.myValue)) {
            return true;
        }
        if (patternPart.myVariable == null || candidatePart.myVariable == null) {
            return match.putExtractedParameter(patternPart, candidatePart);
        }
        return false;
    }

    private boolean matchExtractableVariable(@NotNull PsiElement pattern, @NotNull PsiElement candidate, @NotNull Match match) {
        if (pattern == null) {
            DuplicatesFinder.$$$reportNull$$$0(56);
        }
        if (candidate == null) {
            DuplicatesFinder.$$$reportNull$$$0(57);
        }
        if (match == null) {
            DuplicatesFinder.$$$reportNull$$$0(58);
        }
        if (this.myMatchType == MatchType.EXACT || !(pattern instanceof PsiReferenceExpression) || !(candidate instanceof PsiReferenceExpression)) {
            return false;
        }
        if (this.myPattern.length == 1 && this.myPattern[0] == pattern) {
            return false;
        }
        ExtractableExpressionPart part1 = ExtractableExpressionPart.matchVariable((PsiReferenceExpression)pattern, null);
        if (part1 == null || part1.myVariable == null) {
            return false;
        }
        ExtractableExpressionPart part2 = ExtractableExpressionPart.matchVariable((PsiReferenceExpression)candidate, null);
        if (part2 == null || part2.myVariable == null) {
            return false;
        }
        return match.putExtractedParameter(part1, part2);
    }

    private static boolean isSameExpression(@NotNull PsiElement context, @NotNull PsiExpression expression2) {
        if (context == null) {
            DuplicatesFinder.$$$reportNull$$$0(59);
        }
        if (expression2 == null) {
            DuplicatesFinder.$$$reportNull$$$0(60);
        }
        if (context instanceof PsiExpression) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)context)) == PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        }
        if (context instanceof PsiDeclarationStatement) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            return parent instanceof PsiLocalVariable && parent.getParent() == context;
        }
        return false;
    }

    private static boolean matchModifierList(PsiModifierList modifierList1, PsiModifierList modifierList2) {
        if (!(modifierList1.getParent() instanceof PsiLocalVariable)) {
            for (String modifier : PsiModifier.MODIFIERS) {
                if (!(modifierList1.hasModifierProperty(modifier) ? !modifierList2.hasModifierProperty(modifier) : modifierList2.hasModifierProperty(modifier))) continue;
                return false;
            }
        }
        return AnnotationUtil.equal((PsiAnnotation[])modifierList1.getAnnotations(), (PsiAnnotation[])modifierList2.getAnnotations());
    }

    private static boolean checkParameterModification(PsiExpression expression2, IElementType sign, PsiExpression candidate) {
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate);
        if (expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).resolve() instanceof PsiParameter && (sign.equals(JavaTokenType.MINUSMINUS) || sign.equals(JavaTokenType.PLUSPLUS))) {
            return !(candidate instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)candidate).resolve() instanceof PsiParameter);
        }
        return false;
    }

    private static void traverseParameter(PsiElement pattern, PsiElement candidate, Match match) {
        PsiElement[] children2;
        if (pattern == null || candidate == null) {
            return;
        }
        Parameter parameter2 = (Parameter)pattern.getUserData(PARAMETER);
        if (parameter2 != null) {
            match.putParameter(parameter2, candidate);
            return;
        }
        PsiElement[] children1 = DuplicatesFinder.getFilteredChildren(pattern);
        if (children1.length != (children2 = DuplicatesFinder.getFilteredChildren(candidate)).length) {
            return;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            DuplicatesFinder.traverseParameter(child1, child2, match);
        }
    }

    private boolean matchReturnStatement(PsiReturnStatement patternReturnStatement, PsiElement candidate, List<PsiElement> candidates, Match match) {
        if (candidate instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)candidate).getExpression();
            if (expression2 instanceof PsiAssignmentExpression) {
                PsiExpression rExpression;
                PsiExpression returnValue = patternReturnStatement.getReturnValue();
                if (!this.matchPattern((PsiElement)returnValue, (PsiElement)(rExpression = ((PsiAssignmentExpression)expression2).getRExpression()), candidates, match)) {
                    return false;
                }
                PsiExpression lExpression = ((PsiAssignmentExpression)expression2).getLExpression();
                return match.registerReturnValue(new ExpressionReturnValue(lExpression));
            }
            return false;
        }
        if (candidate instanceof PsiDeclarationStatement) {
            PsiElement[] declaredElements = ((PsiDeclarationStatement)candidate).getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            if (!(declaredElements[0] instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)declaredElements[0];
            if (!this.matchPattern((PsiElement)patternReturnStatement.getReturnValue(), (PsiElement)variable.getInitializer(), candidates, match)) {
                return false;
            }
            return match.registerReturnValue(new VariableReturnValue(variable));
        }
        if (candidate instanceof PsiReturnStatement) {
            PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiReturnStatement)candidate).getReturnValue());
            if (this.myMultipleExitPoints) {
                return match.registerReturnValue(new ConditionalReturnStatementValue(returnValue));
            }
            PsiElement classOrLambda = PsiTreeUtil.getContextOfType((PsiElement)returnValue, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)match.getMatchStart(), (PsiElement)match.getMatchEnd());
            if (!(classOrLambda != null && PsiTreeUtil.isAncestor((PsiElement)commonParent, (PsiElement)classOrLambda, (boolean)false) || returnValue == null || match.registerReturnValue(ReturnStatementReturnValue.INSTANCE))) {
                return false;
            }
            return this.matchPattern((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)patternReturnStatement.getReturnValue()), (PsiElement)returnValue, candidates, match);
        }
        return false;
    }

    private static boolean equivalentResolve(PsiElement resolveResult1, PsiElement resolveResult2, PsiElement qualifier2) {
        if (Comparing.equal((Object)resolveResult1, (Object)resolveResult2)) {
            return true;
        }
        if (resolveResult1 instanceof PsiMethod && resolveResult2 instanceof PsiMethod) {
            PsiMethod method1 = (PsiMethod)resolveResult1;
            PsiMethod method2 = (PsiMethod)resolveResult2;
            if (method1.hasModifierProperty("static")) {
                return false;
            }
            if (ArrayUtil.find((Object[])method1.findSuperMethods(), (Object)method2) >= 0) {
                return true;
            }
            if (ArrayUtil.find((Object[])method2.findSuperMethods(), (Object)method1) >= 0) {
                return true;
            }
            if (method1.getName().equals(method2.getName())) {
                Object[] methods;
                PsiClass resolvedClass;
                PsiType type2;
                PsiClass class2 = method2.getContainingClass();
                if (qualifier2 instanceof PsiReferenceExpression && (type2 = ((PsiReferenceExpression)qualifier2).getType()) instanceof PsiClassType && !((resolvedClass = PsiUtil.resolveClassInType((PsiType)type2)) instanceof PsiTypeParameter)) {
                    class2 = resolvedClass;
                }
                if (class2 != null && PsiUtil.isAccessible((PsiMember)method1, (PsiElement)class2, null) && ArrayUtil.find((Object[])(methods = class2.getAllMethods()), (Object)method1) != -1) {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isUnder(@Nullable PsiElement element, @NotNull List<? extends PsiElement> parents) {
        if (parents == null) {
            DuplicatesFinder.$$$reportNull$$$0(61);
        }
        if (element == null) {
            return false;
        }
        for (PsiElement psiElement : parents) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement[] getFilteredChildren(@NotNull PsiElement element) {
        if (element == null) {
            DuplicatesFinder.$$$reportNull$$$0(62);
        }
        PsiElement[] children = element.getChildren();
        PsiElement[] psiElementArray = DuplicatesFinder.getDeeplyFilteredElements(children);
        if (psiElementArray == null) {
            DuplicatesFinder.$$$reportNull$$$0(63);
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiElement[] getDeeplyFilteredElements(@NotNull PsiElement[] children) {
        if (children == null) {
            DuplicatesFinder.$$$reportNull$$$0(64);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        for (PsiElement child : children) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiEmptyStatement) continue;
            if (child instanceof PsiBlockStatement) {
                child = ((PsiBlockStatement)child).getCodeBlock();
            }
            if (child instanceof PsiCodeBlock) {
                PsiStatement[] statements;
                for (PsiStatement statement : statements = ((PsiCodeBlock)child).getStatements()) {
                    if (statement instanceof PsiBlockStatement) {
                        Collections.addAll(array, DuplicatesFinder.getFilteredChildren((PsiElement)statement));
                        continue;
                    }
                    if (statement instanceof PsiEmptyStatement) continue;
                    array.add(statement);
                }
                continue;
            }
            if (child instanceof PsiParenthesizedExpression) {
                array.add(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiParenthesizedExpression)child)));
                continue;
            }
            array.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            DuplicatesFinder.$$$reportNull$$$0(65);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 63: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 63: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
            case 5: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/DuplicatesFinder";
                break;
            }
            case 6: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 19: 
            case 21: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 9: 
            case 16: 
            case 22: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 23: 
            case 36: 
            case 38: 
            case 41: 
            case 44: 
            case 50: 
            case 53: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternQualifier";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children1";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children2";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/DuplicatesFinder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredChildren";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeeplyFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 63: 
            case 65: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicateFragment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelf";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchParameter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matchVarargs";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isParameterModification";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "matchReferenceElement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentTypeCast";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentNewExpression";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "matchObjectAccess";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentInstanceOf";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentMethodCall";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "matchReferenceExpression";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matchUnqualifiedPatternReference";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "matchUnqualifiedCandidateReference";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "matchThisExpression";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "matchSuperExpression";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "matchChildren";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "matchLeaf";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "matchExtractableExpression";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "matchExtractableVariable";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isSameExpression";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredChildren";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDeeplyFilteredElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 63: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MatchType {
        EXACT,
        PARAMETRIZED,
        FOLDED;

    }

    public static class Parameter {
        private final PsiVariable myVariable;
        private final PsiType myType;
        private final boolean myFolded;

        public Parameter(@Nullable PsiVariable variable, @Nullable PsiType type2) {
            this(variable, type2, false);
        }

        public Parameter(@Nullable PsiVariable variable, @Nullable PsiType type2, boolean folded) {
            this.myVariable = variable;
            this.myType = type2;
            this.myFolded = folded;
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isFolded() {
            return this.myFolded;
        }

        public String toString() {
            return this.myVariable + ", " + this.myType + (this.myFolded ? ", folded" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter p = (Parameter)o;
            return Objects.equals(this.myVariable, p.myVariable) && Objects.equals(this.myType, p.myType) && this.myFolded == p.myFolded;
        }

        public int hashCode() {
            return Objects.hash(this.myVariable, this.myType, this.myFolded);
        }
    }
}

