/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.codeInsight.intention.impl.SplitDeclarationAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Objects;
import java.util.function.BinaryOperator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnsureCodeBlockImpl {
    EnsureCodeBlockImpl() {
    }

    @Nullable
    static <T extends PsiExpression> T ensureCodeBlock(@NotNull T expression2) {
        PsiExpression operand2;
        PsiElement grandParent;
        if (expression2 == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(0);
        }
        PsiElement parent = RefactoringUtil.getParentStatement(expression2, false);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        if (parent instanceof PsiExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)parent.getParent();
            expression2 = EnsureCodeBlockImpl.replace(expression2, parent, (old, copy) -> {
                String replacement = PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2)) ? "{a;}" : "{return a;}";
                PsiElement block = old.replace((PsiElement)factory.createCodeBlockFromText(replacement, (PsiElement)lambda2));
                return LambdaUtil.extractSingleExpressionFromBody((PsiElement)block).replace(copy);
            });
            parent = RefactoringUtil.getParentStatement(expression2, false);
        } else if (parent instanceof PsiStatement && (!((grandParent = parent.getParent()) instanceof PsiCodeBlock) || parent instanceof PsiForStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)parent).getInitialization(), expression2, (boolean)true) && EnsureCodeBlockImpl.hasNameCollision((PsiElement)((PsiForStatement)parent).getInitialization(), grandParent))) {
            boolean addBreak = parent instanceof PsiExpressionStatement && grandParent instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)grandParent).getEnclosingSwitchBlock() instanceof PsiSwitchExpression;
            expression2 = addBreak ? EnsureCodeBlockImpl.replace(expression2, parent, (old, copy) -> {
                PsiBlockStatement block = (PsiBlockStatement)old.replace((PsiElement)factory.createStatementFromText("{break a;}", old));
                PsiExpression copyExpression = ((PsiBreakStatement)block.getCodeBlock().getStatements()[0]).getExpression();
                return Objects.requireNonNull(copyExpression).replace((PsiElement)((PsiExpressionStatement)copy).getExpression());
            }) : EnsureCodeBlockImpl.replace(expression2, parent, (old, copy) -> {
                PsiBlockStatement blockStatement = (PsiBlockStatement)old.replace((PsiElement)factory.createStatementFromText("{}", old));
                return blockStatement.getCodeBlock().add(copy);
            });
            parent = RefactoringUtil.getParentStatement(expression2, false);
        }
        if (parent == null) {
            parent = PsiTreeUtil.getParentOfType(expression2, PsiField.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
            if (parent == null) {
                return null;
            }
            return EnsureCodeBlockImpl.replace(expression2, parent, (oldParent, copy) -> EnsureCodeBlockImpl.extractFieldInitializer((PsiField)oldParent, (PsiField)copy));
        }
        PsiConditionalExpression ternary = EnsureCodeBlockImpl.findSurroundingTernary(expression2);
        if (ternary != null && parent instanceof PsiStatement) {
            return EnsureCodeBlockImpl.replace(expression2, parent, (oldParent, copy) -> EnsureCodeBlockImpl.replaceTernaryWithIf((PsiStatement)oldParent, ternary));
        }
        PsiPolyadicExpression condition2 = EnsureCodeBlockImpl.findSurroundingConditionChain(expression2);
        if (condition2 != null) {
            PsiExpression finalExpression = expression2;
            operand2 = (PsiExpression)StreamEx.of((Object[])condition2.getOperands()).findFirst(op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)finalExpression, (boolean)false)).orElseThrow(AssertionError::new);
        } else {
            operand2 = null;
        }
        if (parent instanceof PsiIfStatement && condition2 != null && condition2.getOperationTokenType().equals(JavaTokenType.ANDAND)) {
            return EnsureCodeBlockImpl.replace(expression2, parent, (oldParent, copy) -> EnsureCodeBlockImpl.splitIf((PsiIfStatement)oldParent, condition2, operand2));
        }
        if (parent instanceof PsiWhileStatement) {
            return EnsureCodeBlockImpl.replace(expression2, parent, (oldParent, copy) -> EnsureCodeBlockImpl.extractWhileCondition((PsiWhileStatement)oldParent, condition2, operand2));
        }
        if (parent instanceof PsiReturnStatement && condition2 != null) {
            return EnsureCodeBlockImpl.replace(expression2, parent, (oldParent, copy) -> EnsureCodeBlockImpl.splitReturn((PsiReturnStatement)oldParent, condition2, operand2));
        }
        return expression2;
    }

    private static <T extends PsiElement> T replace(@NotNull T element, @NotNull PsiElement parent, BinaryOperator<PsiElement> replacer) {
        if (element == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(2);
        }
        Object marker = new Object();
        PsiTreeUtil.mark(element, (Object)marker);
        PsiElement copy = parent.copy();
        PsiElement newParent = (PsiElement)replacer.apply(parent, copy);
        return (T)PsiTreeUtil.releaseMark((PsiElement)newParent, (Object)marker);
    }

    private static PsiElement splitReturn(@NotNull PsiReturnStatement returnStatement, @NotNull PsiPolyadicExpression condition2, @NotNull PsiExpression operand2) {
        if (returnStatement == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(3);
        }
        if (condition2 == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(4);
        }
        if (operand2 == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(5);
        }
        PsiExpression lOperands = SplitConditionUtil.getLOperands(condition2, condition2.getTokenBeforeOperand(operand2));
        PsiExpression rOperands = EnsureCodeBlockImpl.getRightOperands(condition2, operand2);
        Project project = returnStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CommentTracker ct = new CommentTracker();
        boolean orChain = condition2.getOperationTokenType().equals(JavaTokenType.OROR);
        String ifText = "if(" + (orChain ? ct.text((PsiElement)lOperands) : BoolUtils.getNegatedExpressionText(lOperands, ct)) + ") return " + orChain + ";";
        PsiStatement ifStatement = factory.createStatementFromText(ifText, (PsiElement)returnStatement);
        CodeStyleManager.getInstance((Project)project).reformat(returnStatement.getParent().addBefore((PsiElement)ifStatement, (PsiElement)returnStatement));
        return ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(returnStatement.getReturnValue()), (PsiElement)rOperands);
    }

    @NotNull
    private static PsiElement extractFieldInitializer(PsiField field, PsiField copy) {
        PsiType fieldType;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)field.getProject());
        PsiClassInitializer initializer = (PsiClassInitializer)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)field), PsiClassInitializer.class);
        boolean isStatic = field.hasModifierProperty("static");
        if (initializer == null || initializer.hasModifierProperty("static") != isStatic) {
            initializer = factory.createClassInitializer();
            if (isStatic) {
                Objects.requireNonNull(initializer.getModifierList()).setModifierProperty("static", true);
            }
            initializer = (PsiClassInitializer)field.getParent().addAfter((PsiElement)initializer, (PsiElement)field);
        }
        PsiCodeBlock body2 = initializer.getBody();
        PsiElement anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)body2.getFirstChild());
        assert (anchor != null);
        anchor = anchor.getPrevSibling();
        assert (anchor != null);
        PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + "=null;", (PsiElement)initializer);
        assignment = (PsiExpressionStatement)body2.addAfter((PsiElement)assignment, anchor);
        PsiExpression fieldInitializer = copy.getInitializer();
        if (fieldInitializer instanceof PsiArrayInitializerExpression && (fieldType = field.getType()) instanceof PsiArrayType) {
            fieldInitializer = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)fieldInitializer, fieldType);
        }
        PsiExpression rExpression = ((PsiAssignmentExpression)assignment.getExpression()).getRExpression();
        assert (fieldInitializer != null);
        assert (rExpression != null);
        rExpression.replace((PsiElement)fieldInitializer);
        Objects.requireNonNull(field.getInitializer()).delete();
        PsiExpressionStatement psiExpressionStatement = assignment;
        if (psiExpressionStatement == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(6);
        }
        return psiExpressionStatement;
    }

    private static PsiElement extractWhileCondition(PsiWhileStatement whileStatement, PsiPolyadicExpression condition2, PsiExpression operand2) {
        PsiExpression rOperands;
        PsiExpression lOperands;
        PsiBlockStatement blockBody;
        PsiExpression oldCondition = Objects.requireNonNull(whileStatement.getCondition());
        PsiStatement body2 = whileStatement.getBody();
        Project project = whileStatement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (body2 == null) {
            PsiWhileStatement newWhileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", (PsiElement)whileStatement);
            Objects.requireNonNull(newWhileStatement.getCondition()).replace((PsiElement)oldCondition);
            whileStatement = (PsiWhileStatement)whileStatement.replace((PsiElement)newWhileStatement);
            blockBody = (PsiBlockStatement)Objects.requireNonNull(whileStatement.getBody());
            oldCondition = Objects.requireNonNull(whileStatement.getCondition());
        } else if (body2 instanceof PsiBlockStatement) {
            blockBody = (PsiBlockStatement)body2;
        } else {
            PsiBlockStatement newBody = BlockUtils.createBlockStatement(project);
            newBody.add((PsiElement)body2);
            blockBody = (PsiBlockStatement)body2.replace((PsiElement)newBody);
        }
        if (condition2 != null && condition2.getOperationTokenType().equals(JavaTokenType.ANDAND)) {
            lOperands = SplitConditionUtil.getLOperands(condition2, condition2.getTokenBeforeOperand(operand2));
            rOperands = EnsureCodeBlockImpl.getRightOperands(condition2, operand2);
        } else {
            lOperands = factory.createExpressionFromText("true", (PsiElement)whileStatement);
            rOperands = oldCondition;
        }
        PsiCodeBlock codeBlock = blockBody.getCodeBlock();
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(!true) break;", (PsiElement)whileStatement);
        ifStatement = (PsiIfStatement)codeBlock.addAfter((PsiElement)ifStatement, (PsiElement)codeBlock.getLBrace());
        PsiPrefixExpression negation = (PsiPrefixExpression)Objects.requireNonNull(ifStatement.getCondition());
        PsiElement newParent = Objects.requireNonNull(negation.getOperand()).replace((PsiElement)rOperands);
        Objects.requireNonNull(whileStatement.getCondition()).replace((PsiElement)lOperands);
        return newParent;
    }

    private static PsiElement replaceTernaryWithIf(PsiStatement statement, PsiConditionalExpression ternary) {
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ternary.getParent());
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)parent;
            variable.normalizeDeclaration();
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)variable.getParent();
            PsiAssignmentExpression assignment = SplitDeclarationAction.invokeOnDeclarationStatement(declaration2, PsiManager.getInstance((Project)project), project);
            if (assignment != null) {
                ternary = (PsiConditionalExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()));
                statement = (PsiStatement)assignment.getParent();
            }
        }
        CommentTracker ct = new CommentTracker();
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(" + ct.text((PsiElement)ternary.getCondition()) + ") {} else {}", (PsiElement)statement);
        Object mark = new Object();
        PsiTreeUtil.mark((PsiElement)ternary, (Object)mark);
        for (PsiElement child : statement.getChildren()) {
            if (!(child instanceof PsiComment)) continue;
            ct.delete(child);
        }
        PsiStatement thenStatement = (PsiStatement)statement.copy();
        PsiConditionalExpression thenTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)thenStatement, (Object)mark));
        PsiExpression thenBranch = ternary.getThenExpression();
        if (thenBranch != null) {
            thenTernary.replace((PsiElement)ct.markUnchanged(thenBranch));
        }
        PsiStatement elseStatement = (PsiStatement)statement.copy();
        PsiConditionalExpression elseTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)elseStatement, (Object)mark));
        PsiExpression elseBranch = ternary.getElseExpression();
        if (elseBranch != null) {
            elseTernary.replace((PsiElement)ct.markUnchanged(elseBranch));
        }
        ((PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch())).getCodeBlock().add((PsiElement)thenStatement);
        ((PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch())).getCodeBlock().add((PsiElement)elseStatement);
        return ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)ifStatement);
    }

    private static PsiElement splitIf(PsiIfStatement outerIf, PsiPolyadicExpression andChain, PsiExpression operand2) {
        PsiExpression lOperands = SplitConditionUtil.getLOperands(andChain, andChain.getTokenBeforeOperand(operand2));
        PsiExpression rOperands = EnsureCodeBlockImpl.getRightOperands(andChain, operand2);
        Project project = outerIf.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiBlockStatement newThenBranch = (PsiBlockStatement)factory.createStatementFromText("{if(true);}", (PsiElement)outerIf);
        PsiStatement thenBranch = Objects.requireNonNull(outerIf.getThenBranch());
        Objects.requireNonNull(((PsiIfStatement)newThenBranch.getCodeBlock().getStatements()[0]).getThenBranch()).replace((PsiElement)thenBranch);
        newThenBranch = (PsiBlockStatement)thenBranch.replace((PsiElement)newThenBranch);
        PsiIfStatement innerIf = (PsiIfStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newThenBranch.getCodeBlock().getStatements()[0]);
        PsiElement newParent = Objects.requireNonNull(innerIf.getCondition()).replace((PsiElement)rOperands);
        andChain.replace((PsiElement)lOperands);
        return newParent;
    }

    private static PsiExpression getRightOperands(PsiPolyadicExpression andChain, PsiExpression operand2) {
        PsiExpression rOperands;
        if (operand2 == ArrayUtil.getLastElement((Object[])andChain.getOperands())) {
            rOperands = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2);
        } else {
            rOperands = SplitConditionUtil.getROperands(andChain, andChain.getTokenBeforeOperand(operand2));
            ((PsiPolyadicExpression)rOperands).getOperands()[0].replace((PsiElement)operand2);
        }
        return rOperands;
    }

    @Nullable
    private static PsiPolyadicExpression findSurroundingConditionChain(@NotNull PsiExpression expression2) {
        PsiPolyadicExpression polyadicExpression;
        if (expression2 == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(7);
        }
        PsiExpression current = expression2;
        do {
            polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)current, PsiPolyadicExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
            current = polyadicExpression;
        } while (polyadicExpression != null && (polyadicExpression.getOperationTokenType() != JavaTokenType.ANDAND && polyadicExpression.getOperationTokenType() != JavaTokenType.OROR || PsiTreeUtil.isAncestor((PsiElement)polyadicExpression.getOperands()[0], (PsiElement)expression2, (boolean)false)));
        return polyadicExpression;
    }

    @Nullable
    private static PsiConditionalExpression findSurroundingTernary(@NotNull PsiExpression expression2) {
        PsiConditionalExpression ternary;
        if (expression2 == null) {
            EnsureCodeBlockImpl.$$$reportNull$$$0(8);
        }
        PsiExpression current = expression2;
        do {
            ternary = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)current, PsiConditionalExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
            current = ternary;
        } while (ternary != null && PsiTreeUtil.isAncestor((PsiElement)ternary.getCondition(), (PsiElement)expression2, (boolean)false));
        return ternary;
    }

    private static boolean hasNameCollision(PsiElement declaration2, PsiElement context) {
        if (declaration2 instanceof PsiDeclarationStatement) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            return StreamEx.of((Object[])((PsiDeclarationStatement)declaration2).getDeclaredElements()).select(PsiLocalVariable.class).map(PomNamedTarget::getName).nonNull().anyMatch(name2 -> helper.resolveReferencedVariable(name2, context) != null);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/EnsureCodeBlockImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/EnsureCodeBlockImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFieldInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureCodeBlock";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitReturn";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSurroundingConditionChain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSurroundingTernary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

