/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.ui.DuplicateNodeRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MigrationNode
extends AbstractTreeNode<TypeMigrationUsageInfo>
implements DuplicateNodeRenderer.DuplicatableNode<MigrationNode> {
    private final TypeMigrationUsageInfo myInfo;
    private MigrationNode myDuplicatedNode;
    private List<MigrationNode> myCachedChildren;
    private final TypeMigrationLabeler myLabeler;
    private final PsiType myMigrationType;
    private final HashMap<TypeMigrationUsageInfo, Set<MigrationNode>> myProcessed;
    private final HashSet<? extends TypeMigrationUsageInfo> myParents;

    public MigrationNode(Project project, TypeMigrationUsageInfo info, PsiType migrationType, TypeMigrationLabeler labeler, HashSet<? extends TypeMigrationUsageInfo> parents, HashMap<TypeMigrationUsageInfo, Set<MigrationNode>> processed) {
        super(project, (Object)info);
        this.myLabeler = labeler;
        this.myMigrationType = migrationType;
        this.myProcessed = processed;
        this.myParents = parents;
        Set<MigrationNode> alreadyAdded = this.myProcessed.get((Object)info);
        if (alreadyAdded == null) {
            alreadyAdded = new HashSet<MigrationNode>();
            this.myProcessed.put(info, alreadyAdded);
            this.myInfo = info;
        } else {
            MigrationNode duplicate = alreadyAdded.iterator().next();
            this.myInfo = duplicate.getInfo();
            this.myDuplicatedNode = duplicate;
        }
        alreadyAdded.add(this);
    }

    public TypeMigrationUsageInfo getInfo() {
        return this.myInfo;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myCachedChildren == null) {
            this.myCachedChildren = new ArrayList<MigrationNode>();
            PsiElement element = this.myInfo.getElement();
            if (element != null) {
                try {
                    this.myLabeler.setRootAndMigrate(this.myInfo, this.myMigrationType, this.myLabeler.markRootUsages(element, this.myMigrationType));
                }
                catch (TypeMigrationLabeler.MigrateException migrateException) {
                    // empty catch block
                }
                HashSet<Pair<TypeMigrationUsageInfo, PsiType>> roots = this.myLabeler.getRootsTree().get((Object)this.myInfo);
                if (roots != null) {
                    for (Pair<TypeMigrationUsageInfo, PsiType> root : roots) {
                        TypeMigrationUsageInfo info = (TypeMigrationUsageInfo)((Object)root.getFirst());
                        if (this.myParents.contains((Object)info)) continue;
                        HashSet<? extends TypeMigrationUsageInfo> parents = new HashSet<TypeMigrationUsageInfo>(this.myParents);
                        parents.add(info);
                        MigrationNode migrationNode = new MigrationNode(this.getProject(), info, (PsiType)root.getSecond(), this.myLabeler, parents, this.myProcessed);
                        if (this.myInfo.isExcluded()) {
                            info.setExcluded(true);
                        }
                        this.myCachedChildren.add(migrationNode);
                    }
                }
            }
        }
        List<MigrationNode> list = this.myCachedChildren;
        if (list == null) {
            MigrationNode.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean areChildrenInitialized() {
        return this.myCachedChildren != null;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            MigrationNode.$$$reportNull$$$0(1);
        }
    }

    public MigrationNode getDuplicate() {
        return this.myDuplicatedNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/ui/MigrationNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/ui/MigrationNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

