/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaFluentIterableConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaOptionalConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaOptionalConversionRule
extends BaseGuavaTypeConversionRule {
    private static final Logger LOG = Logger.getInstance(GuavaOptionalConversionRule.class);
    public static final String OPTIONAL_CONVERTOR_PATTERN = "Optional.fromNullable($o$.orElse(null))";
    public static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    public static final String JAVA_OPTIONAL = "java.util.Optional";

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(@Nullable PsiType from, @Nullable PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (method == null) {
            GuavaOptionalConversionRule.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            GuavaOptionalConversionRule.$$$reportNull$$$0(1);
        }
        if (!(context instanceof PsiMethodCallExpression)) {
            if ("or".equals(methodName)) {
                PsiMethodCallExpression methodCallExpression = null;
                if (context.getParent() instanceof PsiMethodCallExpression) {
                    methodCallExpression = (PsiMethodCallExpression)context.getParent();
                }
                if (methodCallExpression == null) {
                    return null;
                }
                PsiClass aClass = GuavaOptionalConversionRule.getParameterClass(method);
                if (aClass != null) {
                    String qName = aClass.getQualifiedName();
                    if (GUAVA_OPTIONAL.equals(qName)) {
                        TypeConversionDescriptor descriptor = new TypeConversionDescriptor(null, "java.util.Optional.ofNullable($val$.orElseGet($o$::get))"){

                            @Override
                            public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                                if (evaluator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                this.setStringToReplace("$val$.or(" + GuavaOptionalConversionUtil.simplifyParameterPattern((PsiMethodCallExpression)expression2) + ")");
                                return super.replace(expression2, evaluator);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaOptionalConversionRule$1", "replace"));
                            }
                        };
                        if (to != null) {
                            descriptor.withConversionType(to);
                        }
                        return descriptor;
                    }
                    return GuavaLambda.SUPPLIER.getClassQName().equals(qName) ? new GuavaTypeConversionDescriptor("$val$.or($other$)", "$val$.orElseGet($other$)", context) : new TypeConversionDescriptor("$val$.or($other$)", "$val$.orElse($other$)");
                }
                return null;
            }
            if ("transform".equals(methodName)) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)context.getParent();
                PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
                if (arguments.length != 1) {
                    return null;
                }
                PsiExpression functionArgument = arguments[0];
                GuavaTypeConversionDescriptor descriptor = new GuavaTypeConversionDescriptor("$val$.transform($fun$)", "$val$.map($fun$)", context);
                PsiType typeParameter = GuavaConversionUtil.getFunctionReturnType(functionArgument);
                if (typeParameter == null) {
                    return descriptor;
                }
                String rawOptionalType = "java.util.Optional<" + typeParameter.getCanonicalText(false) + ">";
                return descriptor.withConversionType(JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(rawOptionalType, (PsiElement)context));
            }
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !"com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName()) && !GUAVA_OPTIONAL.equals(aClass.getQualifiedName())) {
            return null;
        }
        return GuavaFluentIterableConversionRule.buildCompoundDescriptor((PsiMethodCallExpression)context, to, labeler);
    }

    @Override
    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return super.isValidMethodQualifierToConvert(aClass) || aClass != null && "com.google.common.collect.FluentIterable".equals(aClass.getQualifiedName());
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@Nullable PsiExpression context) {
        if (GuavaOptionalConversionUtil.isOptionalOrContext(context)) {
            return new TypeConversionDescriptor("$o$", "com.google.common.base.Optional.fromNullable($o$.orElse(null))");
        }
        return new TypeConversionDescriptor("$o$", "$o$::get");
    }

    private static PsiClass getParameterClass(PsiMethod method) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        return PsiTypesUtil.getPsiClass((PsiType)parameters2[0].getType());
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put("absent", new TypeConversionDescriptor("'_Optional?.absent()", "java.util.Optional.empty()"){

            @Override
            public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                if (evaluator == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.assertTrue(expression2 instanceof PsiMethodCallExpression);
                PsiReferenceParameterList typeArguments = ((PsiMethodCallExpression)expression2).getTypeArgumentList();
                PsiReferenceParameterList typeArgumentsCopy = typeArguments.getTypeArguments().length == 0 ? null : (PsiReferenceParameterList)typeArguments.copy();
                PsiMethodCallExpression replacedExpression = (PsiMethodCallExpression)super.replace(expression2, evaluator);
                if (typeArgumentsCopy != null) {
                    replacedExpression.getTypeArgumentList().replace((PsiElement)typeArgumentsCopy);
                }
                return replacedExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaOptionalConversionRule$2", "replace"));
            }
        });
        descriptorsMap.put("of", new TypeConversionDescriptor("'_Optional?.of($ref$)", "java.util.Optional.of($ref$)"));
        descriptorsMap.put("fromNullable", new TypeConversionDescriptor("'_Optional?.fromNullable($ref$)", "java.util.Optional.ofNullable($ref$)"));
        descriptorsMap.put("presentInstances", new TypeConversionDescriptor("'_Optional?.presentInstances($it$)", "java.util.stream.StreamSupport.stream($it$.spliterator(), false).map(java.util.Optional::get).collect(java.util.Collectors.toList())"));
        TypeConversionDescriptorBase identity = new TypeConversionDescriptorBase();
        descriptorsMap.put("get", identity);
        descriptorsMap.put("isPresent", identity);
        descriptorsMap.put("orNull", new TypeConversionDescriptor("$val$.orNull()", "$val$.orElse(null)"));
        descriptorsMap.put("asSet", new TypeConversionDescriptor("$val$.asSet()", "$val$.map(java.util.Collections::singleton).orElse(java.util.Collections.emptySet())"));
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        if (GUAVA_OPTIONAL == null) {
            GuavaOptionalConversionRule.$$$reportNull$$$0(2);
        }
        return GUAVA_OPTIONAL;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        if (JAVA_OPTIONAL == null) {
            GuavaOptionalConversionRule.$$$reportNull$$$0(3);
        }
        return JAVA_OPTIONAL;
    }

    @Override
    protected TypeConversionDescriptorBase getUnknownMethodConversion() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaOptionalConversionRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaOptionalConversionRule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ruleFromClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ruleToClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForMethod";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

