/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Nullable;

enum AtomicConversionType {
    ATOMIC_INTEGER{

        @Override
        protected boolean accept(PsiType from, PsiClassType to, PsiExpression context) {
            return PsiType.INT.isAssignableFrom(from) && to.getCanonicalText().equals(AtomicInteger.class.getName());
        }

        @Override
        protected boolean checkDefaultValue(PsiExpression expr) {
            return Objects.equals(JavaConstantExpressionEvaluator.computeConstantExpression(expr, false), 0);
        }
    }
    ,
    ATOMIC_LONG{

        @Override
        protected boolean accept(PsiType from, PsiClassType to, PsiExpression context) {
            return PsiType.LONG.isAssignableFrom(from) && to.getCanonicalText().equals(AtomicLong.class.getName());
        }

        @Override
        protected boolean checkDefaultValue(PsiExpression expr) {
            return Objects.equals(JavaConstantExpressionEvaluator.computeConstantExpression(expr, false), 0);
        }
    }
    ,
    ATOMIC_BOOLEAN{

        @Override
        protected boolean accept(PsiType from, PsiClassType to, PsiExpression context) {
            return PsiType.BOOLEAN.equals((Object)from) && to.getCanonicalText().equals(AtomicBoolean.class.getName());
        }

        @Override
        protected boolean checkDefaultValue(PsiExpression expr) {
            return false;
        }
    }
    ,
    ATOMIC_REFERENCE_OR_ARRAY{

        @Override
        protected boolean accept(PsiType from, PsiClassType to, PsiExpression context) {
            if (from.equals(PsiType.INT.createArrayType()) && to.getCanonicalText().equals(AtomicIntegerArray.class.getName())) {
                return true;
            }
            if (from.equals(PsiType.LONG.createArrayType()) && to.getCanonicalText().equals(AtomicLongArray.class.getName())) {
                return true;
            }
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
            PsiClass atomicClass = resolveResult.getElement();
            if (atomicClass != null) {
                String typeQualifiedName = atomicClass.getQualifiedName();
                if (!Comparing.strEqual((String)typeQualifiedName, (String)AtomicReference.class.getName()) && !Comparing.strEqual((String)typeQualifiedName, (String)AtomicReferenceArray.class.getName())) {
                    return false;
                }
                PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
                if (typeParameters.length != 1) {
                    return false;
                }
                PsiType toTypeParameterValue = resolveResult.getSubstitutor().substitute(typeParameters[0]);
                if (toTypeParameterValue != null) {
                    if (from.getDeepComponentType() instanceof PsiPrimitiveType) {
                        PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)toTypeParameterValue);
                        if (unboxedInitialType != null) {
                            return TypeConversionUtil.areTypesConvertible((PsiType)from.getDeepComponentType(), (PsiType)unboxedInitialType);
                        }
                    } else {
                        return TypeConversionUtil.isAssignable((PsiType)from.getDeepComponentType(), (PsiType)PsiUtil.captureToplevelWildcards((PsiType)toTypeParameterValue, (PsiElement)context));
                    }
                }
            }
            return false;
        }

        @Override
        protected boolean checkDefaultValue(PsiExpression expr) {
            return PsiType.NULL.equals((Object)expr.getType());
        }
    };


    protected abstract boolean accept(PsiType var1, PsiClassType var2, PsiExpression var3);

    protected abstract boolean checkDefaultValue(PsiExpression var1);

    @Nullable
    static AtomicConversionType getConversionType(PsiType from, PsiClassType to, PsiExpression context) {
        return Arrays.stream(AtomicConversionType.values()).filter(type2 -> type2.accept(from, to, context)).findFirst().orElse(null);
    }
}

