/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.inspections;

import com.intellij.codeInsight.intention.impl.AddOnDemandStaticImportAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrateAssertToMatcherAssertInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(MigrateAssertToMatcherAssertInspection.class);
    private static final Map<String, Pair<String, String>> ASSERT_METHODS = new HashMap<String, Pair<String, String>>();
    private static final String CORE_MATCHERS_CLASS_NAME = "org.hamcrest.CoreMatchers";
    private static final String MATCHERS_CLASS_NAME = "org.hamcrest.Matchers";
    public boolean myStaticallyImportMatchers = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Statically import matcher's methods", (InspectionProfileEntry)this, "myStaticallyImportMatchers");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MigrateAssertToMatcherAssertInspection.$$$reportNull$$$0(0);
        }
        GlobalSearchScope resolveScope = holder.getFile().getResolveScope();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)holder.getProject());
        PsiClass coreMatchersClass = javaPsiFacade.findClass(CORE_MATCHERS_CLASS_NAME, resolveScope);
        final PsiClass matchersClass = javaPsiFacade.findClass(MATCHERS_CLASS_NAME, resolveScope);
        if (coreMatchersClass == null && matchersClass == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                MigrateAssertToMatcherAssertInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass assertClass;
                String methodName = expression2.getMethodExpression().getReferenceName();
                if (!ASSERT_METHODS.containsKey(methodName)) {
                    return;
                }
                PsiMethod assertMethod = expression2.resolveMethod();
                if (assertMethod == null || (assertClass = assertMethod.getContainingClass()) == null) {
                    return;
                }
                if (!"junit.framework.Assert".equals(assertClass.getQualifiedName()) && !"org.junit.Assert".equals(assertClass.getQualifiedName())) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2.getMethodExpression(), "Assert expression <code>#ref</code> can be replaced with 'assertThat' call #loc", new LocalQuickFix[]{new MyQuickFix(matchersClass != null ? MigrateAssertToMatcherAssertInspection.MATCHERS_CLASS_NAME : MigrateAssertToMatcherAssertInspection.CORE_MATCHERS_CLASS_NAME)});
            }
        };
        if (javaElementVisitor == null) {
            MigrateAssertToMatcherAssertInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static IElementType negate(IElementType tokenType) {
        if (JavaTokenType.GT.equals(tokenType)) {
            return JavaTokenType.LE;
        }
        if (JavaTokenType.LT.equals(tokenType)) {
            return JavaTokenType.GE;
        }
        if (JavaTokenType.GE.equals(tokenType)) {
            return JavaTokenType.LT;
        }
        if (JavaTokenType.LE.equals(tokenType)) {
            return JavaTokenType.GT;
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> getSuitableMatcherForMethodCallInsideBooleanAssert(PsiMethodCallExpression expression2, boolean negate) {
        PsiMethod method;
        String methodName = expression2.getMethodExpression().getReferenceName();
        String fromTemplate = null;
        String toLeftPart = null;
        String toRightPart = null;
        if ("contains".equals(methodName)) {
            PsiClass containingClass;
            PsiMethod method2 = expression2.resolveMethod();
            if (method2 != null && (containingClass = method2.getContainingClass()) != null) {
                if ("java.lang.String".equals(containingClass.getQualifiedName())) {
                    fromTemplate = "$str$.contains($sub$)";
                    toLeftPart = "$str$, ";
                    toRightPart = "{0}.containsString($sub$)";
                } else if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) {
                    fromTemplate = "$collection$.contains($element$)";
                    toLeftPart = "$collection$, ";
                    toRightPart = "{0}.hasItem($element$)";
                }
            }
        } else if ("equals".equals(methodName) && (method = expression2.resolveMethod()) != null && MigrateAssertToMatcherAssertInspection.isUniqueObjectParameter(method.getParameterList())) {
            fromTemplate = "$left$.equals($right$)";
            toLeftPart = "$left$, ";
            toRightPart = "{0}.is($right$)";
        }
        if (fromTemplate == null) {
            return null;
        }
        if (negate) {
            toRightPart = "{0}.not(" + toRightPart + ")";
        }
        return Pair.create((Object)fromTemplate, (Object)(toLeftPart + toRightPart));
    }

    private static boolean isUniqueObjectParameter(PsiParameterList parameters2) {
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter2 = parameters2.getParameters()[0];
        PsiClass parameterClass = PsiTypesUtil.getPsiClass((PsiType)parameter2.getType());
        return parameterClass != null && "java.lang.Object".equals(parameterClass.getQualifiedName());
    }

    private static boolean hasMessage(PsiMethod method) {
        PsiParameter maybeMessage = method.getParameterList().getParameters()[0];
        PsiClass maybeString = PsiTypesUtil.getPsiClass((PsiType)maybeMessage.getType());
        return maybeString != null && "java.lang.String".equals(maybeString.getQualifiedName());
    }

    static {
        ASSERT_METHODS.put("assertArrayEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, {0}.is($expected$)"));
        ASSERT_METHODS.put("assertEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, {0}.is($expected$)"));
        ASSERT_METHODS.put("assertNotEquals", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, {0}.not({0}.is($expected$))"));
        ASSERT_METHODS.put("assertSame", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, {0}.sameInstance($expected$)"));
        ASSERT_METHODS.put("assertNotSame", (Pair<String, String>)Pair.create((Object)"$expected$, $actual$", (Object)"$actual$, {0}.not({0}.sameInstance($expected$))"));
        ASSERT_METHODS.put("assertNotNull", (Pair<String, String>)Pair.create((Object)"$obj$", (Object)"$obj$, {0}.notNullValue()"));
        ASSERT_METHODS.put("assertNull", (Pair<String, String>)Pair.create((Object)"$obj$", (Object)"$obj$, {0}.nullValue()"));
        ASSERT_METHODS.put("assertTrue", (Pair<String, String>)Pair.create((Object)"$cond$", (Object)"$cond$, {0}.is(true)"));
        ASSERT_METHODS.put("assertFalse", (Pair<String, String>)Pair.create((Object)"$cond$", (Object)"$cond$, {0}.is(false)"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/inspections/MigrateAssertToMatcherAssertInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/inspections/MigrateAssertToMatcherAssertInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private static final String ORDERING_COMPARISON_NAME = "org.hamcrest.number.OrderingComparison";
        private final String myMatchersClassName;

        public MyQuickFix(String name2) {
            this.myMatchersClassName = name2;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = "Replace with '" + StringUtil.getShortName((String)this.myMatchersClassName) + ".assertThat'";
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression replaced;
            PsiElement element;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid() || !(element.getParent() instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element.getParent();
            PsiMethod method = methodCall.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            Pair templatePair = null;
            if ("assertFalse".equals(methodName) || "assertTrue".equals(methodName)) {
                PsiExpression[] expressions2 = methodCall.getArgumentList().getExpressions();
                PsiExpression conditionExpression = expressions2[expressions2.length - 1];
                boolean negate = methodName.contains("False");
                if (conditionExpression instanceof PsiBinaryExpression) {
                    templatePair = this.getSuitableMatcherForBinaryExpressionInsideBooleanAssert((PsiBinaryExpression)conditionExpression, negate);
                } else if (conditionExpression instanceof PsiMethodCallExpression) {
                    templatePair = MigrateAssertToMatcherAssertInspection.getSuitableMatcherForMethodCallInsideBooleanAssert((PsiMethodCallExpression)conditionExpression, negate);
                }
            }
            if (templatePair == null) {
                templatePair = (Pair)ASSERT_METHODS.get(methodName);
            }
            LOG.assertTrue(templatePair != null);
            templatePair = this.buildFullTemplate((Pair<String, String>)templatePair, method);
            try {
                replaced = TypeConversionDescriptor.replaceExpression((PsiExpression)methodCall, (String)templatePair.getFirst(), MessageFormat.format((String)templatePair.getSecond(), this.myMatchersClassName));
            }
            catch (IncorrectOperationException e) {
                LOG.error("Replacer can't match expression:\n" + methodCall.getText() + "\nwith replacement template:\n(" + (String)templatePair.getFirst() + ", " + (String)templatePair.getSecond() + ")");
                throw e;
            }
            if (MigrateAssertToMatcherAssertInspection.this.myStaticallyImportMatchers) {
                for (PsiJavaCodeReferenceElement ref : ContainerUtil.reverse(new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)replaced, PsiJavaCodeReferenceElement.class)))) {
                    PsiIdentifier identifier;
                    String qName;
                    PsiElement resolvedElement;
                    if (!ref.isValid() || !((resolvedElement = ref.resolve()) instanceof PsiClass) || (qName = ((PsiClass)resolvedElement).getQualifiedName()) == null || !qName.startsWith("org.hamcrest") || (identifier = (PsiIdentifier)PsiTreeUtil.getChildOfType((PsiElement)ref, PsiIdentifier.class)) == null) continue;
                    AddOnDemandStaticImportAction.invoke(project, replaced.getContainingFile(), null, (PsiElement)identifier);
                }
            }
        }

        private Pair<String, String> buildFullTemplate(Pair<String, String> templatePair, PsiMethod method) {
            if (templatePair == null) {
                return null;
            }
            boolean hasMessage = MigrateAssertToMatcherAssertInspection.hasMessage(method);
            String searchTemplate = "'_Assert?." + method.getName() + "(" + (hasMessage ? "$msg$, " : "") + (String)templatePair.getFirst() + ")";
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null);
            String qualifier = containingClass.getQualifiedName();
            LOG.assertTrue(qualifier != null);
            String replaceTemplate = qualifier + ".assertThat(" + (hasMessage ? "$msg$, " : "") + (String)templatePair.getSecond() + ")";
            return Pair.create((Object)searchTemplate, (Object)replaceTemplate);
        }

        @Nullable
        private Pair<String, String> getSuitableMatcherForBinaryExpressionInsideBooleanAssert(PsiBinaryExpression expression2, boolean negate) {
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (negate) {
                tokenType = MigrateAssertToMatcherAssertInspection.negate(tokenType);
            }
            String fromTemplate = "$left$ " + sign.getText() + "  $right$";
            if (JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.NE.equals(tokenType)) {
                String rightPartOfAfterTemplate;
                boolean isEqEqForPrimitives = true;
                for (PsiExpression operand2 : Arrays.asList(expression2.getLOperand(), expression2.getROperand())) {
                    if (operand2.getType() instanceof PsiPrimitiveType) continue;
                    isEqEqForPrimitives = false;
                    break;
                }
                String string = rightPartOfAfterTemplate = isEqEqForPrimitives ? "{0}.is($right$)" : "{0}.sameInstance($right$)";
                if (JavaTokenType.NE.equals(tokenType)) {
                    rightPartOfAfterTemplate = "{0}.not(" + rightPartOfAfterTemplate + ")";
                }
                return Pair.create((Object)fromTemplate, (Object)("$left$, " + rightPartOfAfterTemplate));
            }
            String replaceTemplate = null;
            if (JavaTokenType.GT.equals(tokenType)) {
                replaceTemplate = "greaterThan($right$)";
            } else if (JavaTokenType.LT.equals(tokenType)) {
                replaceTemplate = "lessThan($right$)";
            } else if (JavaTokenType.GE.equals(tokenType)) {
                replaceTemplate = "greaterThanOrEqualTo($right$)";
            } else if (JavaTokenType.LE.equals(tokenType)) {
                replaceTemplate = "lessThanOrEqualTo($right$)";
            }
            if (replaceTemplate == null) {
                return null;
            }
            replaceTemplate = "org.hamcrest.number.OrderingComparison." + replaceTemplate;
            return Pair.create((Object)fromTemplate, (Object)("$left$, " + replaceTemplate));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/inspections/MigrateAssertToMatcherAssertInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/inspections/MigrateAssertToMatcherAssertInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

