/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.replaceConstructorWithBuilder.ParameterData;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderViewDescriptor;
import com.intellij.refactoring.replaceConstructorWithBuilder.usageInfo.ReplaceConstructorWithSettersChainInfo;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderProcessor
extends FixableUsagesRefactoringProcessor {
    public static final String REFACTORING_NAME = "Replace Constructor with Builder";
    private final PsiMethod[] myConstructors;
    private final Map<String, ParameterData> myParametersMap;
    @NotNull
    private final String myClassName;
    private final String myPackageName;
    private final boolean myCreateNewBuilderClass;
    private final PsiElementFactory myElementFactory;
    private final MoveDestination myMoveDestination;

    public ReplaceConstructorWithBuilderProcessor(Project project, PsiMethod[] constructors, Map<String, ParameterData> parametersMap, @NotNull String className2, String packageName, MoveDestination moveDestination, boolean createNewBuilderClass) {
        if (className2 == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myMoveDestination = moveDestination;
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        this.myConstructors = constructors;
        this.myParametersMap = parametersMap;
        this.myClassName = className2;
        this.myPackageName = packageName;
        this.myCreateNewBuilderClass = createNewBuilderClass;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(1);
        }
        ReplaceConstructorWithBuilderViewDescriptor replaceConstructorWithBuilderViewDescriptor = new ReplaceConstructorWithBuilderViewDescriptor();
        if (replaceConstructorWithBuilderViewDescriptor == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(2);
        }
        return replaceConstructorWithBuilderViewDescriptor;
    }

    protected void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(3);
        }
        String builderQualifiedName = StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName);
        PsiClass builderClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(builderQualifiedName, GlobalSearchScope.projectScope((Project)this.myProject));
        for (PsiMethod constructor : this.myConstructors) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)constructor)) {
                PsiElement element = reference.getElement();
                PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
                if (newExpression == null || PsiTreeUtil.isAncestor((PsiElement)builderClass, (PsiElement)element, (boolean)false)) continue;
                usages.add(new ReplaceConstructorWithSettersChainInfo(newExpression, StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), this.myParametersMap));
            }
        }
    }

    @Nullable
    private PsiClass createBuilderClass() {
        PsiDirectory directory;
        PsiClass psiClass = this.myConstructors[0].getContainingClass();
        assert (psiClass != null);
        PsiTypeParameterList typeParameterList = psiClass.getTypeParameterList();
        String text2 = "public class " + this.myClassName + (typeParameterList != null ? typeParameterList.getText() : "") + "{}";
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.myClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)text2);
        PsiFile containingFile = this.myConstructors[0].getContainingFile();
        PsiDirectory containingDirectory = containingFile.getContainingDirectory();
        if (this.myMoveDestination != null) {
            directory = this.myMoveDestination.getTargetDirectory(containingDirectory);
        } else {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            assert (module != null);
            directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.myPackageName, containingDirectory, true, true);
        }
        if (directory != null) {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)this.myProject).getProject());
            PsiJavaFile reformattedFile = (PsiJavaFile)codeStyleManager.reformat(JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)newFile));
            if (directory.findFile(reformattedFile.getName()) != null) {
                return reformattedFile.getClasses()[0];
            }
            return ((PsiJavaFile)directory.add((PsiElement)reformattedFile)).getClasses()[0];
        }
        return null;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        PsiClass builderClass;
        if (usageInfos == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(4);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiClass psiClass = builderClass = this.myCreateNewBuilderClass ? this.createBuilderClass() : psiFacade.findClass(StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), GlobalSearchScope.projectScope((Project)this.myProject));
        if (builderClass == null) {
            return;
        }
        for (String propertyName : this.myParametersMap.keySet()) {
            ParameterData parameterData = this.myParametersMap.get(propertyName);
            PsiField field = this.createField(builderClass, parameterData);
            this.createSetter(builderClass, parameterData, field);
        }
        super.performRefactoring(usageInfos);
        PsiMethod method = this.createMethodSignature(this.createMethodName());
        if (builderClass.findMethodBySignature(method, false) == null) {
            builderClass.add((PsiElement)method);
        }
        PsiMethod constructor = this.getWorkingConstructor();
        VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)builderClass);
        for (PsiClass containingClass = constructor.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            VisibilityUtil.escalateVisibility((PsiMember)containingClass, (PsiElement)builderClass);
        }
    }

    private void createSetter(PsiClass builderClass, ParameterData parameterData, PsiField field) {
        PsiMethod setter = null;
        for (PsiMethod method : builderClass.getMethods()) {
            if (!Comparing.strEqual((String)method.getName(), (String)parameterData.getSetterName()) || method.getParameterList().getParametersCount() != 1 || !TypeConversionUtil.isAssignable((PsiType)method.getParameterList().getParameters()[0].getType(), (PsiType)parameterData.getType())) continue;
            setter = method;
            this.fixSetterReturnType(builderClass, field, setter);
            break;
        }
        if (setter == null) {
            setter = PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)builderClass, (boolean)true);
            PsiIdentifier nameIdentifier = setter.getNameIdentifier();
            assert (nameIdentifier != null);
            nameIdentifier.replace((PsiElement)this.myElementFactory.createIdentifier(parameterData.getSetterName()));
            setter.getParameterList().getParameters()[0].getTypeElement().replace((PsiElement)this.myElementFactory.createTypeElement(parameterData.getType()));
            builderClass.add((PsiElement)setter);
        }
    }

    private PsiField createField(PsiClass builderClass, ParameterData parameterData) {
        PsiExpression initializer;
        String defaultValue;
        PsiField field = builderClass.findFieldByName(parameterData.getFieldName(), false);
        if (field == null) {
            PsiType type2 = parameterData.getType();
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            field = this.myElementFactory.createField(parameterData.getFieldName(), type2);
            field = (PsiField)builderClass.add((PsiElement)field);
        }
        if ((defaultValue = parameterData.getDefaultValue()) != null && (initializer = field.getInitializer()) == null) {
            try {
                field.setInitializer(this.myElementFactory.createExpressionFromText(defaultValue, (PsiElement)field));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return field;
    }

    private void fixSetterReturnType(PsiClass builderClass, PsiField field, PsiMethod method) {
        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) != builderClass) {
            PsiCodeBlock body2 = method.getBody();
            PsiCodeBlock generatedBody = PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)builderClass, (boolean)true).getBody();
            assert (body2 != null);
            assert (generatedBody != null);
            body2.replace((PsiElement)generatedBody);
            PsiTypeElement typeElement = method.getReturnTypeElement();
            assert (typeElement != null);
            typeElement.replace((PsiElement)this.myElementFactory.createTypeElement((PsiType)this.myElementFactory.createType(builderClass)));
        }
    }

    private PsiMethod createMethodSignature(String createMethodName) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        StringBuilder buf = new StringBuilder();
        PsiMethod constructor = this.getWorkingConstructor();
        for (PsiParameter parameter2 : constructor.getParameterList().getParameters()) {
            String pureParamName = styleManager.variableNameToPropertyName(parameter2.getName(), VariableKind.PARAMETER);
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(this.myParametersMap.get(pureParamName).getFieldName());
        }
        return this.myElementFactory.createMethodFromText("public " + constructor.getName() + " " + createMethodName + "(){\n return new " + constructor.getName() + "(" + buf.toString() + ");\n}", (PsiElement)constructor);
    }

    private PsiMethod getWorkingConstructor() {
        PsiMethod constructor = this.getMostCommonConstructor();
        if (constructor == null && (constructor = this.myConstructors[0]).getParameterList().isEmpty()) {
            constructor = this.myConstructors[1];
        }
        return constructor;
    }

    @Nullable
    private PsiMethod getMostCommonConstructor() {
        if (this.myConstructors.length == 1) {
            return this.myConstructors[0];
        }
        PsiMethod commonConstructor = null;
        for (PsiMethod constructor : this.myConstructors) {
            PsiMethod chainedConstructor = RefactoringUtil.getChainedConstructor(constructor);
            if (chainedConstructor == null) {
                if (commonConstructor != null && !ReplaceConstructorWithBuilderProcessor.isChained(commonConstructor, constructor)) {
                    return null;
                }
                commonConstructor = constructor;
                continue;
            }
            if (commonConstructor == null) {
                commonConstructor = chainedConstructor;
                continue;
            }
            if (ReplaceConstructorWithBuilderProcessor.isChained(commonConstructor, chainedConstructor)) continue;
            return null;
        }
        return commonConstructor;
    }

    private static boolean isChained(PsiMethod first, PsiMethod last) {
        if (first == null) {
            return false;
        }
        if (first == last) {
            return true;
        }
        return ReplaceConstructorWithBuilderProcessor.isChained(RefactoringUtil.getChainedConstructor(first), last);
    }

    private String createMethodName() {
        return "create" + StringUtil.capitalize((String)this.myConstructors[0].getName());
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiMethod commonConstructor;
        if (refUsages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(5);
        }
        MultiMap conflicts = new MultiMap();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiClass builderClass = psiFacade.findClass(StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), GlobalSearchScope.projectScope((Project)this.myProject));
        if (builderClass == null) {
            if (!this.myCreateNewBuilderClass) {
                conflicts.putValue(null, (Object)"Selected class was not found.");
            }
        } else if (this.myCreateNewBuilderClass) {
            conflicts.putValue((Object)builderClass, (Object)"Class with chosen name already exist.");
        }
        if (this.myMoveDestination != null && this.myCreateNewBuilderClass) {
            this.myMoveDestination.analyzeModuleConflicts(Collections.emptyList(), conflicts, (UsageInfo[])refUsages.get());
        }
        if ((commonConstructor = this.getMostCommonConstructor()) == null) {
            conflicts.putValue(null, (Object)"Found constructors are not reducible to simple chain");
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    @NotNull
    protected String getCommandName() {
        if (REFACTORING_NAME == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(6);
        }
        return REFACTORING_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

