/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset;
        PsiElement element;
        PsiClass psiClass;
        if (project == null) {
            ReplaceConstructorWithBuilderHandler.$$$reportNull$$$0(0);
        }
        if ((psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(element = file.findElementAt(offset = editor.getCaretModel().getOffset()))) == null) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("The caret should be positioned inside a class which constructors are to be replaced with builder.", project, editor);
            return;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length == 0) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("Current class doesn't have constructors to replace with builder.", project, editor);
            return;
        }
        new ReplaceConstructorWithBuilderDialog(project, constructors).show();
    }

    @Nullable
    public static PsiClass getParentNamedClass(PsiElement element) {
        PsiElement resolve2;
        PsiElement parent;
        if (element != null && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && (resolve2 = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiClass) {
            return (PsiClass)resolve2;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass instanceof PsiAnonymousClass) {
            return ReplaceConstructorWithBuilderHandler.getParentNamedClass((PsiElement)psiClass);
        }
        return psiClass;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            ReplaceConstructorWithBuilderHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ReplaceConstructorWithBuilderHandler.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    private static void showErrorMessage(String message2, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)"Replace Constructor with Builder", (String)"refactoring.replaceConstructorWithBuilder");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

