/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiPackageProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenamePsiDirectoryProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PsiDirectory;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(2);
        }
        RenameWithOptionalReferencesDialog renameWithOptionalReferencesDialog = new RenameWithOptionalReferencesDialog(project, element, nameSuggestionContext, editor){

            protected boolean getSearchForReferences() {
                return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
            }

            protected void setSearchForReferences(boolean value2) {
                RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
            }
        };
        if (renameWithOptionalReferencesDialog == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(3);
        }
        return renameWithOptionalReferencesDialog;
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        PsiPackage psiPackage;
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(5);
        }
        if ((psiPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            return RenamePsiPackageProcessor.getPackageQualifiedNameAfterRename(psiPackage, newName, nonJava);
        }
        return newName;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(7);
        }
        if (!RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                RenamePsiDirectoryProcessor.$$$reportNull$$$0(8);
            }
            return list;
        }
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope).findAll();
        if (collection == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        PsiPackage aPackage;
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(10);
        }
        if ((aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            return aPackage;
        }
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        return "refactoring.renameDirectory";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(11);
        }
        if ((element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(12);
        }
        if ((element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(13);
        }
        if ((element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) == null) {
            return false;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiDirectoryProcessor.$$$reportNull$$$0(14);
        }
        if ((element = JavaDirectoryService.getInstance().getPackage((PsiDirectory)element)) != null) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiDirectoryProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

