/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.move.moveMembers.MoveMembersProcessor;
import com.intellij.refactoring.ui.JavaVisibilityPanel;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionTable;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.UsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMembersDialog
extends MoveDialogBase
implements MoveMembersOptions {
    private static final String RECENTS_KEY = "MoveMembersDialog.RECENTS_KEY";
    private final Project myProject;
    private final PsiClass mySourceClass;
    private final String mySourceClassName;
    private final List<MemberInfo> myMemberInfos;
    private final ReferenceEditorComboWithBrowseButton myTfTargetClassName;
    private final MoveCallback myMoveCallback;
    private MyMemberInfoModel myMemberInfoModel;
    private MemberSelectionTable myTable;
    private JavaVisibilityPanel myVisibilityPanel;
    private final JCheckBox myIntroduceEnumConstants = new JCheckBox(RefactoringBundle.message((String)"move.enum.constant.cb"), true);

    @Override
    protected String getMovePropertySuffix() {
        return "Member";
    }

    @Override
    protected String getCbTitle() {
        return "Open moved members in editor";
    }

    public MoveMembersDialog(Project project, PsiClass sourceClass, PsiClass initialTargetClass, Set<PsiMember> preselectMembers, MoveCallback moveCallback) {
        super(project, true);
        MemberInfo info;
        this.myProject = project;
        this.mySourceClass = sourceClass;
        this.myMoveCallback = moveCallback;
        this.setTitle(MoveMembersImpl.REFACTORING_NAME);
        this.mySourceClassName = this.mySourceClass.getQualifiedName();
        PsiField[] fields = this.mySourceClass.getFields();
        PsiMethod[] methods = this.mySourceClass.getMethods();
        PsiClass[] innerClasses = this.mySourceClass.getInnerClasses();
        ArrayList<MemberInfo> memberList = new ArrayList<MemberInfo>(fields.length + methods.length);
        for (PsiClass innerClass : innerClasses) {
            if (!innerClass.hasModifierProperty("static")) continue;
            MemberInfo memberInfo = new MemberInfo((PsiMember)innerClass);
            if (preselectMembers.contains(innerClass)) {
                memberInfo.setChecked(true);
            }
            memberList.add(memberInfo);
        }
        boolean hasConstantFields = false;
        for (PsiField psiField : fields) {
            if (!psiField.hasModifierProperty("static")) continue;
            info = new MemberInfo((PsiMember)psiField);
            if (preselectMembers.contains(psiField)) {
                info.setChecked(true);
            }
            memberList.add(info);
            hasConstantFields = true;
        }
        if (!hasConstantFields) {
            this.myIntroduceEnumConstants.setVisible(false);
        }
        for (PsiField psiField : methods) {
            if (!psiField.hasModifierProperty("static")) continue;
            info = new MemberInfo((PsiMember)psiField);
            if (preselectMembers.contains(psiField)) {
                info.setChecked(true);
            }
            memberList.add(info);
        }
        this.myMemberInfos = memberList;
        String fqName = initialTargetClass != null && !sourceClass.equals(initialTargetClass) ? initialTargetClass.getQualifiedName() : "";
        this.myTfTargetClassName = new ReferenceEditorComboWithBrowseButton(new ChooseClassAction(), fqName, this.myProject, true, JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE, RECENTS_KEY);
        this.init();
    }

    @Override
    @Nullable
    public String getMemberVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    @Override
    public boolean makeEnumConstant() {
        return this.myIntroduceEnumConstants.isVisible() && this.myIntroduceEnumConstants.isEnabled() && this.myIntroduceEnumConstants.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.move.moveMembers.MoveMembersDialog";
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        JTextField sourceClassField = new JTextField();
        sourceClassField.setText(this.mySourceClassName);
        sourceClassField.setEditable(false);
        _panel.add((Component)new JLabel(RefactoringBundle.message((String)"move.members.move.members.from.label")), "North");
        _panel.add((Component)sourceClassField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        _panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(RefactoringBundle.message((String)"move.members.to.fully.qualified.name.label"));
        label.setLabelFor((Component)((Object)this.myTfTargetClassName));
        _panel.add((Component)label, "North");
        _panel.add((Component)((Object)this.myTfTargetClassName), "Center");
        _panel.add((Component)this.myIntroduceEnumConstants, "South");
        box.add(_panel);
        ((EditorComboBox)this.myTfTargetClassName.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MoveMembersDialog.this.myMemberInfoModel.updateTargetClass();
                MoveMembersDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/move/moveMembers/MoveMembersDialog$1", "documentChanged"));
            }
        });
        panel.add((Component)box, "Center");
        panel.add(Box.createVerticalStrut(10), "South");
        this.validateButtons();
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String title = RefactoringBundle.message((String)"move.members.members.to.be.moved.border.title");
        MemberSelectionPanel selectionPanel = new MemberSelectionPanel(title, this.myMemberInfos, null);
        this.myTable = selectionPanel.getTable();
        this.myMemberInfoModel = new MyMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)((Object)selectionPanel), "Center");
        this.myVisibilityPanel = new JavaVisibilityPanel(true, true);
        this.myVisibilityPanel.setVisibility(null);
        panel.add((Component)((Object)this.myVisibilityPanel), "East");
        panel.add((Component)this.initOpenInEditorCb(), "South");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTfTargetClassName.getChildComponent();
    }

    @Override
    public PsiMember[] getSelectedMembers() {
        Collection selectedMemberInfos = this.myTable.getSelectedMemberInfos();
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        for (MemberInfo selectedMemberInfo : selectedMemberInfos) {
            list.add(selectedMemberInfo.getMember());
        }
        return list.toArray(PsiMember.EMPTY_ARRAY);
    }

    @Override
    public String getTargetClassName() {
        return this.myTfTargetClassName.getText();
    }

    protected void doAction() {
        String message2 = this.validateInputData();
        if (message2 != null) {
            if (message2.length() != 0) {
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.REFACTORING_NAME, (String)message2, (String)"refactoring.moveMembers", (Project)this.myProject);
            }
            return;
        }
        this.invokeRefactoring(new MoveMembersProcessor(this.getProject(), this.myMoveCallback, new MoveMembersOptions(){

            @Override
            public String getMemberVisibility() {
                return MoveMembersDialog.this.getMemberVisibility();
            }

            @Override
            public boolean makeEnumConstant() {
                return MoveMembersDialog.this.makeEnumConstant();
            }

            @Override
            public PsiMember[] getSelectedMembers() {
                return MoveMembersDialog.this.getSelectedMembers();
            }

            @Override
            public String getTargetClassName() {
                return MoveMembersDialog.this.getTargetClassName();
            }
        }, this.isOpenInEditor()));
        this.saveOpenInEditorOption();
        JavaRefactoringSettings.getInstance().MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    protected void canRun() throws ConfigurationException {
    }

    @Nullable
    private String validateInputData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        String fqName = this.getTargetClassName();
        if (fqName != null && fqName.isEmpty()) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!PsiNameHelper.getInstance((Project)manager.getProject()).isQualifiedName(fqName)) {
            return RefactoringBundle.message((String)"0.is.not.a.legal.fq.name", (Object[])new Object[]{fqName});
        }
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, fqName);
        PsiClass[] targetClass = new PsiClass[]{null};
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                targetClass[0] = this.findOrCreateTargetClass(manager, fqName);
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.REFACTORING_NAME, (String)e.getMessage(), (String)"refactoring.moveMembers", (Project)this.myProject);
            }
        }, RefactoringBundle.message((String)"create.class.command", (Object[])new Object[]{fqName}), null);
        if (targetClass[0] == null) {
            return "";
        }
        if (this.mySourceClass.equals(targetClass[0])) {
            return RefactoringBundle.message((String)"source.and.destination.classes.should.be.different");
        }
        if (!this.mySourceClass.getLanguage().equals(targetClass[0].getLanguage())) {
            return RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)this.mySourceClass), this.mySourceClass.getQualifiedName(), targetClass[0].getQualifiedName()});
        }
        for (MemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !PsiTreeUtil.isAncestor((PsiElement)info.getMember(), (PsiElement)targetClass[0], (boolean)false)) continue;
            return RefactoringBundle.message((String)"cannot.move.inner.class.0.into.itself", (Object[])new Object[]{info.getDisplayName()});
        }
        if (!targetClass[0].isWritable()) {
            CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)targetClass[0]);
            return "";
        }
        return null;
    }

    @Nullable
    private PsiClass findOrCreateTargetClass(PsiManager manager, String fqName) throws IncorrectOperationException {
        String className2;
        String packageName;
        int dotIndex = fqName.lastIndexOf(46);
        if (dotIndex >= 0) {
            packageName = fqName.substring(0, dotIndex);
            className2 = dotIndex + 1 < fqName.length() ? fqName.substring(dotIndex + 1) : "";
        } else {
            packageName = "";
            className2 = fqName;
        }
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqName, GlobalSearchScope.projectScope((Project)this.myProject));
        if (aClass != null) {
            return aClass;
        }
        PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(this.myProject, packageName, this.mySourceClass.getContainingFile().getContainingDirectory(), true);
        if (directory == null) {
            return null;
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"class.0.does.not.exist", (Object[])new Object[]{fqName}), (String)MoveMembersImpl.REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return null;
        }
        Ref eRef = new Ref();
        PsiClass newClass = (PsiClass)WriteAction.compute(() -> {
            try {
                return JavaDirectoryService.getInstance().createClass(directory, className2);
            }
            catch (IncorrectOperationException e) {
                eRef.set((Object)e);
                return null;
            }
        });
        if (!eRef.isNull()) {
            throw (IncorrectOperationException)((Object)eRef.get());
        }
        return newClass;
    }

    protected String getHelpId() {
        return "refactoring.moveMembers";
    }

    private class MyMemberInfoModel
    extends UsesAndInterfacesDependencyMemberInfoModel<PsiMember, MemberInfo> {
        PsiClass myTargetClass;

        MyMemberInfoModel() {
            super(MoveMembersDialog.this.mySourceClass, null, false, DEFAULT_CONTAINMENT_VERIFIER);
        }

        @Nullable
        public Boolean isFixedAbstract(MemberInfo member) {
            return null;
        }

        public boolean isCheckedWhenDisabled(MemberInfo member) {
            return false;
        }

        public boolean isMemberEnabled(MemberInfo member) {
            if (this.myTargetClass != null && this.myTargetClass.isInterface() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass)) {
                return !(member.getMember() instanceof PsiMethod);
            }
            return super.isMemberEnabled((MemberInfoBase)member);
        }

        public void updateTargetClass() {
            PsiManager manager = PsiManager.getInstance((Project)MoveMembersDialog.this.myProject);
            this.myTargetClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(MoveMembersDialog.this.getTargetClassName(), GlobalSearchScope.projectScope((Project)MoveMembersDialog.this.myProject));
            MoveMembersDialog.this.myTable.fireExternalDataChange();
            MoveMembersDialog.this.myIntroduceEnumConstants.setEnabled(this.myTargetClass != null && this.myTargetClass.isEnum());
        }
    }

    private class ChooseClassAction
    implements ActionListener {
        private ChooseClassAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PsiClass aClass;
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)MoveMembersDialog.this.myProject).createWithInnerClassesScopeChooser(RefactoringBundle.message((String)"choose.destination.class"), GlobalSearchScope.projectScope((Project)MoveMembersDialog.this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return aClass.getParent() instanceof PsiFile || aClass.hasModifierProperty("static");
                }
            }, null);
            String targetClassName = MoveMembersDialog.this.getTargetClassName();
            if (targetClassName != null) {
                aClass = JavaPsiFacade.getInstance((Project)MoveMembersDialog.this.myProject).findClass(targetClassName, GlobalSearchScope.allScope((Project)MoveMembersDialog.this.myProject));
                if (aClass != null) {
                    chooser.selectDirectory(aClass.getContainingFile().getContainingDirectory());
                } else {
                    chooser.selectDirectory(MoveMembersDialog.this.mySourceClass.getContainingFile().getContainingDirectory());
                }
            }
            chooser.showDialog();
            aClass = chooser.getSelected();
            if (aClass != null) {
                MoveMembersDialog.this.myTfTargetClassName.setText(aClass.getQualifiedName());
                MoveMembersDialog.this.myMemberInfoModel.updateTargetClass();
            }
        }
    }
}

