/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;

public class SingleSourceRootMoveDestination
implements MoveDestination {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.SingleSourceRootMoveDestination");
    private final PackageWrapper myPackage;
    private final PsiDirectory myTargetDirectory;

    public SingleSourceRootMoveDestination(PackageWrapper aPackage, PsiDirectory targetDirectory) {
        LOG.assertTrue(aPackage.equalToPackage(JavaDirectoryService.getInstance().getPackage(targetDirectory)));
        this.myPackage = aPackage;
        this.myTargetDirectory = targetDirectory;
    }

    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return this.myTargetDirectory;
    }

    public PsiDirectory getTargetIfExists(PsiFile source) {
        return this.myTargetDirectory;
    }

    public PsiDirectory getTargetDirectory(PsiDirectory source) {
        return this.myTargetDirectory;
    }

    public String verify(PsiFile source) {
        return null;
    }

    public String verify(PsiDirectory source) {
        return null;
    }

    public String verify(PsiPackage source) {
        return null;
    }

    public void analyzeModuleConflicts(Collection<PsiElement> elements, MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        RefactoringConflictsUtil.analyzeModuleConflicts(this.myPackage.getManager().getProject(), elements, usages, (PsiElement)this.myTargetDirectory, conflicts);
    }

    public boolean isTargetAccessible(Project project, VirtualFile place) {
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(place);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)place, (Project)project);
        VirtualFile targetVirtualFile = this.myTargetDirectory.getVirtualFile();
        return module == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)inTestSourceContent).contains(targetVirtualFile);
    }

    public PsiDirectory getTargetDirectory(PsiFile source) {
        return this.myTargetDirectory;
    }
}

