/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesToNewDirectoryDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.JavaVetoRenameCondition;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMoveClassesOrPackagesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(JavaMoveClassesOrPackagesHandler.class);
    private static final JavaVetoRenameCondition VETO_RENAME_CONDITION = new JavaVetoRenameCondition();

    public static boolean isPackageOrDirectory(PsiElement element) {
        if (element instanceof PsiPackage) {
            return true;
        }
        return element instanceof PsiDirectory && JavaDirectoryService.getInstance().getPackageInSources((PsiDirectory)element) != null;
    }

    public static boolean isReferenceInAnonymousClass(@Nullable PsiReference reference) {
        return reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnonymousClass;
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element) || !JavaMoveClassesOrPackagesHandler.invalid4Move(element)) continue;
            return false;
        }
        if (JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Nullable
    public String getActionName(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JavaMoveClassesOrPackagesHandler.$$$reportNull$$$0(0);
        }
        int classCount = 0;
        int directoryCount = 0;
        for (PsiElement element : elements) {
            if (element instanceof PsiClass) {
                ++classCount;
                continue;
            }
            if (!(element instanceof PsiDirectory) && !(element instanceof PsiPackage)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return classCount == 1 ? "Move Class..." : "Move Classes...";
        }
        if (classCount == 0) {
            return directoryCount == 1 ? "Move Package or Directory..." : "Move Packages or Directories...";
        }
        return "Move Classes and Packages...";
    }

    public static boolean invalid4Move(PsiElement element) {
        PsiFile parentFile;
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
            if (classes2.length == 0 && !PackageUtil.isPackageInfoFile(element)) {
                return true;
            }
            for (PsiClass aClass : classes2) {
                if (!(aClass instanceof PsiSyntheticClass)) continue;
                return true;
            }
            parentFile = (PsiFile)element;
        } else {
            if (element instanceof PsiSyntheticClass) {
                return true;
            }
            if (!(element instanceof PsiClass)) {
                return true;
            }
            if (element instanceof PsiAnonymousClass) {
                return true;
            }
            if (((PsiClass)element).getContainingClass() != null) {
                return true;
            }
            parentFile = element.getContainingFile();
        }
        return parentFile instanceof PsiJavaFile && JavaProjectRootsUtil.isOutsideJavaSourceRoot(parentFile);
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(psiElement)) {
            return true;
        }
        boolean areAllClasses = true;
        for (PsiElement source : sources) {
            areAllClasses &= !JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(source) && !JavaMoveClassesOrPackagesHandler.invalid4Move(source);
        }
        return areAllClasses && psiElement instanceof PsiClass;
    }

    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return MoveClassesOrPackagesImpl.adjustForMove(project, sourceElements, targetElement);
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        PsiElement[] adjustedElements;
        PsiDirectory[] directories = new PsiDirectory[elements.length];
        String prompt = JavaMoveClassesOrPackagesHandler.getPromptToMoveDirectoryLibrariesSafe(elements);
        if (prompt != null) {
            System.arraycopy(elements, 0, directories, 0, directories.length);
            JavaMoveClassesOrPackagesHandler.moveDirectoriesLibrariesSafe(project, targetContainer, callback, directories, prompt);
            return;
        }
        if (JavaMoveClassesOrPackagesHandler.canMoveOrRearrangePackages(elements)) {
            System.arraycopy(elements, 0, directories, 0, directories.length);
            SelectMoveOrRearrangePackageDialog dialog = new SelectMoveOrRearrangePackageDialog(project, directories, targetContainer == null);
            if (!dialog.showAndGet()) {
                return;
            }
            if (dialog.isPackageRearrageSelected()) {
                MoveClassesOrPackagesImpl.doRearrangePackage(project, directories);
                return;
            }
            if (dialog.isMoveDirectory()) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, targetContainer, callback, directories);
                return;
            }
        }
        if ((adjustedElements = MoveClassesOrPackagesImpl.adjustForMove(project, elements, targetContainer)) == null) {
            return;
        }
        if (targetContainer instanceof PsiDirectory && CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(adjustedElements), (boolean)true) && !JavaMoveClassesOrPackagesHandler.packageHasMultipleDirectoriesInModule(project, (PsiDirectory)targetContainer)) {
            this.createMoveClassesOrPackagesToNewDirectoryDialog((PsiDirectory)targetContainer, adjustedElements, callback).show();
            return;
        }
        this.doMoveWithMoveClassesDialog(project, adjustedElements, targetContainer, callback);
    }

    protected void doMoveWithMoveClassesDialog(Project project, PsiElement[] adjustedElements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        MoveClassesOrPackagesImpl.doMove(project, adjustedElements, initialTargetElement, moveCallback);
    }

    private static void moveDirectoriesLibrariesSafe(Project project, PsiElement targetContainer, MoveCallback callback, PsiDirectory[] directories, String prompt) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directories[0]);
        LOG.assertTrue(aPackage != null);
        PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project));
        if (projectDirectories.length > 1) {
            int ret = Messages.showYesNoCancelDialog((Project)project, (String)(prompt + " or all directories in project?"), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"move.current.directory"), (String)RefactoringBundle.message((String)"move.directories"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (ret == 0) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, targetContainer, callback, directories);
            } else if (ret == 1) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, targetContainer, callback, projectDirectories);
            }
        } else if (Messages.showOkCancelDialog((Project)project, (String)(prompt + "?"), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) == 0) {
            JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, targetContainer, callback, directories);
        }
    }

    @NotNull
    protected DialogWrapper createMoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, PsiElement[] elementsToMove, MoveCallback moveCallback) {
        if (directory == null) {
            JavaMoveClassesOrPackagesHandler.$$$reportNull$$$0(1);
        }
        MoveClassesOrPackagesToNewDirectoryDialog moveClassesOrPackagesToNewDirectoryDialog = new MoveClassesOrPackagesToNewDirectoryDialog(directory, elementsToMove, moveCallback);
        if (moveClassesOrPackagesToNewDirectoryDialog == null) {
            JavaMoveClassesOrPackagesHandler.$$$reportNull$$$0(2);
        }
        return moveClassesOrPackagesToNewDirectoryDialog;
    }

    private static void moveAsDirectory(Project project, PsiElement targetContainer, final MoveCallback callback, final PsiDirectory[] directories) {
        if (targetContainer instanceof PsiDirectory) {
            JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
            MoveDirectoryWithClassesProcessor processor = new MoveDirectoryWithClassesProcessor(project, directories, (PsiDirectory)targetContainer, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, true, callback);
            processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
            processor.run();
        } else {
            boolean containsJava = JavaMoveClassesOrPackagesHandler.hasJavaFiles(directories[0]);
            if (!containsJava) {
                MoveFilesOrDirectoriesUtil.doMove((Project)project, (PsiElement[])directories, (PsiElement[])new PsiElement[]{targetContainer}, (MoveCallback)callback);
                return;
            }
            MoveClassesOrPackagesToNewDirectoryDialog dlg = new MoveClassesOrPackagesToNewDirectoryDialog(directories[0], PsiElement.EMPTY_ARRAY, false, callback){

                @Override
                protected BaseRefactoringProcessor createRefactoringProcessor(Project project, final PsiDirectory targetDirectory, PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
                    final MoveDestination destination = this.createDestination(aPackage, targetDirectory);
                    if (destination == null) {
                        return null;
                    }
                    try {
                        for (PsiDirectory dir : directories) {
                            MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)dir, (PsiElement)((PsiElement)WriteAction.compute(() -> destination.getTargetDirectory(dir))));
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)RefactoringBundle.message((String)"cannot.move"));
                        return null;
                    }
                    return new MoveDirectoryWithClassesProcessor(project, directories, null, searchInComments, searchForTextOccurences, true, callback){

                        public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                            PsiDirectory targetDirectory2 = destination.getTargetDirectory(dir);
                            return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(targetDirectory2);
                        }

                        protected String getTargetName() {
                            return targetDirectory.getName();
                        }
                    };
                }
            };
            dlg.show();
        }
    }

    public static boolean hasJavaFiles(PsiDirectory directory) {
        final boolean[] containsJava = new boolean[]{false};
        directory.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (containsJava[0]) {
                    return;
                }
                if (element instanceof PsiDirectory) {
                    super.visitElement(element);
                }
            }

            public void visitFile(PsiFile file) {
                containsJava[0] = file instanceof PsiJavaFile;
            }
        });
        return containsJava[0];
    }

    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        PsiDirectory[] directories;
        Module module;
        if (targetContainer instanceof PsiPackage && (module = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext)) != null && (directories = ((PsiPackage)targetContainer).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
            return directories[0];
        }
        return super.adjustTargetForMove(dataContext, targetContainer);
    }

    public static boolean packageHasMultipleDirectoriesInModule(Project project, PsiDirectory targetElement) {
        Module module;
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(targetElement);
        return psiPackage != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)targetElement.getVirtualFile(), (Project)project)) != null && psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module)).length > 1;
    }

    @Nullable
    private static String getPromptToMoveDirectoryLibrariesSafe(PsiElement[] elements) {
        if (elements.length == 0 || elements.length > 1) {
            return null;
        }
        Project project = elements[0].getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (!(elements[0] instanceof PsiDirectory)) {
            return null;
        }
        PsiDirectory directory = (PsiDirectory)elements[0];
        if (RefactoringUtil.isSourceRoot(directory)) {
            return null;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return null;
        }
        if ("".equals(aPackage.getQualifiedName())) {
            return null;
        }
        PsiDirectory[] directories = aPackage.getDirectories();
        boolean inLib = false;
        for (PsiDirectory psiDirectory : directories) {
            inLib |= !fileIndex.isInContent(psiDirectory.getVirtualFile());
        }
        return inLib ? "Package '" + aPackage.getName() + "' contains directories in libraries which cannot be moved. Do you want to move current directory" : null;
    }

    private static boolean canMoveOrRearrangePackages(PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        Project project = elements[0].getProject();
        if (JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project).size() == 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory)) {
                return false;
            }
            PsiDirectory directory = (PsiDirectory)element;
            if (RefactoringUtil.isSourceRoot(directory)) {
                return false;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return false;
            }
            if (aPackage.getQualifiedName().isEmpty()) {
                return false;
            }
            VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
            if (sourceRootForFile != null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPackages(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null;
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element)) {
            return false;
        }
        if (JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        if (!JavaMoveClassesOrPackagesHandler.invalid4Move(element)) {
            PsiElement initialTargetElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            PsiElement[] adjustedElements = this.adjustForMove(project, new PsiElement[]{element}, initialTargetElement);
            if (adjustedElements == null) {
                return true;
            }
            this.doMoveWithMoveClassesDialog(project, adjustedElements, initialTargetElement, null);
            return true;
        }
        return false;
    }

    public boolean isMoveRedundant(PsiElement source, PsiElement target) {
        PsiPackage aPackage;
        if (target instanceof PsiDirectory && source instanceof PsiClass) {
            try {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface((PsiDirectory)target, ((PsiClass)source).getName());
            }
            catch (IncorrectOperationException e) {
                return true;
            }
        }
        if (target instanceof PsiPackage && source instanceof PsiClass) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)source.getProject());
            return ((PsiPackage)target).findClassByShortName(((PsiClass)source).getName(), globalSearchScope).length > 0;
        }
        if (target instanceof PsiDirectory && source instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)source)) != null && !MoveClassesOrPackagesImpl.checkNesting(target.getProject(), aPackage, target, false)) {
            return true;
        }
        return super.isMoveRedundant(source, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMoveClassesOrPackagesToNewDirectoryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createMoveClassesOrPackagesToNewDirectoryDialog";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SelectMoveOrRearrangePackageDialog
    extends DialogWrapper {
        private JRadioButton myRbMovePackage;
        private JRadioButton myRbRearrangePackage;
        private JRadioButton myRbMoveDirectory;
        private final PsiDirectory[] myDirectories;
        private final boolean myRearrangePackagesEnabled;

        SelectMoveOrRearrangePackageDialog(Project project, PsiDirectory[] directories) {
            this(project, directories, true);
        }

        SelectMoveOrRearrangePackageDialog(Project project, PsiDirectory[] directories, boolean rearrangePackagesEnabled) {
            super(project, true);
            this.myDirectories = directories;
            this.myRearrangePackagesEnabled = rearrangePackagesEnabled;
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbMovePackage;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.refactoring.move.MoveHandler.SelectRefactoringDialog";
        }

        protected JComponent createCenterPanel() {
            String moveDescription;
            JPanel panel = new JPanel(new BorderLayout());
            HashSet<String> packages = new HashSet<String>();
            for (PsiDirectory directory : this.myDirectories) {
                packages.add(JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName());
            }
            LOG.assertTrue(this.myDirectories.length > 0);
            LOG.assertTrue(packages.size() > 0);
            if (packages.size() > 1) {
                moveDescription = RefactoringBundle.message((String)"move.packages.to.another.package", (Object[])new Object[]{packages.size()});
            } else {
                String qName = (String)packages.iterator().next();
                moveDescription = RefactoringBundle.message((String)"move.package.to.another.package", (Object[])new Object[]{qName});
            }
            this.myRbMovePackage = new JRadioButton();
            this.myRbMovePackage.setText(moveDescription);
            this.myRbMovePackage.setSelected(true);
            String rearrangeDescription = this.myDirectories.length > 1 ? RefactoringBundle.message((String)"move.directories.to.another.source.root", (Object[])new Object[]{this.myDirectories.length}) : RefactoringBundle.message((String)"move.directory.to.another.source.root", (Object[])new Object[]{this.myDirectories[0].getVirtualFile().getPresentableUrl()});
            this.myRbRearrangePackage = new JRadioButton();
            this.myRbRearrangePackage.setText(rearrangeDescription);
            this.myRbRearrangePackage.setVisible(this.myRearrangePackagesEnabled);
            String moveDirectoryDescription = this.myDirectories.length > 1 ? "Move everything from " + this.myDirectories.length + " directories to another directory" : "Move everything from " + this.myDirectories[0].getVirtualFile().getPresentableUrl() + " to another directory";
            this.myRbMoveDirectory = new JRadioButton();
            this.myRbMoveDirectory.setMnemonic('e');
            this.myRbMoveDirectory.setText(moveDirectoryDescription);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbMovePackage);
            gr.add(this.myRbRearrangePackage);
            gr.add(this.myRbMoveDirectory);
            if (this.myRearrangePackagesEnabled) {
                new RadioUpDownListener(new JRadioButton[]{this.myRbMovePackage, this.myRbRearrangePackage, this.myRbMoveDirectory});
            } else {
                new RadioUpDownListener(new JRadioButton[]{this.myRbMovePackage, this.myRbMoveDirectory});
            }
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add(this.myRbMovePackage);
            box.add(this.myRbRearrangePackage);
            box.add(this.myRbMoveDirectory);
            panel.add((Component)box, "Center");
            return panel;
        }

        public boolean isPackageRearrageSelected() {
            return this.myRbRearrangePackage.isSelected();
        }

        public boolean isMoveDirectory() {
            return this.myRbMoveDirectory.isSelected();
        }
    }
}

