/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.EnclosingMethodSelectionDialog;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterPopup;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.MethodCellRenderer;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;
    private InplaceIntroduceParameterPopup myInplaceIntroduceParameterPopup;

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn(editor, file, REFACTORING_NAME, "refactoring.introduceParameter", project, (ElementToWorkOn.ElementsProcessor<? super ElementToWorkOn>)new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            @Override
            public boolean accept(ElementToWorkOn el) {
                return true;
            }

            @Override
            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null) {
                    if (!IntroduceParameterHandler.this.introduceStrategy(project, editor, file)) {
                        ElementToWorkOn.showNothingSelectedErrorMessage(editor, REFACTORING_NAME, "refactoring.introduceParameter", project);
                    }
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                PsiLocalVariable localVar = elementToWorkOn.getLocalVariable();
                boolean isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration();
                IntroduceParameterHandler.this.invoke(editor, project, expr, localVar, isInvokedOnDeclaration);
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project, PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiType typeByExpression;
        PsiElement parent;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).hasUncommitedDocuments());
        PsiMethod method = expr != null ? Util.getContainingMethod((PsiElement)expr) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null && localVar == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            IntroduceParameterHandler.showErrorMessage(project, message2, editor);
            return false;
        }
        if (localVar != null && !((parent = localVar.getParent()) instanceof PsiDeclarationStatement)) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            IntroduceParameterHandler.showErrorMessage(project, message3, editor);
            return false;
        }
        if (method == null) {
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            IntroduceParameterHandler.showErrorMessage(project, message4, editor);
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (!invokedOnDeclaration && (typeByExpression == null || LambdaUtil.notInferredType((PsiType)typeByExpression))) {
            String message5 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined"));
            IntroduceParameterHandler.showErrorMessage(project, message5, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiType.VOID.equals((Object)typeByExpression)) {
            String message6 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            IntroduceParameterHandler.showErrorMessage(project, message6, editor);
            return false;
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.isEmpty()) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        Introducer introducer = new Introducer(project, expr, localVar, editor);
        AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
            InplaceIntroduceParameterPopup introduceParameterPopup = (InplaceIntroduceParameterPopup)inplaceIntroducer;
            introducer.introduceParameter(introduceParameterPopup.getMethodToIntroduceParameter(), introduceParameterPopup.getMethodToSearchFor());
            return true;
        }
        this.chooseMethodToIntroduceParameter(editor, validEnclosingMethods, (PairConsumer<? super PsiMethod, ? super PsiMethod>)((PairConsumer)(methodToSearchIn, methodToSearchFor) -> introducer.introduceParameter((PsiMethod)methodToSearchIn, (PsiMethod)methodToSearchFor)));
        return true;
    }

    private void chooseMethodToIntroduceParameter(final Editor editor, List<? extends PsiMethod> validEnclosingMethods, final PairConsumer<? super PsiMethod, ? super PsiMethod> consumer) {
        PsiMethod methodToIntroduceParameterTo;
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if ((validEnclosingMethods.size() == 1 || unitTestMode) && ((methodToIntroduceParameterTo = validEnclosingMethods.get(0)).findDeepestSuperMethod() == null || unitTestMode)) {
            consumer.consume((Object)methodToIntroduceParameterTo, (Object)methodToIntroduceParameterTo);
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox superMethod = new JCheckBox("Refactor super method", true);
        superMethod.setMnemonic('U');
        panel.add((Component)superMethod, "South");
        final JBList list = new JBList((Object[])validEnclosingMethods.toArray(PsiMethod.EMPTY_ARRAY));
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new MethodCellRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList highlighters = new ArrayList();
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PsiMethod selectedMethod = (PsiMethod)list.getSelectedValue();
                if (selectedMethod == null) {
                    return;
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
                IntroduceParameterHandler.updateView(selectedMethod, editor, attributes, highlighters, superMethod);
            }
        });
        IntroduceParameterHandler.updateView(validEnclosingMethods.get(0), editor, attributes, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiMethod methodToSearchIn = (PsiMethod)list.getSelectedValue();
                if (IntroduceParameterHandler.this.myEnclosingMethodsPopup != null && IntroduceParameterHandler.this.myEnclosingMethodsPopup.isVisible()) {
                    IntroduceParameterHandler.this.myEnclosingMethodsPopup.cancel();
                }
                PsiMethod methodToSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? methodToSearchIn.findDeepestSuperMethod() : methodToSearchIn;
                consumer.consume((Object)methodToSearchIn, (Object)methodToSearchFor);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        this.myEnclosingMethodsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)list).setTitle("Introduce parameter to method").setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$4", "onClosed"));
            }
        }).createPopup();
        this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
    }

    private static void updateView(PsiMethod selectedMethod, Editor editor, TextAttributes attributes, List<? super RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        PsiIdentifier nameIdentifier = selectedMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            TextRange textRange = nameIdentifier.getTextRange();
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add((RangeHighlighter)rangeHighlighter);
        }
        superMethod.setEnabled(selectedMethod.findDeepestSuperMethod() != null);
    }

    private static void dropHighlighters(List<? extends RangeHighlighter> highlighters) {
        for (RangeHighlighter rangeHighlighter : highlighters) {
            rangeHighlighter.dispose();
        }
        highlighters.clear();
    }

    protected static NameSuggestionsGenerator createNameSuggestionGenerator(final PsiExpression expr, final String propName, final Project project, final String enteredName) {
        return new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type2) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr != null && expr.isValid() ? expr : null, type2);
                if (expr != null && expr.isValid()) {
                    info = codeStyleManager.suggestUniqueVariableName(info, (PsiElement)expr, true);
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type2, VariableKind.LOCAL_VARIABLE, info), expr);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, info);
            }
        };
    }

    private static void showErrorMessage(Project project, String message2, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(2);
        }
    }

    public static List<PsiMethod> getEnclosingMethods(@NotNull PsiMethod nearest) {
        if (nearest == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        ArrayList<PsiMethod> enclosingMethods = new ArrayList<PsiMethod>();
        enclosingMethods.add(nearest);
        PsiMethod method = nearest;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true)) != null) {
            enclosingMethods.add(method);
        }
        if (enclosingMethods.size() > 1) {
            ArrayList<PsiMethod> methodsNotImplementingLibraryInterfaces = new ArrayList<PsiMethod>();
            for (PsiMethod enclosing : enclosingMethods) {
                PsiMethod[] superMethods = enclosing.findDeepestSuperMethods();
                boolean libraryInterfaceMethod = false;
                for (PsiMethod superMethod : superMethods) {
                    libraryInterfaceMethod |= IntroduceParameterHandler.isLibraryInterfaceMethod(superMethod);
                }
                if (libraryInterfaceMethod) continue;
                methodsNotImplementingLibraryInterfaces.add(enclosing);
            }
            if (methodsNotImplementingLibraryInterfaces.size() > 0) {
                return methodsNotImplementingLibraryInterfaces;
            }
        }
        return enclosingMethods;
    }

    @Nullable
    public static PsiMethod chooseEnclosingMethod(@NotNull PsiMethod method) {
        List<PsiMethod> validEnclosingMethods;
        if (method == null) {
            IntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        if ((validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method)).size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            EnclosingMethodSelectionDialog dialog = new EnclosingMethodSelectionDialog(method.getProject(), validEnclosingMethods);
            if (!dialog.showAndGet()) {
                return null;
            }
            method = dialog.getSelectedMethod();
        } else if (validEnclosingMethods.size() == 1) {
            method = validEnclosingMethods.get(0);
        }
        return method;
    }

    private static boolean isLibraryInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !method.getManager().isInProject((PsiElement)method);
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceParameterPopup;
    }

    @VisibleForTesting
    public boolean introduceStrategy(Project project, Editor editor, PsiFile file) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements = CodeInsightUtil.findStatementsInRange(file, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            return this.introduceStrategy(project, editor, file, elements);
        }
        return false;
    }

    @VisibleForTesting
    public boolean introduceStrategy(final Project project, final Editor editor, PsiFile file, final PsiElement[] elements) {
        if (elements.length > 0) {
            AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
            if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
                return false;
            }
            PsiMethod containingMethod = Util.getContainingMethod(elements[0]);
            if (containingMethod == null) {
                return false;
            }
            final List<PsiMethod> enclosingMethods = IntroduceParameterHandler.getEnclosingMethods(containingMethod);
            if (enclosingMethods.isEmpty()) {
                return false;
            }
            PsiElement[] elementsCopy = IntroduceParameterHandler.getElementsInCopy(project, file, elements);
            PsiMethod containingMethodCopy = Util.getContainingMethod(elementsCopy[0]);
            LOG.assertTrue(containingMethodCopy != null);
            List<PsiMethod> enclosingMethodsInCopy = IntroduceParameterHandler.getEnclosingMethods(containingMethodCopy);
            final MyExtractMethodProcessor processor = new MyExtractMethodProcessor(project, editor, elementsCopy, enclosingMethodsInCopy.get(enclosingMethodsInCopy.size() - 1));
            try {
                if (!processor.prepare()) {
                    return false;
                }
                processor.showDialog();
                PsiMethod emptyMethod = processor.generateEmptyMethod("name", elements[0]);
                Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(emptyMethod);
                if (types.isEmpty()) {
                    return false;
                }
                if (types.size() != 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    final LinkedHashMap<PsiClass, PsiType> classes2 = new LinkedHashMap<PsiClass, PsiType>();
                    for (PsiType psiType : types) {
                        classes2.put(PsiUtil.resolveClassInType((PsiType)psiType), psiType);
                    }
                    PsiClass[] psiClasses = classes2.keySet().toArray(PsiClass.EMPTY_ARRAY);
                    String string = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
                    PsiType returnType = emptyMethod.getReturnType();
                    LOG.assertTrue(returnType != null);
                    String title = "Choose Applicable Functional Interface: " + string + " -> " + returnType.getPresentableText();
                    NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                        public boolean execute(@NotNull PsiClass psiClass) {
                            if (psiClass == null) {
                                6.$$$reportNull$$$0(0);
                            }
                            IntroduceParameterHandler.this.functionalInterfaceSelected((PsiType)classes2.get(psiClass), enclosingMethods, project, editor, processor, elements);
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$6", "execute"));
                        }
                    }).showInBestPositionFor(editor);
                    return true;
                }
                PsiType next = types.iterator().next();
                this.functionalInterfaceSelected(next, enclosingMethods, project, editor, processor, elements);
                return true;
            }
            catch (PrepareFailedException | IncorrectOperationException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static PsiElement[] getElementsInCopy(Project project, PsiFile file, PsiElement[] elements) {
        return IntroduceParameterHandler.getElementsInCopy(project, file, elements, true);
    }

    public static PsiElement[] getElementsInCopy(Project project, PsiFile file, PsiElement[] elements, boolean reuseNonPhysical) {
        PsiElement[] elementsCopy;
        if (reuseNonPhysical && !elements[0].isPhysical()) {
            elementsCopy = elements;
        } else {
            PsiElement[] psiElementArray;
            TextRange range;
            PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
            PsiExpression exprInRange = CodeInsightUtil.findExpressionInRange(copy, (range = new TextRange(elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset())).getStartOffset(), range.getEndOffset());
            if (exprInRange != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = exprInRange;
            } else {
                psiElementArray = elementsCopy = CodeInsightUtil.findStatementsInRange(copy, range.getStartOffset(), range.getEndOffset());
            }
        }
        if (elementsCopy.length == 1 && elementsCopy[0].getUserData(ElementToWorkOn.PARENT) == null) {
            elementsCopy[0].putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, (Object)true);
        }
        return elementsCopy;
    }

    private void functionalInterfaceSelected(PsiType selectedType, List<? extends PsiMethod> enclosingMethods, Project project, Editor editor, MyExtractMethodProcessor processor, PsiElement[] elements) {
        PairConsumer consumer = (methodToIntroduceParameter, methodToSearchFor) -> this.introduceWrappedCodeBlockParameter((PsiMethod)methodToIntroduceParameter, (PsiMethod)methodToSearchFor, editor, project, selectedType, processor, elements);
        this.chooseMethodToIntroduceParameter(editor, enclosingMethods, (PairConsumer<? super PsiMethod, ? super PsiMethod>)consumer);
    }

    private void introduceWrappedCodeBlockParameter(PsiMethod methodToIntroduceParameter, PsiMethod methodToSearchFor, Editor editor, Project project, PsiType selectedType, ExtractMethodProcessor processor, PsiElement[] elements) {
        if (!elements[0].isValid()) {
            return;
        }
        PsiElement commonParent = IntroduceParameterHandler.findCommonParent(elements);
        if (commonParent == null) {
            LOG.error("Should have common parent:" + Arrays.toString(elements));
            return;
        }
        RangeMarker marker = editor.getDocument().createRangeMarker(commonParent.getTextRange());
        Object[] copyElements = processor.getElements();
        PsiElement containerCopy = IntroduceParameterHandler.findCommonParent((PsiElement[])copyElements);
        if (containerCopy == null) {
            LOG.error("Should have common parent:" + Arrays.toString(copyElements));
            return;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        PsiClass wrapperClass = resolveResult.getElement();
        LOG.assertTrue(wrapperClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        Ref suffixText = new Ref();
        Ref prefixText = new Ref();
        Ref methodText = new Ref();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
            LOG.assertTrue(method != null);
            String interfaceMethodName = method.getName();
            processor.setMethodName(interfaceMethodName);
            processor.doExtract();
            PsiMethod extractedMethod = processor.getExtractedMethod();
            PsiParameter[] parameters2 = extractedMethod.getParameterList().getParameters();
            PsiParameter[] interfaceParameters = method.getParameterList().getParameters();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (int i = 0; i < interfaceParameters.length; ++i) {
                PsiTypeElement typeAfterInterface = factory.createTypeElement(substitutor.substitute(interfaceParameters[i].getType()));
                PsiTypeElement typeElement = parameters2[i].getTypeElement();
                if (typeElement == null) continue;
                typeElement.replace((PsiElement)typeAfterInterface);
            }
            methodText.set((Object)extractedMethod.getText());
            PsiMethodCallExpression methodCall = processor.getMethodCall();
            prefixText.set((Object)containerCopy.getText().substring(0, methodCall.getTextRange().getStartOffset() - containerCopy.getTextRange().getStartOffset()));
            suffixText.set((Object)("." + methodCall.getText() + containerCopy.getText().substring(methodCall.getTextRange().getEndOffset() - containerCopy.getTextRange().getStartOffset())));
        });
        PsiExpression expression2 = factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {" + (String)methodText.get() + "}", elements[0]);
        expression2 = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)expression2);
        expression2.putUserData(ElementToWorkOn.PARENT, (Object)commonParent);
        expression2.putUserData(ElementToWorkOn.PREFIX, prefixText.get());
        expression2.putUserData(ElementToWorkOn.SUFFIX, suffixText.get());
        expression2.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)marker);
        expression2.putUserData(ElementToWorkOn.EXPR_RANGE, elements.length == 1 ? elements[0].getTextRange() : null);
        new Introducer(project, expression2, null, editor).introduceParameter(methodToIntroduceParameter, methodToSearchFor);
    }

    @Nullable
    private static PsiElement findCommonParent(PsiElement[] copyElements) {
        if (copyElements.length > 1) {
            return PsiTreeUtil.findCommonParent((PsiElement[])copyElements);
        }
        PsiElement parent = (PsiElement)copyElements[0].getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = copyElements[0].getParent();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCodeBlock.class, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnclosingMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseEnclosingMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        private final PsiMethod myTopEnclosingMethod;

        MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, @NotNull PsiMethod topEnclosing) {
            if (topEnclosing == null) {
                MyExtractMethodProcessor.$$$reportNull$$$0(0);
            }
            super(project, editor, elements, null, REFACTORING_NAME, null, null);
            this.myTopEnclosingMethod = topEnclosing;
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return new MyAbstractExtractDialog();
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        @Override
        public Boolean hasDuplicates() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        protected PsiMethod addExtractedMethod(PsiMethod newMethod) {
            return newMethod;
        }

        @Override
        public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare = super.prepare(pass);
            if (prepare && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topEnclosing", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$MyExtractMethodProcessor", "<init>"));
        }

        private class MyAbstractExtractDialog
        implements AbstractExtractDialog {
            private MyAbstractExtractDialog() {
            }

            @Override
            @NotNull
            public String getChosenMethodName() {
                if ("name" == null) {
                    MyAbstractExtractDialog.$$$reportNull$$$0(0);
                }
                return "name";
            }

            @Override
            public VariableData[] getChosenParameters() {
                InputVariables inputVariables = MyExtractMethodProcessor.this.getInputVariables();
                ArrayList<VariableData> datas = new ArrayList<VariableData>();
                for (VariableData data : inputVariables.getInputVariables()) {
                    PsiVariable variable = data.variable;
                    if (variable instanceof PsiParameter && MyExtractMethodProcessor.this.myTopEnclosingMethod.equals(((PsiParameter)variable).getDeclarationScope())) continue;
                    datas.add(data);
                }
                return datas.toArray(new VariableData[0]);
            }

            @Override
            @NotNull
            public String getVisibility() {
                if ("public" == null) {
                    MyAbstractExtractDialog.$$$reportNull$$$0(1);
                }
                return "public";
            }

            @Override
            public boolean isMakeStatic() {
                return false;
            }

            @Override
            public boolean isChainedConstructor() {
                return false;
            }

            @Override
            public PsiType getReturnType() {
                return null;
            }

            @Override
            public void show() {
            }

            @Override
            public boolean isOK() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$MyExtractMethodProcessor$MyAbstractExtractDialog";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChosenMethodName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibility";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    private class Introducer {
        private final Project myProject;
        private PsiExpression myExpr;
        private PsiLocalVariable myLocalVar;
        private final Editor myEditor;

        Introducer(Project project, PsiExpression expr, PsiLocalVariable localVar, Editor editor) {
            this.myProject = project;
            this.myExpr = expr;
            this.myLocalVar = localVar;
            this.myEditor = editor;
        }

        public void introduceParameter(PsiMethod method, PsiMethod methodToSearchFor) {
            boolean isInplaceAvailableOnDataContext;
            PsiExpression[] occurrences = this.myExpr != null ? new ExpressionOccurrenceManager(this.myExpr, (PsiElement)method, null).findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method, (PsiElement)this.myLocalVar);
            String enteredName = null;
            boolean replaceAllOccurrences = false;
            boolean delegate = false;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, this.myExpr, this.myLocalVar);
            AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)this.myEditor);
            if (activeIntroducer != null) {
                activeIntroducer.stopIntroduce(this.myEditor);
                this.myExpr = (PsiExpression)activeIntroducer.getExpr();
                this.myLocalVar = (PsiLocalVariable)activeIntroducer.getLocalVariable();
                occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
                enteredName = activeIntroducer.getInputName();
                replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
                delegate = ((InplaceIntroduceParameterPopup)activeIntroducer).isGenerateDelegate();
                initializerType = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            }
            boolean mustBeFinal = false;
            if (this.myExpr != null) {
                PsiExpression[] parent = (PsiExpression[])this.myExpr.getUserData(ElementToWorkOn.PARENT);
                mustBeFinal = parent != null && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) != method;
            }
            for (PsiElement psiElement : occurrences) {
                if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method) continue;
                mustBeFinal = true;
                break;
            }
            String propName = this.myLocalVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myLocalVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            boolean bl = isInplaceAvailableOnDataContext = this.myEditor != null && this.myEditor.getSettings().isVariableInplaceRenameEnabled();
            if (this.myExpr != null) {
                isInplaceAvailableOnDataContext &= this.myExpr.isPhysical();
            }
            if (isInplaceAvailableOnDataContext && activeIntroducer == null) {
                IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup = new InplaceIntroduceParameterPopup(this.myProject, this.myEditor, this.createTypeSelectorManager(occurrences, initializerType), this.myExpr, this.myLocalVar, method, methodToSearchFor, occurrences, this.getParamsToRemove(method, occurrences), mustBeFinal);
                if (IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String parameterName = "anObject";
                boolean bl2 = true;
                boolean isDeleteLocalVariable = true;
                PsiExpression initializer = this.myLocalVar != null && this.myExpr == null ? this.myLocalVar.getInitializer() : this.myExpr;
                new IntroduceParameterProcessor(this.myProject, method, methodToSearchFor, initializer, this.myExpr, this.myLocalVar, isDeleteLocalVariable, parameterName, bl2, 0, mustBeFinal, false, null, this.getParamsToRemove(method, occurrences)).run();
            } else {
                if (this.myEditor != null) {
                    RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurrences, this.myEditor);
                }
                ArrayList classMemberRefs = new ArrayList();
                if (this.myExpr != null) {
                    Util.analyzeExpression(this.myExpr, new ArrayList(), classMemberRefs, new ArrayList());
                }
                this.showDialog(method, methodToSearchFor, occurrences, replaceAllOccurrences, delegate, initializerType, mustBeFinal, classMemberRefs, IntroduceParameterHandler.createNameSuggestionGenerator(this.myExpr, propName, this.myProject, enteredName));
            }
        }

        private void showDialog(PsiMethod method, PsiMethod methodToSearchFor, PsiExpression[] occurrences, boolean replaceAllOccurrences, boolean delegate, PsiType initializerType, boolean mustBeFinal, List<? extends UsageInfo> classMemberRefs, NameSuggestionsGenerator nameSuggestionGenerator) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                IntroduceParameterDialog dialog = new IntroduceParameterDialog(this.myProject, classMemberRefs, occurrences, this.myLocalVar, this.myExpr, nameSuggestionGenerator, this.createTypeSelectorManager(occurrences, initializerType), methodToSearchFor, method, this.getParamsToRemove(method, occurrences), mustBeFinal);
                dialog.setReplaceAllOccurrences(replaceAllOccurrences);
                dialog.setGenerateDelegate(delegate);
                if (dialog.showAndGet()) {
                    Runnable cleanSelectionRunnable = () -> {
                        if (this.myEditor != null && !this.myEditor.isDisposed()) {
                            this.myEditor.getSelectionModel().removeSelection();
                        }
                    };
                    ApplicationManager.getApplication().invokeLater(cleanSelectionRunnable, ModalityState.any());
                }
            });
        }

        private TypeSelectorManagerImpl createTypeSelectorManager(PsiExpression[] occurrences, PsiType initializerType) {
            return this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, initializerType, this.myExpr, occurrences) : new TypeSelectorManagerImpl(this.myProject, initializerType, occurrences);
        }

        private TIntArrayList getParamsToRemove(PsiMethod method, PsiExpression[] occurrences) {
            PsiExpression expressionToRemoveParamFrom = this.myExpr;
            if (this.myExpr == null) {
                expressionToRemoveParamFrom = this.myLocalVar.getInitializer();
            }
            return expressionToRemoveParamFrom == null ? new TIntArrayList() : Util.findParametersToRemove(method, expressionToRemoveParamFrom, occurrences);
        }
    }
}

