/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.intention.impl.singlereturn.ConvertToSingleReturnAction;
import com.intellij.codeInsight.intention.impl.singlereturn.FinishMarker;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.BooleanReturnModel;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.util.InlineUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface InlineTransformer {
    public PsiLocalVariable transformBody(PsiMethod var1, PsiReferenceExpression var2, PsiType var3);

    default public boolean isFallBackTransformer() {
        return false;
    }

    @NotNull
    public static Function<PsiReference, InlineTransformer> getSuitableTransformer(PsiMethod method) {
        PsiCodeBlock body2;
        PsiReturnStatement[] returns = PsiUtil.findReturnStatements((PsiMethod)method);
        if (!InlineMethodProcessor.checkBadReturns(returns, body2 = Objects.requireNonNull(method.getBody()))) {
            Function<PsiReference, InlineTransformer> function = ref -> {
                InlineUtil.TailCallType type2 = InlineUtil.getTailCallType(ref);
                if (type2 == InlineUtil.TailCallType.Return || type2 == InlineUtil.TailCallType.Simple) {
                    return type2.getTransformer();
                }
                return new NormalTransformer();
            };
            if (function == null) {
                InlineTransformer.$$$reportNull$$$0(0);
            }
            return function;
        }
        boolean canUseContinue = Arrays.stream(returns).allMatch(statement -> PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}) == null);
        BooleanReturnModel model = BooleanReturnModel.from(body2, returns);
        Function<PsiReference, InlineTransformer> function = ref -> {
            InlineTransformer fromBooleanModel;
            InlineTransformer fromTailCall;
            InlineUtil.TailCallType type2 = InlineUtil.getTailCallType(ref);
            if (type2 == InlineUtil.TailCallType.Continue && !canUseContinue) {
                type2 = InlineUtil.TailCallType.None;
            }
            if ((fromTailCall = type2.getTransformer()) != null) {
                return fromTailCall;
            }
            if (model != null && (fromBooleanModel = model.getTransformer((PsiReference)ref)) != null) {
                return fromBooleanModel;
            }
            return new ConvertToSingleReturnTransformer();
        };
        if (function == null) {
            InlineTransformer.$$$reportNull$$$0(1);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineTransformer", "getSuitableTransformer"));
    }

    public static class ConvertToSingleReturnTransformer
    implements InlineTransformer {
        @Override
        public boolean isFallBackTransformer() {
            return true;
        }

        @Override
        public PsiLocalVariable transformBody(PsiMethod methodCopy, PsiReferenceExpression callSite, PsiType returnType) {
            if (callSite.getParent() instanceof PsiMethodCallExpression && ExpressionUtils.isVoidContext((PsiExpression)callSite.getParent())) {
                InlineUtil.extractReturnValues(methodCopy, false);
                returnType = PsiType.VOID;
            }
            PsiCodeBlock block = Objects.requireNonNull(methodCopy.getBody());
            List<PsiReturnStatement> returns = Arrays.asList(PsiUtil.findReturnStatements((PsiCodeBlock)block));
            FinishMarker marker = FinishMarker.defineFinishMarker(block, returnType, returns);
            return ConvertToSingleReturnAction.convertReturns(methodCopy.getProject(), block, returnType, marker, returns.size(), (ProgressIndicator)new EmptyProgressIndicator());
        }
    }

    public static class NormalTransformer
    implements InlineTransformer {
        @Override
        public PsiLocalVariable transformBody(PsiMethod methodCopy, PsiReferenceExpression callSite, PsiType returnType) {
            if (returnType == null || PsiType.VOID.equals((Object)returnType) || callSite.getParent() instanceof PsiMethodCallExpression && ExpressionUtils.isVoidContext((PsiExpression)callSite.getParent())) {
                InlineUtil.extractReturnValues(methodCopy, false);
                return null;
            }
            PsiCodeBlock block = Objects.requireNonNull(methodCopy.getBody());
            Project project = methodCopy.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String resultName = new VariableNameGenerator((PsiElement)block, VariableKind.LOCAL_VARIABLE).byName("result", "res").generate(true);
            PsiDeclarationStatement declaration2 = factory.createVariableDeclarationStatement(resultName, returnType, null);
            declaration2 = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration2, null);
            PsiLocalVariable resultVar = (PsiLocalVariable)declaration2.getDeclaredElements()[0];
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            for (PsiReturnStatement returnStatement : PsiUtil.findReturnStatements((PsiCodeBlock)block)) {
                PsiExpression returnValue = returnStatement.getReturnValue();
                if (returnValue == null) continue;
                PsiStatement statement = factory.createStatementFromText(resultName + "=0;", null);
                statement = (PsiStatement)codeStyleManager.reformat((PsiElement)statement);
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)((PsiExpressionStatement)statement).getExpression();
                Objects.requireNonNull(assignment.getRExpression()).replace((PsiElement)returnValue);
                returnStatement.replace((PsiElement)statement);
            }
            return resultVar;
        }
    }
}

