/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionAccessMethodBuilder {
    private static final Logger LOG = Logger.getInstance(ReflectionAccessMethodBuilder.class);
    private boolean myIsStatic;
    private String myReturnType;
    private final String myName;
    private MyMemberAccessor myMemberAccessor;
    private final List<ParameterInfo> myParameters;

    public ReflectionAccessMethodBuilder(@NotNull String name2) {
        if (name2 == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(0);
        }
        this.myIsStatic = false;
        this.myReturnType = "void";
        this.myParameters = new SmartList();
        this.myName = name2;
    }

    public PsiMethod build(@NotNull PsiElementFactory elementFactory, @Nullable PsiElement context) {
        if (elementFactory == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(1);
        }
        this.checkRequirements();
        String parameters2 = StreamEx.of(this.myParameters).map(p -> p.accessibleType + " " + p.name).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String returnExpression2 = ("void".equals(this.myReturnType) ? "member." : "return (" + this.myReturnType + ")member.") + this.myMemberAccessor.getAccessExpression();
        String methodBody2 = "  java.lang.Class<?> klass = " + this.myMemberAccessor.getClassLookupExpression() + ";\n  " + this.myMemberAccessor.getMemberType() + " member = null;\n  int interfaceNumber = -1;\n  Class<?>[] interfaces = null;\n  while (member == null) {\n    try {\n      member = klass." + this.myMemberAccessor.getMemberLookupExpression() + ";\n    } catch (java.lang.ReflectiveOperationException e) {\n      if (interfaceNumber == -1) {\n        interfaces = klass.getInterfaces();\n        interfaceNumber = 0;\n      }\n      if (interfaceNumber < interfaces.length) {\n        klass = interfaces[interfaceNumber];\n        interfaceNumber += 1;\n      } else {\n        klass = klass.getSuperclass();\n        if (klass == null) throw e;\n        interfaceNumber = -1;\n      }\n    }\n  }\n  member.setAccessible(true);\n  " + returnExpression2 + ";\n";
        List<String> possibleExceptions = this.myMemberAccessor.getPossibleExceptions();
        if (!possibleExceptions.isEmpty()) {
            methodBody2 = "try {\n" + methodBody2 + "}" + ReflectionAccessMethodBuilder.createCatchBlocks(possibleExceptions);
        }
        String methodText = "public" + (this.myIsStatic ? " static " : " ") + this.myReturnType + " " + this.myName + parameters2 + " { \n" + methodBody2 + "}\n";
        return elementFactory.createMethodFromText(methodText, context);
    }

    private void checkRequirements() {
        if (this.myMemberAccessor == null) {
            LOG.error("Accessed member not specified");
        }
    }

    public ReflectionAccessMethodBuilder accessedMethod(@NotNull String jvmClassName, @NotNull String methodName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(3);
        }
        this.myMemberAccessor = new MyMethodAccessor(jvmClassName, methodName);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(5);
        }
        this.myMemberAccessor = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.GET);
        return this;
    }

    public ReflectionAccessMethodBuilder updatedField(@NotNull String jvmClassName, @NotNull String fieldName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(6);
        }
        if (fieldName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(7);
        }
        this.myMemberAccessor = new MyFieldAccessor(jvmClassName, fieldName, FieldAccessType.SET);
        return this;
    }

    public ReflectionAccessMethodBuilder accessedConstructor(@NotNull String jvmClassName) {
        if (jvmClassName == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(8);
        }
        this.myMemberAccessor = new MyConstructorAccessor(jvmClassName);
        return this;
    }

    public ReflectionAccessMethodBuilder setReturnType(@NotNull String returnType) {
        if (returnType == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(9);
        }
        this.myReturnType = returnType;
        return this;
    }

    public ReflectionAccessMethodBuilder setStatic(boolean isStatic) {
        this.myIsStatic = isStatic;
        return this;
    }

    public ReflectionAccessMethodBuilder addParameter(@NotNull String jvmType, @NotNull String name2) {
        if (jvmType == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(10);
        }
        if (name2 == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(11);
        }
        this.myParameters.add(new ParameterInfo(jvmType.replace('$', '.'), name2, jvmType));
        return this;
    }

    public ReflectionAccessMethodBuilder addParameters(@NotNull PsiParameterList parameterList) {
        if (parameterList == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(12);
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            PsiType parameterType = parameter2.getType();
            PsiType erasedType = TypeConversionUtil.erasure((PsiType)parameterType);
            String typeName = ReflectionAccessMethodBuilder.typeName(parameterType, erasedType);
            String jvmType = erasedType != null ? ReflectionAccessMethodBuilder.extractJvmType(erasedType) : typeName;
            String name2 = parameter2.getName();
            if (name2 == null) {
                LOG.warn("Parameter name not found, index = " + i + ", type = " + typeName);
                name2 = "arg" + i;
            }
            PsiType accessedType = erasedType != null ? PsiReflectionAccessUtil.nearestAccessibleType(erasedType) : PsiReflectionAccessUtil.nearestAccessibleType(parameterType);
            this.myParameters.add(new ParameterInfo(accessedType.getCanonicalText(), name2, jvmType));
        }
        return this;
    }

    @NotNull
    private static String typeName(@NotNull PsiType type2, @Nullable PsiType erasedType) {
        if (type2 == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(13);
        }
        if (erasedType == null) {
            String typeName = type2.getCanonicalText();
            int typeParameterIndex = typeName.indexOf(60);
            if (typeParameterIndex != -1) {
                typeName = typeName.substring(0, typeParameterIndex);
            }
            LOG.warn("Type erasure failed, the following type used instead: " + typeName);
            String string = typeName;
            if (string == null) {
                ReflectionAccessMethodBuilder.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = erasedType.getCanonicalText();
        if (string == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String extractJvmType(@NotNull PsiType type2) {
        if (type2 == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(16);
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        String canonicalText = type2.getCanonicalText();
        String jvmName = psiClass == null ? canonicalText : ClassUtil.getJVMClassName((PsiClass)psiClass);
        String string = jvmName == null ? canonicalText : jvmName;
        if (string == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static String createCatchBlocks(@NotNull List<String> exceptions) {
        if (exceptions == null) {
            ReflectionAccessMethodBuilder.$$$reportNull$$$0(18);
        }
        return StreamEx.of(exceptions).map(x -> "catch(" + x + " e) { throw new java.lang.RuntimeException(e); }").joining((CharSequence)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "typeName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractJvmType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accessedMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accessedField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updatedField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accessedConstructor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setReturnType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "typeName";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractJvmType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCatchBlocks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyConstructorAccessor
    implements MyMemberAccessor {
        private final String myClassName;

        MyConstructorAccessor(String className2) {
            if (className2 == null) {
                MyConstructorAccessor.$$$reportNull$$$0(0);
            }
            this.myClassName = className2;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.jvmTypeName).map(PsiReflectionAccessUtil::classForName).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredConstructor" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getAccessExpression() {
            String args = StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.name).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "newInstance" + args;
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Constructor<?>";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyConstructorAccessor", "<init>"));
        }
    }

    private class MyMethodAccessor
    implements MyMemberAccessor {
        private final String myClassName;
        private final String myMethodName;

        MyMethodAccessor(@NotNull String className2, String methodName) {
            if (className2 == null) {
                MyMethodAccessor.$$$reportNull$$$0(0);
            }
            if (methodName == null) {
                MyMethodAccessor.$$$reportNull$$$0(1);
            }
            this.myClassName = className2;
            this.myMethodName = methodName;
        }

        @Override
        public String getMemberLookupExpression() {
            String args = ((StreamEx)StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).skip(1L)).map(x -> PsiReflectionAccessUtil.classForName(x.jvmTypeName)).prepend((Object)StringUtil.wrapWithDoubleQuote((String)this.myMethodName)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
            return "getDeclaredMethod" + args;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Method";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        }

        @Override
        public String getAccessExpression() {
            return StreamEx.of((Collection)ReflectionAccessMethodBuilder.this.myParameters).map(x -> x.name).joining((CharSequence)", ", (CharSequence)"invoke(", (CharSequence)")");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyMethodAccessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyFieldAccessor
    implements MyMemberAccessor {
        private static final List<String> EXCEPTIONS = Collections.unmodifiableList(Collections.singletonList("java.lang.ReflectiveOperationException"));
        private final String myFieldName;
        private final String myClassName;
        private final FieldAccessType myAccessType;

        MyFieldAccessor(@NotNull String className2, @NotNull String fieldName, @NotNull FieldAccessType accessType) {
            if (className2 == null) {
                MyFieldAccessor.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                MyFieldAccessor.$$$reportNull$$$0(1);
            }
            if (accessType == null) {
                MyFieldAccessor.$$$reportNull$$$0(2);
            }
            this.myFieldName = fieldName;
            this.myClassName = className2;
            this.myAccessType = accessType;
        }

        @Override
        public String getClassLookupExpression() {
            return PsiReflectionAccessUtil.classForName(this.myClassName);
        }

        @Override
        public String getMemberLookupExpression() {
            return "getDeclaredField(" + StringUtil.wrapWithDoubleQuote((String)this.myFieldName) + ")";
        }

        @Override
        public String getAccessExpression() {
            return FieldAccessType.GET.equals((Object)this.myAccessType) ? "get(object)" : "set(object, value)";
        }

        @Override
        public String getMemberType() {
            return "java.lang.reflect.Field";
        }

        @Override
        public List<String> getPossibleExceptions() {
            return EXCEPTIONS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$MyFieldAccessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface MyMemberAccessor {
        public String getMemberLookupExpression();

        public String getClassLookupExpression();

        public String getAccessExpression();

        public String getMemberType();

        public List<String> getPossibleExceptions();
    }

    private static class ParameterInfo {
        public final String accessibleType;
        public final String name;
        public final String jvmTypeName;

        ParameterInfo(@NotNull String accessibleType, @NotNull String name2, @NotNull String jvmTypeName) {
            if (accessibleType == null) {
                ParameterInfo.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                ParameterInfo.$$$reportNull$$$0(1);
            }
            if (jvmTypeName == null) {
                ParameterInfo.$$$reportNull$$$0(2);
            }
            this.accessibleType = accessibleType;
            this.name = name2;
            this.jvmTypeName = jvmTypeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "accessibleType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jvmTypeName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessMethodBuilder$ParameterInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

