/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDeclarationDescriptor
implements ItemToReplaceDescriptor {
    private final List<AccessibleLocalVariable> myVariables;
    private final PsiDeclarationStatement myDeclarationStatement;

    public LocalVariableDeclarationDescriptor(@NotNull List<AccessibleLocalVariable> names, PsiDeclarationStatement statement) {
        if (names == null) {
            LocalVariableDeclarationDescriptor.$$$reportNull$$$0(0);
        }
        this.myVariables = names;
        this.myDeclarationStatement = statement;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiDeclarationStatement declarationStatement) {
        if (declarationStatement == null) {
            LocalVariableDeclarationDescriptor.$$$reportNull$$$0(1);
        }
        ArrayList<AccessibleLocalVariable> variables = new ArrayList<AccessibleLocalVariable>();
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            if (!(element instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)element;
            String name2 = variable.getName();
            PsiType variableType = variable.getType();
            if (name2 == null || PsiReflectionAccessUtil.isAccessibleType(variableType)) continue;
            variables.add(new AccessibleLocalVariable(name2, PsiReflectionAccessUtil.nearestAccessibleType(variableType), variable));
        }
        if (!variables.isEmpty()) {
            return new LocalVariableDeclarationDescriptor(variables, declarationStatement);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        if (outerClass == null) {
            LocalVariableDeclarationDescriptor.$$$reportNull$$$0(2);
        }
        if (elementFactory == null) {
            LocalVariableDeclarationDescriptor.$$$reportNull$$$0(3);
        }
        if (callExpression == null) {
            LocalVariableDeclarationDescriptor.$$$reportNull$$$0(4);
        }
        AccessibleLocalVariable variable = this.myVariables.get(0);
        PsiDeclarationStatement lastDeclaration = variable.toVariableDeclaration(elementFactory);
        this.myDeclarationStatement.replace((PsiElement)lastDeclaration);
        for (int i = 1; i < this.myVariables.size(); ++i) {
            variable = this.myVariables.get(i);
            PsiDeclarationStatement declaration2 = variable.toVariableDeclaration(elementFactory);
            lastDeclaration.getParent().addAfter((PsiElement)declaration2, (PsiElement)lastDeclaration);
            lastDeclaration = declaration2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/LocalVariableDeclarationDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfInaccessible";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AccessibleLocalVariable {
        private final String myName;
        private final PsiType myAccessibleType;
        private final PsiLocalVariable myLocalVariable;

        private AccessibleLocalVariable(@NotNull String name2, @NotNull PsiType type2, @NotNull PsiLocalVariable localVariable) {
            if (name2 == null) {
                AccessibleLocalVariable.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                AccessibleLocalVariable.$$$reportNull$$$0(1);
            }
            if (localVariable == null) {
                AccessibleLocalVariable.$$$reportNull$$$0(2);
            }
            this.myName = name2;
            this.myAccessibleType = type2;
            this.myLocalVariable = localVariable;
        }

        private PsiDeclarationStatement toVariableDeclaration(@NotNull PsiElementFactory elementFactory) {
            if (elementFactory == null) {
                AccessibleLocalVariable.$$$reportNull$$$0(3);
            }
            return elementFactory.createVariableDeclarationStatement(this.myName, this.myAccessibleType, this.myLocalVariable.getInitializer(), (PsiElement)this.myLocalVariable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localVariable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementFactory";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/LocalVariableDeclarationDescriptor$AccessibleLocalVariable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toVariableDeclaration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

