/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(ConstructorDescriptor.class);
    private final PsiNewExpression myNewExpression;
    private final PsiClass myPsiClass;
    @Nullable
    private final PsiMethod myConstructor;

    private ConstructorDescriptor(@NotNull PsiNewExpression expression2, @Nullable PsiMethod constructor, @NotNull PsiClass psiClass) {
        if (expression2 == null) {
            ConstructorDescriptor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ConstructorDescriptor.$$$reportNull$$$0(1);
        }
        this.myNewExpression = expression2;
        this.myConstructor = constructor;
        this.myPsiClass = psiClass;
    }

    @Nullable
    public static ConstructorDescriptor createIfInaccessible(@NotNull PsiNewExpression expression2) {
        PsiMethod constructor;
        if (expression2 == null) {
            ConstructorDescriptor.$$$reportNull$$$0(2);
        }
        if ((constructor = expression2.resolveConstructor()) != null) {
            PsiClass containingClass = constructor.getContainingClass();
            if (containingClass != null && !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)constructor)) {
                return new ConstructorDescriptor(expression2, constructor, containingClass);
            }
        } else {
            PsiElement referent;
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
            PsiElement psiElement = referent = classReference2 != null ? classReference2.resolve() : null;
            if (referent instanceof PsiClass && !PsiReflectionAccessUtil.isAccessible((PsiClass)referent)) {
                return new ConstructorDescriptor(expression2, null, (PsiClass)referent);
            }
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        if (outerClass == null) {
            ConstructorDescriptor.$$$reportNull$$$0(3);
        }
        if (elementFactory == null) {
            ConstructorDescriptor.$$$reportNull$$$0(4);
        }
        if (callExpression == null) {
            ConstructorDescriptor.$$$reportNull$$$0(5);
        }
        String className2 = ClassUtil.getJVMClassName((PsiClass)this.myPsiClass);
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myNewExpression, this.myPsiClass);
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        if (className2 == null || argumentList == null || returnType == null) {
            LOG.warn("code is incomplete: " + this.myNewExpression);
            return;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, ConstructorDescriptor.methodName(className2));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        methodBuilder.accessedConstructor(className2).setStatic(outerClass.hasModifierProperty("static")).setReturnType(returnType);
        if (this.myConstructor != null) {
            methodBuilder.addParameters(this.myConstructor.getParameterList());
        }
        PsiMethod newPsiMethod = methodBuilder.build(elementFactory, (PsiElement)outerClass);
        outerClass.add((PsiElement)newPsiMethod);
        String args = StreamEx.of((Object[])argumentList.getExpressions()).map(x -> x.getText()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String newCallExpression = newPsiMethod.getName() + args;
        this.myNewExpression.replace((PsiElement)elementFactory.createExpressionFromText(newCallExpression, (PsiElement)this.myNewExpression));
    }

    @NotNull
    private static String methodName(@NotNull String jvmClassName) {
        if (jvmClassName == null) {
            ConstructorDescriptor.$$$reportNull$$$0(6);
        }
        String name2 = StringUtil.getShortName((String)jvmClassName);
        String string = "new" + StringUtil.capitalize((String)name2);
        if (string == null) {
            ConstructorDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ConstructorDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createIfInaccessible";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "methodName";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

