/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ReusedLocalVariable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReusedLocalVariablesFinder {
    private final ControlFlow myControlFlow;
    private final PsiStatement myNextStatement;
    private final int myOffset;
    private final JavaCodeStyleManager myCodeStyleManager;

    private ReusedLocalVariablesFinder(@NotNull ControlFlow controlFlow, @NotNull PsiStatement nextStatement, int offset) {
        if (controlFlow == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(0);
        }
        if (nextStatement == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(1);
        }
        this.myControlFlow = controlFlow;
        this.myNextStatement = nextStatement;
        this.myOffset = offset;
        this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myNextStatement.getProject());
    }

    public static List<ReusedLocalVariable> findReusedLocalVariables(@NotNull PsiElement fragmentStart, @NotNull PsiElement fragmentEnd, @NotNull Set<PsiLocalVariable> ignoreVariables, @NotNull InputVariables inputVariables) {
        List<PsiLocalVariable> declaredVariables;
        if (fragmentStart == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(2);
        }
        if (fragmentEnd == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(3);
        }
        if (ignoreVariables == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(4);
        }
        if (inputVariables == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(5);
        }
        if ((declaredVariables = ReusedLocalVariablesFinder.getDeclaredVariables(fragmentStart, fragmentEnd, ignoreVariables)).isEmpty()) {
            return Collections.emptyList();
        }
        ReusedLocalVariablesFinder finder = ReusedLocalVariablesFinder.createFinder(fragmentEnd);
        if (finder == null) {
            return Collections.emptyList();
        }
        List reusedVariables = ContainerUtil.filter(declaredVariables, finder::isVariableReused);
        if (reusedVariables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReusedLocalVariable> result = new ArrayList<ReusedLocalVariable>();
        HashSet<String> tempNames = new HashSet<String>(ContainerUtil.map(inputVariables.getInputVariables(), data -> data.name));
        for (PsiLocalVariable variable : reusedVariables) {
            String name2 = variable.getName();
            if (name2 == null) continue;
            String typeText = variable.getType().getCanonicalText();
            if (finder.isValueReused((PsiVariable)variable)) {
                String suggestedName = finder.suggestUniqueVariableName(name2);
                String tempName = UniqueNameGenerator.generateUniqueName((String)suggestedName, tempNames);
                tempNames.add(tempName);
                result.add(new ReusedLocalVariable(name2, tempName, typeText, true));
                continue;
            }
            result.add(new ReusedLocalVariable(name2, null, typeText, false));
        }
        return result;
    }

    private static List<PsiLocalVariable> getDeclaredVariables(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull Set<PsiLocalVariable> ignoreVariables) {
        if (start == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(6);
        }
        if (end == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(7);
        }
        if (ignoreVariables == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(8);
        }
        SmartList result = new SmartList();
        PsiElement element = start;
        while (element != null) {
            if (element instanceof PsiDeclarationStatement) {
                PsiElement[] declaredElements;
                for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiLocalVariable) || ignoreVariables.contains(declaredElement)) continue;
                    result.add((PsiLocalVariable)declaredElement);
                }
            }
            element = element != end ? element.getNextSibling() : null;
        }
        return result;
    }

    @Nullable
    private static ReusedLocalVariablesFinder createFinder(@NotNull PsiElement fragmentEnd) {
        ControlFlow controlFlow;
        PsiStatement nextStatement;
        if (fragmentEnd == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(9);
        }
        if ((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)fragmentEnd, PsiStatement.class)) == null) {
            return null;
        }
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment((PsiElement)nextStatement);
        try {
            controlFlow = ControlFlowFactory.getInstance(codeFragment.getProject()).getControlFlow(codeFragment, new LocalsControlFlowPolicy(codeFragment), false, false);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
        int offset = controlFlow.getStartOffset((PsiElement)nextStatement);
        if (offset < 0) {
            return null;
        }
        return new ReusedLocalVariablesFinder(controlFlow, nextStatement, offset);
    }

    private boolean isVariableReused(@NotNull PsiVariable variable) {
        if (variable == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(10);
        }
        return ControlFlowUtil.isVariableUsed(this.myControlFlow, this.myOffset, this.myControlFlow.getSize(), variable);
    }

    private boolean isValueReused(@NotNull PsiVariable variable) {
        if (variable == null) {
            ReusedLocalVariablesFinder.$$$reportNull$$$0(11);
        }
        return ControlFlowUtil.needVariableValueAt(variable, this.myControlFlow, this.myOffset);
    }

    private String suggestUniqueVariableName(String name2) {
        return this.myCodeStyleManager.suggestUniqueVariableName(name2, (PsiElement)this.myNextStatement, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentStart";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentEnd";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreVariables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/ReusedLocalVariablesFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReusedLocalVariables";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclaredVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createFinder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableReused";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isValueReused";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

