/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ReusedLocalVariable;
import com.intellij.refactoring.extractMethod.ReusedLocalVariablesFinder;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.ExtractedParameter;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametrizedDuplicates {
    private static final Logger LOG = Logger.getInstance(ParametrizedDuplicates.class);
    private final PsiElement[] myElements;
    private List<Match> myMatches;
    private List<ClusterOfUsages> myUsagesList;
    private PsiMethod myParametrizedMethod;
    private PsiMethodCallExpression myParametrizedCall;
    private VariableData[] myVariableDatum;

    private ParametrizedDuplicates(@NotNull PsiElement[] pattern, @NotNull ExtractMethodProcessor originalProcessor) {
        PsiElement firstElement;
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(0);
        }
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(1);
        }
        PsiElement[] filteredPattern = ParametrizedDuplicates.getFilteredElements(pattern);
        PsiElement psiElement = firstElement = filteredPattern.length != 0 ? filteredPattern[0] : null;
        if (firstElement instanceof PsiStatement) {
            PsiElement[] copy = ParametrizedDuplicates.copyElements(pattern);
            this.myElements = ParametrizedDuplicates.wrapWithCodeBlock(copy, originalProcessor.getInputVariables());
        } else if (firstElement instanceof PsiExpression) {
            PsiElement[] psiElementArray;
            PsiElement[] copy = ParametrizedDuplicates.copyElements(pattern);
            PsiExpression wrapped = ParametrizedDuplicates.wrapExpressionWithCodeBlock(copy, originalProcessor);
            if (wrapped != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = wrapped;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            this.myElements = psiElementArray;
        } else {
            this.myElements = PsiElement.EMPTY_ARRAY;
        }
    }

    private static PsiElement[] copyElements(@NotNull PsiElement[] pattern) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(2);
        }
        Project project = pattern[0].getProject();
        return IntroduceParameterHandler.getElementsInCopy(project, pattern[0].getContainingFile(), pattern, false);
    }

    @Nullable
    public static ParametrizedDuplicates findDuplicates(@NotNull ExtractMethodProcessor originalProcessor, @NotNull DuplicatesFinder.MatchType matchType, @Nullable Set<? extends TextRange> textRanges) {
        DuplicatesFinder finder;
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(3);
        }
        if (matchType == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(4);
        }
        if ((finder = ParametrizedDuplicates.createDuplicatesFinder(originalProcessor, matchType, textRanges)) == null) {
            return null;
        }
        List<Match> matches = finder.findDuplicates((PsiElement)originalProcessor.myTargetClass);
        if ((matches = ParametrizedDuplicates.filterNestedSubexpressions(matches)).isEmpty()) {
            return null;
        }
        Map<PsiExpression, String> predefinedNames = ParametrizedDuplicates.foldParameters(originalProcessor, matches);
        PsiElement[] pattern = originalProcessor.myElements;
        ParametrizedDuplicates duplicates = new ParametrizedDuplicates(pattern, originalProcessor);
        if (!duplicates.initMatches(pattern, matches)) {
            return null;
        }
        if (!duplicates.extract(originalProcessor, predefinedNames)) {
            return null;
        }
        return duplicates;
    }

    @NotNull
    private static Map<PsiExpression, String> foldParameters(ExtractMethodProcessor originalProcessor, List<Match> matches) {
        if (matches.isEmpty() || !originalProcessor.getInputVariables().isFoldable()) {
            Map<PsiExpression, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                ParametrizedDuplicates.$$$reportNull$$$0(5);
            }
            return map2;
        }
        DuplicatesFinder finder = ParametrizedDuplicates.createDuplicatesFinder(originalProcessor, DuplicatesFinder.MatchType.FOLDED, null);
        if (finder == null) {
            Map<PsiExpression, String> map3 = Collections.emptyMap();
            if (map3 == null) {
                ParametrizedDuplicates.$$$reportNull$$$0(6);
            }
            return map3;
        }
        HashMap<Match, Match> foldedMatches = new HashMap<Match, Match>();
        LinkedHashMap<DuplicatesFinder.Parameter, VariableData> parametersToFold = new LinkedHashMap<DuplicatesFinder.Parameter, VariableData>();
        for (VariableData data : originalProcessor.getInputVariables().getInputVariables()) {
            parametersToFold.put(new DuplicatesFinder.Parameter(data.variable, data.type, true), data);
        }
        for (Match match : matches) {
            Match foldedMatch = finder.isDuplicate(match.getMatchStart(), false);
            LOG.assertTrue(foldedMatch != null, (Object)"folded match should exist");
            LOG.assertTrue(match.getMatchStart() == foldedMatch.getMatchStart() && match.getMatchEnd() == foldedMatch.getMatchEnd(), (Object)"folded match range should be the same");
            foldedMatches.put(match, foldedMatch);
            parametersToFold.keySet().removeIf(parameter2 -> !ParametrizedDuplicates.canFoldParameter(match, foldedMatch, parameter2));
        }
        if (parametersToFold.isEmpty()) {
            Map<PsiExpression, String> map4 = Collections.emptyMap();
            if (map4 == null) {
                ParametrizedDuplicates.$$$reportNull$$$0(7);
            }
            return map4;
        }
        HashMap<PsiExpression, String> predefinedNames = new HashMap<PsiExpression, String>();
        for (Match match : matches) {
            Match foldedMatch = (Match)foldedMatches.get(match);
            LOG.assertTrue(foldedMatch != null, (Object)"folded match");
            for (Map.Entry entry : parametersToFold.entrySet()) {
                DuplicatesFinder.Parameter parameter3 = (DuplicatesFinder.Parameter)entry.getKey();
                VariableData variableData = (VariableData)((Object)entry.getValue());
                List<Pair.NonNull<PsiExpression, PsiExpression>> expressionMappings = foldedMatch.getFoldedExpressionMappings(parameter3);
                LOG.assertTrue(!ContainerUtil.isEmpty(expressionMappings), (Object)"foldedExpressionMappings can't be empty");
                PsiType type2 = parameter3.getType();
                ExtractedParameter extractedParameter = null;
                for (Pair.NonNull<PsiExpression, PsiExpression> expressionMapping : expressionMappings) {
                    PsiExpression patternExpression = (PsiExpression)expressionMapping.getFirst();
                    ExtractableExpressionPart patternPart = ExtractableExpressionPart.fromUsage(patternExpression, type2);
                    if (extractedParameter == null) {
                        PsiExpression candidateExpression = (PsiExpression)expressionMapping.getSecond();
                        ExtractableExpressionPart candidatePart = ExtractableExpressionPart.fromUsage(candidateExpression, type2);
                        extractedParameter = new ExtractedParameter(patternPart, candidatePart, type2);
                    } else {
                        extractedParameter.addUsages(patternPart);
                    }
                    predefinedNames.put(patternExpression, variableData.name);
                }
                LOG.assertTrue(extractedParameter != null, (Object)"extractedParameter can't be null");
                match.getExtractedParameters().add(extractedParameter);
            }
        }
        HashMap<PsiExpression, String> hashMap = predefinedNames;
        if (hashMap == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    private static boolean canFoldParameter(Match match, Match foldedMatch, DuplicatesFinder.Parameter parameter2) {
        List<Pair.NonNull<PsiExpression, PsiExpression>> expressionMappings = foldedMatch.getFoldedExpressionMappings(parameter2);
        if (ContainerUtil.isEmpty(expressionMappings)) {
            return false;
        }
        for (Pair.NonNull<PsiExpression, PsiExpression> expressionMapping : expressionMappings) {
            PsiExpression patternExpression = (PsiExpression)expressionMapping.getFirst();
            for (ExtractedParameter extractedParameter : match.getExtractedParameters()) {
                for (PsiExpression extractedUsage : extractedParameter.myPatternUsages) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)patternExpression, (PsiElement)extractedUsage, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)extractedUsage, (PsiElement)patternExpression, (boolean)false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static DuplicatesFinder createDuplicatesFinder(@NotNull ExtractMethodProcessor processor, @NotNull DuplicatesFinder.MatchType matchType, @Nullable Set<? extends TextRange> textRanges) {
        PsiElement[] elements;
        if (processor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(9);
        }
        if (matchType == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(10);
        }
        if ((elements = ParametrizedDuplicates.getFilteredElements(processor.myElements)).length == 0) {
            return null;
        }
        Set<PsiVariable> effectivelyLocal = processor.getEffectivelyLocalVariables();
        InputVariables inputVariables = matchType == DuplicatesFinder.MatchType.PARAMETRIZED ? processor.myInputVariables.copyWithoutFolding() : processor.myInputVariables;
        VariableReturnValue returnValue = processor.myOutputVariable != null ? new VariableReturnValue(processor.myOutputVariable) : null;
        return new DuplicatesFinder(elements, inputVariables, returnValue, Collections.emptyList(), matchType, effectivelyLocal, textRanges);
    }

    @NotNull
    public PsiMethod replaceMethod(@NotNull PsiMethod originalMethod) {
        if (originalMethod == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(11);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalMethod.getProject());
        String text2 = this.myParametrizedMethod.getText();
        PsiMethod method = factory.createMethodFromText(text2, originalMethod.getParent());
        PsiMethod psiMethod = (PsiMethod)originalMethod.replace((PsiElement)method);
        if (psiMethod == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(12);
        }
        return psiMethod;
    }

    @NotNull
    public PsiMethodCallExpression replaceCall(@NotNull PsiMethodCallExpression originalCall) {
        if (originalCall == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(13);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)originalCall.getProject());
        String text2 = this.myParametrizedCall.getText();
        PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(text2, originalCall.getParent());
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)originalCall.replace((PsiElement)call);
        if (psiMethodCallExpression == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(14);
        }
        return psiMethodCallExpression;
    }

    private boolean initMatches(@NotNull PsiElement[] pattern, @NotNull List<Match> matches) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(15);
        }
        if (matches == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(16);
        }
        if (this.myElements.length == 0) {
            return false;
        }
        this.myUsagesList = new ArrayList<ClusterOfUsages>();
        THashMap usagesMap = new THashMap();
        THashSet badMatches = new THashSet();
        for (Match match : matches) {
            List<ClusterOfUsages> usagesInMatch = ParametrizedDuplicates.getUsagesInMatch((Map<PsiExpression, ClusterOfUsages>)usagesMap, match);
            if (usagesInMatch == null) {
                badMatches.add(match);
                continue;
            }
            for (ClusterOfUsages usages2 : usagesInMatch) {
                this.myUsagesList.add(usages2);
                for (PsiExpression expression2 : usages2.myPatterns) {
                    usagesMap.put(expression2, usages2);
                }
            }
        }
        if (!badMatches.isEmpty()) {
            matches = new ArrayList<Match>(matches);
            matches.removeAll((Collection<?>)badMatches);
        }
        this.myMatches = matches;
        if (this.myMatches.isEmpty()) {
            return false;
        }
        HashMap<Match, Map> expressionsMapping = new HashMap<Match, Map>();
        for (ClusterOfUsages usages3 : this.myUsagesList) {
            for (Match match : this.myMatches) {
                ExtractedParameter parameter2 = usages3.getParameter(match);
                if (parameter2 != null) continue;
                Map expressions2 = expressionsMapping.computeIfAbsent(match, arg_0 -> ParametrizedDuplicates.lambda$initMatches$2(pattern, match, (Map)usagesMap, arg_0));
                PsiExpression candidateUsage = usages3.myPatterns.stream().map(expressions2::get).findAny().orElse(null);
                LOG.assertTrue(candidateUsage != null, (Object)"candidateUsage shouldn't be null");
                ExtractedParameter fromParameter = usages3.myParameter;
                parameter2 = fromParameter.copyWithCandidateUsage(candidateUsage);
                match.addExtractedParameter(parameter2);
                usages3.putParameter(match, parameter2);
            }
        }
        ParametrizedDuplicates.mergeDuplicateUsages(this.myUsagesList, this.myMatches);
        this.myUsagesList.sort(Comparator.comparing(usages -> ((ClusterOfUsages)usages).myFirstOffset));
        return true;
    }

    private static void mergeDuplicateUsages(@NotNull List<? extends ClusterOfUsages> usagesList, @NotNull List<Match> matches) {
        if (usagesList == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(17);
        }
        if (matches == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(18);
        }
        THashSet duplicateUsages = new THashSet();
        for (int i = 0; i < usagesList.size(); ++i) {
            ClusterOfUsages usages = usagesList.get(i);
            if (duplicateUsages.contains(usages)) continue;
            for (int j = i + 1; j < usagesList.size(); ++j) {
                ClusterOfUsages otherUsages = usagesList.get(j);
                if (!usages.isEquivalent(otherUsages, matches)) continue;
                for (Match match : matches) {
                    ExtractedParameter parameter2 = usages.getParameter(match);
                    ExtractedParameter otherParameter = otherUsages.getParameter(match);
                    if (parameter2 == null || otherParameter == null) continue;
                    parameter2.addUsages(otherParameter.myPattern);
                    match.getExtractedParameters().remove(otherParameter);
                }
                duplicateUsages.add(otherUsages);
            }
        }
        usagesList.removeAll((Collection<?>)duplicateUsages);
    }

    private static List<Match> filterNestedSubexpressions(List<Match> matches) {
        THashMap patternUsages = new THashMap();
        for (Match match : matches) {
            for (ExtractedParameter parameter2 : match.getExtractedParameters()) {
                for (PsiExpression patternUsage : parameter2.myPatternUsages) {
                    patternUsages.computeIfAbsent(patternUsage, k -> new THashSet()).add(match);
                }
            }
        }
        THashSet badMatches = new THashSet();
        block3: for (Map.Entry entry : patternUsages.entrySet()) {
            PsiExpression patternUsage = (PsiExpression)entry.getKey();
            Set patternMatches = (Set)entry.getValue();
            for (PsiExpression maybeNestedUsage : patternUsages.keySet()) {
                if (patternUsage == maybeNestedUsage || !PsiTreeUtil.isAncestor((PsiElement)patternUsage, (PsiElement)maybeNestedUsage, (boolean)true)) continue;
                badMatches.addAll(patternMatches);
                continue block3;
            }
        }
        if (!badMatches.isEmpty()) {
            matches = new ArrayList<Match>(matches);
            matches.removeAll((Collection<?>)badMatches);
        }
        return matches;
    }

    @Nullable
    private static List<ClusterOfUsages> getUsagesInMatch(@NotNull Map<PsiExpression, ClusterOfUsages> usagesMap, @NotNull Match match) {
        if (usagesMap == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(19);
        }
        if (match == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(20);
        }
        ArrayList<ClusterOfUsages> result = new ArrayList<ClusterOfUsages>();
        List<ExtractedParameter> parameters2 = match.getExtractedParameters();
        for (ExtractedParameter parameter2 : parameters2) {
            ClusterOfUsages usages = usagesMap.get(parameter2.myPattern.getUsage());
            if (usages != null && !usages.arePatternsEquivalent(parameter2) || usages == null && ClusterOfUsages.isPatternPresent(usagesMap, parameter2)) {
                return null;
            }
            if (usages == null) {
                usages = new ClusterOfUsages(parameter2);
                result.add(usages);
            }
            usages.putParameter(match, parameter2);
        }
        return result;
    }

    private boolean extract(@NotNull ExtractMethodProcessor originalProcessor, @NotNull Map<PsiExpression, String> predefinedNames) {
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(21);
        }
        if (predefinedNames == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(22);
        }
        THashMap expressionsMapping = new THashMap();
        THashMap variablesMapping = new THashMap();
        ParametrizedDuplicates.collectCopyMapping(originalProcessor.myElements, this.myElements, this.myUsagesList, (Map<PsiExpression, PsiExpression>)expressionsMapping, (Map<PsiVariable, PsiVariable>)variablesMapping);
        Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations = this.createParameterDeclarations(originalProcessor, (Map<PsiExpression, PsiExpression>)expressionsMapping, predefinedNames);
        this.putMatchParameters(parameterDeclarations);
        JavaDuplicatesExtractMethodProcessor parametrizedProcessor = new JavaDuplicatesExtractMethodProcessor(this.myElements, ExtractMethodHandler.REFACTORING_NAME);
        if (!parametrizedProcessor.prepare(false)) {
            return false;
        }
        parametrizedProcessor.applyFrom(originalProcessor, (Map<PsiVariable, PsiVariable>)variablesMapping);
        parametrizedProcessor.doExtract();
        this.myParametrizedMethod = parametrizedProcessor.getExtractedMethod();
        this.myParametrizedCall = parametrizedProcessor.getMethodCall();
        this.myVariableDatum = ParametrizedDuplicates.unmapVariableData(parametrizedProcessor.myVariableDatum, (Map<PsiVariable, PsiVariable>)variablesMapping);
        ParametrizedDuplicates.replaceArguments(parameterDeclarations, this.myParametrizedCall);
        return true;
    }

    @NotNull
    private static VariableData[] unmapVariableData(@NotNull VariableData[] variableDatum, @NotNull Map<PsiVariable, PsiVariable> variablesMapping) {
        if (variableDatum == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(23);
        }
        if (variablesMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(24);
        }
        Map reverseMapping = ContainerUtil.reverseMap(variablesMapping);
        VariableData[] variableDataArray = (VariableData[])StreamEx.of((Object[])variableDatum).map(data -> data.substitute((PsiVariable)reverseMapping.get(data.variable))).toArray(VariableData[]::new);
        if (variableDataArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(25);
        }
        return variableDataArray;
    }

    private static void replaceArguments(@NotNull Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations, @NotNull PsiMethodCallExpression parametrizedCall) {
        PsiExpression[] arguments;
        if (parameterDeclarations == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(26);
        }
        if (parametrizedCall == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(27);
        }
        for (PsiExpression argument : arguments = parametrizedCall.getArgumentList().getExpressions()) {
            PsiExpression initializer;
            PsiElement resolved;
            if (!(argument instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)argument).resolve()) instanceof PsiLocalVariable) || !parameterDeclarations.containsKey(resolved) || (initializer = ((PsiLocalVariable)resolved).getInitializer()) == null) continue;
            argument.replace((PsiElement)initializer);
        }
    }

    private void putMatchParameters(@NotNull Map<PsiLocalVariable, ClusterOfUsages> parameterDeclarations) {
        if (parameterDeclarations == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(28);
        }
        THashMap patternUsageToParameter = new THashMap();
        for (Map.Entry<PsiLocalVariable, ClusterOfUsages> entry : parameterDeclarations.entrySet()) {
            PsiExpression usage = ((ClusterOfUsages)entry.getValue()).myParameter.myPattern.getUsage();
            patternUsageToParameter.put(usage, entry.getKey());
        }
        for (Match match : this.myMatches) {
            List<ExtractedParameter> matchedParameters = match.getExtractedParameters();
            for (ExtractedParameter matchedParameter : matchedParameters) {
                PsiLocalVariable localVariable = (PsiLocalVariable)patternUsageToParameter.get(matchedParameter.myPattern.getUsage());
                LOG.assertTrue(localVariable != null, (Object)"match local variable");
                DuplicatesFinder.Parameter parameter2 = new DuplicatesFinder.Parameter((PsiVariable)localVariable, matchedParameter.myType);
                boolean ok = match.putParameter(parameter2, (PsiElement)matchedParameter.myCandidate.getUsage());
                LOG.assertTrue(ok, (Object)"put match parameter");
            }
        }
    }

    public PsiMethod getParametrizedMethod() {
        return this.myParametrizedMethod;
    }

    public PsiMethodCallExpression getParametrizedCall() {
        return this.myParametrizedCall;
    }

    public VariableData[] getVariableDatum() {
        return this.myVariableDatum;
    }

    public int getSize() {
        return this.myMatches != null ? this.myMatches.size() : 0;
    }

    public List<Match> getDuplicates() {
        return this.myMatches;
    }

    boolean isEmpty() {
        return ContainerUtil.isEmpty(this.myMatches);
    }

    @NotNull
    private static PsiElement[] wrapWithCodeBlock(@NotNull PsiElement[] elements, @NotNull InputVariables inputVariables) {
        if (elements == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(29);
        }
        if (inputVariables == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(30);
        }
        PsiElement fragmentStart = elements[0];
        PsiElement fragmentEnd = elements[elements.length - 1];
        List<ReusedLocalVariable> reusedLocalVariables = ReusedLocalVariablesFinder.findReusedLocalVariables(fragmentStart, fragmentEnd, Collections.emptySet(), inputVariables);
        PsiElement parent = fragmentStart.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)fragmentStart.getProject());
        PsiBlockStatement statement = (PsiBlockStatement)factory.createStatementFromText("{}", parent);
        statement.getCodeBlock().addRange(fragmentStart, fragmentEnd);
        statement = (PsiBlockStatement)parent.addBefore((PsiElement)statement, fragmentStart);
        parent.deleteChildRange(fragmentStart, fragmentEnd);
        PsiElement[] elementsInBlock = ParametrizedDuplicates.trimBracesAndWhitespaces(statement.getCodeBlock());
        ParametrizedDuplicates.declareReusedLocalVariables(reusedLocalVariables, statement, factory);
        if (elementsInBlock == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(31);
        }
        return elementsInBlock;
    }

    @NotNull
    private static PsiElement[] trimBracesAndWhitespaces(@NotNull PsiCodeBlock codeBlock) {
        int end;
        int start;
        if (codeBlock == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(32);
        }
        PsiElement[] elements = codeBlock.getChildren();
        for (start = 1; start < elements.length && elements[start] instanceof PsiWhiteSpace; ++start) {
        }
        for (end = elements.length - 1; end > 0 && elements[end - 1] instanceof PsiWhiteSpace; --end) {
        }
        LOG.assertTrue(start < end, (Object)"wrapper block length is too small");
        PsiElement[] psiElementArray = Arrays.copyOfRange(elements, start, end);
        if (psiElementArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(33);
        }
        return psiElementArray;
    }

    private static void declareReusedLocalVariables(@NotNull List<? extends ReusedLocalVariable> reusedLocalVariables, @NotNull PsiBlockStatement statement, @NotNull PsiElementFactory factory) {
        if (reusedLocalVariables == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(34);
        }
        if (statement == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(35);
        }
        if (factory == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(36);
        }
        PsiElement parent = statement.getParent();
        PsiCodeBlock codeBlock = statement.getCodeBlock();
        PsiBlockStatement addAfter = statement;
        for (ReusedLocalVariable reusedLocalVariable : reusedLocalVariables) {
            if (reusedLocalVariable.reuseValue()) {
                PsiStatement declarationBefore = factory.createStatementFromText(reusedLocalVariable.getTempDeclarationText(), (PsiElement)codeBlock.getRBrace());
                parent.addBefore((PsiElement)declarationBefore, (PsiElement)statement);
                PsiStatement assignment = factory.createStatementFromText(reusedLocalVariable.getAssignmentText(), (PsiElement)codeBlock.getRBrace());
                codeBlock.addBefore((PsiElement)assignment, (PsiElement)codeBlock.getRBrace());
            }
            PsiStatement declarationAfter = factory.createStatementFromText(reusedLocalVariable.getDeclarationText(), (PsiElement)statement);
            parent.addAfter((PsiElement)declarationAfter, (PsiElement)addAfter);
            addAfter = declarationAfter;
        }
    }

    @Nullable
    private static PsiExpression wrapExpressionWithCodeBlock(@NotNull PsiElement[] copy, @NotNull ExtractMethodProcessor originalProcessor) {
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(37);
        }
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(38);
        }
        if (copy.length != 1 || !(copy[0] instanceof PsiExpression)) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)copy[0];
        PsiType type2 = expression2.getType();
        if (type2 == null || PsiType.NULL.equals((Object)type2)) {
            return null;
        }
        PsiElement parent = expression2.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        if (parentClass == null) {
            return null;
        }
        PsiElement parentClassStart = parentClass.getLBrace();
        if (parentClassStart == null) {
            return null;
        }
        String wrapperBodyText = (PsiType.VOID.equals((Object)type2) ? "" : "return ") + expression2.getText() + ";";
        String wrapperClassImmediateCallText = "new java.lang.Object() { " + type2.getCanonicalText() + " wrapperMethod() {" + wrapperBodyText + "} }.wrapperMethod()";
        PsiExpression wrapperClassImmediateCall = factory.createExpressionFromText(wrapperClassImmediateCallText, parent);
        wrapperClassImmediateCall = (PsiExpression)expression2.replace((PsiElement)wrapperClassImmediateCall);
        PsiMethod method = (PsiMethod)PsiTreeUtil.findChildOfType((PsiElement)wrapperClassImmediateCall, PsiMethod.class);
        LOG.assertTrue(method != null, (Object)"wrapper class method is null");
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null, (Object)"wrapper class method's body is null");
        PsiStatement[] statements = body2.getStatements();
        LOG.assertTrue(statements.length == 1, (Object)"wrapper class method's body statement count");
        PsiStatement bodyStatement = statements[0];
        Set<PsiVariable> effectivelyLocal = originalProcessor.getEffectivelyLocalVariables();
        for (PsiVariable variable : effectivelyLocal) {
            String name2 = variable.getName();
            LOG.assertTrue(name2 != null, (Object)"effectively local variable's name is null");
            PsiDeclarationStatement declaration2 = factory.createVariableDeclarationStatement(name2, variable.getType(), null);
            body2.addBefore((PsiElement)declaration2, (PsiElement)bodyStatement);
        }
        PsiExpression wrapped = null;
        if (PsiType.VOID.equals((Object)type2) && bodyStatement instanceof PsiExpressionStatement) {
            wrapped = ((PsiExpressionStatement)bodyStatement).getExpression();
        } else if (bodyStatement instanceof PsiReturnStatement) {
            wrapped = ((PsiReturnStatement)bodyStatement).getReturnValue();
        } else {
            LOG.error("Unexpected statement in expression code block " + bodyStatement);
        }
        if (wrapped != null) {
            wrapped.putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, expression2.getUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL));
        }
        return wrapped;
    }

    @NotNull
    private Map<PsiLocalVariable, ClusterOfUsages> createParameterDeclarations(@NotNull ExtractMethodProcessor originalProcessor, @NotNull Map<PsiExpression, PsiExpression> expressionsMapping, @NotNull Map<PsiExpression, String> predefinedNames) {
        if (originalProcessor == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(39);
        }
        if (expressionsMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(40);
        }
        if (predefinedNames == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(41);
        }
        Project project = this.myElements[0].getProject();
        THashMap parameterDeclarations = new THashMap();
        UniqueNameGenerator generator = originalProcessor.getParameterNameGenerator(this.myElements[0]);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiStatement statement = this.myElements[0] instanceof PsiStatement ? (PsiStatement)this.myElements[0] : (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElements[0], PsiStatement.class);
        LOG.assertTrue(statement != null, (Object)"first statement is null");
        PsiElement parent = statement.getParent();
        LOG.assertTrue(parent instanceof PsiCodeBlock, (Object)"first statement's parent isn't a code block");
        for (ClusterOfUsages usages : this.myUsagesList) {
            ExtractedParameter parameter2 = usages.myParameter;
            PsiExpression patternUsage = parameter2.myPattern.getUsage();
            String initializerText = patternUsage.getText();
            PsiExpression initializer = factory.createExpressionFromText(initializerText, parent);
            String predefinedName = predefinedNames.get(patternUsage);
            SuggestedNameInfo info = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, predefinedName, initializer, null);
            String parameterName = generator.generateUniqueName(info.names.length > 0 ? info.names[0] : "p");
            String declarationText = parameter2.getLocalVariableTypeText() + " " + parameterName + " = " + initializerText + ";";
            PsiDeclarationStatement paramDeclaration = (PsiDeclarationStatement)factory.createStatementFromText(declarationText, parent);
            paramDeclaration = (PsiDeclarationStatement)parent.addBefore((PsiElement)paramDeclaration, (PsiElement)statement);
            PsiLocalVariable localVariable = (PsiLocalVariable)paramDeclaration.getDeclaredElements()[0];
            parameterDeclarations.put(localVariable, usages);
            for (PsiExpression expression2 : parameter2.myPatternUsages) {
                PsiExpression mapped = expressionsMapping.get(expression2);
                if (mapped == null) continue;
                PsiExpression replacement = factory.createExpressionFromText(parameterName, (PsiElement)expression2);
                mapped.replace((PsiElement)replacement);
            }
        }
        THashMap tHashMap = parameterDeclarations;
        if (tHashMap == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(42);
        }
        return tHashMap;
    }

    private static void collectCopyMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy, @NotNull List<? extends ClusterOfUsages> patternUsages, @NotNull Map<PsiExpression, PsiExpression> expressions2, @NotNull Map<PsiVariable, PsiVariable> variables) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(43);
        }
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(44);
        }
        if (patternUsages == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(45);
        }
        if (expressions2 == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(46);
        }
        if (variables == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(47);
        }
        THashSet patternExpressions = new THashSet();
        for (ClusterOfUsages clusterOfUsages : patternUsages) {
            patternExpressions.addAll(clusterOfUsages.myPatterns);
        }
        ParametrizedDuplicates.collectCopyMapping(pattern, copy, ((Set)patternExpressions)::contains, expressions2::put, variables::put);
    }

    public static void collectCopyMapping(@NotNull PsiElement[] pattern, @NotNull PsiElement[] copy, @NotNull Predicate<? super PsiExpression> isReplaceablePattern, @NotNull BiConsumer<? super PsiExpression, ? super PsiExpression> expressionsMapping, @NotNull BiConsumer<? super PsiVariable, ? super PsiVariable> variablesMapping) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(48);
        }
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(49);
        }
        if (isReplaceablePattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(50);
        }
        if (expressionsMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(51);
        }
        if (variablesMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(52);
        }
        pattern = DuplicatesFinder.getDeeplyFilteredElements(pattern);
        if ((copy = DuplicatesFinder.getDeeplyFilteredElements(copy)).length != pattern.length) {
            return;
        }
        for (int i = 0; i < pattern.length; ++i) {
            ParametrizedDuplicates.collectCopyMapping(pattern[i], copy[i], isReplaceablePattern, expressionsMapping, variablesMapping);
        }
    }

    private static void collectCopyMapping(@NotNull PsiElement pattern, @NotNull PsiElement copy, @NotNull Predicate<? super PsiExpression> isReplaceablePattern, @NotNull BiConsumer<? super PsiExpression, ? super PsiExpression> expressionsMapping, @NotNull BiConsumer<? super PsiVariable, ? super PsiVariable> variablesMapping) {
        if (pattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(53);
        }
        if (copy == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(54);
        }
        if (isReplaceablePattern == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(55);
        }
        if (expressionsMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(56);
        }
        if (variablesMapping == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(57);
        }
        if (pattern == copy) {
            return;
        }
        if (pattern instanceof PsiExpression && copy instanceof PsiExpression && isReplaceablePattern.test((PsiExpression)((PsiExpression)pattern))) {
            expressionsMapping.accept((PsiExpression)((PsiExpression)pattern), (PsiExpression)((PsiExpression)copy));
            return;
        }
        if (pattern instanceof PsiJavaCodeReferenceElement && copy instanceof PsiJavaCodeReferenceElement) {
            PsiElement resolvedCopy;
            PsiElement resolvedPattern = ((PsiJavaCodeReferenceElement)pattern).resolve();
            if (resolvedPattern != (resolvedCopy = ((PsiJavaCodeReferenceElement)copy).resolve()) && resolvedPattern instanceof PsiVariable && resolvedCopy instanceof PsiVariable) {
                variablesMapping.accept((PsiVariable)((PsiVariable)resolvedPattern), (PsiVariable)((PsiVariable)resolvedCopy));
            }
            PsiElement patternQualifier = ((PsiJavaCodeReferenceElement)pattern).getQualifier();
            PsiElement copyQualifier = ((PsiJavaCodeReferenceElement)copy).getQualifier();
            if (patternQualifier != null && copyQualifier != null) {
                ParametrizedDuplicates.collectCopyMapping(patternQualifier, copyQualifier, isReplaceablePattern, expressionsMapping, variablesMapping);
            }
            return;
        }
        if (pattern instanceof PsiVariable && copy instanceof PsiVariable) {
            variablesMapping.accept((PsiVariable)((PsiVariable)pattern), (PsiVariable)((PsiVariable)copy));
        }
        ParametrizedDuplicates.collectCopyMapping(pattern.getChildren(), copy.getChildren(), isReplaceablePattern, expressionsMapping, variablesMapping);
    }

    @NotNull
    private static PsiElement[] getFilteredElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(58);
        }
        if (elements.length == 0) {
            if (elements == null) {
                ParametrizedDuplicates.$$$reportNull$$$0(59);
            }
            return elements;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements.length);
        for (PsiElement e : elements) {
            if (e == null || e instanceof PsiWhiteSpace || e instanceof PsiComment || e instanceof PsiEmptyStatement) continue;
            if (e instanceof PsiParenthesizedExpression) {
                e = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiParenthesizedExpression)e));
            }
            result.add(e);
        }
        PsiElement[] psiElementArray = result.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ParametrizedDuplicates.$$$reportNull$$$0(60);
        }
        return psiElementArray;
    }

    private static /* synthetic */ Map lambda$initMatches$2(PsiElement[] pattern, Match match, Map usagesMap, Match unused) {
        HashMap result = new HashMap();
        ParametrizedDuplicates.collectCopyMapping(pattern, match.getMatchElements(), usagesMap.keySet()::contains, result::put, (? super PsiVariable unused1, ? super PsiVariable unused2) -> {});
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 33: 
            case 42: 
            case 59: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 33: 
            case 42: 
            case 59: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: 
            case 21: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalProcessor";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 33: 
            case 42: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCall";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 22: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedNames";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDatum";
                break;
            }
            case 24: 
            case 52: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesMapping";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDeclarations";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametrizedCall";
                break;
            }
            case 29: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reusedLocalVariables";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 37: 
            case 44: 
            case 49: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 40: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionsMapping";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternUsages";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 50: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isReplaceablePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "foldParameters";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceMethod";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceCall";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unmapVariableData";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithCodeBlock";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "trimBracesAndWhitespaces";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterDeclarations";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyElements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicates";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 33: 
            case 42: 
            case 59: 
            case 60: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDuplicatesFinder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceCall";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initMatches";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeDuplicateUsages";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUsagesInMatch";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unmapVariableData";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceArguments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "putMatchParameters";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithCodeBlock";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "trimBracesAndWhitespaces";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "declareReusedLocalVariables";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "wrapExpressionWithCodeBlock";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createParameterDeclarations";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "collectCopyMapping";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 25: 
            case 31: 
            case 33: 
            case 42: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ClusterOfUsages {
        @NotNull
        private final Set<PsiExpression> myPatterns;
        @NotNull
        private final Map<Match, ExtractedParameter> myParameters;
        @NotNull
        private final ExtractedParameter myParameter;
        private final int myFirstOffset;

        ClusterOfUsages(@NotNull ExtractedParameter parameter2) {
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(0);
            }
            this.myPatterns = parameter2.myPatternUsages;
            this.myParameters = new THashMap();
            this.myParameter = parameter2;
            this.myFirstOffset = this.myPatterns.stream().mapToInt(PsiElement::getTextOffset).min().orElse(0);
        }

        void putParameter(@NotNull Match match, @NotNull ExtractedParameter parameter2) {
            if (match == null) {
                ClusterOfUsages.$$$reportNull$$$0(1);
            }
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(2);
            }
            this.myParameters.put(match, parameter2);
        }

        @Nullable
        ExtractedParameter getParameter(@NotNull Match match) {
            if (match == null) {
                ClusterOfUsages.$$$reportNull$$$0(3);
            }
            return this.myParameters.get(match);
        }

        boolean arePatternsEquivalent(@NotNull ExtractedParameter parameter2) {
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(4);
            }
            return this.myPatterns.equals(parameter2.myPatternUsages);
        }

        boolean isEquivalent(@NotNull ClusterOfUsages usages, @NotNull Collection<Match> matches) {
            if (usages == null) {
                ClusterOfUsages.$$$reportNull$$$0(5);
            }
            if (matches == null) {
                ClusterOfUsages.$$$reportNull$$$0(6);
            }
            if (!this.myParameter.myPattern.isEquivalent(usages.myParameter.myPattern)) {
                return false;
            }
            for (Match match : matches) {
                ExtractedParameter parameter2 = this.getParameter(match);
                ExtractedParameter otherParameter = usages.getParameter(match);
                if (parameter2 != null && otherParameter != null && parameter2.myCandidate.isEquivalent(otherParameter.myCandidate)) continue;
                return false;
            }
            return true;
        }

        static boolean isPatternPresent(@NotNull Map<PsiExpression, ClusterOfUsages> usagesMap, @NotNull ExtractedParameter parameter2) {
            if (usagesMap == null) {
                ClusterOfUsages.$$$reportNull$$$0(7);
            }
            if (parameter2 == null) {
                ClusterOfUsages.$$$reportNull$$$0(8);
            }
            return parameter2.myPatternUsages.stream().anyMatch(usagesMap::containsKey);
        }

        public String toString() {
            return StreamEx.of(this.myParameters.values()).map(p -> p.myPattern + "->" + p.myCandidate).joining((CharSequence)", ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "match";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matches";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usagesMap";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractMethod/ParametrizedDuplicates$ClusterOfUsages";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "arePatternsEquivalent";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEquivalent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPatternPresent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

