/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAnonymousToInnerHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (element instanceof PsiAnonymousClass) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (element instanceof PsiAnonymousClass && element.getParent() instanceof PsiNewExpression) {
            new AnonymousToInnerHandler().invoke(project, editor, (PsiAnonymousClass)element);
            return true;
        }
        return false;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            MoveAnonymousToInnerHandler.$$$reportNull$$$0(0);
        }
        return language instanceof JvmLanguage;
    }

    @Nullable
    public String getActionName(@NotNull PsiElement[] elements) {
        if (elements == null) {
            MoveAnonymousToInnerHandler.$$$reportNull$$$0(1);
        }
        return "Convert Anonymous to Inner...";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/anonymousToInner/MoveAnonymousToInnerHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

