/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class OptimizeImportsTask
implements SequentialTask {
    private static final Logger LOG = Logger.getInstance(OptimizeImportsTask.class);
    private final Iterator<SmartPsiElementPointer<PsiImportStatementBase>> myPointers;
    private final SequentialModalProgressTask myTask;
    private final int myTotal;
    private int myCount;
    private final Map<PsiFile, Set<String>> myDuplicates = new HashMap<PsiFile, Set<String>>();

    OptimizeImportsTask(SequentialModalProgressTask progressTask, Collection<SmartPsiElementPointer<PsiImportStatementBase>> pointers) {
        this.myTask = progressTask;
        this.myTotal = pointers.size();
        this.myPointers = pointers.iterator();
    }

    public void prepare() {
    }

    public boolean isDone() {
        return !this.myPointers.hasNext();
    }

    public boolean iteration() {
        PsiJavaCodeReferenceElement ref;
        SmartPsiElementPointer<PsiImportStatementBase> pointer;
        PsiImportStatementBase importStatement;
        ProgressIndicator indicator = this.myTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount++ / (double)this.myTotal);
        }
        if ((importStatement = (PsiImportStatementBase)(pointer = this.myPointers.next()).getElement()) != null && importStatement.isValid() && (ref = importStatement.getImportReference()) != null) {
            PsiElement resolve2 = ref.resolve();
            try {
                if (resolve2 != null) {
                    if (!(resolve2 instanceof PsiPackage) || ((PsiPackage)resolve2).getDirectories(ref.getResolveScope()).length != 0) {
                        importStatement.delete();
                    }
                } else {
                    Collection imports2 = this.myDuplicates.computeIfAbsent(pointer.getContainingFile(), file -> new HashSet());
                    if (!imports2.add(importStatement.getText())) {
                        importStatement.delete();
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.isDone();
    }

    public void stop() {
    }
}

