/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.redundantCast.RedundantCastUtil");

    private RedundantCastUtil() {
    }

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(@NotNull PsiElement where) {
        if (where == null) {
            RedundantCastUtil.$$$reportNull$$$0(0);
        }
        MyCollectingVisitor visitor = new MyCollectingVisitor();
        if (where instanceof PsiEnumConstant) {
            where.accept((PsiElementVisitor)visitor);
        } else {
            where.acceptChildren((PsiElementVisitor)visitor);
        }
        ArrayList<PsiTypeCastExpression> arrayList = new ArrayList<PsiTypeCastExpression>(visitor.myFoundCasts);
        if (arrayList == null) {
            RedundantCastUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 != null && operand2.getType() != null && operand2.getType().equals(typeCast.getType())) {
            return true;
        }
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        MyIsRedundantVisitor visitor = new MyIsRedundantVisitor();
        parent.accept((PsiElementVisitor)visitor);
        return visitor.foundRedundantCast == typeCast;
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        while (arg instanceof PsiParenthesizedExpression) {
            arg = ((PsiParenthesizedExpression)arg).getExpression();
        }
        return arg;
    }

    private static boolean isCastRedundantInRefExpression(PsiReferenceExpression refExpression, PsiExpression castOperand) {
        if (refExpression.getParent() instanceof PsiMethodCallExpression) {
            return false;
        }
        PsiElement resolved = refExpression.resolve();
        try {
            PsiReferenceExpression copy;
            PsiExpression qualifier;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)refExpression.getProject());
            PsiExpression copyExpression = elementFactory.createExpressionFromText(refExpression.getText(), (PsiElement)refExpression);
            if (copyExpression instanceof PsiReferenceExpression && (qualifier = (copy = (PsiReferenceExpression)copyExpression).getQualifierExpression()) != null) {
                qualifier.replace((PsiElement)castOperand);
                return copy.resolve() == resolved;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isTypeCastSemantic(PsiTypeCastExpression typeCast) {
        PsiExpression stripParenthesisOperand;
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 == null) {
            return false;
        }
        if (RedundantCastUtil.isInPolymorphicCall(typeCast)) {
            return true;
        }
        PsiType opType = operand2.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
                if ((parent instanceof PsiReturnStatement || parent instanceof PsiExpressionList || parent instanceof PsiVariable || parent instanceof PsiAssignmentExpression) && castType.equals(ExpectedTypeUtils.findExpectedType((PsiExpression)typeCast, false))) {
                    return !TypeConversionUtil.isSafeConversion((PsiType)castType, (PsiType)opType);
                }
                return !castType.equals(opType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType((PsiType)opType);
            if (unboxedOpType != null && !unboxedOpType.equals((Object)castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && ((PsiClassType)castType).hasParameters() && opType instanceof PsiClassType && ((PsiClassType)opType).isRaw()) {
            return true;
        }
        if ((stripParenthesisOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)) instanceof PsiFunctionalExpression) {
            if (RedundantCastUtil.isCastToSerializable(castType)) {
                return true;
            }
        } else if (stripParenthesisOperand instanceof PsiConditionalExpression) {
            PsiExpression thenExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getThenExpression());
            PsiExpression elseExpr = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getElseExpression());
            if (thenExpr instanceof PsiFunctionalExpression || elseExpr instanceof PsiFunctionalExpression) {
                return true;
            }
        }
        PsiElement parent = typeCast.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression2 = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression2.getLOperand();
            PsiExpression otherOperand = expression2.getROperand();
            if (PsiTreeUtil.isAncestor((PsiElement)otherOperand, (PsiElement)typeCast, (boolean)false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand2)) {
                return true;
            }
        } else if (parent instanceof PsiConditionalExpression) {
            if (opType instanceof PsiPrimitiveType && !(((PsiConditionalExpression)parent).getType() instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType((PsiType)PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent)) != null) {
                return true;
            }
        } else if (parent instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)parent).getTypeElement().isInferredType();
        }
        return false;
    }

    private static boolean isCastToSerializable(PsiType castType) {
        return InheritanceUtil.isInheritor((PsiType)castType, (String)"java.io.Serializable");
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand2, PsiExpression otherOperand, PsiExpression toCast) {
        boolean isPrimitiveComparisonWithoutCast;
        boolean isPrimitiveComparisonWithCast;
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)otherOperand.getType())) {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)operand2.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)toCast.getType());
        } else {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operand2.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)toCast.getType());
        }
        return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
    }

    public static boolean isInPolymorphicCall(PsiTypeCastExpression typeCast) {
        PsiElement methodCall;
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)typeCast)) {
            return false;
        }
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)operand2)) {
            return true;
        }
        PsiElement exprList = typeCast.getParent();
        return exprList instanceof PsiExpressionList && (methodCall = exprList.getParent()) instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)methodCall);
    }

    private static boolean isPolymorphicMethod(PsiMethodCallExpression expression2) {
        PsiElement method = expression2.getMethodExpression().resolve();
        return method instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)method), (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/RedundantCastUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/RedundantCastUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRedundantCastsInside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRedundantCastsInside";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIsRedundantVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiTypeCastExpression foundRedundantCast;

        private MyIsRedundantVisitor() {
        }

        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                MyIsRedundantVisitor.$$$reportNull$$$0(0);
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.foundRedundantCast = typeCast;
                this.stopWalking();
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.processPossibleTypeCast(expression2.getRExpression(), expression2.getLExpression().getType());
            super.visitAssignmentExpression(expression2);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            PsiType type2 = expression2.getType();
            if (type2 instanceof PsiArrayType) {
                for (PsiExpression initializer : expression2.getInitializers()) {
                    this.processPossibleTypeCast(initializer, ((PsiArrayType)type2).getComponentType());
                }
            }
            super.visitArrayInitializerExpression(expression2);
        }

        public void visitVariable(PsiVariable variable) {
            this.processPossibleTypeCast(variable.getInitializer(), variable.getType());
            super.visitVariable(variable);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length >= 2) {
                PsiType lType = operands2[0].getType();
                this.processBinaryExpressionOperand(RedundantCastUtil.deparenthesizeExpression(operands2[0]), operands2[1].getType(), tokenType);
                for (int i = 1; i < operands2.length; ++i) {
                    PsiExpression operand2 = RedundantCastUtil.deparenthesizeExpression(operands2[i]);
                    if (operand2 == null) continue;
                    this.processBinaryExpressionOperand(operand2, lType, tokenType);
                    lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)operand2.getType(), (IElementType)tokenType, (boolean)true);
                }
            }
            super.visitPolyadicExpression(expression2);
        }

        private void processBinaryExpressionOperand(PsiExpression operand2, PsiType otherType, IElementType binaryToken) {
            PsiTypeCastExpression typeCast;
            PsiExpression toCast;
            if (operand2 instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand2).getOperand()) != null && TypeConversionUtil.isBinaryOperatorApplicable((IElementType)binaryToken, (PsiType)toCast.getType(), (PsiType)otherType, (boolean)false)) {
                this.addToResults(typeCast);
            }
        }

        private void processPossibleTypeCast(PsiExpression rExpr, @Nullable PsiType lType) {
            PsiExpression castOperand;
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression && (castOperand = ((PsiTypeCastExpression)rExpr).getOperand()) != null) {
                PsiType operandType;
                if (castOperand instanceof PsiTypeCastExpression) {
                    PsiExpression nestedCastOperand = ((PsiTypeCastExpression)castOperand).getOperand();
                    operandType = nestedCastOperand != null ? nestedCastOperand.getType() : null;
                } else if (castOperand instanceof PsiFunctionalExpression && lType != null) {
                    PsiTypeElement typeElement = ((PsiTypeCastExpression)rExpr).getCastType();
                    PsiType castType = typeElement != null ? typeElement.getType() : null;
                    operandType = lType.equals(castType) ? castOperand.getType() : null;
                } else {
                    operandType = castOperand.getType();
                }
                if (operandType != null && lType != null && TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)operandType, (boolean)false)) {
                    this.addToResults((PsiTypeCastExpression)rExpr);
                }
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            this.processCall((PsiCall)expression2);
            this.checkForVirtual(expression2);
            super.visitMethodCallExpression(expression2);
        }

        private void checkForVirtual(PsiMethodCallExpression methodCall) {
            PsiReferenceExpression methodExpr = methodCall.getMethodExpression();
            PsiExpression qualifier = methodExpr.getQualifierExpression();
            if (!(qualifier instanceof PsiParenthesizedExpression)) {
                return;
            }
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
            if (!(operand2 instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)operand2;
            PsiExpression castOperand = typeCast.getOperand();
            if (castOperand == null) {
                return;
            }
            PsiType type2 = castOperand.getType();
            if (type2 == null) {
                return;
            }
            if (type2 instanceof PsiPrimitiveType) {
                return;
            }
            JavaResolveResult resolveResult = methodExpr.advancedResolve(false);
            PsiMethod targetMethod = (PsiMethod)resolveResult.getElement();
            if (targetMethod == null) {
                return;
            }
            if (targetMethod.hasModifierProperty("static")) {
                return;
            }
            try {
                Project project = methodExpr.getProject();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression expressionFromText = factory.createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
                if (!(expressionFromText instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression newCall = (PsiMethodCallExpression)expressionFromText;
                PsiExpression newQualifier = newCall.getMethodExpression().getQualifierExpression();
                PsiTypeCastExpression newCast = Objects.requireNonNull((PsiTypeCastExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)newQualifier));
                PsiExpression newOperand = Objects.requireNonNull(newCast.getOperand());
                newQualifier.replace((PsiElement)newOperand);
                JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                if (!newResult.isValidResult()) {
                    return;
                }
                PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                PsiType newReturnType = newCall.getType();
                PsiType oldReturnType = methodCall.getType();
                if (newReturnType instanceof PsiCapturedWildcardType && oldReturnType instanceof PsiCapturedWildcardType) {
                    newReturnType = ((PsiCapturedWildcardType)newReturnType).getUpperBound();
                    oldReturnType = ((PsiCapturedWildcardType)oldReturnType).getUpperBound();
                }
                if (Comparing.equal((Object)newReturnType, (Object)oldReturnType) && (Comparing.equal((Object)newTargetMethod, (Object)targetMethod) || (!newTargetMethod.isDeprecated() || targetMethod.isDeprecated()) && MethodSignatureUtil.isSuperMethod((PsiMethod)newTargetMethod, (PsiMethod)targetMethod) && MyIsRedundantVisitor.areThrownExceptionsCompatible(targetMethod, newTargetMethod) && MyIsRedundantVisitor.areNullabilityCompatible(targetMethod, newTargetMethod))) {
                    this.addToResults(typeCast);
                }
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }

        private static boolean areNullabilityCompatible(PsiMethod oldTargetMethod, PsiMethod newTargetMethod) {
            Nullability newNullability;
            Nullability oldNullability = NullableNotNullManager.getNullability((PsiModifierListOwner)oldTargetMethod);
            return oldNullability == (newNullability = NullableNotNullManager.getNullability((PsiModifierListOwner)newTargetMethod));
        }

        private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
            PsiClassType[] newThrowsTypes;
            PsiClassType[] oldThrowsTypes = targetMethod.getThrowsList().getReferencedTypes();
            for (PsiClassType throwsType : newThrowsTypes = newTargetMethod.getThrowsList().getReferencedTypes()) {
                if (MyIsRedundantVisitor.isExceptionThrown(throwsType, oldThrowsTypes)) continue;
                return false;
            }
            return true;
        }

        private static boolean isExceptionThrown(PsiClassType exceptionType, PsiClassType[] thrownTypes) {
            for (PsiClassType type2 : thrownTypes) {
                if (!type2.equals((Object)exceptionType)) continue;
                return true;
            }
            return false;
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            this.processCall((PsiCall)expression2);
            super.visitNewExpression(expression2);
        }

        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            this.processCall((PsiCall)enumConstant);
            super.visitEnumConstant(enumConstant);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitElement((PsiElement)expression2);
        }

        private void processCall(PsiCall expression2) {
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            JavaResolveResult oldResult = expression2.resolveMethodGenerics();
            PsiElement element = oldResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod oldMethod = (PsiMethod)element;
            PsiParameter[] parameters2 = oldMethod.getParameterList().getParameters();
            try {
                for (int i = 0; i < args.length; ++i) {
                    PsiType interfaceType;
                    ProgressManager.checkCanceled();
                    PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                    if (arg instanceof PsiTypeCastExpression) {
                        PsiAnonymousClass newAnonymousClass;
                        JavaResolveResult newResult;
                        PsiCall newCall;
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)arg;
                        PsiType typeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2);
                        if (typeByParent != null) {
                            newCall = (PsiCall)LambdaUtil.copyWithExpectedType((PsiElement)expression2, (PsiType)typeByParent);
                        } else {
                            PsiCall call = LambdaUtil.treeWalkUp((PsiElement)expression2);
                            if (call != null) {
                                Object marker = new Object();
                                PsiTreeUtil.mark((PsiElement)argumentList, (Object)marker);
                                PsiCall callCopy = LambdaUtil.copyTopLevelCall((PsiCall)call);
                                newCall = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)marker), expression2.getClass(), (boolean)false);
                            } else {
                                newCall = (PsiCall)expression2.copy();
                            }
                        }
                        PsiExpressionList argList = newCall.getArgumentList();
                        LOG.assertTrue(argList != null);
                        PsiExpression[] newArgs = argList.getExpressions();
                        LOG.assertTrue(newArgs.length == args.length, (Object)("oldCall: " + expression2.getText() + "; old length: " + args.length + "; newCall: " + newCall.getText() + "; new length: " + newArgs.length));
                        PsiTypeCastExpression castExpression = (PsiTypeCastExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                        PsiTypeElement castTypeElement = cast.getCastType();
                        PsiType castType = castTypeElement != null ? castTypeElement.getType() : null;
                        PsiExpression castOperand = castExpression.getOperand();
                        if (castOperand == null) {
                            return;
                        }
                        newArgs[i] = (PsiExpression)castExpression.replace((PsiElement)castOperand);
                        if (newCall instanceof PsiEnumConstant) {
                            PsiEnumConstant enumConstant = (PsiEnumConstant)expression2;
                            PsiClass containingClass = enumConstant.getContainingClass();
                            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)enumConstant.getProject());
                            PsiClassType type2 = facade.getElementFactory().createType(containingClass);
                            newResult = facade.getResolveHelper().resolveConstructor(type2, newCall.getArgumentList(), (PsiElement)enumConstant);
                        } else {
                            newResult = newCall.resolveMethodGenerics();
                        }
                        if (i == args.length - 1 && args.length == parameters2.length && parameters2[i].isVarArgs() && (ExpressionUtils.isNullLiteral(cast.getOperand()) || oldResult instanceof MethodCandidateInfo && newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)oldResult).getApplicabilityLevel() != ((MethodCandidateInfo)newResult).getApplicabilityLevel())) continue;
                        PsiAnonymousClass oldAnonymousClass = expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getAnonymousClass() : null;
                        PsiAnonymousClass psiAnonymousClass = newAnonymousClass = newCall instanceof PsiNewExpression ? ((PsiNewExpression)newCall).getAnonymousClass() : null;
                        if (!oldMethod.equals(newResult.getElement()) || newCall instanceof PsiCallExpression && (oldAnonymousClass == null || newAnonymousClass == null || !Comparing.equal((Object)oldAnonymousClass.getBaseClassType(), (Object)newAnonymousClass.getBaseClassType())) && !Comparing.equal((Object)PsiUtil.recaptureWildcards((PsiType)((PsiCallExpression)newCall).getType(), (PsiElement)expression2), (Object)((PsiCallExpression)expression2).getType()) || !newResult.isValidResult() || newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).getInferenceErrorMessage() != null) continue;
                        PsiExpression newArg = PsiUtil.deparenthesizeExpression((PsiExpression)newArgs[i]);
                        if (newArg instanceof PsiConditionalExpression && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)newArgs[i])) {
                            PsiType elseType;
                            PsiType targetType = newArg.getType();
                            LOG.assertTrue(targetType != null);
                            PsiExpression thenExpression2 = ((PsiConditionalExpression)newArg).getThenExpression();
                            PsiType thenType = thenExpression2 != null ? thenExpression2.getType() : null;
                            PsiExpression elseExpression2 = ((PsiConditionalExpression)newArg).getElseExpression();
                            PsiType psiType = elseType = elseExpression2 != null ? elseExpression2.getType() : null;
                            if (thenType == null || !targetType.isAssignableFrom(thenType) || elseType == null || !targetType.isAssignableFrom(elseType)) continue;
                            this.addToResults(cast);
                            continue;
                        }
                        if (!(newArg instanceof PsiFunctionalExpression)) {
                            this.addToResults(cast);
                            continue;
                        }
                        boolean varargs = newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).isVarargs();
                        PsiType parameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs);
                        PsiType newArgType = newResult.getSubstitutor().substitute(parameterType);
                        if (!Comparing.equal((Object)castType, (Object)((PsiFunctionalExpression)newArg).getGroundTargetType(newArgType))) continue;
                        this.addToResults(cast);
                        continue;
                    }
                    if (!(arg instanceof PsiLambdaExpression) || (interfaceType = ((PsiLambdaExpression)arg).getFunctionalInterfaceType()) == null) continue;
                    List expressions2 = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)arg));
                    for (int returnExprIdx = 0; returnExprIdx < expressions2.size(); ++returnExprIdx) {
                        PsiExpression elseExpression3;
                        ProgressManager.checkCanceled();
                        PsiExpression returnExpression2 = RedundantCastUtil.deparenthesizeExpression((PsiExpression)expressions2.get(returnExprIdx));
                        if (returnExpression2 instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression2, i, interfaceType, (PsiTypeCastExpression)returnExpression2, returnExprIdx, (Function<? super PsiExpression, ? extends PsiTypeCastExpression>)((Function)expression13 -> (PsiTypeCastExpression)expression13));
                            continue;
                        }
                        if (!(returnExpression2 instanceof PsiConditionalExpression)) continue;
                        PsiExpression thenExpression3 = ((PsiConditionalExpression)returnExpression2).getThenExpression();
                        if (thenExpression3 instanceof PsiTypeCastExpression) {
                            this.processLambdaReturnExpression(expression2, i, interfaceType, (PsiTypeCastExpression)thenExpression3, returnExprIdx, (Function<? super PsiExpression, ? extends PsiTypeCastExpression>)((Function)expression12 -> (PsiTypeCastExpression)((PsiConditionalExpression)expression12).getThenExpression()));
                        }
                        if (!((elseExpression3 = ((PsiConditionalExpression)returnExpression2).getElseExpression()) instanceof PsiTypeCastExpression)) continue;
                        this.processLambdaReturnExpression(expression2, i, interfaceType, (PsiTypeCastExpression)elseExpression3, returnExprIdx, (Function<? super PsiExpression, ? extends PsiTypeCastExpression>)((Function)expression1 -> (PsiTypeCastExpression)((PsiConditionalExpression)expression1).getElseExpression()));
                    }
                }
            }
            catch (IncorrectOperationException e) {
                return;
            }
            for (PsiExpression arg : args) {
                if (arg instanceof PsiTypeCastExpression) {
                    PsiExpression castOperand = ((PsiTypeCastExpression)arg).getOperand();
                    if (castOperand == null) continue;
                    castOperand.accept((PsiElementVisitor)this);
                    continue;
                }
                arg.accept((PsiElementVisitor)this);
            }
        }

        private void processLambdaReturnExpression(PsiCall expression2, int i, PsiType interfaceType, PsiTypeCastExpression returnExpression2, int returnExprIdx, Function<? super PsiExpression, ? extends PsiTypeCastExpression> computeCastExpression) {
            PsiCall newCall = LambdaUtil.copyTopLevelCall((PsiCall)expression2);
            if (newCall == null) {
                return;
            }
            PsiExpressionList newArgsList = newCall.getArgumentList();
            LOG.assertTrue(newArgsList != null);
            PsiExpression[] newArgs = newArgsList.getExpressions();
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
            LOG.assertTrue(lambdaExpression != null, (Object)newCall);
            PsiExpression newReturnExpression = RedundantCastUtil.deparenthesizeExpression((PsiExpression)LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression).get(returnExprIdx));
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)computeCastExpression.fun((Object)newReturnExpression);
            PsiExpression castOperand = castExpression.getOperand();
            if (castOperand == null) {
                return;
            }
            castOperand = (PsiExpression)castExpression.replace((PsiElement)castOperand);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (interfaceType.equals(functionalInterfaceType)) {
                PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)interfaceType);
                PsiType castExprType = castOperand.getType();
                if (interfaceReturnType != null && castExprType != null && interfaceReturnType.isAssignableFrom(castExprType)) {
                    this.addToResults(returnExpression2);
                }
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
            PsiExpression operand2 = typeCast.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiExpression expr = RedundantCastUtil.deparenthesizeExpression(operand2);
            PsiType topCastType = typeCast.getType();
            if (expr instanceof PsiTypeCastExpression) {
                PsiType operandType;
                PsiTypeCastExpression innerCast = (PsiTypeCastExpression)expr;
                PsiTypeElement typeElement = innerCast.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiExpression innerOperand = innerCast.getOperand();
                PsiType psiType = operandType = innerOperand != null ? innerOperand.getType() : null;
                if (!(castType instanceof PsiPrimitiveType) && !(topCastType instanceof PsiPrimitiveType)) {
                    if (operandType != null && topCastType != null && TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)topCastType)) {
                        this.addToResults(innerCast);
                    }
                } else if (Comparing.equal((Object)PsiPrimitiveType.getUnboxedType((PsiType)operandType), (Object)topCastType)) {
                    this.addToResults(innerCast);
                } else if (operandType != null && operandType.equals(castType)) {
                    this.addToResults(innerCast);
                }
            } else {
                PsiElement parent = typeCast.getParent();
                if (parent instanceof PsiConditionalExpression) {
                    PsiType conditionalType;
                    PsiType operandType = operand2.getType();
                    if (!Comparing.equal((Object)operandType, (Object)(conditionalType = ((PsiConditionalExpression)parent).getType()))) {
                        PsiExpression opposite;
                        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)typeCast)) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.checkResolveAfterRemoveCast(parent)) {
                            return;
                        }
                        PsiExpression thenExpression2 = ((PsiConditionalExpression)parent).getThenExpression();
                        PsiExpression elseExpression2 = ((PsiConditionalExpression)parent).getElseExpression();
                        PsiExpression psiExpression = opposite = thenExpression2 == typeCast ? elseExpression2 : thenExpression2;
                        if (opposite == null || conditionalType instanceof PsiPrimitiveType && !Comparing.equal((Object)conditionalType, (Object)opposite.getType())) {
                            return;
                        }
                    }
                } else {
                    if (parent instanceof PsiSynchronizedStatement && expr != null && (expr.getType() instanceof PsiPrimitiveType || expr instanceof PsiFunctionalExpression)) {
                        return;
                    }
                    if (expr instanceof PsiLambdaExpression || expr instanceof PsiMethodReferenceExpression) {
                        if (parent instanceof PsiParenthesizedExpression && PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent()) instanceof PsiReferenceExpression) {
                            return;
                        }
                        PsiType functionalInterfaceType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)typeCast);
                        if (topCastType != null && functionalInterfaceType != null && !TypeConversionUtil.isAssignable((PsiType)topCastType, (PsiType)functionalInterfaceType, (boolean)false)) {
                            return;
                        }
                    }
                }
                this.processAlreadyHasTypeCast(typeCast);
            }
            super.visitTypeCastExpression(typeCast);
        }

        private static boolean checkResolveAfterRemoveCast(PsiElement parent) {
            PsiElement grandPa = parent.getParent();
            if (grandPa instanceof PsiExpressionList) {
                PsiMethod resolve2;
                Object[] expressions2 = ((PsiExpressionList)grandPa).getExpressions();
                int idx = ArrayUtil.find((Object[])expressions2, (Object)parent);
                PsiElement grandGrandPa = grandPa.getParent();
                if (grandGrandPa instanceof PsiCall && (resolve2 = ((PsiCall)grandGrandPa).resolveMethod()) != null) {
                    PsiCall expression2 = LambdaUtil.copyTopLevelCall((PsiCall)((PsiCall)grandGrandPa));
                    if (expression2 == null) {
                        return false;
                    }
                    PsiExpressionList argumentList = expression2.getArgumentList();
                    LOG.assertTrue(argumentList != null);
                    PsiExpression toReplace = argumentList.getExpressions()[idx];
                    if (toReplace instanceof PsiConditionalExpression) {
                        PsiExpression elseOperand;
                        PsiExpression thenExpression2 = ((PsiConditionalExpression)toReplace).getThenExpression();
                        PsiExpression elseExpression2 = ((PsiConditionalExpression)toReplace).getElseExpression();
                        if (thenExpression2 instanceof PsiTypeCastExpression) {
                            PsiExpression thenOperand = ((PsiTypeCastExpression)thenExpression2).getOperand();
                            if (thenOperand != null) {
                                thenExpression2.replace((PsiElement)thenOperand);
                            }
                        } else if (elseExpression2 instanceof PsiTypeCastExpression && (elseOperand = ((PsiTypeCastExpression)elseExpression2).getOperand()) != null) {
                            elseExpression2.replace((PsiElement)elseOperand);
                        }
                    }
                    if (expression2.resolveMethod() != resolve2) {
                        return false;
                    }
                }
            }
            return true;
        }

        private void processAlreadyHasTypeCast(PsiTypeCastExpression typeCast) {
            PsiElement parent = typeCast.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList) {
                return;
            }
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            if (parent instanceof PsiTypeCastExpression) {
                return;
            }
            if (parent instanceof PsiLambdaExpression) {
                return;
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
                if (gParent instanceof PsiLambdaExpression) {
                    return;
                }
                if (gParent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType((PsiElement)gParent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                    return;
                }
            }
            if (RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                return;
            }
            PsiTypeElement typeElement = typeCast.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castTo = typeElement.getType();
            PsiExpression operand2 = typeCast.getOperand();
            PsiType opType = operand2.getType();
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)typeCast);
            if (expectedTypeByParent != null) {
                try {
                    PsiExpression expr;
                    Project project = operand2.getProject();
                    String uniqueVariableName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("l", parent, false);
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(expectedTypeByParent.getCanonicalText() + " " + uniqueVariableName + " = " + operand2.getText() + ";", parent);
                    PsiExpression initializer = ((PsiLocalVariable)declarationStatement.getDeclaredElements()[0]).getInitializer();
                    LOG.assertTrue(initializer != null, (Object)operand2.getText());
                    opType = initializer.getType();
                    if (opType != null && (expr = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)) instanceof PsiConditionalExpression) {
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getThenExpression())) {
                            return;
                        }
                        if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expr).getElseExpression())) {
                            return;
                        }
                    }
                }
                catch (IncorrectOperationException project) {
                    // empty catch block
                }
            }
            if (opType == null) {
                return;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (opType instanceof PsiClassType) {
                    PsiReferenceExpression refExpression = (PsiReferenceExpression)parent;
                    PsiElement element = refExpression.resolve();
                    if (!(element instanceof PsiMember)) {
                        return;
                    }
                    PsiClass accessClass = ((PsiClassType)opType).resolve();
                    if (accessClass == null) {
                        return;
                    }
                    if (!JavaPsiFacade.getInstance((Project)parent.getProject()).getResolveHelper().isAccessible((PsiMember)element, (PsiElement)typeCast, accessClass)) {
                        return;
                    }
                    if (!RedundantCastUtil.isCastRedundantInRefExpression(refExpression, operand2)) {
                        return;
                    }
                }
            }
            if (parent instanceof PsiConditionalExpression) {
                if (castTo instanceof PsiClassType && opType instanceof PsiPrimitiveType && opType != PsiType.NULL) {
                    PsiExpression opposite;
                    PsiExpression thenExpression2 = ((PsiConditionalExpression)parent).getThenExpression();
                    PsiExpression elseExpression2 = ((PsiConditionalExpression)parent).getElseExpression();
                    PsiExpression psiExpression = opposite = PsiTreeUtil.isAncestor((PsiElement)thenExpression2, (PsiElement)typeCast, (boolean)false) ? elseExpression2 : thenExpression2;
                    if (opposite != null && !(opposite.getType() instanceof PsiPrimitiveType) && !(PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent) instanceof PsiPrimitiveType)) {
                        return;
                    }
                }
                if (operand2 instanceof PsiFunctionalExpression && !castTo.equals(PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent))) {
                    return;
                }
            }
            if (MyIsRedundantVisitor.arrayAccessAtTheLeftSideOfAssignment(parent, (PsiElement)typeCast)) {
                if (TypeConversionUtil.isAssignable((PsiType)opType, (PsiType)castTo, (boolean)false) && opType.getArrayDimensions() == castTo.getArrayDimensions()) {
                    this.addToResults(typeCast);
                }
            } else {
                if (parent instanceof PsiInstanceOfExpression && opType instanceof PsiPrimitiveType) {
                    return;
                }
                if (parent instanceof PsiForeachStatement) {
                    PsiClassType.ClassResolveResult castResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)opType);
                    PsiClass psiClass = castResolveResult.getElement();
                    if (psiClass != null) {
                        PsiType resultedParamType;
                        PsiTypeParameter[] iterableTypeParameters;
                        PsiClassType[] iterableClass = JavaPsiFacade.getInstance((Project)parent.getProject()).findClass("java.lang.Iterable", psiClass.getResolveScope());
                        if (iterableClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)iterableClass, (boolean)true) && (iterableTypeParameters = iterableClass.getTypeParameters()).length == 1 && (resultedParamType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)iterableClass, (PsiClass)psiClass, (PsiSubstitutor)castResolveResult.getSubstitutor()).substitute(iterableTypeParameters[0])) != null && TypeConversionUtil.isAssignable((PsiType)((PsiForeachStatement)parent).getIterationParameter().getType(), (PsiType)resultedParamType)) {
                            this.addToResults(typeCast);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (parent instanceof PsiThrowStatement) {
                    PsiMethod method;
                    PsiClass thrownClass = PsiUtil.resolveClassInType((PsiType)opType);
                    if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.RuntimeException")) {
                        this.addToResults(typeCast);
                        return;
                    }
                    if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.Throwable") && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class)) != null) {
                        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
                            if (!TypeConversionUtil.isAssignable((PsiType)thrownType, (PsiType)opType, (boolean)false)) continue;
                            this.addToResults(typeCast);
                            return;
                        }
                    }
                }
                if (parent instanceof PsiInstanceOfExpression) {
                    PsiTypeElement checkTypeElement = ((PsiInstanceOfExpression)parent).getCheckType();
                    if (checkTypeElement != null && TypeConversionUtil.areTypesConvertible((PsiType)opType, (PsiType)checkTypeElement.getType())) {
                        this.addToResults(typeCast);
                    }
                } else if (parent instanceof PsiBinaryExpression) {
                    PsiType oppositeType;
                    PsiExpression lOperand = ((PsiBinaryExpression)parent).getLOperand();
                    PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
                    Object object = lOperand == typeCast ? (rOperand != null ? rOperand.getType() : null) : (oppositeType = lOperand.getType());
                    if (oppositeType != null && TypeConversionUtil.areTypesConvertible((PsiType)opType, (PsiType)oppositeType)) {
                        this.addToResults(typeCast);
                    }
                } else if (TypeConversionUtil.isAssignable((PsiType)castTo, (PsiType)opType, (boolean)false) && (expectedTypeByParent == null || TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)opType, (boolean)false))) {
                    PsiClass aClass;
                    if (parent instanceof PsiSwitchBlock && opType instanceof PsiClassType && PsiPrimitiveType.getUnboxedType((PsiType)opType) == null && !opType.equalsToText("java.lang.String") && (aClass = ((PsiClassType)opType).resolve()) != null && !aClass.isEnum()) {
                        return;
                    }
                    this.addToResults(typeCast);
                }
            }
        }

        private static boolean isApplicableForConditionalBranch(PsiType opType, PsiExpression thenExpression2) {
            PsiType thenType;
            return thenExpression2 == null || (thenType = thenExpression2.getType()) == null || TypeConversionUtil.isAssignable((PsiType)opType, (PsiType)thenType);
        }

        private static boolean arrayAccessAtTheLeftSideOfAssignment(PsiElement parent, PsiElement element) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiAssignmentExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
            if (assignment == null) {
                return false;
            }
            PsiExpression lExpression = assignment.getLExpression();
            return lExpression instanceof PsiArrayAccessExpression && PsiTreeUtil.isAncestor((PsiElement)lExpression, (PsiElement)parent, (boolean)false) && !MyIsRedundantVisitor.isIndexExpression(element, (PsiArrayAccessExpression)lExpression);
        }

        private static boolean isIndexExpression(PsiElement element, PsiArrayAccessExpression arrayAccessExpression) {
            if (PsiTreeUtil.isAncestor((PsiElement)arrayAccessExpression.getIndexExpression(), (PsiElement)element, (boolean)false)) {
                return true;
            }
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            if (arrayExpression instanceof PsiArrayAccessExpression) {
                return MyIsRedundantVisitor.isIndexExpression(element, (PsiArrayAccessExpression)arrayExpression);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyIsRedundantVisitor", "addToResults"));
        }
    }

    private static class MyCollectingVisitor
    extends MyIsRedundantVisitor {
        private final Set<PsiTypeCastExpression> myFoundCasts = new HashSet<PsiTypeCastExpression>();

        private MyCollectingVisitor() {
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitMethod(PsiMethod method) {
        }

        public void visitField(PsiField field) {
        }

        @Override
        protected void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                MyCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.myFoundCasts.add(typeCast);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$MyCollectingVisitor", "addToResults"));
        }
    }
}

