/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LBRACKET, JavaTokenType.RBRACKET});

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(0);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(1);
        }
        return JavaSharedImplUtil.getType(typeElement, anchor, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(3);
        }
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType().annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])annotations2));
        }
        return type2;
    }

    @Nullable
    private static List<PsiAnnotation[]> collectAnnotations(@NotNull PsiElement anchor, @Nullable PsiAnnotation stopAt) {
        if (anchor == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(4);
        }
        List annotations2 = ContainerUtil.newSmartList();
        List current = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                annotations2.add(current == null ? PsiAnnotation.EMPTY_ARRAY : (PsiAnnotation[])ContainerUtil.toArray((Collection)current, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations2;
    }

    @NotNull
    public static PsiType applyAnnotations(@NotNull PsiType type2, @Nullable PsiModifierList modifierList) {
        PsiAnnotation[] annotations2;
        if (type2 == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(5);
        }
        if (modifierList != null && (annotations2 = modifierList.getAnnotations()).length > 0) {
            TypeAnnotationProvider original = modifierList.getParent() instanceof PsiMethod ? type2.getAnnotationProvider() : TypeAnnotationProvider.EMPTY;
            FilteringTypeAnnotationProvider provider = new FilteringTypeAnnotationProvider(annotations2, original);
            if (type2 instanceof PsiArrayType) {
                Stack types = new Stack();
                do {
                    types.push((Object)((PsiArrayType)type2));
                } while ((type2 = ((PsiArrayType)type2).getComponentType()) instanceof PsiArrayType);
                type2 = type2.annotate((TypeAnnotationProvider)provider);
                while (!types.isEmpty()) {
                    PsiArrayType t = (PsiArrayType)types.pop();
                    type2 = t instanceof PsiEllipsisType ? new PsiEllipsisType(type2, t.getAnnotations()) : new PsiArrayType(type2, t.getAnnotations());
                }
                PsiType psiType = type2;
                if (psiType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(6);
                }
                return psiType;
            }
            if (type2 instanceof PsiDisjunctionType) {
                ArrayList<PsiType> components = new ArrayList<PsiType>(((PsiDisjunctionType)type2).getDisjunctions());
                components.set(0, ((PsiType)components.get(0)).annotate((TypeAnnotationProvider)provider));
                PsiDisjunctionType psiDisjunctionType = ((PsiDisjunctionType)type2).newDisjunctionType(components);
                if (psiDisjunctionType == null) {
                    JavaSharedImplUtil.$$$reportNull$$$0(7);
                }
                return psiDisjunctionType;
            }
            PsiType psiType = type2.annotate((TypeAnnotationProvider)provider);
            if (psiType == null) {
                JavaSharedImplUtil.$$$reportNull$$$0(8);
            }
            return psiType;
        }
        PsiType psiType = type2;
        if (psiType == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(9);
        }
        return psiType;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(10);
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name2 = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name2;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                CodeEditUtil.removeChild((ASTNode)variableElement, (ASTNode)element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite((IElementType)JavaElementType.TYPE);
                newType1.rawAddChildren((TreeElement)newType);
                newType1.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JavaTokenType.LBRACKET, (CharSequence)"["));
                newType1.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JavaTokenType.RBRACKET, (CharSequence)"]"));
                newType = newType1;
                newType.acceptTree((TreeElementVisitor)new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, (Object)SharedImplUtil.findCharTableByTree((ASTNode)type2));
            CodeEditUtil.replaceChild((ASTNode)variableElement, (ASTNode)type2, (ASTNode)newType);
        }
    }

    public static void setInitializer(@NotNull PsiVariable variable, PsiExpression initializer) throws IncorrectOperationException {
        PsiExpression oldInitializer;
        if (variable == null) {
            JavaSharedImplUtil.$$$reportNull$$$0(11);
        }
        if ((oldInitializer = variable.getInitializer()) != null) {
            oldInitializer.delete();
        }
        if (initializer == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)variableElement);
            eq = Factory.createSingleLeafElement((IElementType)JavaTokenType.EQ, (CharSequence)"=", (int)0, (int)1, (CharTable)charTable, (PsiManager)variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter((PsiElement)initializer, eq.getPsi());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBrackets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilteringTypeAnnotationProvider
    implements TypeAnnotationProvider {
        private final PsiAnnotation[] myCandidates;
        private final TypeAnnotationProvider myOriginalProvider;
        private volatile PsiAnnotation[] myCache;

        private FilteringTypeAnnotationProvider(@NotNull PsiAnnotation[] candidates, @NotNull TypeAnnotationProvider originalProvider) {
            if (candidates == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(0);
            }
            if (originalProvider == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(1);
            }
            this.myCandidates = candidates;
            this.myOriginalProvider = originalProvider;
        }

        @NotNull
        public PsiAnnotation[] getAnnotations() {
            PsiAnnotation[] result = this.myCache;
            if (result == null) {
                List filtered = JBIterable.of((Object[])this.myCandidates).filter(annotation -> AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation)).append((Object[])this.myOriginalProvider.getAnnotations()).toList();
                result = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
                this.myCache = result;
            }
            if (result == null) {
                FilteringTypeAnnotationProvider.$$$reportNull$$$0(2);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/JavaSharedImplUtil$FilteringTypeAnnotationProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

