/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassListReferenceProvider
extends JavaClassReferenceProvider {
    public JavaClassListReferenceProvider() {
        this.setOption(ADVANCED_RESOLVE, Boolean.TRUE);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByString(String str, final @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            JavaClassListReferenceProvider.$$$reportNull$$$0(0);
        }
        if (position instanceof XmlTag && ((XmlTag)position).getValue().getTextElements().length == 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaClassListReferenceProvider.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (str.length() < 2) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaClassListReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = position.getTextRange().getStartOffset() + offsetInPosition;
        for (PsiElement child = position.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof OuterLanguageElement) || !child.getTextRange().contains(offset)) continue;
            if (PsiReference.EMPTY_ARRAY == null) {
                JavaClassListReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        NotNullLazyValue<Set<String>> topLevelPackages = new NotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                HashSet<String> knownTopLevelPackages = new HashSet<String>();
                List<PsiPackage> defaultPackages = JavaClassReferenceProvider.getDefaultPackages(position.getProject());
                for (PsiElement psiElement : defaultPackages) {
                    if (!(psiElement instanceof PsiPackage)) continue;
                    knownTopLevelPackages.add(((PsiPackage)psiElement).getName());
                }
                HashSet<String> hashSet = knownTopLevelPackages;
                if (hashSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassListReferenceProvider$1", "compute"));
            }
        };
        ArrayList results = new ArrayList();
        int dot = str.indexOf(46);
        while (dot > 0) {
            int start;
            for (start = dot; start > 0 && Character.isLetterOrDigit(str.charAt(start - 1)); --start) {
            }
            if (dot != start) {
                String candidate = str.substring(start, dot);
                if (((Set)topLevelPackages.getValue()).contains(candidate)) {
                    char ch;
                    int end = dot;
                    while (end < str.length() - 1 && ((ch = str.charAt(++end)) == '.' || Character.isJavaIdentifierPart(ch))) {
                    }
                    String s = str.substring(start, end + 1);
                    ContainerUtil.addAll(results, (Object[])new JavaClassReferenceSet(s, position, offsetInPosition + start, false, this){

                        @Override
                        public boolean isSoft() {
                            return true;
                        }

                        @Override
                        public boolean isAllowDollarInNames() {
                            return true;
                        }
                    }.getAllReferences());
                    ProgressManager.checkCanceled();
                }
            }
            dot = str.indexOf(46, dot + 1);
        }
        PsiReference[] psiReferenceArray = results.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            JavaClassListReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Override
    public GlobalSearchScope getScope(Project project) {
        return GlobalSearchScope.allScope((Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassListReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/JavaClassListReferenceProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

