/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    InferenceSessionContainer() {
    }

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, @NotNull PsiType returnType, PsiExpression returnExpression2) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession;
        if (returnType == null) {
            InferenceSessionContainer.$$$reportNull$$$0(0);
        }
        if ((callSession = this.findNestedSubstitutor((PsiElement)((PsiCallExpression)returnExpression2).getArgumentList(), null)) == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression2, returnType, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession);
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @Nullable MethodCandidateInfo currentMethod) {
        PsiCall topLevelCall;
        if (typeParameters == null) {
            InferenceSessionContainer.$$$reportNull$$$0(1);
        }
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            InferenceSessionContainer.$$$reportNull$$$0(3);
        }
        if (partialSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            InferenceSessionContainer.$$$reportNull$$$0(5);
        }
        if (policy == null) {
            InferenceSessionContainer.$$$reportNull$$$0(6);
        }
        PsiExpressionList argumentList = InferenceSession.getArgumentList(parent);
        if (parent instanceof PsiCall && !MethodCandidateInfo.isOverloadCheck((PsiElement)argumentList) && (topLevelCall = (PsiCall)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)parent, false, () -> {
            if (parent instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((PsiExpression)parent))) {
                return null;
            }
            return LambdaUtil.treeWalkUp((PsiElement)parent);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || !policy.equals(DefaultParameterTypeInferencePolicy.INSTANCE)) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy, currentMethod);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue((PsiElement)topLevelCall, () -> new CachedValueProvider.Result((Object)InferenceSessionContainer.startTopLevelInference(topLevelCall, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE, null), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent)) != null) {
                    for (PsiTypeParameter parameter2 : typeParameters) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter2)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy, currentMethod);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters2, arguments, (PsiCall)parent, currentMethod, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy);
        inferenceSession.initExpressionConstraints(parameters2, arguments, currentMethod != null ? currentMethod.getElement() : null, currentMethod != null && currentMethod.isVarargs());
        return inferenceSession.infer(parameters2, arguments, parent, currentMethod);
    }

    private static PsiSubstitutor inferNested(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiCall parent, @NotNull MethodCandidateInfo currentMethod, @NotNull InferenceSession parentSession) {
        List<String> errorMessages;
        if (parameters2 == null) {
            InferenceSessionContainer.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            InferenceSessionContainer.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            InferenceSessionContainer.$$$reportNull$$$0(9);
        }
        if (currentMethod == null) {
            InferenceSessionContainer.$$$reportNull$$$0(10);
        }
        if (parentSession == null) {
            InferenceSessionContainer.$$$reportNull$$$0(11);
        }
        if ((errorMessages = parentSession.getIncompatibleErrorMessages()) != null) {
            return null;
        }
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState, parentSession.getInferencePolicy());
            return childSession.collectAdditionalAndInfer(parameters2, arguments, currentMethod, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        while (true) {
            PsiCall call;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (gParent instanceof PsiConditionalExpression) {
                gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)gParent.getParent());
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call);
            if (initialInferenceState != null) {
                PsiParameter[] methodParameters;
                PsiExpressionList argumentList = call.getArgumentList();
                int idx = argumentList != null ? LambdaUtil.getLambdaIdx((PsiExpressionList)argumentList, (PsiElement)gParent) : -1;
                JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)call);
                PsiElement method = result.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1 || (methodParameters = ((PsiMethod)method).getParameterList().getParameters()).length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState, parentSession.getInferencePolicy());
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList.getExpressions(), (MethodCandidateInfo)result, compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters2, arguments, parent, currentMethod, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor = super.findNestedSubstitutor(arg, null);
                if (substitutor != null) {
                    return substitutor;
                }
                InitialInferenceState state = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
                if (state != null) {
                    return state.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)topInferenceSubstitutor.substitute((PsiTypeParameter)variable))) instanceof InferenceVariable)) continue;
            substitutor = substitutor.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy, MethodCandidateInfo currentMethod) {
        JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)topLevelCall);
        if (result instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, (Object)topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return (InferenceSession)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result).getSiteSubstitutor(), topLevelCall.getManager(), (PsiElement)topLevelCall, policy);
                topLevelSession.setCurrentMethod(currentMethod);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, method, ((MethodCandidateInfo)result).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, (MethodCandidateInfo)result);
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[0])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            substitutor = substitutor.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)newVariable));
            targetVars.add(newVariable);
            if (variable.isThrownBound()) {
                newVariable.setThrownBound();
            }
            newVariable.putUserData(InferenceSession.ORIGINAL_CAPTURE, variable.getUserData(InferenceSession.ORIGINAL_CAPTURE));
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)((Object)targetVars.get(i));
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            InferenceSessionContainer.$$$reportNull$$$0(12);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSession";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerNestedSession";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "infer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inferNested";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

