/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InferenceIncorporationPhase {
    private static final Logger LOG = Logger.getInstance(InferenceIncorporationPhase.class);
    private final InferenceSession mySession;
    private final List<Pair<InferenceVariable[], PsiClassType>> myCaptures = new ArrayList<Pair<InferenceVariable[], PsiClassType>>();
    private final Map<InferenceVariable, Map<InferenceBound, Set<PsiType>>> myCurrentBounds = new HashMap<InferenceVariable, Map<InferenceBound, Set<PsiType>>>();

    public InferenceIncorporationPhase(InferenceSession session) {
        this.mySession = session;
    }

    public void addCapture(InferenceVariable[] typeParameters, PsiClassType rightType) {
        this.myCaptures.add((Pair<InferenceVariable[], PsiClassType>)Pair.create((Object)typeParameters, (Object)rightType));
    }

    public void forgetCaptures(List<? extends InferenceVariable> variables) {
        for (InferenceVariable inferenceVariable : variables) {
            Iterator<Pair<InferenceVariable[], PsiClassType>> iterator = this.myCaptures.iterator();
            while (iterator.hasNext()) {
                Pair<InferenceVariable[], PsiClassType> capture = iterator.next();
                if (!InferenceIncorporationPhase.isCapturedVariable(inferenceVariable, capture)) continue;
                iterator.remove();
            }
        }
    }

    public boolean hasCaptureConstraints(Iterable<? extends InferenceVariable> variables) {
        for (InferenceVariable inferenceVariable : variables) {
            for (Pair<InferenceVariable[], PsiClassType> capture : this.myCaptures) {
                if (!InferenceIncorporationPhase.isCapturedVariable(inferenceVariable, capture)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCapturedVariable(InferenceVariable variable, Pair<InferenceVariable[], PsiClassType> capture) {
        for (InferenceVariable capturedVariable : (InferenceVariable[])capture.first) {
            if (variable != capturedVariable) continue;
            return true;
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable variable, Set<? super InferenceVariable> dependencies) {
        for (Pair<InferenceVariable[], PsiClassType> capture : this.myCaptures) {
            if (!InferenceIncorporationPhase.isCapturedVariable(variable, capture)) continue;
            this.mySession.collectDependencies((PsiType)capture.second, dependencies);
            ContainerUtil.addAll(dependencies, (Object[])((Object[])capture.first));
        }
    }

    public List<Pair<InferenceVariable[], PsiClassType>> getCaptures() {
        return this.myCaptures;
    }

    public boolean incorporate() {
        Collection<InferenceVariable> inferenceVariables = this.mySession.getInferenceVariables();
        for (InferenceVariable inferenceVariable : inferenceVariables) {
            Map<InferenceBound, Set<PsiType>> boundsMap;
            if (inferenceVariable.getInstantiation() != PsiType.NULL || (boundsMap = this.myCurrentBounds.get((Object)inferenceVariable)) == null) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            Collection changedEqBounds = boundsMap.get((Object)InferenceBound.EQ);
            Collection changedUpperBounds = boundsMap.get((Object)InferenceBound.UPPER);
            Collection changedLowerBounds = boundsMap.get((Object)InferenceBound.LOWER);
            if (changedEqBounds != null) {
                this.eqEq(eqBounds, changedEqBounds);
            }
            this.upDown(lowerBounds, changedLowerBounds, upperBounds, changedUpperBounds);
            this.upDown(eqBounds, changedEqBounds, upperBounds, changedUpperBounds);
            this.upDown(lowerBounds, changedLowerBounds, eqBounds, changedEqBounds);
            if (changedUpperBounds == null) continue;
            this.upUp(upperBounds);
        }
        for (Pair pair2 : this.myCaptures) {
            PsiClassType right = (PsiClassType)pair2.second;
            PsiClass gClass = right.resolve();
            LOG.assertTrue(gClass != null);
            InferenceVariable[] parameters2 = (InferenceVariable[])pair2.first;
            PsiType[] typeArgs = right.getParameters();
            PsiSubstitutor restSubst = PsiSubstitutor.EMPTY;
            if (Registry.is((String)"javac.fresh.variables.for.captured.wildcards.only")) {
                ArrayList<PsiType> args = new ArrayList<PsiType>();
                PsiTypeParameter[] typeParameters = gClass.getTypeParameters();
                for (int i = 0; i < typeArgs.length; ++i) {
                    PsiType arg = typeArgs[i];
                    if (arg instanceof PsiWildcardType) {
                        args.add(arg);
                        continue;
                    }
                    restSubst = restSubst.put(typeParameters[i], arg);
                }
                typeArgs = args.toArray(PsiType.EMPTY_ARRAY);
            }
            if (parameters2.length != typeArgs.length) continue;
            for (int i = 0; i < typeArgs.length; ++i) {
                PsiType aType = typeArgs[i];
                InferenceVariable inferenceVariable = parameters2[i];
                List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                if (aType instanceof PsiWildcardType) {
                    for (PsiType eqBound : eqBounds) {
                        if (InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(inferenceVariable, eqBound).booleanValue()) continue;
                        return false;
                    }
                    PsiClassType[] paramBounds = inferenceVariable.getParameter().getExtendsListTypes();
                    Object glb = null;
                    for (PsiClassType paramBound : paramBounds) {
                        glb = glb == null ? paramBound : GenericsUtil.getGreatestLowerBound((PsiType)glb, (PsiType)paramBound);
                    }
                    glb = restSubst.substitute(glb);
                    if (!((PsiWildcardType)aType).isBounded()) {
                        for (PsiType upperBound : upperBounds) {
                            if (glb == null || this.mySession.getInferenceVariable(upperBound) != null) continue;
                            this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables((PsiType)glb)));
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(inferenceVariable, lowerBound).booleanValue()) continue;
                            return false;
                        }
                        continue;
                    }
                    if (((PsiWildcardType)aType).isExtends()) {
                        PsiType extendsBound = ((PsiWildcardType)aType).getExtendsBound();
                        for (PsiType upperBound : upperBounds) {
                            if (this.mySession.getInferenceVariable(upperBound) != null) continue;
                            if (paramBounds.length == 1 && paramBounds[0].equalsToText("java.lang.Object") || paramBounds.length == 0) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, extendsBound));
                                continue;
                            }
                            if (!extendsBound.equalsToText("java.lang.Object") || glb == null) continue;
                            this.addConstraint(new StrictSubtypingConstraint(upperBound, this.mySession.substituteWithInferenceVariables((PsiType)glb)));
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!InferenceIncorporationPhase.isInferenceVariableOrFreshTypeParameter(inferenceVariable, lowerBound).booleanValue()) continue;
                            return false;
                        }
                        continue;
                    }
                    LOG.assertTrue(((PsiWildcardType)aType).isSuper());
                    PsiType superBound = ((PsiWildcardType)aType).getSuperBound();
                    for (PsiType upperBound : upperBounds) {
                        if (glb == null || this.mySession.getInferenceVariable(upperBound) != null) continue;
                        this.addConstraint(new StrictSubtypingConstraint(this.mySession.substituteWithInferenceVariables((PsiType)glb), upperBound));
                    }
                    for (PsiType lowerBound : lowerBounds) {
                        if (this.mySession.getInferenceVariable(lowerBound) != null) continue;
                        this.addConstraint(new StrictSubtypingConstraint(superBound, lowerBound));
                    }
                    continue;
                }
                inferenceVariable.addBound(aType, InferenceBound.EQ, this);
            }
        }
        return true;
    }

    protected void upDown(List<? extends PsiType> lowerBounds, Collection<? extends PsiType> changedLowerBounds, List<? extends PsiType> upperBounds, Collection<? extends PsiType> changedUpperBounds) {
        if (changedLowerBounds != null) {
            this.upDown(changedLowerBounds, upperBounds);
        }
        if (changedUpperBounds != null) {
            this.upDown(lowerBounds, changedUpperBounds);
        }
    }

    private static Boolean isInferenceVariableOrFreshTypeParameter(InferenceVariable inferenceVariable, PsiType eqBound) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)eqBound);
        if (psiClass instanceof InferenceVariable || psiClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)psiClass)) || eqBound instanceof PsiCapturedWildcardType && eqBound.equals(inferenceVariable.getUserData(InferenceSession.ORIGINAL_CAPTURE))) {
            return true;
        }
        return false;
    }

    boolean isFullyIncorporated() {
        boolean needFurtherIncorporation = false;
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            Map<InferenceBound, Set<PsiType>> boundsMap;
            if (inferenceVariable.getInstantiation() != PsiType.NULL || (boundsMap = this.myCurrentBounds.remove((Object)inferenceVariable)) == null) continue;
            Set<PsiType> upperBounds = boundsMap.get((Object)InferenceBound.UPPER);
            Set<PsiType> lowerBounds = boundsMap.get((Object)InferenceBound.LOWER);
            if (upperBounds != null) {
                needFurtherIncorporation |= this.crossVariables(inferenceVariable, upperBounds, lowerBounds, InferenceBound.LOWER);
            }
            if (lowerBounds == null) continue;
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, lowerBounds, upperBounds, InferenceBound.UPPER);
        }
        return !needFurtherIncorporation;
    }

    private boolean crossVariables(InferenceVariable inferenceVariable, Collection<? extends PsiType> upperBounds, Collection<? extends PsiType> lowerBounds, InferenceBound inferenceBound) {
        InferenceBound oppositeBound = inferenceBound == InferenceBound.LOWER ? InferenceBound.UPPER : InferenceBound.LOWER;
        boolean result = false;
        for (PsiType psiType : upperBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(psiType);
            if (inferenceVar == null || inferenceVariable == inferenceVar) continue;
            if (lowerBounds != null) {
                for (PsiType psiType2 : lowerBounds) {
                    result |= inferenceVar.addBound(psiType2, inferenceBound, this);
                }
            }
            for (PsiType psiType3 : inferenceVar.getBounds(oppositeBound)) {
                result |= inferenceVariable.addBound(psiType3, oppositeBound, this);
            }
        }
        return result;
    }

    private void upDown(Collection<? extends PsiType> eqBounds, Collection<? extends PsiType> upperBounds) {
        for (PsiType psiType : upperBounds) {
            if (psiType == null || PsiType.NULL.equals((Object)psiType) || psiType instanceof PsiWildcardType) continue;
            for (PsiType psiType2 : eqBounds) {
                if (psiType2 == null || PsiType.NULL.equals((Object)psiType2) || psiType2 instanceof PsiWildcardType) continue;
                if (Registry.is((String)"javac.unchecked.subtyping.during.incorporation", (boolean)true)) {
                    if (TypeCompatibilityConstraint.isUncheckedConversion(psiType, psiType2, this.mySession)) {
                        if (!(PsiUtil.resolveClassInType((PsiType)psiType2) instanceof PsiTypeParameter) || this.mySession.isProperType(psiType)) continue;
                        this.mySession.setErased();
                        continue;
                    }
                    if (!this.mySession.isProperType(psiType) && psiType2 instanceof PsiCapturedWildcardType && TypeCompatibilityConstraint.isUncheckedConversion(psiType, ((PsiCapturedWildcardType)psiType2).getUpperBound(), this.mySession)) {
                        this.mySession.setErased();
                        continue;
                    }
                }
                this.addConstraint(new StrictSubtypingConstraint(psiType, psiType2));
            }
        }
    }

    private void eqEq(List<? extends PsiType> eqBounds, Collection<? extends PsiType> changedEqBounds) {
        for (int i = 0; i < eqBounds.size(); ++i) {
            PsiType sBound = eqBounds.get(i);
            boolean changed = changedEqBounds.contains(sBound);
            for (int j = i + 1; j < eqBounds.size(); ++j) {
                PsiType tBound = eqBounds.get(j);
                if (!changed && !changedEqBounds.contains(tBound)) continue;
                this.addConstraint(new TypeEqualityConstraint(tBound, sBound));
            }
        }
    }

    private boolean upUp(List<? extends PsiType> upperBounds) {
        return InferenceSession.findParameterizationOfTheSameGenericClass(upperBounds, (Processor<? super Pair<PsiType, PsiType>>)((Processor)pair2 -> {
            PsiType sType = (PsiType)pair2.first;
            PsiType tType = (PsiType)pair2.second;
            if (!(sType instanceof PsiWildcardType) && !(tType instanceof PsiWildcardType) && sType != null && tType != null) {
                this.addConstraint(new TypeEqualityConstraint(sType, tType));
            }
            return false;
        })) != null;
    }

    private void addConstraint(ConstraintFormula constraint) {
        this.mySession.addConstraint(constraint);
    }

    public void addBound(InferenceVariable variable, PsiType type2, InferenceBound bound) {
        Set<PsiType> types;
        Map<InferenceBound, Set<PsiType>> bounds = this.myCurrentBounds.get((Object)variable);
        if (bounds == null) {
            bounds = new HashMap<InferenceBound, Set<PsiType>>();
            this.myCurrentBounds.put(variable, bounds);
        }
        if ((types = bounds.get((Object)bound)) == null) {
            types = new LinkedHashSet<PsiType>();
            bounds.put(bound, types);
        }
        types.add(type2);
    }
}

