/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.ClassReferencePointer;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    PsiTypeElementImpl(@NotNull IElementType type2) {
        if (type2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(type2);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calculateType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @NotNull
    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType((PsiTypeElement)this);
        if (inferredType != null) {
            PsiType psiType = inferredType;
            if (psiType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(3);
            }
            return psiType;
        }
        Object type2 = null;
        SmartList annotations2 = new SmartList();
        PsiElement parent = this.getParent();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations2.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type2 == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type2 = new PsiDiamondTypeImpl((PsiManager)this.getManager(), this);
                    break;
                }
                type2 = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken((PsiElement)child, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type2 == null) : this;
                String text2 = child.getText();
                type2 = annotations2.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text2) : new PsiPrimitiveType(text2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations2));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.VAR_KEYWORD)) {
                assert (type2 == null) : this;
                type2 = this.inferVarType(parent);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type2 == null) : this;
                type2 = new PsiClassReferenceType(this.getReferenceComputable((PsiJavaCodeReferenceElement)child), null, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations2));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                assert (type2 != null) : this;
                type2 = new PsiArrayType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations2));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) {
                assert (type2 != null) : this;
                type2 = new PsiEllipsisType(type2, PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations2));
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)child).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type2 == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
                PsiElement boundType = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)boundKind);
                type2 = PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                type2 = type2.annotate(PsiTypeElementImpl.createProvider((List<PsiAnnotation>)annotations2));
                break;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type2 = PsiIntersectionType.createIntersection((boolean)false, (PsiType[])types.toArray(PsiType.createArray((int)types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type2 = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        if (type2 == null) {
            PsiPrimitiveType psiPrimitiveType = PsiType.NULL;
            if (psiPrimitiveType == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(4);
            }
            return psiPrimitiveType;
        }
        if (parent instanceof PsiModifierListOwner) {
            type2 = JavaSharedImplUtil.applyAnnotations(type2, ((PsiModifierListOwner)parent).getModifierList());
        }
        PsiType psiType = type2;
        if (psiType == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(5);
        }
        return psiType;
    }

    private PsiType inferVarType(PsiElement parent) {
        if (parent instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)parent).getDeclarationScope();
            if (declarationScope instanceof PsiForeachStatement) {
                PsiExpression iteratedValue2 = ((PsiForeachStatement)declarationScope).getIteratedValue();
                if (iteratedValue2 != null) {
                    return JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2);
                }
                return null;
            }
            if (declarationScope instanceof PsiLambdaExpression) {
                return ((PsiParameter)parent).getType();
            }
        } else {
            for (PsiTypeElementImpl e = this; e != null; e = e.getNextSibling()) {
                if (!(e instanceof PsiExpression)) continue;
                if (!(e instanceof PsiArrayInitializerExpression) && !PsiTypeElementImpl.isSelfReferenced((PsiExpression)e, parent)) {
                    PsiExpression expression2 = (PsiExpression)e;
                    PsiType type2 = (PsiType)RecursionManager.doPreventingRecursion((Object)expression2, (boolean)true, () -> expression2.getType());
                    return type2 == null ? null : JavaVarTypeUtil.getUpwardProjection(type2);
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isSelfReferenced(@NotNull PsiExpression initializer, PsiElement parent) {
        if (initializer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(6);
        }
        class SelfReferenceVisitor
        extends JavaRecursiveElementVisitor {
            private boolean referenced;
            final /* synthetic */ PsiElement val$parent;

            SelfReferenceVisitor(PsiElement psiElement) {
                this.val$parent = psiElement;
            }

            public void visitElement(PsiElement element) {
                if (this.referenced) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getParent() instanceof PsiMethodCallExpression) {
                    return;
                }
                if (expression2.resolve() == this.val$parent) {
                    this.referenced = true;
                }
            }
        }
        SelfReferenceVisitor visitor = new SelfReferenceVisitor(parent);
        initializer.accept((PsiElementVisitor)visitor);
        return visitor.referenced;
    }

    public boolean isInferredType() {
        PsiElement firstChild = this.getFirstChild();
        return PsiUtil.isJavaToken((PsiElement)firstChild, (IElementType)JavaTokenType.VAR_KEYWORD);
    }

    @NotNull
    private ClassReferencePointer getReferenceComputable(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiElement parent;
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(7);
        }
        if ((parent = this.getParent()) instanceof PsiMethod || parent instanceof PsiVariable) {
            ClassReferencePointer classReferencePointer = PsiTypeElementImpl.computeFromTypeOwner(parent, new WeakReference<PsiJavaCodeReferenceElement>(ref));
            if (classReferencePointer == null) {
                PsiTypeElementImpl.$$$reportNull$$$0(8);
            }
            return classReferencePointer;
        }
        ClassReferencePointer classReferencePointer = ClassReferencePointer.constant(ref);
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(9);
        }
        return classReferencePointer;
    }

    @NotNull
    private static ClassReferencePointer computeFromTypeOwner(final PsiElement parent, final @NotNull WeakReference<PsiJavaCodeReferenceElement> ref) {
        if (ref == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(10);
        }
        ClassReferencePointer classReferencePointer = new ClassReferencePointer(){
            volatile WeakReference<PsiJavaCodeReferenceElement> myCache;
            {
                this.myCache = ref;
            }

            @Override
            @Nullable
            public PsiJavaCodeReferenceElement retrieveReference() {
                PsiJavaCodeReferenceElement result = (PsiJavaCodeReferenceElement)this.myCache.get();
                if (result == null) {
                    PsiTypeElement typeElement = this.calcTypeElement();
                    if (typeElement != null) {
                        result = ((PsiTypeElementImpl)typeElement).getReferenceElement();
                    }
                    this.myCache = new WeakReference<PsiJavaCodeReferenceElement>(result);
                }
                return result;
            }

            @Nullable
            private PsiTypeElement calcTypeElement() {
                return parent instanceof PsiMethod ? ((PsiMethod)parent).getReturnTypeElement() : ((PsiVariable)parent).getTypeElement();
            }

            @Override
            @NotNull
            public PsiJavaCodeReferenceElement retrieveNonNullReference() {
                PsiJavaCodeReferenceElement result = this.retrieveReference();
                if (result == null) {
                    PsiTypeElement typeElement = this.calcTypeElement();
                    if (typeElement == null) {
                        PsiUtilCore.ensureValid((PsiElement)parent);
                        throw new IllegalStateException("No type for " + parent.getClass());
                    }
                    result = ((PsiTypeElementImpl)typeElement).getReferenceElement();
                    if (result == null) {
                        PsiUtilCore.ensureValid((PsiElement)typeElement);
                        throw new IllegalStateException("No reference in " + typeElement.getClass());
                    }
                }
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = result;
                if (psiJavaCodeReferenceElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiJavaCodeReferenceElement;
            }

            public String toString() {
                String msg = "Type element reference of " + parent.getClass() + " #" + parent.getClass().getSimpleName();
                return parent.isValid() ? msg + " #" + parent.getLanguage() : msg + ", invalid";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$1", "retrieveNonNullReference"));
            }
        };
        if (classReferencePointer == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(11);
        }
        return classReferencePointer;
    }

    @NotNull
    private static TypeAnnotationProvider createProvider(@NotNull List<PsiAnnotation> annotations2) {
        if (annotations2 == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(12);
        }
        TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])((PsiAnnotation[])ContainerUtil.copyAndClear(annotations2, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true)));
        if (typeAnnotationProvider == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(13);
        }
        return typeAnnotationProvider;
    }

    @NotNull
    private List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        List list = ContainerUtil.map((Collection)typeElements, typeElement -> typeElement.getType());
        if (list == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)ref);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(17);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations2 != null ? annotations2 : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(18);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(19);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(20);
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiElement result;
        if (newElement == null) {
            PsiTypeElementImpl.$$$reportNull$$$0(22);
        }
        if (!(newElement instanceof PsiTypeElement) || !((PsiTypeElement)newElement).isInferredType()) {
            PsiImplUtil.markTypeAnnotations(this);
        }
        if ((result = super.replace(newElement)) instanceof PsiTypeElement) {
            PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        }
        return result;
    }

    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceComputable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFromTypeOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReferenced";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceComputable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeFromTypeOwner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

