/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap();
    private static final Map<IElementType, String> KEYWORD_TYPE_TO_NAME_MAP;
    private volatile ModifierCache myModifierCache;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        ModifierCache modifierCache;
        if (name2 == null) {
            PsiModifierListImpl.$$$reportNull$$$0(0);
        }
        if ((modifierCache = this.myModifierCache) == null || !modifierCache.isUpToDate()) {
            this.myModifierCache = modifierCache = this.calcModifiers();
        }
        return modifierCache.modifiers.contains(name2);
    }

    private ModifierCache calcModifiers() {
        Set<String> modifiers = this.calcExplicitModifiers();
        modifiers.addAll(this.calcImplicitModifiers(modifiers));
        if (!(modifiers.contains("public") || modifiers.contains("protected") || modifiers.contains("private"))) {
            modifiers.add("packageLocal");
        }
        PsiFile file = this.getContainingFile();
        return new ModifierCache(file, PsiAugmentProvider.transformModifierProperties((PsiModifierList)this, (Project)file.getProject(), modifiers));
    }

    private Set<String> calcExplicitModifiers() {
        HashSet<String> explicitModifiers = new HashSet<String>();
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            int mask = stub.getModifiersMask();
            for (int i = 0; i < 31; ++i) {
                int flag = 1 << i;
                if (!BitUtil.isSet((int)mask, (int)flag)) continue;
                ContainerUtil.addIfNotNull(explicitModifiers, (Object)ModifierFlags.MODIFIER_FLAG_TO_NAME_MAP.get(flag));
            }
        } else {
            for (ASTNode child : this.getNode().getChildren(null)) {
                ContainerUtil.addIfNotNull(explicitModifiers, (Object)KEYWORD_TYPE_TO_NAME_MAP.get(child.getElementType()));
            }
        }
        return explicitModifiers;
    }

    private Set<String> calcImplicitModifiers(Set<String> explicitModifiers) {
        HashSet<String> implicitModifiers = new HashSet<String>();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement grandParent = parent.getContext();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                Collections.addAll(implicitModifiers, "public", "static");
            }
            if (((PsiClass)parent).isInterface()) {
                implicitModifiers.add("abstract");
                if (grandParent instanceof PsiClass) {
                    implicitModifiers.add("static");
                }
            }
            if (((PsiClass)parent).isEnum()) {
                boolean hasSubClass;
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                List<PsiField> fields = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnFields() : Arrays.asList(((PsiClass)parent).getFields());
                boolean bl = hasSubClass = ContainerUtil.find(fields, field -> field instanceof PsiEnumConstant && ((PsiEnumConstant)field).getInitializingClass() != null) != null;
                if (!hasSubClass) {
                    implicitModifiers.add("final");
                }
                List<PsiMethod> methods = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnMethods() : Arrays.asList(((PsiClass)parent).getMethods());
                for (PsiMethod method : methods) {
                    if (!method.hasModifierProperty("abstract")) continue;
                    implicitModifiers.add("abstract");
                    break;
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (!explicitModifiers.contains("private")) {
                    implicitModifiers.add("public");
                    if (!explicitModifiers.contains("default") && !explicitModifiers.contains("static")) {
                        implicitModifiers.add("abstract");
                    }
                }
            } else if (aClass != null && aClass.isEnum() && ((PsiMethod)parent).isConstructor()) {
                implicitModifiers.add("private");
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                Collections.addAll(implicitModifiers, "public", "static", "final");
            } else {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && aClass.isInterface()) {
                    Collections.addAll(implicitModifiers, "public", "static", "final");
                }
            }
        } else if (parent instanceof PsiParameter && parent.getParent() instanceof PsiCatchSection && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType) {
            Collections.addAll(implicitModifiers, "final");
        } else if (parent instanceof PsiResourceVariable) {
            Collections.addAll(implicitModifiers, "final");
        }
        return implicitModifiers;
    }

    public boolean hasExplicitModifier(@NotNull String name2) {
        PsiModifierListStub stub;
        if (name2 == null) {
            PsiModifierListImpl.$$$reportNull$$$0(1);
        }
        if ((stub = (PsiModifierListStub)this.getGreenStub()) != null) {
            return BitUtil.isSet((int)stub.getModifiersMask(), (int)ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name2));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        IElementType type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name2);
        return type2 != null && tree.findChildByType(type2) != null;
    }

    public void setModifierProperty(@NotNull String name2, boolean value2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiModifierListImpl.$$$reportNull$$$0(2);
        }
        this.checkSetModifierProperty(name2, value2);
        PsiElement parent = this.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        IElementType type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name2);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat((ASTNode)method.getParameterList().getNode(), (boolean)true);
        }
        if (value2) {
            if (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.PRIVATE_KEYWORD || type2 == JavaTokenType.PROTECTED_KEYWORD || type2 == null) {
                if (type2 != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type2 != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type2 != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type2 == null) {
                    return;
                }
            }
            if (parent instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.STATIC_KEYWORD || type2 == JavaTokenType.FINAL_KEYWORD : (parent instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD : (parent instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD : parent instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type2) == null) {
                LeafElement keyword = Factory.createSingleLeafElement((IElementType)type2, (CharSequence)name2, null, (PsiManager)this.getManager());
                treeElement.addInternal((TreeElement)keyword, (ASTNode)keyword, null, null);
            }
        } else {
            if (type2 == null) {
                throw new IncorrectOperationException("Cannot reset package-private modifier.");
            }
            ASTNode child = treeElement.findChildByType(type2);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)child).delete();
            }
        }
    }

    public void checkSetModifierProperty(@NotNull String name2, boolean value2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiModifierListImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        Object[] own = (PsiAnnotation[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])ArrayUtil.mergeArrayAndCollection((Object[])own, (Collection)ext, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            PsiModifierListImpl.$$$reportNull$$$0(4);
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)this);
        List filtered = ContainerUtil.findAll((Object[])this.getAnnotations(), annotation -> {
            PsiAnnotation.TargetType target = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets);
            return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            PsiModifierListImpl.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiModifierListImpl.$$$reportNull$$$0(6);
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiModifierListImpl.$$$reportNull$$$0(7);
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter((PsiElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createAnnotationFromText("@" + qualifiedName, (PsiElement)this), null);
        if (psiAnnotation == null) {
            PsiModifierListImpl.$$$reportNull$$$0(8);
        }
        return psiAnnotation;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiModifierListImpl.$$$reportNull$$$0(9);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("open", JavaTokenType.OPEN_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transitive", JavaTokenType.TRANSITIVE_KEYWORD);
        KEYWORD_TYPE_TO_NAME_MAP = new THashMap();
        for (String name2 : NAME_TO_KEYWORD_TYPE_MAP.keySet()) {
            KEYWORD_TYPE_TO_NAME_MAP.put(NAME_TO_KEYWORD_TYPE_MAP.get(name2), name2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiModifierListImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiModifierListImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModifierCache {
        static final Interner<List<String>> ourInterner = new WeakInterner();
        final PsiFile file;
        final List<String> modifiers;
        final long modCount;

        ModifierCache(@NotNull PsiFile file, @NotNull Set<String> modifiers) {
            if (file == null) {
                ModifierCache.$$$reportNull$$$0(0);
            }
            if (modifiers == null) {
                ModifierCache.$$$reportNull$$$0(1);
            }
            this.file = file;
            ArrayList<String> modifierList = new ArrayList<String>(modifiers);
            Collections.sort(modifierList);
            this.modifiers = (List)ourInterner.intern(modifierList);
            this.modCount = this.getModCount();
        }

        private long getModCount() {
            return this.file.getManager().getModificationTracker().getModificationCount() + this.file.getModificationStamp();
        }

        boolean isUpToDate() {
            return this.getModCount() == this.modCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modifiers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

